<?php

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

use ODE\Helper\OdeArrayHelper;

use ODE\Sms\OdeSms;

class OPS_template_smsController extends SugarController
{
    /**
     * @access public
     * action_sendSms()
     * Fonction qui envoi un SMS
     *
     */
    public function action_sendSms()
    {
        $libelle_erreur = '';
        $data_return = [];

        # Vérification + récupération des champs
        $data_verified = OdeArrayHelper::isDataValid($_REQUEST, ["json" => true]);

        if ($data_verified['statut'] == 'ok') 
        {
            $data = $data_verified['data']['json_array'];

            if( !empty($data['numero']) && !empty($data['message']) )
            {
                # On initialise le SMS
                $sms = new OdeSms();

                # On formate le numéro du destinataire
                $numero = $sms->format_numero($data['numero']);

                # On vérifie que le template récupéré existe et actif & que le numéro de téléphone a été formaté
                if($numero != false)
                {
                    try {
                        $response = $sms->send_sms($numero, $data['message'], $data['config']);

                        if($response)
                        {
                            $data = [
                                'statut' => 'ok',
                                'message' => 'Le SMS a été envoyé',
                            ];
                        }
                        else
                        {
                            $data = [
                                'statut' => 'ko',
                                'message' => 'Le SMS n\'a pas été envoyé : ' . $e,
                            ];
                        }
                    } catch (\Exception $e) {
                        $data = [
                            'statut' => 'ko',
                            'message' => 'Le SMS n\'a pas été envoyé : ' . $e,
                        ];
                        $GLOBALS['log']->fatal('OPS_template_smsController::action_sendSms() => Impossible d\'envoyer le SMS - Erreur : ' . $e);
                    }
                }
                else
                {
                    $data = [
                        'statut' => 'ko',
                        'message' => 'Le numéro de téléphone est invalide',
                    ];
                }
            }
            else
            {
                $data = [
                    'statut' => 'ko',
                    'message' => 'Les données transmises ne sont pas remplis',
                ];
            }
        }
        else
        {
            $libelle_erreur = $data_verified['data'];
        }

        $data = (empty($libelle_erreur)) ? ['statut' => 'ok', 'data' => $data ] : ['statut' => 'err', 'data' => $libelle_erreur];

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }
}