<?php

use ODE\ActionStatut\OdeActionStatut;
use Configurator;

class OPS_statut extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_statut';
    public $object_name = 'OPS_statut';
    public $table_name = 'ops_statut';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $code_couleur;
    public $avancement;
    public $ordre;
    public $nom_statut_gru;

    public function bean_implements($interface)
    {
        switch ($interface) {
            case 'ACL':
                return true;
        }

        return false;
    }

    // Fonction qui vérifie si il y'a des actions actives liées au statut et les déclenche
    function action_statut($obj_dossier)
    {
        global $db;
        // On vérifie que l'id n'est pas vide 
        if (!empty($this->id)) {

            // On récupere les actions associer au statut
            $liste_actions = $this->get_linked_beans('ops_action_statut_ops_statut', 'OPS_action_statut', 'ordre');

            // Si on a des actions disponible on foreach et on vérifie si les actions sont actives
            if (is_array($liste_actions) && count($liste_actions) > 0) {
                foreach ($liste_actions as $action) {
                    // Vérification que l'action a déclenché soit toujours le même statut sur le dossier 
                    if ($action->ops_statut_id == $obj_dossier->ops_statut_id || empty($obj_dossier->ops_statut_id)) {
                        if ($action->active == 1 && $action->execution_retarde == 0) {
                            // On execute l'action
                            $action_statut = new OdeActionStatut($action, $obj_dossier);
                            $action_statut->execute();
                        }else if ( $action->active == 1 && $action->execution_retarde == 1){
                            $obj_action_retarde = BeanFactory::newBean('OPS_action_retarde');
                            $where = 'ops_action_retarde.deleted = 0 AND ops_action_retarde.ops_action_id="'.$action->id.'" AND ops_action_retarde.ops_dossier_id="'.$obj_dossier->id.'" AND ops_action_retarde.ops_statut_id="'.$action->ops_statut_id.'"';
                            $liste = $obj_action_retarde->get_full_list('',$where);
                            if(empty($liste)){
                                // Récupère le format de date
                                $user_date_format = $GLOBALS['timedate']->get_date_time_format();
                                if (empty($user_date_format)){
                                    $configuratorObj = new Configurator();
                                    $user_date_format = $configuratorObj->config['default_date_format'];
                                }
                                $result = $db->query('SELECT NOW()');
                                foreach($result as $row) {
                                    $mysqlDate = $row['NOW()'];
                                }
                                $date = date( "Y-m-d H:i", strtotime($mysqlDate. "+".$action->jours." days +".$action->heures."hours +".$action->minutes."minutes" ));
                                $dateTime = DateTime::createFromFormat('Y-m-d H:i', $date);
                                $date_activation_time = $dateTime->format($user_date_format);
                                $obj_action_retarde->name = $action->name;
                                $obj_action_retarde->ops_action_id = $action->id;
                                $obj_action_retarde->ops_dossier_id = $obj_dossier->id;
                                $obj_action_retarde->ops_statut_id = $action->ops_statut_id;
                                $obj_action_retarde->date_declenchement = $date_activation_time;
                                $obj_action_retarde->save();
                            }
                        }
                    }
                }
            }
        } else {
            $GLOBALS['log']->fatal('-------------- OPS_statut :: action_statut() -> id statut vide ');
        }
    }

    function liste_statuts($obj_dossier)
    {

        $liste_statuts = array();

        do {

            // Vérification que l'objet $obj_dossier est bien une instance de OPS_dossier
            if (empty($obj_dossier->id)) {
                $GLOBALS['log']->fatal(" OPS_statut :: liste_statuts() =>  obj_dossier non initialisé ");
                break;
            }

            // Récupération du dispositif lié au dossier pour récupérer le guide d'instruction
            $liste_dispositifs = $obj_dossier->get_linked_beans('ops_dispositif_ops_dossier', 'OPS_dispositif');
            if (!is_array($liste_dispositifs) || count($liste_dispositifs) === 0) {
                $GLOBALS['log']->fatal(" OPS_statut :: liste_statuts() => Aucun dispositif n'est rattaché au dossier id = " . $obj_dossier->id);
                break;
            } else {
                $dispositif = $liste_dispositifs[0];
            }

            // On récupere la liste des guides associé au dispositif
            $liste_guides = $dispositif->get_linked_beans('ops_guide_instruction_ops_dispositif', 'OPS_guide_instruction');
            if (!is_array($liste_guides) || count($liste_guides) === 0) {
                $GLOBALS['log']->fatal(" OPS_statut :: liste_statuts() => Aucun guide d'instruction n'est rattaché au dispositif id = " . $dispositif->id);
                break;
            } else {
                $obj_guide_instruction = $liste_guides[0];
            }

            // Si le dossier n'a pas de statut, on retourne les statuts de l'étape initiale du guide d'instruction
            if (empty($obj_dossier->ops_statut_id)) {

                // On récupere le statut d'initialisation associé au guide d'instruction
                $statut_initial = BeanFactory::getBean('OPS_statut', $obj_guide_instruction->ops_statut_id);

                // On récupere l'etape associé au statut d'initialisation
                $liste_etapes = (!empty($statut_initial->id)) ?  $statut_initial->get_linked_beans('ops_etape_ops_statut', 'OPS_etape') : false;
                $etape_initiale = (is_array($liste_etapes) && count($liste_etapes) > 0) ? $liste_etapes[0] : false;

                $etape_statuts = ($etape_initiale !== false) ? $etape_initiale->getListeStatuts() : array();

                if (!is_array($etape_statuts) || count($etape_statuts) === 0) {
                    $GLOBALS['log']->fatal(" OPS_statut :: liste_statuts() => Les statuts de l'étape d'initilisation du guide d'instruction non pas pu etre récupérer ");
                } else {
                    $liste_statuts = $etape_statuts;
                }

                break;
            }

            // On récupere l'object OPS_statut du statut associé au dossier 
            $obj_statut = BeanFactory::getBean('OPS_statut', $obj_dossier->ops_statut_id);
            if (empty($obj_statut->id)) {
                $GLOBALS['log']->fatal(" OPS_statut :: liste_statuts() =>  Le statut id = " . $obj_dossier->ops_statut_id . " n'a pas pu etre recupérer");
                break;
            }

            // On récupere l'étape associé au statut
            $liste_etapes = $obj_statut->get_linked_beans('ops_etape_ops_statut', 'OPS_etape');
            $obj_etape = (is_array($liste_etapes) && count($liste_etapes) > 0) ? $liste_etapes[0] : false;

            $statutPrecedentExistant = false;
            if ($obj_etape !== false) {
                // Récupération des status passés 
                $tab_historiques = $obj_dossier->get_linked_beans('ops_historisation_ops_dossier', 'OPS_historisation', '', 0, -1, 0, "flag_retour = '1'");
                if (is_array($tab_historiques) && count($tab_historiques) > 1)  $statutPrecedentExistant = true;
            }

            // Si l'avancement du statut du dossier === "terminé"
            if ($obj_statut->avancement === "termine") {
                if ($obj_etape->retour_arriere == true && $statutPrecedentExistant === true) {
                    $liste_statuts['precedent'] = "Retour";
                } else {
                    $liste_statuts[''] = "Workflow Terminé";
                }
                break;
            }

            // Si l'avancement du statut du dossier === "courant"
            if ($obj_statut->avancement === "courant") {

                // Ajout du choix Précédent si l'étape courante a la propriété retour arrière
                if ($obj_etape->retour_arriere == true && $statutPrecedentExistant === true) {
                    $liste_statuts['precedent'] = "Retour";
                }
                $etape_statuts = $obj_etape->getListeStatuts();
                $liste_statuts = array_merge($liste_statuts, $etape_statuts);
                break;
            }

            // Si l'avancement du statut du dossier === "suivant"
            if ($obj_statut->avancement === "suivant") {

                // On récupere l'étape suivante
                $obj_etape_suivante = $obj_etape->getEtapeSuivante();
                if ($obj_etape_suivante !== false) {

                    // Ajout du choix Précédent si l'étape courante a la propriété retour arrière
                    if ($obj_etape_suivante->retour_arriere == true && $statutPrecedentExistant === true) {
                        $liste_statuts['precedent'] = "Retour";
                    }
                    $etape_suivante_statuts = $obj_etape_suivante->getListeStatuts();
                    $liste_statuts = array_merge($liste_statuts, $etape_suivante_statuts);
                } else {
                    $liste_statuts[''] = "Workflow Terminé";
                }

                break;
            }
        } while (0);

        return $liste_statuts;
    }
}
