$(document).ready(function() {

	var apiBanDisabled = Boolean(getApiBan());

	$('[role=section_title]').each(function() {
        $(this).closest('.edit-view-row-item').find('> .label').hide();
        $(this).text( $(this).closest('.edit-view-row-item').find('> .label').text().replaceAll(':', '') );
        $(this).show();
    });
    
    Inputmask({ regex: "^W([A-Za-z0-9]{9})$", "clearIncomplete": true }).mask( $("#numero_rna") );
    Inputmask({ mask: "(0|1|2|3)9 99 999 999 999", "clearIncomplete": true }).mask( $("#numero_fiscale") );
    Inputmask({ mask: "999 999 999 99999", "clearIncomplete": true }).mask( $("#siret") );
    Inputmask({ mask: "9999999a", "clearIncomplete": true }).mask( $("#numero_rne") );

    //$("#numero_rna").inputmask({ regex: "^W([A-Za-z0-9]{9})$" });
	
	var siret = document.getElementById("siret") ;
	var rna = document.getElementById("numero_rna") ;
	var rne = document.getElementById("numero_rne") ;
	var tel = document.getElementById("phone_office") ;
	var code_ape = document.getElementById("code_ape") ;
	var num_tahiti = document.getElementById("num_tahiti") ;
	num_tahiti.onblur = function() {
		verif_num_tahiti() ;
	};
	siret.onblur = function() {
		verif_siret() ;
	};
	rna.onblur = function() {
		verif_rna() ;
	};
	rne.onblur = function() {
		verif_rne() ;
	};
	tel.onblur = function() {
		//verif_tel() ;
	};
	code_ape.onblur = function() {
		addUppercaseToCodeApe() ;
	};

	check_agrement_administratif();
	check_utilite_publique();
	check_affiliee_reseau();

    $('#agrement_administratif').change(function(){
    	check_agrement_administratif();
    });

    $('#utilite_publique').change(function(){
    	check_utilite_publique();
    });

    $('#affiliee_reseau').change(function(){
    	check_affiliee_reseau();
    });

	replaceLibelle();

	loadObligatoires();

	$('form').each(function(){
		if(this.id == 'EditView' || this.id == 'form_SubpanelQuickCreate_OPS_personne_morale'){
			view = this.id;
		}
	});

	$('#ops_type_personne_id').parent().parent().show();
	if( 0 == $('#ops_type_personne_id').parent().parent().children('div')[0].children.length ){
		$('#ops_type_personne_id').parent().parent().children('div').first().append('<span class="required">*</span>');
	}
	addToValidate(view,'ops_type_personne_id','relate',true,'Type');

	apply_phone_mask("#phone_office");
    select_on_focus("#phone_office");

    //Autocomplétion du code postal
    $('#billing_address_postalcode, #shipping_address_postalcode').autocomplete({
		minLength:3,
		disabled:apiBanDisabled,
        source: function(request, response){
            const self = this;
            $.ajax({
                url: "https://api-adresse.data.gouv.fr/search/?postcode=" + $(self.element).val() + "&limit=25",
                data: {q: request.term},
                dataType: "json",
                success: function(data){
                    var villes = [];
                    response($.map(data.features, function(item){
                        if($.inArray(item.properties.city, villes) == -1){
                            villes.push(item.properties.city);
                            var ville = item.properties.city;
                            var villeReg = ville.replace(/\s\d*[e]\sArrondissement/,'');
                            return {label: item.properties.postcode + " " + item.properties.city,
                                    city: villeReg,
                                    value: item.properties.postcode
                                };
                        }
                    }));
                }
            });
        },
        select: function(event,ui)
        {
        	var ville = '';
        	if($(event.target).attr('id') == 'billing_address_postalcode'){
        		ville = 'billing_address_city';
        	}else{
        		ville = 'shipping_address_city';
        	}
            $('#'+ville).val(ui.item.city);
            $(this).trigger("change");
        }
    });

    //Autocomplétion de la ville
    $('#billing_address_city, #shipping_address_city').autocomplete({
		minLength:3,
		disabled: apiBanDisabled,
        source: function(request, response){
            const self = this;
            $.ajax({
                url: "https://api-adresse.data.gouv.fr/search/?q=" + $(self.element).val() + "&type=municipality&limit=20&autocomplete=1",
                data: {q: request.term},
                dataType: "json",
                success: function(data){
                    var villes = [];
                    response($.map(data.features, function(item){
                        if($.inArray(item.properties.city, villes == -1)){
                            villes.push(item.properties.city);
                            var ville = item.properties.city;
                            var villeReg = ville.replace(/\s\d*[e]\sArrondissement/,'');
                            return {label: item.properties.postcode + " " + item.properties.city,
                                    postcode: item.properties.postcode,
                                    value: villeReg
                                };
                        }
                    }));
                }
            });
        },
        select: function(event,ui)
        {
        	var postcode = '';
        	if($(event.target).attr('id') == 'billing_address_city'){
        		postcode = 'billing_address_postalcode';
        	}else{
        		postcode = 'shipping_address_postalcode';
        	}
            $('#'+postcode).val(ui.item.postcode);
            $(this).trigger("change");
        }
    });

    //Autocomplétion de la voie
    $('#billing_address_street, #shipping_address_street').autocomplete({
		minLength:3,
		disabled: apiBanDisabled,
        source: function(request, response){
            const self = this;
            $.ajax({
                url: "https://api-adresse.data.gouv.fr/search/?q=" + $(self.element).val() + "&type=street&limit=10&autocomplete=1",
                data: {q: request.term},
                dataType: "json",
                success: function(data){
                    var voies = [];
                    response($.map(data.features, function(item){
                        if($.inArray(item.properties.name, voies) == -1){
                            voies.push(item.properties.name);
                            return {label: item.properties.name,
                                    value: item.properties.name
                                };
                        }
                    }));
                }
            });
        }
    });

    $('#billing_address_number, #billing_address_street, #billing_address_city, #billing_address_postalcode').change(function(){
    	getAdresse('billing', apiBanDisabled);
    });

    $('#shipping_address_number, #shipping_address_street, #shipping_address_city, #shipping_address_postalcode').change(function(){
    	getAdresse('shipping',apiBanDisabled);
    });

});

function getAdresse(champ, apiBanDisabled){
	if(apiBanDisabled) return;
	if($('#'+champ+'_address_street').val() != '' && $('#'+champ+'_address_city').val() != '' && $('#'+champ+'_address_postalcode').val() != '' ){
		var adresse = $('#'+champ+'_address_number').val() + $('#'+champ+'_address_street').val() + $('#'+champ+'_address_city').val() + $('#'+champ+'_address_postalcode').val();
		$.ajax({
            url: "https://api-adresse.data.gouv.fr/search/?q="+adresse,
            dataType:"json",
            success: function(data){
            	if(data.features.length != 0){
                    if(champ == 'billing'){
	            		$('#'+champ+'_coordonnees_x').val(data.features[0].geometry.coordinates[1]);
	                    $('#'+champ+'_coordonnees_y').val(data.features[0].geometry.coordinates[0]);
	                    $('#'+champ+'_id_adresse').val(data.features[0].properties.id);
	                    $('#'+champ+'_code_insee').val(data.features[0].properties.citycode);
                    }else{
                    	$('#'+champ+'_address_coordonnees_x').val(data.features[0].geometry.coordinates[1]);
	                    $('#'+champ+'_address_coordonnees_y').val(data.features[0].geometry.coordinates[0]);
                    }
            	}
            }
        });
	}
}

function check_agrement_administratif()
{
	if(!$('#agrement_administratif').is(':checked'))
    {
        $('#detail_agrement').parent().parent().hide();
    }
    else
    {
        $('#detail_agrement').parent().parent().show();
    }
}

function check_utilite_publique()
{
	if(!$('#utilite_publique').is(':checked'))
    {
        $('#date_utilite_publique').parent().parent().parent().hide();
    }
    else
    {
        $('#date_utilite_publique').parent().parent().parent().show();
    }
}

function check_affiliee_reseau()
{
	if(!$('#affiliee_reseau').is(':checked'))
    {
        $('#detail_affiliation').parent().parent().hide();
    }
    else
    {
        $('#detail_affiliation').parent().parent().show();
    }
}

function verif_siret() {

	var estValide;
	var siret = document.getElementById("siret").value ;
	siret = siret.replace(/ /gi , "");

	if ( (siret.length != 14) || (isNaN(siret)) ){
		estValide = false;
	}
	else {
		var somme = 0;
		var tmp;
		for (var cpt = 0; cpt<siret.length; cpt++) {
			if ((cpt % 2) == 0) { // Les positions impaires : 1er, 3è, 5è, etc...
				tmp = siret.charAt(cpt) * 2; // On le multiplie par 2
				if (tmp > 9)
					tmp -= 9;	// Si le résultat est supérieur à 9, on lui soustrait 9
			}
			else
				tmp = siret.charAt(cpt);
			somme += parseInt(tmp);
		}
		if ((somme % 10) == 0)
			estValide = true; // Si la somme est un multiple de 10 alors le SIRET est valide
		else
			estValide = false;

	}

	if( estValide == false ){ 
	   tag_echec("siret");
	}
	 else{
	   tag_succes('siret');
	}  
}

function verif_num_tahiti() {

    var estValide;

    var num_tahiti = jQuery("#num_tahiti").val();
    num_tahiti = String( num_tahiti.replace(/ /gi , "") );

    if( num_tahiti.length < 2 || num_tahiti.length > 6 ){
        estValide = false;
    }else{
        // Sinon on approfondi la détection...
        if( (/([a-zA-Z0-9]{1,1})[0-9]{5}/g).test( num_tahiti ) 
         || (/^[0-9]{2,6}/g).test( num_tahiti ) )
        {
            // Cas 6 caractères : ( 1L | 1D ) + 5D
            // Cas 2 à 6 chiffres : Ne peut commencer par 1L, et peut 2D à 6D 
            estValide = true;
        }else{
            estValide = false;
        }

    }

	if( estValide == false ){
		document.getElementById("num_tahiti").value = "";
	   tag_echec("num_tahiti");
	}
	 else{
	   tag_succes('num_tahiti');
	}  


}

function verif_rna() {

	var estValide;
	var rna = document.getElementById("numero_rna").value ;

	if ( rna.length != 10 || rna.substr(0, 1) != "W" || /^[A-Za-z0-9]*$/.test( rna.substr(1, 10) ) !== true ){
		estValide = false;
	}

	if( estValide == false ){
	   tag_echec("numero_rna");
	}
	 else{
	   tag_succes('numero_rna');
	}  


}

function verif_rne() {

	var estValide;
	var rne = document.getElementById("numero_rne").value ;

	if ( rne.length !=  8 || isNaN( rne.substr(6, 7) ) == false  || isNaN( rne.substr(0, 6) ) == true ){

		estValide = false;

	}


	if( estValide == false ){
	   tag_echec("numero_rne");
	}
	 else{
	   tag_succes('numero_rne');
	}  

}

function verif_tel( tel ){

	var estValide;
	var tel = document.getElementById("phone_office").value ;
	tel = tel.replace(/ /gi , "");

	var valide=/^0[1-6]\d{8}$/;

	if(	!valide.test(tel)){
		estValide = false;
	}

	if( estValide == false ){
	   tag_echec("phone_office");
	}
	 else{
	   tag_succes('phone_office');
	}  

}

function addUppercaseToCodeApe(){
	$( "#code_ape" ).val( String( $( "#code_ape" ).val() ).toUpperCase() );
}

function tag_succes(champ){
   $('#'+champ).attr('style', '!important;border-color:#E6E7EA !important');
}

function tag_echec(champ){
   $('#'+champ).attr('style', '!important;border-color:red !important');
   $("#msg_erreur_"+champ).remove();
   $("#"+champ).after('<div id="msg_erreur_'+champ+'" >Le format saisi est incorrect</div>');

   setTimeout( function() {
          $("#msg_erreur_"+champ).remove();
          }, 3000);
}

function b64_to_utf8( str ) {
	return decodeURIComponent(escape(window.atob( str )));
}

Object.size = function(obj) {
	var size = 0, key;
	for (key in obj) {
		if (obj.hasOwnProperty(key)) size++;
	}
	return size;
};

function onChangeSelectTypeTiers() {

	var type_tiers = getTypeTiers();
	var type_tiers_id = $("#select_type_personne_initial").children("option:selected").attr("id");
	$("#ops_type_tiers_id").val(type_tiers_id);
	$("#ops_type_personne_id").val("");
	if ( type_tiers.hasOwnProperty(type_tiers_id) ) {
		var type_personnes = type_tiers[type_tiers_id].type_personnes;
		if( Object.size(type_personnes) > 0 ){
			Object.keys(type_personnes).forEach(function(type_personne_id) {
				const type_personne_name = type_personnes[type_personne_id];
				$("#select_type_personne_initial").append('<option id="'+ type_personne_id +'">'+ type_personne_name +'</option>');
			});
		}
	}
	var formeJuridiques = getFormeJuridiques();
	$("#forme_juridique").empty();
	if(formeJuridiques.hasOwnProperty(type_tiers_id)){
		var forme_juridique = formeJuridiques[type_tiers_id].forme_juridique;
		if( Object.size(forme_juridique) > 0){
			Object.keys(forme_juridique).forEach(function(forme_juridique_id){
				const forme_juridique_name = forme_juridique[forme_juridique_id];
				$("#forme_juridique").append('<option id="'+forme_juridique_id+'" value="'+forme_juridique_id+'" label="'+forme_juridique_name+'">'+forme_juridique_name+'</option>');
			})
		}
	}else{
		var forme_juridique = formeJuridiques["all"].forme_juridique;
		Object.keys(forme_juridique).forEach(function(forme_juridique_id){
			const forme_juridique_name = forme_juridique[forme_juridique_id];
			$("#forme_juridique").append('<option id="'+forme_juridique_id+'" value="'+forme_juridique_id+'" label="'+forme_juridique_name+'">'+forme_juridique_name+'</option>');
		})
	}

	var effectifList = getEffectifs();
	$("#effectif").empty();
	$("#effectif").append('<option id=""></option>');
	if(effectifList.hasOwnProperty(type_tiers_id)){
		var effectif = effectifList[type_tiers_id].effectif;
		if( Object.size(effectif) > 0){
			Object.keys(effectif).forEach(function(effectif_id){
				const effectif_name = effectif[effectif_id];
				$("#effectif").append('<option id="'+effectif_id+'" value="'+effectif_id+'" label="'+effectif_name+'">'+effectif_name+'</option>');
			})
		}
	}else{
		var effectif = effectifList["all"].effectif;
		Object.keys(effectif).forEach(function(effectif_id){
			const effectif_name = effectif[effectif_id];
			$("#effectif").append('<option id="'+effectif_id+'" value="'+effectif_id+'" label="'+effectif_name+'">'+effectif_name+'</option>');
		})
	}

	var natureList = getNatures();
	$("#nature").empty();
	$("#nature").append('<option id=""></option>');
	if(natureList.hasOwnProperty(type_tiers_id)){
		var nature = natureList[type_tiers_id].nature;
		if( Object.size(nature) > 0){
			Object.keys(nature).forEach(function(nature_id){
				const nature_name = nature[nature_id];
				$("#nature").append('<option id="'+nature_id+'" value="'+nature_id+'" label="'+nature_name+'">'+nature_name+'</option>');
			})
		}
	}else{
		var nature = natureList["all"].nature;
		Object.keys(nature).forEach(function(nature_id){
			const nature_name = nature[nature_id];
			$("#nature").append('<option id="'+nature_id+'" value="'+nature_id+'" label="'+nature_name+'">'+nature_name+'</option>');
		})
	}

	replaceLibelle();

	loadObligatoires();
}

function loadObligatoires(){
	var obligatoires = getObligatoires();
	var type_tiers_id = $("#select_type_personne_initial").children("option:selected").attr("id");
	var view = '';

	$("#ops_type_personne_id").val(type_tiers_id);

	$('form').each(function(){
		if(this.id == 'EditView' || this.id == 'form_SubpanelQuickCreate_OPS_personne_morale'){
			view = this.id;
		}
	});

	if(typeof type_tiers_id != "undefined" || type_tiers_id != null){
		if(obligatoires[type_tiers_id]['code_ape'] == 'required'){
			$('#code_ape').parent().parent().show();
			if( 0 == $('#code_ape').parent().parent().children('div')[0].children.length ){
				$('#code_ape').parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'code_ape','enum',true,obligatoires['langue']['LBL_CODE_APE']);
		}else if(obligatoires[type_tiers_id]['code_ape'] == 'hidden'){
			$('#code_ape').parent().parent().hide();
			$('#code_ape').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'code_ape');
		}else{
			$('#code_ape').parent().parent().children('div').children('span.required').remove();
			$('#code_ape').parent().parent().show();
			removeFromValidate(view,'code_ape');
			addToValidate(view,'code_ape','enum',false,obligatoires['langue']['LBL_CODE_APE']);
		}

		if(obligatoires[type_tiers_id]['date_declaration'] == 'required'){
			$('#date_declaration').parent().parent().parent().show();
			if( 0 == $('#date_declaration').parent().parent().parent().children('div')[0].children.length ){
				$('#date_declaration').parent().parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'date_declaration','enum',true,obligatoires['langue']['LBL_DATE_DECLARATION']);
		}else if(obligatoires[type_tiers_id]['date_declaration'] == 'hidden'){
			$('#date_declaration').parent().parent().parent().hide();
			$('#date_declaration').parent().parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'date_declaration');
		}else{
			$('#date_declaration').parent().parent().parent().children('div').children('span.required').remove();
			$('#date_declaration').parent().parent().parent().show();
			removeFromValidate(view,'date_declaration');
			addToValidate(view,'date_declaration','enum',false,obligatoires['langue']['LBL_DATE_DECLARATION']);
		}

		if(obligatoires[type_tiers_id]['numero_rne'] == 'required'){
			$('#numero_rne').parent().parent().show();
			if( 0 == $('#numero_rne').parent().parent().children('div')[0].children.length ){
				$('#numero_rne').parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'numero_rne','varchar',true,obligatoires['langue']['LBL_NUMERO_RNE']);
		}else if(obligatoires[type_tiers_id]['numero_rne'] == 'hidden'){
			$('#numero_rne').parent().parent().hide();
			$('#numero_rne').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'numero_rne');
		}else{
			$('#numero_rne').parent().parent().children('div').children('span.required').remove();
			$('#numero_rne').parent().parent().show();
			removeFromValidate(view,'numero_rne');
			addToValidate(view,'numero_rne','varchar',false,obligatoires['langue']['LBL_NUMERO_RNE']);
		}

		if(obligatoires[type_tiers_id]['numero_rna'] == 'required'){
			$('#numero_rna').parent().parent().show();
			if( 0 == $('#numero_rna').parent().parent().children('div')[0].children.length ){
				$('#numero_rna').parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'numero_rna','varchar',true,obligatoires['langue']['LBL_NUMERO_RNA']);
		}else if(obligatoires[type_tiers_id]['numero_rna'] == 'hidden'){
			$('#numero_rna').parent().parent().hide();
			$('#numero_rna').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'numero_rna');
		}else{
			$('#numero_rna').parent().parent().children('div').children('span.required').remove();
			$('#numero_rna').parent().parent().show();
			removeFromValidate(view,'numero_rna');
			addToValidate(view,'numero_rna','varchar',false,obligatoires['langue']['LBL_NUMERO_RNA']);
		}

				if(obligatoires[type_tiers_id]['num_tahiti'] == 'required'){
			$('#num_tahiti').parent().parent().show();
			if( 0 == $('#num_tahiti').parent().parent().children('div')[0].children.length ){
				$('#num_tahiti').parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'num_tahiti','varchar',true,obligatoires['langue']['LBL_num_tahiti']);
		}else if(obligatoires[type_tiers_id]['num_tahiti'] == 'hidden'){
			$('#num_tahiti').parent().parent().hide();
			$('#num_tahiti').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'num_tahiti');
		}else{
			$('#num_tahiti').parent().parent().children('div').children('span.required').remove();
			$('#num_tahiti').parent().parent().show();
			removeFromValidate(view,'num_tahiti');
			addToValidate(view,'num_tahiti','varchar',false,obligatoires['langue']['LBL_num_tahiti']);
		}


		if(obligatoires[type_tiers_id]['siret'] == 'required'){
			$('#siret').parent().parent().show();
			if( 0 == $('#siret').parent().parent().children('div')[0].children.length ){
				$('#siret').parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'siret','varchar',true,obligatoires['langue']['LBL_SIRET']);
		}else if(obligatoires[type_tiers_id]['siret'] == 'hidden'){
			$('#siret').parent().parent().hide();
			$('#siret').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'siret');
		}else{
			$('#siret').parent().parent().children('div').children('span.required').remove();
			$('#siret').parent().parent().show();
			removeFromValidate(view,'siret');
			addToValidate(view,'siret','varchar',false,obligatoires['langue']['LBL_SIRET']);
		}

		if(obligatoires[type_tiers_id]['objet_social'] == 'required'){
			$('#objet_social').parent().parent().show();
			if( 0 == $('#objet_social').parent().parent().children('div')[0].children.length ){
				$('#objet_social').parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'objet_social','varchar',true,obligatoires['langue']['LBL_OBJET_SOCIAL']);
		}else if(obligatoires[type_tiers_id]['objet_social'] == 'hidden'){
			$('#objet_social').parent().parent().hide();
			$('#objet_social').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'objet_social');
		}else{
			$('#objet_social').parent().parent().children('div').children('span.required').remove();
			$('#objet_social').parent().parent().show();
			removeFromValidate(view,'objet_social');
			addToValidate(view,'objet_social','varchar',false,obligatoires['langue']['LBL_OBJET_SOCIAL']);
		}

		if(obligatoires[type_tiers_id]['sigle'] == 'required'){
			$('#sigle').parent().parent().show();
			if( 0 == $('#sigle').parent().parent().children('div')[0].children.length ){
				$('#sigle').parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'sigle','varchar',true,obligatoires['langue']['LBL_SIGLE']);
		}else if(obligatoires[type_tiers_id]['sigle'] == 'hidden'){
			$('#sigle').parent().parent().hide();
			$('#sigle').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'sigle');
		}else{
			$('#sigle').parent().parent().children('div').children('span.required').remove();
			$('#sigle').parent().parent().show();
			removeFromValidate(view,'sigle');
			addToValidate(view,'sigle','varchar',false,obligatoires['langue']['LBL_SIGLE']);
		}

		if(obligatoires[type_tiers_id]['website'] == 'required'){
			$('#website').parent().parent().show();
			if( 0 == $('#website').parent().parent().children('div')[0].children.length ){
				$('#website').parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'website','varchar',true,obligatoires['langue']['LBL_WEBSITE']);
		}else if(obligatoires[type_tiers_id]['website'] == 'hidden'){
			$('#website').parent().parent().hide();
			$('#website').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'website');
		}else{
			$('#website').parent().parent().children('div').children('span.required').remove();
			$('#website').parent().parent().show();
			removeFromValidate(view,'website');
			addToValidate(view,'website','varchar',false,obligatoires['langue']['LBL_WEBSITE']);
		}

		if(obligatoires[type_tiers_id]['forme_juridique'] == 'required'){
			$('#forme_juridique').parent().parent().show();
			if( 0 == $('#forme_juridique').parent().parent().children('div')[0].children.length ){
				$('#forme_juridique').parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'forme_juridique','enum',true,obligatoires['langue']['LBL_FORME_JURIDIQUE']);
		}else if(obligatoires[type_tiers_id]['forme_juridique'] == 'hidden'){
			$('#forme_juridique').parent().parent().hide();
			$('#forme_juridique').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'forme_juridique');
		}else{
			$('#forme_juridique').parent().parent().children('div').children('span.required').remove();
			$('#forme_juridique').parent().parent().show();
			removeFromValidate(view,'forme_juridique');
			addToValidate(view,'forme_juridique','enum',false,obligatoires['langue']['LBL_FORME_JURIDIQUE']);
		}

		if(obligatoires[type_tiers_id]['effectif'] == 'required'){
			$('#effectif').parent().parent().show();
			if( 0 == $('#effectif').parent().parent().children('div')[0].children.length ){
				$('#effectif').parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'effectif','enum',true,obligatoires['langue']['LBL_EFFECTIF']);
		}else if(obligatoires[type_tiers_id]['effectif'] == 'hidden'){
			$('#effectif').parent().parent().hide();
			$('#effectif').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'effectif');
		}else{
			$('#effectif').parent().parent().children('div').children('span.required').remove();
			$('#effectif').parent().parent().show();
			removeFromValidate(view,'effectif');
			addToValidate(view,'effectif','enum',false,obligatoires['langue']['LBL_EFFECTIF']);
		}

		if(obligatoires[type_tiers_id]['nature'] == 'required'){
			$('#nature').parent().parent().show();
			if( 0 == $('#nature').parent().parent().children('div')[0].children.length ){
				$('#nature').parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'nature','enum',true,obligatoires['langue']['LBL_NATURE']);
		}else if(obligatoires[type_tiers_id]['nature'] == 'hidden'){
			$('#nature').parent().parent().hide();
			$('#nature').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'nature');
		}else{
			$('#nature').parent().parent().children('div').children('span.required').remove();
			$('#nature').parent().parent().show();
			removeFromValidate(view,'nature');
			addToValidate(view,'nature','enum',false,obligatoires['langue']['LBL_NATURE']);
		}

		if(obligatoires[type_tiers_id]['situation_handicap'] == 'hidden'){
			$('#situation_handicap').parent().parent().hide();
			$('#situation_handicap').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'situation_handicap');
		}else{
			$('#situation_handicap').parent().parent().children('div').children('span.required').remove();
			$('#situation_handicap').parent().parent().show();
			removeFromValidate(view,'situation_handicap');
			addToValidate(view,'situation_handicap','bool',false,obligatoires['langue']['LBL_SITUATION_HANDICAP']);
		}
		
		if(obligatoires[type_tiers_id]['secteur_activite'] == 'hidden'){
			$('#secteur_activite').parent().parent().hide();
			$('#secteur_activite').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'secteur_activite');
		}else if(obligatoires[type_tiers_id]['secteur_activite'] == 'required'){
			$('#secteur_activite').parent().parent().show();
			if( 0 == $('#secteur_activite').parent().parent().children('div')[0].children.length ){
				$('#secteur_activite').parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'secteur_activite','varchar',true,obligatoires['langue']['LBL_SECTEUR_ACTIVITE']);
		}else{
			$('#secteur_activite').parent().parent().children('div').children('span.required').remove();
			$('#secteur_activite').parent().parent().show();
			removeFromValidate(view,'secteur_activite');
			addToValidate(view,'secteur_activite','enum',false,obligatoires['langue']['LBL_SECTEUR_ACTIVITE']);
		}

		if(obligatoires[type_tiers_id]['adresse_date_validite'] == 'required'){
			$('#adresse_date_validite').parent().parent().parent().show();
			if( 0 == $('#adresse_date_validite').parent().parent().parent().children('div')[0].children.length ){
				$('#adresse_date_validite').parent().parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'adresse_date_validite','varchar',true,obligatoires['langue']['LBL_adresse_date_validite']);
		}else if(obligatoires[type_tiers_id]['adresse_date_validite'] == 'hidden'){
			$('#adresse_date_validite').parent().parent().parent().hide();
			$('#adresse_date_validite').parent().parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'adresse_date_validite');
		}else{
			$('#adresse_date_validite').parent().parent().parent().children('div').children('span.required').remove();
			$('#adresse_date_validite').parent().parent().parent().show();
			removeFromValidate(view,'adresse_date_validite');
			addToValidate(view,'adresse_date_validite','varchar',false,obligatoires['langue']['LBL_adresse_date_validite']);
		}

		if(obligatoires[type_tiers_id]['adresse_hors_commune'] == 'required'){
			$('#adresse_hors_commune').parent().parent().show();
			if( 0 == $('#adresse_hors_commune').parent().parent().children('div')[0].children.length ){
				$('#adresse_hors_commune').parent().parent().children('div').first().append('<span class="required">*</span>');
			}
			addToValidate(view,'adresse_hors_commune','enum',true,obligatoires['langue']['LBL_adresse_hors_commune']);
		}else if(obligatoires[type_tiers_id]['adresse_hors_commune'] == 'hidden'){
			$('#adresse_hors_commune').parent().parent().hide();
			$('#adresse_hors_commune').parent().parent().children('div').children('span.required').remove();
			removeFromValidate(view,'adresse_hors_commune');
		}else{
			$('#adresse_hors_commune').parent().parent().children('div').children('span.required').remove();
			$('#adresse_hors_commune').parent().parent().show();
			removeFromValidate(view,'adresse_hors_commune');
			addToValidate(view,'adresse_hors_commune','enum',false,obligatoires['langue']['LBL_adresse_hors_commune']);
		}

		console.log( obligatoires[type_tiers_id]['adresse_date_validite'] );
		console.log( obligatoires[type_tiers_id]['adresse_hors_commune'] );

		if(obligatoires[type_tiers_id]['display_relation'] == 0){
			$('a[id=tab1]').hide();
		}else{
			$('a[id=tab1]').show();
		}

		if(obligatoires[type_tiers_id]['display_annuaire'] == 0){
			$('a[id=tab2]').hide();
		}else{
			$('a[id=tab2]').show();
		}

		if(obligatoires[type_tiers_id]['display_formule'] == 0){
			$('a[id=tab3]').hide();
		}else{
			$('a[id=tab3]').show();
		}

		if(obligatoires[type_tiers_id]['display_info_fiscales'] == 0){
			$('a[id=tab4]').hide();
		}else{
			$('a[id=tab4]').show();
		}
	}else{
		$('#num_tahiti').parent().parent().children('div').children('span.required').remove();
		$('#num_tahiti').parent().parent().show();
		removeFromValidate(view,'num_tahiti');
		addToValidate(view,'num_tahiti','enum',false,obligatoires['langue']['LBL_num_tahiti']);
		$('#date_declaration').parent().parent().children('div').children('span.required').remove();
		$('#date_declaration').parent().parent().show();
		removeFromValidate(view,'date_declaration');
		addToValidate(view,'date_declaration','enum',false,obligatoires['langue']['LBL_DATE_DECLARATION']);
		$('#code_ape').parent().parent().children('div').children('span.required').remove();
		$('#code_ape').parent().parent().show();
		removeFromValidate(view,'code_ape');
		addToValidate(view,'code_ape','enum',false,obligatoires['langue']['LBL_CODE_APE']);
		$('#numero_rne').parent().parent().children('div').children('span.required').remove();
		$('#numero_rne').parent().parent().show();
		removeFromValidate(view,'numero_rne');
		addToValidate(view,'numero_rne','varchar',false,obligatoires['langue']['LBL_NUMERO_RNE']);
		$('#numero_rna').parent().parent().children('div').children('span.required').remove();
		$('#numero_rna').parent().parent().show();
		removeFromValidate(view,'numero_rna');
		addToValidate(view,'numero_rna','varchar',false,obligatoires['langue']['LBL_NUMERO_RNA']);
		$('#siret').parent().parent().children('div').children('span.required').remove();
		$('#siret').parent().parent().show();
		removeFromValidate(view,'siret');
		addToValidate(view,'siret','varchar',false,obligatoires['langue']['LBL_SIRET']);
		$('#objet_social').parent().parent().children('div').children('span.required').remove();
		$('#objet_social').parent().parent().show();
		removeFromValidate(view,'objet_social');
		addToValidate(view,'objet_social','varchar',false,obligatoires['langue']['LBL_OBJET_SOCIAL']);
		$('#sigle').parent().parent().children('div').children('span.required').remove();
		$('#sigle').parent().parent().show();
		removeFromValidate(view,'sigle');
		addToValidate(view,'sigle','varchar',false,obligatoires['langue']['LBL_SIGLE']);
		$('#website').parent().parent().children('div').children('span.required').remove();
		$('#website').parent().parent().show();
		removeFromValidate(view,'website');
		addToValidate(view,'website','varchar',false,obligatoires['langue']['LBL_WEBSITE']);
		$('#forme_juridique').parent().parent().children('div').children('span.required').remove();
		$('#forme_juridique').parent().parent().show();
		removeFromValidate(view,'forme_juridique');
		addToValidate(view,'forme_juridique','enum',false,obligatoires['langue']['LBL_FORME_JURIDIQUE']);
		$('#effectif').parent().parent().children('div').children('span.required').remove();
		$('#effectif').parent().parent().show();
		removeFromValidate(view,'effectif');
		addToValidate(view,'effectif','enum',false,obligatoires['langue']['LBL_EFFECTIF']);
		$('#nature').parent().parent().children('div').children('span.required').remove();
		$('#nature').parent().parent().show();
		removeFromValidate(view,'nature');
		addToValidate(view,'nature','enum',false,obligatoires['langue']['LBL_NATURE']);
		$('#situation_handicap').parent().parent().children('div').children('span.required').remove();
		$('#situation_handicap').parent().parent().show();
		removeFromValidate(view,'situation_handicap');
		addToValidate(view,'situation_handicap','enum',false,obligatoires['langue']['LBL_SITUATION_HANDICAP']);
		$('#secteur_activite').parent().parent().children('div').children('span.required').remove();
		$('#secteur_activite').parent().parent().show();
		removeFromValidate(view,'secteur_activite');
		addToValidate(view,'secteur_activite','enum',false,obligatoires['langue']['LBL_SECTEUR_ACTIVITE']);
	}
}

function replaceLibelle()
{
	var type_tiers_id = $("#select_type_personne_initial").children("option:selected").attr("id");
	if (typeof type_tiers_id != "undefined" || type_tiers_id != null)
	{
		var type_tiers_libelles = getTypeTiersLibelle();
		var libelle = type_tiers_libelles[type_tiers_id];

		if(libelle != '')
	    {
	    	var label = $('div[field=name]').parent().children()[0];
			$(label).text("\n" + libelle + ':');
			$(label).append('<span class="required">*</span>');
	    }
	}
}

function getTypeTiers( ) {
	return ( $("#personne_morale_type_tiers").val() !== "" ) ? JSON.parse( b64_to_utf8( $("#personne_morale_type_tiers").val() ) ) : {} ;
}

function getTypeTiersLibelle( ) {
	return ( $("#personne_morale_type_tiers_libelle").val() !== "" ) ? JSON.parse( b64_to_utf8( $("#personne_morale_type_tiers_libelle").val() ) ) : {} ;
}

function getFormeJuridiques(){
	return ( $("#personne_morale_forme_juridique").val() !== "" ) ? JSON.parse( b64_to_utf8( $("#personne_morale_forme_juridique").val() ) ) : {} ;
}

function getEffectifs(){
	return ( $("#personne_morale_effectif").val() !== "" ) ? JSON.parse( b64_to_utf8( $("#personne_morale_effectif").val() ) ) : {} ;
}

function getNatures(){
	return ( $("#personne_morale_nature").val() !== "" ) ? JSON.parse( b64_to_utf8( $("#personne_morale_nature").val() ) ) : {} ;
}

function getObligatoires(){
	return ( $("#personne_morale_obligatoire").val() !== "" ) ? JSON.parse( b64_to_utf8( $("#personne_morale_obligatoire").val() ) ) : {} ;
}

/**
 * Applicateur de masque téléphone
 * 
 * @return void.
 */
function apply_phone_mask(input_field_selector) {
    var mask_array = ($(input_field_selector)[0].dataset.mask).split(',')
    $(input_field_selector).inputmask({
        mask: mask_array,
        greedy: false,
        clearIncomplete: true,
        definitions: {
            'T': {
                validator: "[4]"
            },
            'Z': {
                validator: "[0]"
            },
            'V': {
                validator: "[8]"
            },
            'R': {
                validator: "[2]"
            },
            'W': {
                validator: "[2-3]"
            },
            'F': {
                validator: "[3]"
            },
            'M': {
                validator: "[7]"
            },
            'I': {
                validator: "[6]"
            },
            'C': {
                validator: "[1-5]"
            },
            'G': {
                validator: "[6-7]"
            },
            'D': {
                validator: "[9]"
            },
            'E': {
                validator: "[5]"
            }
        },
        onBeforePaste: function (pastedValue, opts) {
            // For paired 6, 8 and 10 numbers!
            if (String(pastedValue).trim().length == 6 || String(pastedValue).trim().length == 10) {
                pastedValue = String(pastedValue).trim();
                numbers = pastedValue.match(/[0-9]{2}/g);
                return numbers.join(".");
            }

            // For not paired 7, 9 numbers!
            if (String(pastedValue).trim().length == 7 || String(pastedValue).trim().length == 9) {
                pastedValue = '0' + String(pastedValue).trim();
                numbers = pastedValue.match(/[0-9]{2}/g);
                numbers[0] = String(parseInt(numbers[0]));
                return numbers.join(".");
            }

        }
    });
}

function select_on_focus(field) {
    $(field).on('focus active', function (e) {
        $(e.target).select();
    });
};


function getApiBan(){
	var apiBanDisabled = false;
	$.ajax({
		url: "index.php",
        data: {
            module: 'OPS_personne_morale',
            action: 'getApiBan',
        },
		async:false,
		success: function(data){
			apiBanDisabled = JSON.parse(data).apiBanDisabled;

		}
	});

	return apiBanDisabled;


}