<?php

$dictionary['OPS_individu'] = array(
    'table' => 'ops_individu',
    'audited' => true,
    'inline_edit' => true,
    'duplicate_merge' => true,
    'fields' => array(

        'salutation' => array(
            'name' => 'salutation',
            'vname' => 'LBL_SALUTATION',
            'type' => 'enum',
            'options' => 'salutation_dom',
            'massupdate' => false,
            'len' => '255',
            'audited' => true,
            'duplicate_merge' => 'enabled',
        ),
        'first_name' => array(
            'name' => 'first_name',
            'vname' => 'LBL_FIRST_NAME',
            'type' => 'varchar',
            'len' => '100',
            'unified_search' => true,
            'full_text_search' => array('boost' => 3),
            'merge_filter' => 'selected',
            'audited' => true,
        ),
        'last_name' => array(
            'name' => 'last_name',
            'vname' => 'LBL_LAST_NAME',
            'type' => 'varchar',
            'len' => '100',
            'unified_search' => true,
            'full_text_search' => array('boost' => 3),
            'merge_filter' => 'selected',
            'required' => true,
            'importable' => 'required',
            'audited' => true,
        ),
        'phone_home' => array(
            'name' => 'phone_home',
            'vname' => 'LBL_HOME_PHONE',
            'type' => 'phone',
            'dbType' => 'varchar',
            'len' => 100,
            'unified_search' => true,
            'full_text_search' => array('boost' => 1),
            'merge_filter' => 'enabled',
            'audited' => true,
        ),
        'phone_mobile' => array(
            'name' => 'phone_mobile',
            'vname' => 'LBL_MOBILE_PHONE',
            'type' => 'phone',
            'dbType' => 'varchar',
            'len' => 100,
            'unified_search' => true,
            'full_text_search' => array('boost' => 1),
            'merge_filter' => 'enabled',
            'audited' => true,
        ),
        'phone_work' => array(
            'name' => 'phone_work',
            'vname' => 'LBL_OFFICE_PHONE',
            'type' => 'phone',
            'dbType' => 'varchar',
            'len' => 100,
            'audited' => true,
            'unified_search' => true,
            'full_text_search' => array('boost' => 1),
            'merge_filter' => 'enabled',
        ),
        'phone_other' => array(
            'name' => 'phone_other',
            'vname' => 'LBL_OTHER_PHONE',
            'type' => 'phone',
            'dbType' => 'varchar',
            'len' => 100,
            'audited' => true,
            'unified_search' => true,
            'full_text_search' => array('boost' => 1),
            'comment' => 'Other phone number for the contact',
            'merge_filter' => 'enabled',
        ),
        'lawful_basis' => array(
            'name' => 'lawful_basis',
            'vname' => 'LBL_LAWFUL_BASIS',
            'type' => 'multienum',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'inline_edit' => false,
            'reportable' => false,
            'merge_filter' => 'enabled',
            'len' => 100,
            'size' => '20',
            'options' => 'lawful_basis_dom',
            'audited' => false,
            'importable' => false,
            'default' => '',
        ),
        'date_reviewed' => array(
            'name' => 'date_reviewed',
            'vname' => 'LBL_DATE_REVIEWED',
            'type' => 'date',
            'massupdate' => false,
            'audited' => true,
            'importable' => true,
        ),
        'lawful_basis_source' => array(
            'name' => 'lawful_basis_source',
            'vname' => 'LBL_LAWFUL_BASIS_SOURCE',
            'type' => 'enum',
            'massupdate' => false,
            'no_default' => false,
            'comments' => '',
            'inline_edit' => false,
            'reportable' => false,
            'merge_filter' => 'enabled',
            'len' => 100,
            'size' => '20',
            'options' => 'lawful_basis_source_dom',
            'audited' => false,
            'importable' => true,
        ),
        'do_not_call' => array(
            'name' => 'do_not_call',
            'vname' => 'LBL_DO_NOT_CALL',
            'type' => 'bool',
            'massupdate' => false,
            'default' => '0',
            'audited' => true,
        ),
        'assigned_user_id' => array(
            'name' => 'assigned_user_id',
            'rname' => 'user_name',
            'id_name' => 'assigned_user_id',
            'vname' => 'LBL_ASSIGNED_TO_ID',
            'group' => 'assigned_user_name',
            'massupdate' => false,
            'type' => 'relate',
            'table' => 'users',
            'module' => 'Users',
            'reportable' => true,
            'isnull' => 'false',
            'dbType' => 'id',
            'audited' => true,
            'comment' => 'User ID assigned to record',
            'duplicate_merge' => 'disabled'
        ),

        'date_naissance' => array(
            'required' => false,
            'name' => 'date_naissance',
            'vname' => 'LBL_DATE_NAISSANCE',
            'type' => 'date',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'enable_range_search' => false,
            'duplicate_merge' => 'enabled',
        ),
        'lieu_naissance' => array(
            'required' => false,
            'name' => 'lieu_naissance',
            'vname' => 'LBL_LIEU_NAISSANCE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),
        'nationalite' => array(
            'required' => false,
            'name' => 'nationalite',
            'vname' => 'LBL_NATIONALITE',
            'type' => 'enum',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_nationalite_list',
            'studio' => 'visible',
            'dependency' => false,
            'duplicate_merge' => 'enabled',
        ),

        'reference' => array(
            'required' => false,
            'name' => 'reference',
            'vname' => 'LBL_REFERENCE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'tiers_financier' => array(
            'required' => false,
            'name' => 'tiers_financier',
            'vname' => 'LBL_TIERS_FINANCIER',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'financeur' => array(
            'required' => false,
            'name' => 'financeur',
            'vname' => 'LBL_FINANCEUR',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20'
        ),
        'num_individu' => array(
            'required' => false,
            'name' => 'num_individu',
            'vname' => 'LBL_NUM_INDIVIDU',
            'type' => 'int',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => false,
            'reportable' => true,
            'unified_search' => true,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'enable_range_search' => false,
            'disable_num_format' => '1',
            'min' => 1,
            'max' => false,
            'validation' => array(
                'type' => 'range',
                'min' => 1,
                'max' => false
            )
        ),
        //bug 42902 
        'email'=>
        array(
             'name' => 'email',
             'type' => 'email',
             'query_type' => 'default',
             'source' => 'non-db',
             'operator' => 'subquery',
             'subquery' => 'SELECT eabr.bean_id FROM email_addr_bean_rel eabr JOIN email_addresses ea ON (ea.id = eabr.email_address_id) WHERE eabr.deleted=0 AND ea.email_address LIKE',
             'db_field' => array(
                     'id',
             ),
             'vname' =>'LBL_ANY_EMAIL',
             'studio' => array('visible'=>false, 'searchview'=>true),
             'importable' => false,
             'duplicate_merge' => 'enabled',
        ), 
        'email1' => 
        array(
            'name'      => 'email1',
            'vname'     => 'LBL_EMAIL_ADDRESS',
            'type'      => 'varchar',
            'unified_search' => true,
            'function'  => array(
                    'name'  => 'getEmailAddressWidget',
                    'returns'   => 'html'),
            'source'    => 'non-db',
            'group'=>'email1',
            'merge_filter' => 'enabled',
            'full_text_search' => array('boost' => 3, 'analyzer' => 'whitespace'), //bug 54567
            'audited' => true,
            'duplicate_merge' => 'enabled',
        ),

        'type_individu' => array(
            'required' => false,
            'name' => 'type_individu',
            'vname' => 'LBL_TYPE_INDIVIDU',
            'type' => 'enum',
            'massupdate' => true,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_type_individu_list',
            'studio' => 'visible',
            'dependency' => false,
            'duplicate_merge' => 'enabled',
        ),
        
        'situation_familiale' => array(
            'required' => false,
            'name' => 'situation_familiale',
            'vname' => 'LBL_SITUATION_FAMILIALE',
            'type' => 'enum',
            'massupdate' => true,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_situation_familiale_list',
            'studio' => 'visible',
            'dependency' => false,
            'duplicate_merge' => 'enabled',
        ),
        
        'primary_address_number' => array(
            'name' => 'primary_address_number',
            'vname' => 'LBL_PRIMARY_ADDRESS_NUMBER',
            'type' => 'varchar',
            'len' => '200',
            'group' => 'primary_address',
            'merge_filter' => 'enabled',
            'audited' => true,
            'duplicate_merge' => 'enabled',
        ),
        'primary_address_street' => array(
            'name' => 'primary_address_street',
            'vname' => 'LBL_PRIMARY_ADDRESS_STREET',
            'type' => 'varchar',
            'len' => '200',
            'group' => 'primary_address',
            'merge_filter' => 'enabled',
            'audited' => true,
            'duplicate_merge' => 'enabled',
        ),
        'primary_address_street_1' => array(
            'name' => 'primary_address_street_1',
            'vname' => 'LBL_PRIMARY_ADDRESS_STREET_1',
            'type' => 'varchar',
            'len' => '38',
            'source' => 'non-db',
            'duplicate_merge' => 'enabled',
        ),
        'primary_address_street_2' => array(
            'name' => 'primary_address_street_2',
            'vname' => 'LBL_PRIMARY_ADDRESS_STREET_2',
            'type' => 'varchar',
            'len' => '38',
            'source' => 'non-db',
            'duplicate_merge' => 'enabled',
        ),
        'primary_address_street_3' => array(
            'name' => 'primary_address_street_3',
            'vname' => 'LBL_PRIMARY_ADDRESS_STREET_3',
            'type' => 'varchar',
            'len' => '38',
            'source' => 'non-db',
            'duplicate_merge' => 'enabled',
        ),
        'primary_address_postalcode' => array(
            'name' => 'primary_address_postalcode',
            'vname' => 'LBL_PRIMARY_ADDRESS_POSTALCODE',
            'type' => 'varchar',
            'len' => '10',
            'group' => 'primary_address',
            'merge_filter' => 'enabled',
            'massupdate' => true,
            'audited' => true,
            'duplicate_merge' => 'enabled',
        ),
        'primary_address_city' => array(
            'name' => 'primary_address_city',
            'vname' => 'LBL_PRIMARY_ADDRESS_CITY',
            'type' => 'varchar',
            'len' => '30',
            'group' => 'primary_address',
            'merge_filter' => 'enabled',
            'massupdate' => true,
            'audited' => true,
            'duplicate_merge' => 'enabled',
        ),
        'primary_address_state' => array(
            'name' => 'primary_address_state',
            'vname' => 'LBL_PRIMARY_ADDRESS_STATE',
            'type' => 'varchar',
            'len' => '100',
            'group' => 'primary_address',
            'merge_filter' => 'enabled',
            'duplicate_merge' => 'enabled',
        ),
        'primary_address_country' => array(
            'name' => 'primary_address_country',
            'vname' => 'LBL_PRIMARY_ADDRESS_COUNTRY',
            'type' => 'varchar',
            'group' => 'primary_address',
            'merge_filter' => 'enabled',
            'audited' => false,
            'len' => '100',
            'duplicate_merge' => 'enabled',
        ),

        'primary_address_complement_batiment' => array(
            'name' => 'primary_address_complement_batiment',
            'vname' => 'LBL_PRIMARY_ADDRESS_COMPLEMENT_BATIMENT',
            'type' => 'varchar',
            'merge_filter' => 'enabled',
            'audited' => false,
            'len' => '100',
            'duplicate_merge' => 'enabled',
        ),

        'primary_address_complement_lieu' => array(
            'name' => 'primary_address_complement_lieu',
            'vname' => 'LBL_PRIMARY_ADDRESS_COMPLEMENT_LIEU',
            'type' => 'varchar',
            'merge_filter' => 'enabled',
            'audited' => false,
            'len' => '100',
            'duplicate_merge' => 'enabled',
        ),
        'connexion_internet' => array(
            'required' => false,
            'name' => 'connexion_internet',
            'vname' => 'LBL_CONNEXION_INTERNET',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),
        'statut_compte' => array(
            'required' => false,
            'name' => 'statut_compte',
            'vname' => 'LBL_STATUT_COMPTE',
            'type' => 'enum',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_statut_compte_list',
            'studio' => 'visible',
            'dependency' => false,
            'duplicate_merge' => 'enabled',
        ),
        'canal' => array(
            'required' => false,
            'name' => 'canal',
            'vname' => 'LBL_CANAL',
            'type' => 'enum',
            'default' => 'crm',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_canal_list',
            'studio' => 'visible',
            'dependency' => false,
            'duplicate_merge' => 'enabled',
        ),

        'nom_usage' => array(
            'required' => false,
            'name' => 'nom_usage',
            'vname' => 'LBL_NOM_USAGE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'etat' => array(
            'required' => false,
            'name' => 'etat',
            'vname' => 'LBL_ETAT',
            'type' => 'enum',
            'massupdate' => true,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_etat_individu_list',
            'default' => 'vivant',
            'studio' => 'visible',
            'dependency' => false,
            'duplicate_merge' => 'enabled',
        ),

        'pays_naissance' => array(
            'required' => false,
            'name' => 'pays_naissance',
            'vname' => 'LBL_PAYS_NAISSANCE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'representant_parent' => array(
            'required' => false,
            'name' => 'representant_parent',
            'vname' => 'LBL_REPRESENTANT_PARENT',
            'type' => 'bool',
            'massupdate' => true,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'accepte_mail' => array(
            'required' => false,
            'name' => 'accepte_mail',
            'vname' => 'LBL_ACCEPTE_MAIL',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'accepte_sms' => array(
            'required' => false,
            'name' => 'accepte_sms',
            'vname' => 'LBL_ACCEPTE_SMS',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'profession_pcs' => array(
            'required' => false,
            'name' => 'profession_pcs',
            'vname' => 'LBL_PROFESSION_PCS',
            'type' => 'enum',
            'massupdate' => true,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => false,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_pcs_list',
            'studio' => 'visible',
            'dependency' => false,
            'duplicate_merge' => 'enabled',
        ),

        'nom_employeur' => array(
            'required' => false,
            'name' => 'nom_employeur',
            'vname' => 'LBL_NOM_EMPLOYEUR',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'adresse_num' => array(
            'required' => false,
            'name' => 'adresse_num',
            'vname' => 'LBL_PRIMARY_ADDRESS_NUMBER',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'adresse_voie' => array(
            'required' => false,
            'name' => 'adresse_voie',
            'vname' => 'LBL_PRIMARY_ADDRESS_STREET',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'adresse_complement_lieu' => array(
            'required' => false,
            'name' => 'adresse_complement_lieu',
            'vname' => 'LBL_ADRESSE_COMPLEMENT_LIEU',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'adresse_complement_batiment' => array(
            'required' => false,
            'name' => 'adresse_complement_batiment',
            'vname' => 'LBL_ADRESSE_COMPLEMENT_BATIMENT',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'address_postalcode' => array(
            'required' => false,
            'name' => 'address_postalcode',
            'vname' => 'LBL_ADRESSE_CODE_POSTAL',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '10',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'address_city' => array(
            'required' => false,
            'name' => 'address_city',
            'vname' => 'LBL_ADRESSE_VILLE',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '30',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'handicap' => array(
            'required' => false,
            'name' => 'handicap',
            'vname' => 'LBL_HANDICAP',
            'type' => 'enum',
            'massupdate' => 0,
            'default' => 'non',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_handicap_list',
            'studio' => 'visible',
            'dependency' => false,
            'duplicate_merge' => 'enabled',
        ),

        'aide_handicap' => array(
            'required' => false,
            'name' => 'aide_handicap',
            'vname' => 'LBL_AIDE_HANDICAP',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'vaccin_a_jour' => array(
            'required' => false,
            'name' => 'vaccin_a_jour',
            'vname' => 'LBL_VACCIN_A_JOUR',
            'type' => 'bool',
            'massupdate' => true,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'medecin_traitant' => 
        array (
            'required' => false,
            'name' => 'medecin_traitant',
            'vname' => 'LBL_MEDECIN_TRAITANT',
            'type' => 'varchar',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => false,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '30',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'presence_trouble_consigne' => array(
            'required' => false,
            'name' => 'presence_trouble_consigne',
            'vname' => 'LBL_PRESENCE_TROUBLE_CONSIGNE',
            'type' => 'text',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'size' => '20',
            'studio' => 'visible',
            'rows' => '6',
            'cols' => '80',
            'duplicate_merge' => 'enabled',
        ),

        'menu_autorise' => array(
            'required' => false,
            'name' => 'menu_autorise',
            'vname' => 'LBL_MENU_AUTORISE',
            'type' => 'enum',
            'massupdate' => 0,
            'default' => '',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_menu_autorise_list',
            'studio' => 'visible',
            'dependency' => false,
            'duplicate_merge' => 'enabled',
        ),

        'fai' => array(
            'required' => false,
            'name' => 'fai',
            'vname' => 'LBL_FAI',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'production_diffusion_image' => array(
            'required' => false,
            'name' => 'production_diffusion_image',
            'vname' => 'LBL_PRODUCTION_DIFFUSION_IMAGE',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'diffusion_caf' => array(
            'required' => false,
            'name' => 'diffusion_caf',
            'vname' => 'LBL_DIFFUSION_CAF',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'attestation_assurance' => array(
            'required' => false,
            'name' => 'attestation_assurance',
            'vname' => 'LBL_ATTESTATION_ASSURANCE',
            'type' => 'bool',
            'massupdate' => 0,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'sexe' => array(
            'required' => false,
            'name' => 'sexe',
            'vname' => 'LBL_SEXE',
            'type' => 'enum',
            'massupdate' => 0,
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => 100,
            'size' => '20',
            'options' => 'ops_sexe_list',
            'studio' => 'visible',
            'dependency' => false
        ),

        'inactif_notification' => array(
            'required' => false,
            'name' => 'inactif_notification',
            'vname' => 'LBL_INACTIF_NOTIFICATION',
            'type' => 'bool',
            'massupdate' => true,
            'default' => '0',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'audited' => true,
            'inline_edit' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'len' => '255',
            'size' => '20',
            'duplicate_merge' => 'enabled',
        ),

        'assigned_user_id' => array(
            'name' => 'assigned_user_id',
            'rname' => 'user_name',
            'id_name' => 'assigned_user_id',
            'vname' => 'LBL_ASSIGNED_TO_NAME',
            'group' => 'assigned_user_name',
            'massupdate' => '0',
            'type' => 'relate',
            'table' => 'users',
            'module' => 'Users',
            'reportable' => true,
            'isnull' => 'false',
            'dbType' => 'id',
            'audited' => true,
            'massupdate' => true,
            'comment' => 'User ID assigned to record',
            'duplicate_merge' => 'disabled'
        ),


    ),
    'relationships' => array(),
    'optimistic_locking' => true,
    'unified_search' => true
);

if (!class_exists('VardefManager')) {
    require_once('include/SugarObjects/VardefManager.php');
}
VardefManager::createVardef('OPS_individu', 'OPS_individu', array(
    'basic',
    'assignable',
    'security_groups',
    'person'
)); 