$(document).ready(function() 
{
    let lignes = $('.tabform tr');

    $('.tabform tr').remove();

    let list_generalites_identite = [
        'salutation',
        'last_name',
        'first_name',
        'nom_usage',
        'situation_familiale',
        'etat',
        'nationalite',
        'date_naissance',
        'lieu_naissance',
        'pays_naissance',
        'representant_parent',
    ];

    let list_generalites_autre = [
        'connexion_internet',
        'statut_compte',
        'assigned_user_name',
        'canal',
        'description',
    ];

    let list_autorisation = [
        'production_diffusion_image',
        'diffusion_caf',
        'attestation_assurance',
    ];

    let list_sante = [
        'handicap',
        'aide_handicap',
        'vaccin_a_jour',
        'medecin_traitant',
        'presence_trouble_consigne',
    ];

    let list_contact = [
        'email1',
        'phone_mobile',
        'phone_home',
        'phone_work',
        'phone_other',
        'accepte_mail',
        'accepte_sms',
    ];

    let list_contact_adresse = [
        'primary_address_number',
        'primary_address_street',
        'primary_address_complement_batiment',
        'primary_address_complement_lieu',
        'primary_address_postalcode',
        'primary_address_city',
    ];

    let list_pro = [
        'profession_pcs',
        'nom_employeur',
    ];

    let list_pro_adresse = [
        'adresse_num',
        'adresse_voie',
        'adresse_complement_batiment',
        'adresse_complement_lieu',
        'address_postalcode',
        'address_city',
    ]

    let list_alimentaire = [
        'menu_autorise',
        'fai',
    ];
    
    // Généralités
    $('.tabform tbody').append( build_section('Généralités', 20) );
    $('.tabform tbody').append( getLignes(lignes, 'type_individu') );
    $('.tabform tbody').append( build_section('Identité', 14) );
    $(list_generalites_identite).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });
    $('.tabform tbody').append( build_section('Autres informations', 14) );
    $(list_generalites_autre).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });

    // Autorisations et attestations
    $('.tabform tbody').append( build_section('Autorisations et attestations', 20) );
    $(list_autorisation).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });

    // Fiche santé
    $('.tabform tbody').append( build_section('Fiche santé', 20) );
    $(list_sante).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });

    // Moyens de contact
    $('.tabform tbody').append( build_section('Moyens de contact', 20) );
    $(list_contact).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });
    $('.tabform tbody').append( build_section('Adresse de domiciliation', 14) );
    $(list_contact_adresse).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });
    
    // Situation professionnelle
    $('.tabform tbody').append( build_section('Situation professionnelle', 20) );
    $(list_pro).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });
    $('.tabform tbody').append( build_section('Adresse de l\'employeur', 14) );
    $(list_pro_adresse).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });

    // Régime alimentaire
    $('.tabform tbody').append( build_section('Régime alimentaire', 20) );
    $(list_alimentaire).each(function() {
        $('.tabform tbody').append( getLignes(lignes, this) );
    });

});

function getLignes(lignes, id)
{
    let matched_line = ''
    $(lignes).each(function() {
        if( $(this).children().find('span').find('input, select, textarea').attr('id') == id)
        {
            matched_line = this;
            return;
        }
    });

    return matched_line;
}

function build_section(titre, size)
{
    let section = '<tr><th colspan="2" style="padding: ' + size + 'px;font-size: ' + size + 'px;">' + titre + '</th></tr>';

    return section;
}