<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

use ODE\Calendar\OdeCalendar;

class OPS_individuController extends SugarController
{

    /**
     * Bean that is being handled by the Calendar's current action.
     * @var SugarBean $currentBean
     */
    protected $currentBean = null;

    /**
     * Action action_workflow
    */
    protected function action_dossier()
    {    
        global $current_user, $beanFiles;
        
        $module = $this->currentBean->module_dir;
        $bean = $this->currentBean;

        $individu_id = $this->bean->id ;
        $indi = $this->bean->name ;

        SugarApplication::redirect('index.php?action=create&module=OPS_dossier&type_tiers=OPS_individu&id_tiers='.$individu_id.'&tiers='.base64_encode($indi) );    


    }

    function action_checkDossier(){
        if(!empty($_REQUEST['json'])){
            $data = json_decode( base64_decode($_REQUEST['json']),true );
            $individuObj = BeanFactory::getBean('OPS_individu',$data['record']);
            $dossiers = $individuObj->get_linked_beans(
                        'ops_individu_ops_dossier',
                        'OPS_dossier',
                        'num_dossier DESC',
                        0,
                        -1,
                        0,
                        'ops_dossier.cloture = 0 AND ops_dossier.name != "TEMP"'
                    );
            if(!empty($dossiers)){
                $resultat['message'] = "Suppression impossible : il existe un(des) dossier(s) non clôturé(s) rattaché(s) à cet individu";

                foreach ($dossiers as $dossier) {
                    $objDispositif = BeanFactory::getBean('OPS_dispositif',$dossier->ops_dispositif_id);
                    $resultat['dossiers'][$dossier->id] = array(
                        "id" => $dossier->id,
                        "num_dossier" => $dossier->num_dossier,
                        "brouillon" => $dossier->brouillon,
                        "cloture" => $dossier->cloture,
                        "dispositif" => $objDispositif->name,
                    );
                }
                $resultat['length'] = count($dossiers);
                $resultat['cloture'] = 0;
            }else{
                $dossiers = $individuObj->get_linked_beans(
                        'ops_individu_ops_dossier',
                        'OPS_dossier',
                        'num_dossier DESC',
                        0,
                        -1,
                        0,
                        'ops_dossier.cloture = 1'
                    );
                $resultat['message'] = "J'ai compris que les dossiers indiqués ici seront supprimés";
                foreach ($dossiers as $dossier) {
                    $objDispositif = BeanFactory::getBean('OPS_dispositif',$dossier->ops_dispositif_id);
                    $resultat['dossiers'][$dossier->id] = array(
                        "id" => $dossier->id,
                        "num_dossier" => $dossier->num_dossier,
                        "brouillon" => $dossier->brouillon,
                        "cloture" => $dossier->cloture,
                        "dispositif" => $objDispositif->name,
                    );
                }
                $resultat['cloture'] = 1;
                $resultat['length'] = count($dossiers);
            }

            $data = array('statut' => 'ok', 'data' => array('resultat' => $resultat));

            ob_clean();
            echo json_encode($data);
            sugar_cleanup(true);
        }
    }

    public function action_CalendarView()
    {
        $this->view = 'calendar';
    }

    public function action_getEventCalendar()
    {
        $events = [];
        if(isset($_POST['id']) && !empty($_POST['id']))
        {
            $calendar = new OdeCalendar(module: 'OPS_individu', id: $_POST['id']);

            $events = $calendar->getEvents();
        }

        ob_clean();
        echo json_encode($events);
        sugar_cleanup(true);
    }

    
    public function action_getApiBan(){

        global $sugar_config;

        $apiBanDisabled = $sugar_config['opensocle']['disable_api_ban'] ?? false;
        
        ob_clean();
        echo json_encode(["apiBanDisabled" => $apiBanDisabled]);
        sugar_cleanup(true);
    }
}
