<?php

require_once('include/SugarObjects/templates/person/Person.php');
require_once('include/EmailInterface.php');


class OPS_individu extends Person implements EmailInterface
{
    public $new_schema = true;
    public $module_dir = 'OPS_individu';
    public $object_name = 'OPS_individu';
    public $table_name = 'ops_individu';
    public $importable = true;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $salutation;
    public $first_name;
    public $last_name;
    public $full_name;
    public $title;
    public $photo;
    public $department;
    public $do_not_call;
    public $phone_home;
    public $email;
    public $phone_mobile;
    public $phone_work;
    public $phone_other;
    public $phone_fax;
    public $email1;
    public $email2;
    public $invalid_email;
    public $email_opt_out;
    public $primary_address_street;
    public $primary_address_street_2;
    public $primary_address_street_3;
    public $primary_address_city;
    public $primary_address_state;
    public $primary_address_postalcode;
    public $primary_address_country;
    public $alt_address_street;
    public $alt_address_street_2;
    public $alt_address_street_3;
    public $alt_address_city;
    public $alt_address_state;
    public $alt_address_postalcode;
    public $alt_address_country;
    public $assistant;
    public $assistant_phone;
    public $email_addresses_primary;
    public $email_addresses;
    public $email_addresses_non_primary;
    public $date_naissance;
    public $lieu_naissance;
    public $nationalite;
    public $situation_familiale;
    public $reference;
    public $tiers_financier;
    public $financeur;
    public $canal;
    public $type_individu;
    public $nom_jeune_fille;
    public $etat;
    public $pays_naissance;
    public $representant_parent;
    public $accepte_mail;
    public $accepte_sms;
    public $profession_pcs;
    public $nom_employeur;
    public $adresse_num;
    public $adresse_voie;
    public $address_postalcode;
    public $address_city;
    public $handicap;
    public $aide_handicap;
    public $vaccin_a_jour;
    public $medecin_traitant;
    public $presence_trouble_consigne;
    public $menu_autorise;
    public $fai;
    public $production_diffusion_image;
    public $diffusion_caf;
    public $attestation_assurance;
    public $sexe;
    
    public function bean_implements($interface)
    {
        switch($interface)
        {
            case 'ACL':
                return true;
        }

        return false;
    }

    function ops_lien_parente_ops_individu($params)
    {
        $arg = func_get_args();

        $id = $arg[0]['id'];

        $ret = array();
        $ret['select'] = " SELECT ops_lien_parente.id FROM ops_lien_parente";
        $ret['from'] = " FROM ops_lien_parente";
        $ret['join'] = " LEFT JOIN ops_lien_parente_ops_individu ON ops_lien_parente.id = ops_lien_parente_ops_individu.ops_lien_parente_id 
        LEFT JOIN ops_lien_parente_ops_individu_2 ON ops_lien_parente.id = ops_lien_parente_ops_individu_2.ops_lien_parente_id";
        $ret['join_table'] = "";
        $ret['where'] = " (ops_lien_parente_ops_individu.ops_individu_id = '".$id."' AND ops_lien_parente_ops_individu.deleted = 0) OR (ops_lien_parente_ops_individu_2.ops_individu_id2 = '".$id."' AND ops_lien_parente_ops_individu_2.deleted = 0)";

        return $ret;
    }

    public static function get_field_list($isGenerateur = false, $isModelMail = false)
    {
        global $app_list_strings;

        $liste_champs = array(
            'generalites' => [
                'libelle' => 'LBL_ONGLET_1',
                'ordre' => 10,
                'description' => '',
                'champs' => [
                    'type_individu'       => array( "type" => "liste" , "list_name" => "ops_type_individu_list" , "propriete" => "hidden" ),
                    'salutation'          => array( "type" => "liste" , "list_name" => "salutation_dom", "class" => "select_salutation", "propriete" => "required", 'condition' => 'adulte,contact' ),
                    'sexe'                => array( "type" => "liste" , "list_name" => "ops_sexe_list", "class" => "select_salutation", "propriete" => "required", 'condition' => 'enfant' ),
                    'last_name'           => array( "type" => "varchar", "class" => "input_prenom", "propriete" => "required" ),
                    'first_name'          => array( "type" => "varchar", "propriete" => "required" ),
                    'skip'                => array( "type" => "skip"),
                    'nom_usage'           => array( "type" => "varchar", "propriete" => "display" ),
                    'situation_familiale' => array( "type" => "liste" , "list_name" => "ops_situation_familiale_list", 'condition' => 'adulte'),
                    'etat'                => array( "type" => "liste" , "list_name" => "ops_etat_individu_list", 'condition' => 'adulte,enfant' ),
                    'nationalite'         => array( "type" => "liste" , "list_name" => "ops_nationalite_list", 'condition' => 'adulte,enfant' ),
                    'date_naissance'      => array( "type" => "date", 'condition' => 'adulte,enfant'),
                    'skip2'               => array( "type" => "skip"),
                    'lieu_naissance'      => array( "type" => "varchar", 'condition' => 'adulte,enfant' ),
                    'pays_naissance'      => array( "type" => "varchar", 'condition' => 'adulte,enfant' ),
                    'representant_parent' => array( "type" => "bool" , 'condition' => 'adulte' ),
                    'skip3'               => array( "type" => "skip"),
                    'role'                => array( "type" => "liste" , "list_name" => "ops_role_list", "propriete" => "required" ),
                ],
            ],

            'autorisations_attestations' => [
                'libelle' => 'LBL_ONGLET_2',
                'ordre' => 11,
                'description' => '',
                'condition' => 'enfant',
                'icone' => 'checkmark',
                'champs' => [
                    'production_diffusion_image' => array( "type" => "bool" ),
                    'diffusion_caf'              => array( "type" => "bool" ),
                    'attestation_assurance'      => array( "type" => "bool" ),
                ],
            ],

            'fiche_sante' => [
                'libelle' => 'LBL_ONGLET_3',
                'ordre' => 12,
                'description' => '',
                'condition' => 'enfant',
                'icone' => 'medical',
                'champs' => [
                    'handicap'                  => array( "type" => "liste" , "list_name" => "ops_handicap_list" ),
                    'aide_handicap'             => array( "type" => "bool" ),
                    'vaccin_a_jour'             => array( "type" => "bool" ),
                    'medecin_traitant'          => array( "type" => "varchar" ),
                    'presence_trouble_consigne' => array( "type" => "varchar" ),
                ],
            ],

            'moyens_contact' => [
                'libelle' => 'LBL_ONGLET_4',
                'ordre' => 13,
                'description' => '',
                'icone' => 'letter',
                'champs' => [
                    'email1'                              => array( "type" => "email" ),
                    'skip'                                => array( "type" => "skip" ),
                    'phone_mobile'                        => array( "type" => "phone" ),
                    'phone_home'                          => array( "type" => "phone" ),
                    'phone_work'                          => array( "type" => "phone" ),
                    'phone_other'                         => array( "type" => "phone" ),
                    'accepte_mail'                        => array( "type" => "bool" ),
                    'accepte_sms'                         => array( "type" => "bool" ),
                    'title'                               => array( "type" => "title", "libelle" => 'Adresse de domiciliation' ),
                    'skip2'                               => array( "type" => "skip" ),
                    'primary_address_number'              => array( "type" => "varchar" ),
                    'primary_address_street'              => array( "type" => "varchar" ),
                    'primary_address_complement_batiment' => array( "type" => "varchar" ),
                    'primary_address_complement_lieu'     => array( "type" => "varchar" ),
                    'primary_address_postalcode'          => array( "type" => "varchar" ),
                    'primary_address_city'                => array( "type" => "varchar" ),
                ],
            ],

            'situation_professionnelle' => [
                'libelle' => 'LBL_ONGLET_5',
                'ordre' => 14,
                'description' => '',
                'condition' => 'adulte',
                'icone' => 'briefcase',
                'champs' => [
                    'profession_pcs'              => array( "type" => "liste" , "list_name" => "ops_pcs_list" ),
                    'skip'                        => array( "type" => "skip" ),
                    'nom_employeur'               => array( "type" => "varchar" ),
                    'skip2'                       => array( "type" => "skip" ),
                    'title'                       => array( "type" => "title", "libelle" => 'Adresse de l\'employeur' ),
                    'skip3'                       => array( "type" => "skip" ),
                    'adresse_num'                 => array( "type" => "varchar" ),
                    'adresse_voie'                => array( "type" => "varchar" ),
                    'adresse_complement_batiment' => array( "type" => "varchar" ),
                    'adresse_complement_lieu'     => array( "type" => "varchar" ),
                    'address_postalcode'          => array( "type" => "varchar" ),
                    'address_city'                => array( "type" => "varchar" ),
                ],
            ],

            'regime_alimentaire' => [
                'libelle' => 'LBL_ONGLET_6',
                'ordre' => 15,
                'description' => '',
                'condition' => 'enfant',
                'icone' => 'eat',
                'champs' => [
                    'menu_autorise' => array( "type" => "liste" , "list_name" => "ops_menu_autorise_list" ),
                    'fai'           => array( "type" => "bool" ),
                ],
            ],
        );

        if($isModelMail || $isGenerateur)
        {
            foreach ($liste_champs as $onglet_key => $onglet)
            {
                foreach ($onglet['champs'] as $key => $champ) 
                {
                    if($champ['type'] == 'skip' || $champ['type'] == 'title')
                    {
                        unset($liste_champs[$onglet_key]['champs'][$key]);
                    }
                }
            }
        }

        if($isGenerateur)
        {
            $liste_champs['moyens_contact']['champs'] = [
                'email1'                => array( "type" => "email" ),
                'phone_mobile'          => array( "type" => "phone" ),
                'phone_home'            => array( "type" => "phone" ),
                'phone_work'            => array( "type" => "phone" ),
                'phone_other'           => array( "type" => "phone" ),
                'accepte_mail'          => array( "type" => "bool" ),
                'accepte_sms'           => array( "type" => "bool" ),
                'adresse_domiciliation' => array( "type" => "adresse" ),
            ];

            $liste_champs['situation_professionnel']['champs'] = [
                'profession_pcs'    => array( "type" => "liste" , "list_name" => "ops_pcs_list" ),
                'nom_employeur'     => array( "type" => "varchar" ),
                'adresse_employeur' => array( "type" => "adresse" ),
            ];
        }

        foreach ($liste_champs as $onglet_key => $onglet)
        {
            $liste_champs[$onglet_key]['libelle'] = translate($onglet['libelle'], 'OPS_individu');

            foreach ($onglet['champs'] as $key => $champ) 
            {
                $liste_champs[$onglet_key]['champs'][$key]['name'] = $key;

                if(!isset($champ['libelle']))
                {
                    $liste_champs[$onglet_key]['champs'][$key]['libelle'] = translate('LBL_'.strtoupper($key),'OPS_individu'); 
                }
                
                if( !isset( $champ['propriete'] ) )
                {
                    $liste_champs[$onglet_key]['champs'][$key]['propriete'] = ""; 
                }
                
                if( $champ['type'] == "liste" || $champ['type'] == "radio" )
                {
                    foreach ($app_list_strings[$champ['list_name']] as $cle => $libelle ) 
                    {
                        $liste_champs[$onglet_key]['champs'][$key]['liste'][$cle ] = $libelle;
                    }

                }
            }
        }
        
        return $liste_champs;
    }



    /**
     * Recupere l'id de l'individu anonyme
     * s'il n'existe pas, il est créé en amont
     * @return string|boolean
     */
    public static function getIdAnonyme() : string|boolean{
        global $db;

        // recuperation d'un individu anonyme
        $sql = "SELECT id FROM ops_individu WHERE last_name LIKE '%Anonyme%' AND deleted = 0";
        $res = $db->query($sql);

        $idAnonyme = $db->fetchRow($res)['id'] ?? false;

        if($idAnonyme) return $idAnonyme; 

        $beanAnonyme = BeanFactory::newBean("OPS_individu");
        $beanAnonyme->last_name = "ANONYME";
        $beanAnonyme->save();

        return $beanAnonyme->id ?? false;
    }
}