<?php

use ODE\Helper\OdeArrayHelper;

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

class OPS_generateur_referentielController extends SugarController
{


    /**
     * @access public 
     * action_create()
     * Fonction qui crée un champ dans le référentiel
     *
     */
    function action_createChamp()
    {

        $libelle_erreur = "";

        do {

            $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, array("json" => true));
            if ($data_verified['statut'] === "err") {
                $libelle_erreur = $data_verified['data'];
                break;
            }

            $champ = $data_verified['data']['json_array'];
            $champ_name = OdeArrayHelper::formatString($champ['nom']);
            $champ_name_verified = OPS_generateur_referentiel::isChampValid($champ_name);
            if ($champ_name_verified['statut'] === "err") {
                $libelle_erreur = $champ_name_verified['data'];
                break;
            }

            $obj_referentiel = BeanFactory::newBean('OPS_generateur_referentiel');
            $obj_referentiel->name        = $champ_name;
            $obj_referentiel->type        = $champ['type'];
            $obj_referentiel->libelle     = (!empty($champ['libelle'])) ? $champ['libelle'] : $champ['name'];
            $obj_referentiel->obligatoire = (!empty($champ['obligatoire']) && $champ['obligatoire'] == 1) ? 1 : 0;
            $obj_referentiel->ineditable  = (!empty($champ['ineditable']) && $champ['obligatoire'] == 1) ? 1 : 0;
            $obj_referentiel->aide        = (!empty($champ['aide'])) ? $champ['aide'] : "";
            $obj_referentiel->defaut      = (!empty($champ['defaut'])) ? $champ['defaut'] : "";
            $obj_referentiel->description = "custom";
            $obj_referentiel->modifiable  = 1;
            $obj_referentiel->params      = (!empty($champ['params'])) ? $champ['params'] : "";
            $obj_referentiel->conditions  = (!empty($champ['conditions'])) ? $champ['conditions'] : "";
            $obj_referentiel->save();

            if (empty($obj_referentiel->id)) {
                $libelle_erreur = "Erreur sauvegarde champ";
                break;
            }

            $champ_retour = array_merge($champ, ["id" => $obj_referentiel->id, "nom" => $champ_name, "description" => "custom"]);
        } while (0);


        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $champ_retour) : array('statut' => 'err', 'data' => $libelle_erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }


    /**
     * @access public
     * action_addOnglet()
     * Fonction qui crée un onglet
     * 
     * @return json     $data
     */
    public function action_upload()
    {

        $data = array(
            'statut' => 'err',
            'data' => '',
        );

        /*
        $champs = array(
            "vue_id" => true,
            "onglet_name" => true,
            "onglet_cle" => false
        );

        $data_verified = $this->isDataValid( $_REQUEST, $champs );
        */

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }
}
