<?php

use ODE\Generateur\Factory\OdeFieldFactory;

class OPS_generateur_onglet extends Basic
{
    public $new_schema = true;
    public $module_dir = 'OPS_generateur_onglet';
    public $object_name = 'OPS_generateur_onglet';
    public $table_name = 'ops_generateur_onglet';
    public $importable = false;

    public $id;
    public $name;
    public $date_entered;
    public $date_modified;
    public $modified_user_id;
    public $modified_by_name;
    public $created_by;
    public $created_by_name;
    public $description;
    public $deleted;
    public $created_by_link;
    public $modified_user_link;
    public $assigned_user_id;
    public $assigned_user_name;
    public $assigned_user_link;
    public $SecurityGroups;
    public $cle;
    public $libelle;
    public $ordre;
    public $conditions;

    public function bean_implements($interface)
    {
        switch ($interface) {
            case 'ACL':
                return true;
        }

        return false;
    }

    /**
     * @access public
     * @name getChamps()
     * Fonction qui retourne les champs de l'onglet en tableau
     *
     *  @return array|boolean               - $champs : tableau des champs de l'onglet
     */
    public function getChamps()
    {
        $champs = array();
        $liste_champs = $this->get_linked_beans("ops_generateur_onglet_ops_generateur_champ", "OPS_generateur_champ");
        foreach ($liste_champs as  $champ) {
            $champs[$champ->ligne][$champ->ordre . $this->getUniqueId()] = array(
                "nom" => $champ->name,
                "libelle" => $champ->libelle,
                "obligatoire" => ($champ->obligatoire == 1) ? 1 : 0,
                "type" => $champ->type,
                "type_libelle" => $this->getLibelleType($champ->type),
                "cle" => $champ->cle,
                "ineditable" => ($champ->ineditable == 1) ? 1 : 0,
                "aide" => $champ->aide,
                "defaut" => $champ->defaut,
                "description" => $champ->description,
                "params" => $champ->params,
                "conditions" => $champ->conditions,
                "modifiable" => ($champ->modifiable == 0) ? 0 : 1
            );
            ksort($champs[$champ->ligne]);
        }
        ksort($champs);
        return $champs;
    }

    public function getUniqueId()
    {
        return strtoupper(hash("sha256", time() . rand()));
    }

    public function getLibelleType($type)
    {
        $types = OdeFieldFactory::getFieldLanguage();
        return array_key_exists($type, $types) ? $types[$type] : "";
    }

    /**
     * @access public
     * @name createSection()
     * Fonction qui retourne 
     *
     *  @return array|boolean               
     */
    public function createSection($title, $ligne_ordre, $conditions)
    {
        $obj_champ = BeanFactory::newBean('OPS_generateur_champ');
        $obj_champ->name = "";
        $obj_champ->description = "";
        $obj_champ->ligne = $ligne_ordre;
        $obj_champ->ordre = 0;
        $obj_champ->libelle = (!empty($title)) ? $title : "";
        $obj_champ->type = "section";
        $obj_champ->obligatoire = 0;
        $obj_champ->ineditable = 0;
        $obj_champ->modifiable = 1;
        $obj_champ->params = "";
        $obj_champ->conditions = $conditions;
        $champ_demandeur_id = $obj_champ->save(false);

        $this->load_relationship('ops_generateur_onglet_ops_generateur_champ');
        $this->ops_generateur_onglet_ops_generateur_champ->add($champ_demandeur_id);
    }

    /**
     * @access public
     * @name createLigneDoubleChamp()
     * Fonction qui retourne 
     *
     *  @return array|boolean               
     */
    public function createLigneDoubleChamp($champs, $ligne_ordre)
    {

        foreach ($champs as $champ_ordre => $champ) {
            if (!is_array($champ) || count($champ) === 0) {
                $champ = [
                    "nom" => "",
                    "libelle" => "",
                    "type" => "vide",
                    "obligatoire" => 0,
                    "ineditable" => 0,
                    "aide" => "",
                    "defaut" => "",
                    "description" => "",
                    "conditions" => "",
                    "params" => "",
                    "modifiable" => 1,
                ];
            }
            $obj_champ = BeanFactory::newBean('OPS_generateur_champ');
            $obj_champ->name = $champ["nom"];
            $obj_champ->description = $champ["description"];
            $obj_champ->ligne = $ligne_ordre;
            $obj_champ->ordre = $champ_ordre;
            $obj_champ->libelle = $champ["libelle"];
            $obj_champ->type = $champ["type"];
            $obj_champ->obligatoire = $champ["obligatoire"];
            $obj_champ->ineditable = $champ["ineditable"];
            $obj_champ->modifiable = $champ["modifiable"];
            $obj_champ->params = $champ["params"];
            $obj_champ->conditions = $champ["conditions"];
            $obj_champ->aide = $champ["aide"];
            $obj_champ->defaut = $champ["defaut"];
            $champ_demandeur_id = $obj_champ->save(false);

            $this->load_relationship('ops_generateur_onglet_ops_generateur_champ');
            $this->ops_generateur_onglet_ops_generateur_champ->add($champ_demandeur_id);
        }
    }

    /**
     * @access public
     * @name createLigneSimpleChamp()
     * Fonction qui retourne 
     *
     *  @return array|boolean               
     */
    public function createLigneSimpleChamp($champs, $ligne_ordre)
    {

        foreach ($champs as $champ_ordre => $champ) {
            if (!is_array($champ) || count($champ) === 0) {
                $champ = [
                    "nom" => "",
                    "libelle" => "",
                    "type" => "vide",
                    "obligatoire" => 0,
                    "ineditable" => 0,
                    "aide" => "",
                    "defaut" => "",
                    "description" => "",
                    "conditions" => "",
                    "params" => "",
                    "modifiable" => 1,
                ];
            }
            $obj_champ = BeanFactory::newBean('OPS_generateur_champ');
            $obj_champ->name = $champ["nom"];
            $obj_champ->description = $champ["description"];
            $obj_champ->ligne = $ligne_ordre;
            $obj_champ->ordre = $champ_ordre;
            $obj_champ->libelle = $champ["libelle"];
            $obj_champ->type = $champ["type"];
            $obj_champ->obligatoire = $champ["obligatoire"];
            $obj_champ->ineditable = $champ["ineditable"];
            $obj_champ->modifiable = $champ["modifiable"];
            $obj_champ->params = $champ["params"];
            $obj_champ->conditions = $champ["conditions"];
            $obj_champ->aide = $champ["aide"];
            $obj_champ->defaut = $champ["defaut"];
            $champ_demandeur_id = $obj_champ->save(false);

            $this->load_relationship('ops_generateur_onglet_ops_generateur_champ');
            $this->ops_generateur_onglet_ops_generateur_champ->add($champ_demandeur_id);
        }
    }

    /**
     * @access public
     * @name createLignes()
     * Fonction qui retourne 
     *
     *  @return array|boolean               
     */
    public function createLignes($lignes)
    {

        /*
        $GLOBALS['log']->fatal(" OPS_generateur_onglet :: updateChamps() => " . print_r(array(
            "this->id =" => $this->id,
            "lignes =" => count($lignes),
        ), true));
        */

        // Ligne à deux colonnes
        if (is_array($lignes) && count($lignes) > 0) {
            foreach ($lignes as $ligne_ordre => $ligne) {

                if (!empty($ligne["type"])) {
                    switch ($ligne["type"]) {
                        case 'ligne_double_champ':
                            if (!empty($ligne["champs"])) {
                                $this->createLigneDoubleChamp($ligne["champs"], $ligne_ordre);
                            }
                            break;
                        case 'ligne_simple_champ':
                            if (!empty($ligne["champs"])) {
                                $this->createLigneSimpleChamp($ligne["champs"], $ligne_ordre);
                            }
                            break;
                        case 'section':
                            if (!empty($ligne["title"])) {
                                $this->createSection($ligne["title"], $ligne_ordre, $ligne["conditions"]);
                            }
                            break;
                        default:
                            $GLOBALS['log']->fatal(" OPS_generateur_onglet :: createLignes() => type de ligne à créer non géré " . print_r($ligne, true));
                            break;
                    }
                } else {
                    $GLOBALS['log']->fatal(" OPS_generateur_onglet :: createLignes() => Le type de ligne à créer est vide " . print_r($ligne, true));
                }
            }
        }
    }
}
