$(document).ready(function(){
    if($('#methode').val() == 'traitement'){
    	var champs = $('.detail-view-row-item');
    	for(var i = 2; i < champs.size(); i++){
    		$(champs[i]).hide()
    	}
    }
});

function init_header_modal() {

    // Je désactive le bouton close
    var styleEl = document.createElement('style');
    styleEl.innerHTML = " .no-close .ui-dialog-titlebar-close {display : none;} .btn_modal_test{ background :#F08377!important; color: white!important; } .modal_test_td{ width: 30%;border-radius: 4px;line-height: 20px;text-align: left;color: #534D64;}";
    document.head.appendChild(styleEl);
}

function open_modal_visualiser_requete(flux_id_modal) {

    // Initialisation des styles, js ... etc 
    init_header_modal();

    // Modal responsive 
    var modal_width = window.innerWidth / 1.5;
    var modal_height = window.innerHeight / 1.5;

    // Génération de la popup 
    $(function() {
        $('#div_modal_visualiser_requete').dialog({
            resizable: false,
            height: modal_height,
            width: modal_width,
            modal: true,
            dialogClass: "no-close",
            draggable: false,
            buttons: [ {
                text: "Tester le flux",
                class: "btn_modal_test",
                id: "btn_modal_test_flux",
                click: function() {
                  tester_flux(flux_id_modal);
                }
            },
            {
                text: "Précédent",
                class: "btn_modal_test",
                id: "btn_modal_precedent",
                click: function() {
                    precedent();
                }
            },
            {
                text: "Terminer",
                class: "btn_modal_test",
                id: "btn_modal_terminer",
                click: function() {
                    $(this).dialog("close");
                    window.location.reload();
                }
            }]
        });
    });

    document.getElementById('div_content').parentNode.parentNode.firstChild.style.display = "none";
    document.getElementsByClassName('ui-dialog ui-widget ui-widget-content ui-corner-all ui-front ui-dialog-buttons no-close')[0].style.background = "#f5f5f5";
    document.getElementsByClassName("ui-dialog-titlebar ui-widget-header ui-corner-all ui-helper-clearfix")[2].style.background = "#f5f5f5"; 
    document.getElementById('btn_modal_precedent').style.display = "none";
}

function tester_flux(flux_id){
    var xhr = null;
    if (window.XMLHttpRequest || window.ActiveXObject) {
        if (window.ActiveXObject) {
            try {
                xhr = new ActiveXObject('Msxml2.XMLHTTP');
            } catch (e) {
                xhr = new ActiveXObject('Microsoft.XMLHTTP');
            }
        } else {
            xhr = new XMLHttpRequest();
        }
    } else {
        alert('Votre navigateur ne supporte pas l objet XMLHTTPRequest.');
        return;
    }

    var url = '/index.php?entryPoint=ops_flux_ajax';
    var data = "flux_id="+flux_id;
    xhr.open('POST', url, true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.addEventListener('loadstart', afficher_loading());
    xhr.onreadystatechange = function() {
        if (xhr.readyState === 4) {
            cacher_loading();
            afficher_retour_call(xhr.response);
        }
    }
    xhr.send(data);
}

function afficher_retour_call(reponse){

    var retour_requete = "null";
    var retour_envoi = "null";

    // J'affiche le div de retour '
    if (document.getElementById('div_reponse_requete') != null) {

        if(is_json(reponse)){

            retour_requete = JSON.parse(reponse);
            if(retour_requete['statut'] == "ok"){

                if( retour_requete['data'] != "" ){
                    retour_envoi = retour_requete['data'];
                }else{
                    retour_envoi ="Requete envoyée : réponse vide.";
                }
            }else{

                if( retour_requete['data'] != "" ){
                    retour_envoi = retour_requete['data'];
                }else{
                    retour_envoi ="Requete non envoyée : réponse vide.";
                }
            }
        }else{
            retour_envoi = reponse;
        }

        if (document.getElementById('reponse_code') != null) {
            document.getElementById('reponse_code').appendChild(document.createTextNode(retour_envoi));
        }
        if (document.getElementById('div_reponse_requete').style.display == "none") {
            document.getElementById('div_reponse_requete').style.display = "block";
        }
    }
 
}

function cacher_loading(){

    // Je cache la div loading
    if (document.getElementById('div_loading') != null) {
        if (document.getElementById('div_loading').style.display != "none") {
            document.getElementById('div_loading').style.display = "none";
        }
    }

    // J'affiche le bouton précédent
    if (document.getElementById('btn_modal_precedent') != null) {
        if (document.getElementById('btn_modal_precedent').style.display == "none") {
            document.getElementById('btn_modal_precedent').style.display = "inline-block";
        }
    }

}

function afficher_loading(){
    
    // Cache le bouton tester le flux 
    if (document.getElementById('btn_modal_test_flux') != null) {
        if (document.getElementById('btn_modal_test_flux').style.display != "none") {
            document.getElementById('btn_modal_test_flux').style.display = "none";
        }
    }

    // Je cache la partie Requete pour afficher le loading à la place
    if (document.getElementById('json_visualisation') != null) {
        if (document.getElementById('json_visualisation').style.display != "none") {
            document.getElementById('json_visualisation').style.display = "none";
        }
    }

    // J'affiche le loading 
    var div_content = document.getElementById("div_content");

    // On vérifie si le div n'a pas deja été crée 
    if (document.getElementById("div_loading") == null) {
        
        var div_loading = document.createElement("div");
        div_loading.id = "div_loading";
        div_loading.style = " margin: 37px 10px 10px;text-align:center;";
        div_content.appendChild(div_loading);

        var titre_loading = document.createElement("h3");
        titre_loading.appendChild(document.createTextNode(" Traitement en cours, veuillez patienter "));
        titre_loading.style = "text-align:center;color:#534d64;";
        div_loading.appendChild(titre_loading);

        var img = document.createElement('img');
        img.src = 'custom/include/images/loading.gif';
        div_loading.appendChild(img);

    } else {
        document.getElementById("div_loading").style.display = "block";
    }

}

function precedent() {
    
    // Je cache le bouton précédent
    if (document.getElementById('btn_modal_precedent') != null) {
        if (document.getElementById('btn_modal_precedent').style.display == "inline-block") {
            document.getElementById('btn_modal_precedent').style.display = "none";
        }
    }

    // J'affiche le bouton tester le flux
    if (document.getElementById('btn_modal_test_flux') != null) {
        if (document.getElementById('btn_modal_test_flux').style.display == "none") {
            document.getElementById('btn_modal_test_flux').style.display = "inline-block";
        }
    }

    // je vide la réponse 
    if (document.getElementById('reponse_code') != null) {
        document.getElementById('reponse_code').innerHTML = "";
    }
    
    // je cache div reponse
    if (document.getElementById('div_reponse_requete') != null) {
        if (document.getElementById('div_reponse_requete').style.display == "block") {
            document.getElementById('div_reponse_requete').style.display = "none";
        }
    }

    // J'affiche la partie Requete
    if (document.getElementById('json_visualisation') != null) {
        if (document.getElementById('json_visualisation').style.display == "none") {
            document.getElementById('json_visualisation').style.display = "block";
        }
    }

}

function vider_modal(name_modal) {
    
    var myNode = document.getElementById(name_modal);
    while (myNode.firstChild) {
        myNode.removeChild(myNode.firstChild);
    }

}

function is_json(item) {
    item = typeof item !== "string" ?
        JSON.stringify(item) :
        item;
    try {
        item = JSON.parse(item);
    } catch (e) {
        return false;
    }
    if (typeof item === "object" && item !== null) {
        return true;
    }
    return false;
}