<?php
class Filtre_ThematiqueViewUtils {

    private $smarty;
    private $template;
    private $type = "basique";
    private $nomListe;
    private $nomFiltre;

    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/MenuDeroulantChoixMultipleCheckbox.tpl";
        $this->nomListe = "Thématique";
        $this->nomFiltre = "thematique";
    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);
    }

    private function setData(){

        global $db, $app_list_strings;

        $idDispositif = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples_relation']['dispositif']['valeurs'] ?? array();

        $beanDispositif = BeanFactory::getBean("OPS_dispositif", $idDispositif);
        $thematiques = json_decode(base64_decode($beanDispositif->getListeThematique($beanDispositif->thematique)), true);
        if($beanDispositif->check_thematique === '0') $thematiques = '';


        $options = ["empty" => "- Non renseignée -"];
        foreach($thematiques as $value => $libelle){
            $options[$value] = $libelle;
        }


        $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples']['thematique'] ?? array();
        $valeur = isset($infosFiltre['valeurs']) ? $infosFiltre['valeurs'] : "";

        $this->smarty->assign("NOM_LISTE", $this->nomListe);
        $this->smarty->assign("ICON", "fas fa-tag"); // l'icone souhaité
        $this->smarty->assign("NOM_CHAMP", $this->nomFiltre);
        $this->smarty->assign("VALEURS_SELECT", strval($valeur)); // la valeur déjà selectionné (après recherche)
        $this->smarty->assign("NOM_TABLE", "ops_dossier"); // nom de la table
        $this->smarty->assign("TYPE_CHAMPS", $this->type); // type de champ (ici basique)
        $this->smarty->assign("OPTIONS", $options); // les differentes options du menu déroulant
        $this->smarty->assign("CUSTOM_CLASS", "augmente-taille-contenu");

        
    }

    public function getOrdre(){
        return 2;
    }
    public function getNomListe(){
        return $this->nomListe;
    }

    public function getNomFiltre() {
        return $this->nomFiltre;

    }

}