<?php
class Filtre_ReunionViewUtils {

    private $smarty;
    private $template;
    private $type = "relation";
    private $nomListe;
    private $nomFiltre;

    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/MenuDeroulantChoixMultipleCheckbox.tpl";
        $this->nomListe = "Réunion";
        $this->nomFiltre = "reunion";
    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);

    }

    private function setData(){
        global $db;


        // $queryDepasse = "SELECT distinct id 
        // FROM ops_reunion WHERE
        // DATE_REUNION <= NOW() AND
        // deleted = 0 order by date_reunion desc";

        // $queryDepasse = $db->query($queryDepasse);

        // $reunionDepasse = "";
        // while($row = $db->fetchRow($queryDepasse)){
        //     $reunionDepasse .= $row['id'] . "|"; 
        // }

        $query = "SELECT distinct id, name 
                  FROM ops_reunion WHERE
                  deleted = 0 order by date_reunion desc";
        $query = $db->query($query);

        $options = (object)[
            "empty" => "- Non renseignée -",
            //rtrim($reunionDepasse, "|") => "Réunion dépassée"
        ];

        while($row = $db->fetchRow($query)){
            $options->{$row['id']} = ucfirst($row['name']); 
        }


        $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples_relation']['reunion'] ?? array();
        $valeur = $infosFiltre['valeurs'] ?? "";

        $this->smarty->assign("NOM_LISTE", $this->nomListe);
        $this->smarty->assign("ICON", "fas fa-users");
        $this->smarty->assign("OPTIONS", $options);
        // ca donne ops_reunion_ops_dossier
        $this->smarty->assign("RELATE_TABLE", "ops_reunion_ops_dossier");
        $this->smarty->assign("NOM_FILTRE", $this->nomFiltre);
        $this->smarty->assign("CHAMPS1_R", "ops_dossier_id");
        $this->smarty->assign("CHAMPS2_R", "ops_reunion_id");
        $this->smarty->assign("NOM_CHAMP", "id");
        $this->smarty->assign("NOM_TABLE", "ops_dossier");
        $this->smarty->assign("NOM_TABLE2", "ops_reunion");
        $this->smarty->assign("TYPE_CHAMPS", $this->type);
        $this->smarty->assign("VALEURS_SELECT", $valeur);

        
        /*join ops_reunion_ops_dossier rd on ops_dossier.id = ops_reunion_ops_dossier.ops_dossier_id
        join ops_reunion on ops_reunion.id = ops_reunion_ops_dossier.ops_reunion_id*/
        
    }

    public function getOrdre(){
        return 5;
    }

    public function getNomListe(){
        return $this->nomListe;
    }

    public function getNomFiltre() {
        return $this->nomFiltre;

    }
}