<?php
class Filtre_AssigneAViewUtils {

    private $smarty;
    private $template;
    private $type = "basique";
    private $nomListe;
    private $nomFiltre;



    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/MenuDeroulantChoixMultipleCheckbox.tpl";
        $this->nomListe = "Assigné à";
        $this->nomFiltre = "assigned_user_id";

    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);

    }

    private function setData(){
        global $db, $app_list_strings;

        $options = ["empty" => "- Non renseigné - "] + $this->getOptions() ;


        $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples']['assigned_user_id'] ?? array();
        $valeur = $infosFiltre['valeurs'] ?? "";
        $this->smarty->assign("NOM_LISTE", $this->nomListe);
        $this->smarty->assign("ICON", "fas fa-user-check");
        $this->smarty->assign("NOM_CHAMP", $this->nomFiltre);
        $this->smarty->assign("VALEURS_SELECT", $valeur);
        $this->smarty->assign("NOM_TABLE", "ops_dossier");
        $this->smarty->assign("TYPE_CHAMPS",$this->type);
        $this->smarty->assign("OPTIONS", $options);
        
    }

    public function getOrdre(){
        return 3;
    }

    private function getOptions(){

            $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples_relation']['dispositif'] ?? array();
            $dispositifId = $infosFiltre['valeurs'] ?? "";

            $obj_dispositif = BeanFactory::getBean('OPS_dispositif', $dispositifId);
            $obj_dispositif->load_relationship('ops_habilitation_dispositif_ops_dispositif');
            $habilitationsID = $obj_dispositif->ops_habilitation_dispositif_ops_dispositif->get();

            $resultat = [];
            foreach($habilitationsID as $habilitationID)
            {
                $obj_habilitation = BeanFactory::getBean('OPS_habilitation_dispositif', $habilitationID);

                if($obj_habilitation->instruction == 0) continue;

                $obj_habilitation->load_relationship('ops_habilitation_dispositif_securitygroups');
                $securityGroupsID = $obj_habilitation->ops_habilitation_dispositif_securitygroups->get(); 
                
                foreach ($securityGroupsID as $securityGroupID) 
                {
                    $obj_security = BeanFactory::getBean('SecurityGroups', $securityGroupID);
                    $members = $obj_security->getMembers();

                    if(is_array($members) && count($members) > 0)
                    {
                        foreach($members as $member)
                        {
                            // on ne prend pas en compte l'administrator
                            if($member['id'] == '1') continue;
                            
                            $name = $member['last_name'] . ' ' . $member['first_name'];
                            $resultat[$member['id']] = $name;
                        }

                    }
                }
            }
            return $resultat;

    }

    public function getNomListe(){
        return $this->nomListe;
    }

    public function getNomFiltre() {
        return $this->nomFiltre;

    }
}