<?php
use ODE\Model\DispositifModel;
class Filtre_GuideInstructionsViewUtils {

    private $smarty;
    private $template;
    private $type = "basique";

    public function __construct(){
        $this->smarty = new Sugar_Smarty();
        $this->template = "modules/OPS_dossier/tpls/gestion_dossier/generic/Tuile.tpl";

    }

    public function fetch(){
        $this->setData();
        return $this->smarty->fetch($this->template);

    }

    public function setData(){
        $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples_relation']['dispositif'] ?? array();
        
        $idDispositif = $infosFiltre['valeurs'] ?? "";



        $resultats = DispositifModel::getEtapesGuideInstructionById($idDispositif, true);
        $infosFiltre = OPS_dossier::getParamRequestToArray(("gestion_dossier"))['filtres_simples']['ops_etape_id'] ?? array();
        $valeurs = $infosFiltre['valeurs'] ?? "";

        $this->smarty->assign("ELEMENTS", $resultats);
        $this->smarty->assign("TYPE_CHAMPS", $this->type);
        $this->smarty->assign("NOM_CHAMP", "ops_etape_id");
        $this->smarty->assign("NOM_TABLE", "ops_dossier");
        $this->smarty->assign("VALEURS_SELECT", explode("|", $valeurs));

        $res = $this->getNombreDossierParEtape();
        $this->smarty->assign("NB_DOSSIER_ARRAY", $res);

    }

    public function getNombreDossierParEtape(){
        global $db;
        
        $from = $_GET['from'];
        $where = $_GET['where'];

        // on enleve l'etape car sinon si on a le filtre sur une etape on aura toutes les etapes a 0 dossiers
        $patternSecuritaire = "/AND\s+\(ops_dossier\.ops_etape_id\s+=\s+'[0-9a-fA-F-]+'\)/";
        $whereSansEtape = preg_replace($patternSecuritaire, "", $where);

        $pattern = "/AND\s+ops_etape_id\s+=\s+'[0-9a-fA-F-]+'/";
        $whereSansEtape = preg_replace($pattern, "", $whereSansEtape);


        if(empty($from)) return [];
        
        $query = "SELECT count(ops_dossier.id) nb, ops_dossier.ops_etape_id " . $from . $whereSansEtape . " group by ops_etape_id";
        
        $query = $db->query($query);
        
        $resultats = [];

        while($row = $db->fetchRow($query)){
            $resultats[$row['ops_etape_id']] = $row['nb'];
        }

        return $resultats;

    }


    public function getOrdre(){
        return 1;
    }
}