$(document).ready(function() {
    surchageFermerModalModifierStatut();
    gestionDispositif();
    rechercherDispositif();
    gestionBoutonRechercher();
    repositionFooter();
    gestionInput();
    triDesFiltresParOrdreAlphabetique();
    gestionTuiles();
    gestionAffichageDeBase();
    gestionMassUpdate();
    gestionCliqueSurAutreOnglet();


});

function gestionCliqueSurAutreOnglet(){

    $(document).on('click', "td[field='num_dossier'] a", function(e){ 
        e.preventDefault(); 
        const url = $(this).attr('href'); 
        window.open(url, '_blank');
    });
}

function gestionAffichageDeBase(){

    $(".dropdown-specifique-content").last().css("right", "0px");
    $("[title='Mes filtres']").parent().parent().remove();

    $(".listViewLinkButton, .columnsFilterLink ").hide();

    $("#MassAssign_SecurityGroups").remove();
    $(".listViewBody #MassUpdate").nextAll().insertBefore($("#displayMassUpdate"));

    $(".listViewEmpty").css("margin-top", "15px");

    if(!existeFiltreSelectionne()) {
        $(".list-view-rounded-corners").hide();
        $(".dropdown-specifique").not("#select_dispositif").find("button").addClass("dropdown-specifique-btn-disabled");
        $(".dropdown-specifique").not("#select_dispositif").addClass("dropdown-specifique-disabled");
    }

    $("#select_dispositif .dropdown-specifique-actions").hide(); 


    $(".moduleTitle").remove();

}

function gestionMassUpdate(){
    let massUpdateForm = JSON.parse($("#MassUpdate input[name='current_query_by_page']").val());
    let filtres = btoa(setForm());
    massUpdateForm.gestion_dossier_mu = filtres;

    $("#MassUpdate input[name='current_query_by_page']").val(JSON.stringify(massUpdateForm));
}

function setForm(event= false){
    // preparation des filtres a envoyé a la vue
    var data = {["filtres_simples"]: {}, ["filtres_simples_flag"]: {}, ["filtres_simples_relation"]: {}};


    // suppression des eventuels residus
    if(event) event.formData.delete("gestion_dossier");

    // recuperation des filtres simples
    let filtresBasique = $("[data-type='basique']");
    
    for(var el of filtresBasique){
        let element = $(el);
        
        let champ = element.data("champ");
        let values = element.data("value");
        let table = element.data("table");

        if(champ == undefined || champ === "" ) continue;
        if(values == undefined || values === "" ) continue;
        if(table == undefined || table === "" ) table = "";
    
        // cas des tuilles ou plusieurs tuiles correspondent au meme champs a filtrer
        if(data["filtres_simples"][champ] != undefined && data["filtres_simples"][champ]["table"] == table){
            data["filtres_simples"][champ]["valeurs"] += "|" + values;
            continue;
        }

        data["filtres_simples"][champ] = {"table" : table, "valeurs" : values};
    }


    let filtreColonnes = $("[data-type='flag_colonne']");
    for(var el of filtreColonnes){
        let element = $(el);
        
        let colonne = element.data("value");
        let table = element.data("table");

        if(colonne == undefined || colonne == "" ) continue;
        if(table == undefined || table == "" ) table = "";
        
        data["filtres_simples_flag"][element.attr("name")] = {"colonnes" : colonne, "table" : table, "valeurs" : 1};
    }

    let filtresRelations = $("[data-type='relation']");
    for(var el of filtresRelations){
        let element = $(el);
        
        let champ = element.data('champ');
        let value = element.data('value');
        let table = element.data('table');
        let table2 = element.data('table2');
        let relate = element.data('relate');
        let champs1r = element.data('champs1r');
        let champs2r = element.data('champs2r');

        if(champ == undefined || champ == "" ) continue
        if(value == undefined || value == "" ) continue
        if(table == undefined || table == "" ) continue
        if(table2 == undefined || table2 == "" ) continue
        if(relate == undefined || relate == "" ) continue
        if(champs1r == undefined || champs1r == "" ) continue
        if(champs2r == undefined || champs2r == "" ) continue
        

        data["filtres_simples_relation"][element.attr("name")] = 
        {
            "champ": champ,
            "valeurs": value,
            "table": table,
            "table2": table2,
            "relate": relate,
            "champs1r": champs1r,
            "champs2r": champs2r
        };
    }

    // mise en string sinon ca passe pas dans la requete
    data = JSON.stringify(data);

    if(event){
        // maj du formdata
        event.formData.set("gestion_dossier", data);


        // pour eviter le renvoi sur la vrai listview !
        event.formData.set("action","GestionView");
    }
    return data;
}

function construireGuideInstruction(etapes){
    $(".tuile").remove();

    $.each(etapes,function(id, data){
        let tuile = $($("#template_tuile").html());
        tuile.find(".titre_tuile").text(data.name).attr("title",data.name);
        tuile.attr("id", id);
        tuile.find(".data_important").text(data.nb);
        tuile.find(".nomination_data_important").text("dossiers");
        // tuile.attr("data-type", "basique");
        // tuile.attr("data-champ", "ops_etape_id");
        if(data.instruction != null){
            tuile.find(".icone1_titre").addClass("fa fa-info-circle info-tooltip").attr("title", data.instruction.replace(/(<([^>]+)>)/ig, ''));
        }
        //tuile.find(".icone2_titre").addClass("far fa-clock");;
        $("#filtres_avancees_dossier").append(tuile);
    })
}

function repositionFooter() {
    $("footer.expandedSidebar").css({
        "position":"fixed",
        "bottom":0,
        "left": $(".sidebar").width()
    })
}

function gestionTuiles(){
    $(".tuile").on("click", function(){

        //gestionOverlay("Veuillez cliquer sur rechercher");
        if(!$(this).hasClass("tuile-selected")){
            $(".tuile-selected").not(this).each(function(){$(this).data("value", "")});
            $(".tuile-selected").not(this).removeClass("tuile-selected");
            $(this).addClass("tuile-selected");
            $(this).attr("data-value", $(this).attr('id'));
        }
        else {
            $(this).data('value', '');
            $(this).removeClass("tuile-selected");
            
        }

        $("#filtre_simple_rechercher").click();

    });
}

function gestionDispositif(){

    let selectedInput = $("#select_dispositif").find("input:checked");
    if(selectedInput.length != 0){
        let nomDispo = selectedInput.parent().attr("title");
        $("#select_dispositif").find(".dropdown-specifique-btn").text(nomDispo);
        $("#select_dispositif").find(".dropdown-specifique-btn").attr("title", nomDispo);
    }

    $("#select_dispositif").on("change", function(e){
        if($(e.target).hasClass("dropdownSearch")) return;

        // $(".dropdown-specifique").removeClass("dropdown-specifique-disabled");
        // $(".dropdown-specifique-btn").removeClass("dropdown-specifique-btn-disabled");

        // $(".tuile .data_important").text("-");
        // $(".tuile .nomination_data_important").text("dossiers");
        // //gestionOverlay("Veuillez cliquer sur rechercher");
        // $(".dropdown-specifique input").not($(this).find("input")).prop("checked", false);
        // $(".dropdown-specifique button").not($(this).find("input")).removeClass("filter-selected");
        // $(".dropdown-specifique").not($(this).find("input")).data("value", "");
        let id = $(this).find("input:checked").val();
        let nomDispo = $(this).find("input:checked").parent().attr("title");
        $(this).find(".dropdown-specifique-btn").text(nomDispo);
        $(this).find(".dropdown-specifique-btn").attr("title", nomDispo);
        $(this).data("value", id);

        $(".dropdown-specifique-clear").not($(this).find(".dropdown-specifique-clear")).click();
        $(".tuile-selected").data("value", "");
        $(this).find(".dropdown-specifique-search").click();

        //recuperationEtapesDuGuideInstruction(id);

    });
}

function recuperationEtapesDuGuideInstruction(idDispositif){
    let data =  [];
    data['id'] = idDispositif;
    loading = function(){
    };

    callBack = function(){
        $.when(construireGuideInstruction(this.result)).then(gestionTuiles);
    };

    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_dispositif');
    query.setAction("getEtapesGuideInstruction");
    query.setPostData(data);
    OdeAjax.getByAction( query, loading, callBack );

    $("#filtre_simple_rechercher").attr("disabled", false);
}

function gestionInput(){

    $(".dropdown-specifique-search").on("click", function(){
        $("#filtre_simple_rechercher").click();
    })

    $(".dropdown-specifique-clear").on("click", function(){
        let input = $(this).parent().parent().find(".dropdown-specifique-options").find("input");
        input.prop("checked", false);
        $(this).parent().parent().parent().data("value", "");

    })

    $(".dropdown-specifique").each(function(){
        if($(this).data("value") !== "") $(this).find("button").addClass("filter-selected");
    });
    $(".dropdown-specifique").on("mouseleave", function(){  


        let button = $(this).find("button");
        let inputChecked = $(this).find(".dropdown-specifique-content input:checked");
        let input = $(this).find(".dropdown-specifique-content input");

        const oldData = $(this).data("old");
        const newData = $(this).data("value");

        // pas de filtre selectionné
        if(!button.hasClass("filter-selected")){
            inputChecked.prop("checked", false);
            button.removeClass("filter-selected");
            $(this).data("value", "");
            return;
        }
        else if((typeof oldData == "string" && oldData != newData)){
            inputChecked.prop("checked", false);
            // on remet les anciennes valeurs cochées
            oldData.split("|").forEach(el => {
                input.filter(function() {return $(this).val() === el}).prop("checked", true);
            });
            
            $(this).data("value", oldData);
        }


        if(input.filter(":checked").length == 0){
            button.removeClass("filter-selected");
        }
        else button.addClass("filter-selected");

    });

    $(".dropdown-specifique input:checkbox").on("change", function(){
        // $(".tuile .data_important").text("-");
        // $(".tuile .nomination_data_important").text("dossiers");
        //gestionOverlay("Veuillez cliquer sur rechercher");

        let divDropDown = $(this).closest(".dropdown-specifique");
        let selectedValues = []; // tableau pour stocker les valeurs sélectionnées

        let oldData = divDropDown.data("value");
        // Parcourir toutes les cases à cocher sélectionnées dans ce groupe
        divDropDown.find("input:checkbox:checked").each(function() {
            selectedValues.push($(this).val()); // Ajouter la valeur de la case à cocher sélectionnée au tableau
        });
    
        // sauvegarde des anciennes données pour gérer l'effacement des filtres s'ils n'ont pas ete appliqués
        if(divDropDown.data("old") == undefined) divDropDown.attr("data-old", oldData);

        // Mettre à jour l'attribut data-value avec la liste des valeurs sélectionnées, séparées par des virgules
        divDropDown.data("value", selectedValues.join("|"));
    });

    addEventListener("formdata", (event) => {
        setForm(event);
    

    });

}

function gestionOverlay(message){
    if($("#overlay_list").length != 0) return;

    $("<div id='overlay_list'>"+message+"</div>").css({
        position: "absolute",
        width: "100%",
        height: "100%",
        'border-radius':'15px 15px 0 0',
        'font-weight':'bold',
        color: "white",
        'font-size':"25px",
        'padding-top': "5%",
        top: "0px",
        left: "0px",
        background: "#575757b3",
        'text-align': "center",
    }).appendTo($(".list-view-rounded-corners").css("position", "relative"));
}

function gestionBoutonRechercher(){
    $("#filtre_simple_rechercher").hide();
    $("#filtre_simple_rechercher").on("click", function(){
        if($("#select_dispositif").val() == null) {
            alert("Veuillez selectionner à minima un dispositif");
            return;
        }
        document.MassUpdate.submit();
    });
}

function existeFiltreSelectionne(){
    return $(".filter-selected, .tuile-selected, #select_dispositif option:selected:not(:disabled)").length != 0;
}

function triDesFiltresParOrdreAlphabetique(){
    // Sélection des éléments avec la classe "dropdown-specifique"
    var dropdownSpecifiques = $('.dropdown-specifique').not("#select_dispositif");
    // Tri des éléments "dropdown-specifique" en fonction du texte de leur enfant "dropdown-specifique-btn"
    dropdownSpecifiques.sort(function(a, b) {

        var textA = $(a).find('.dropdown-specifique-btn').text().trim(); // Texte de l'élément a
        var textB = $(b).find('.dropdown-specifique-btn').text().trim(); // Texte de l'élément b

        return textB.localeCompare(textA); // Comparaison des textes
    });


    // Réorganisation des éléments "dropdown-specifique" dans le DOM
    dropdownSpecifiques.each(function(index, element) {
        $("#select_dispositif").after(element); // Réinsérer l'élément trié dans le parent
    });
}

function rechercherDispositif(){
    $(".dropdown-specifique:not(#select_dispositif").find(".dropdownSearch").remove();
    $('.dropdownSearch').on('keyup', function() {
        var filter = $(this).val().toLowerCase();
        $('.dropdown-item').each(function() {
          var text = $(this).text().toLowerCase();
          if (text.includes(filter)) {
            $(this).show();
          } else {
            $(this).hide();
          }
        });
      });
}


function surchageFermerModalModifierStatut(){
    $('#form_statut_btn_terminer').off().click(function(){
        if ( $("#dossiers_updated").val() === "oui" ){
            $("#dossiers_updated").val("non");
            window.location.reload();
        } else {
            $.f_modal.close();
        }
    });
}