$(document).ready(function() {

    // We initialize the modal
    ModalDocument.initialisation( GenererDocument.modal_id );

    if ( ModalDocument.loaded ) {

        // We initialize the onclick function [ Action par lot ]
        GenererDocument.setClickActionLotBtn();
    }

    $('#form_generer_document_btn_terminer').click(function(){
        $.f_modal.close();
    });

    $('#form_generer_document_btn_execute').click(function(){
        GenererDocument.GenererDocumentDossiers();
    });

});

// We create an instance of the OdeModal object
const ModalDocument = Object.create(OdeModal);

if( typeof(GenererDocument) == 'undefined' ){ var GenererDocument = { modal_id: 'ode_modal_generer_document', loaded: false }; }

// We initialize the onclick function [ Action par lot ]
GenererDocument.setClickActionLotBtn = function(){
    $('[role="ode-modal-generer-document-btn"]').off().on('click', function () {
        $('#form_generer_document_btn_terminer').text('Fermer');
        $('#form_generer_document_btn_terminer').show();
        $("#form_generer_document_btn_execute").hide();
        $('#form_generer_document_btn_telecharger').hide();
        ModalDocument.initialisation( GenererDocument.modal_id );
        ModalDocument.open();
        GenererDocument.initialisation();
    });
}

GenererDocument.initialisation = function(){ 

    ModalDocument.route('loading');

    var loading = function(){
        ModalDocument.loading.setMessage('Récupération des dossiers séléctionnés');
    };

    var callBack = function(){

        if ( typeof this.result.html_message === "string"){
            ModalDocument.route('erreur',this.result.html_message);
            return; 
        }

        if(typeof this.result.erreur === "string" && this.result.erreur != '' ){
            ModalDocument.route('erreur',this.result.erreur);
            return; 
        }

        var message = ( this.result.dossiers_selected.nb === 1 ) 
                    ? `Récupération du dossier séléctionné`
                    : `Récupération des ${this.result.dossiers_selected.nb} dossiers séléctionnés`;

        ModalDocument.loading.setMessage(message);
        ModalDocument.loading.setTotal(this.result.dossiers_selected.nb);

        for(var i = 0; i < this.result.dossiers_selected.nb; i++){
            ModalDocument.loading.increaseCurrent();
        }

        setTimeout(() => {
            ModalDocument.route('generer-document');
            ModalDocument.loading.reset();
            retourFunctionDocument.initChoixDocument(this);
        }, 1000);
    };

    var dossiers = GenererDocument.getSelectedDossiers();

    if(dossiers.dossiers.length > 20){
        ModalDocument.loading.reset();
        ModalDocument.route('generer-document');
        ModalDocument.route('erreur','Plus de 20 dossiers ont été séléctionnés');
    }else{
        var query = OdeQueries.getAjaxActionQuery();
        query.setModule('OPS_dossier');
        query.setAction("initChoixDocument");
        query.setPostData( dossiers );
        OdeAjax.getByAction( query, loading, callBack );
    }
}



GenererDocument.GenererDocumentDossiers = function(){
    ModalDocument.route('loading');

    var loading = function(){
        ModalDocument.loading.setMessage('Récupération des dossiers séléctionnés');
    };

    var callBack = function(){

        if ( typeof this.result.html_message === "string"){
            ModalDocument.route('erreur',this.result.html_message);
            return; 
        }

        if(typeof this.result.erreur === "string" && this.result.erreur != '' ){
            ModalDocument.route('erreur',this.result.erreur);
            return; 
        }

        var message = ( this.result.nb === 1 ) 
                    ? `Récupération du dossier séléctionné`
                    : `Récupération des ${this.result.nb} dossiers séléctionnés`;

        ModalDocument.loading.setMessage(message);
        ModalDocument.loading.setTotal(this.result.nb);

        for(var i = 0; i < this.result.nb; i++){
            ModalDocument.loading.increaseCurrent();
        }

        setTimeout(() => {
            ModalDocument.route('generer-document');
            ModalDocument.loading.reset();
            retourFunctionDocument.GenererDocumentDossiers(this);
        }, 1000);
    };

    var dossiers = GenererDocument.getSelectedDossiers();
    var query = OdeQueries.getAjaxActionQuery();
    query.setModule('OPS_dossier');
    query.setAction("genererDocumentDossiers");
    query.setPostData( dossiers );
    OdeAjax.getByAction( query, loading, callBack );
}

GenererDocument.getSelectedDossiers = function(){
    var tabId = new Array();
    for (var wp = 0; wp < document.MassUpdate.elements.length; wp++) {
        if (document.MassUpdate.elements[wp].name == 'current_query_by_page') {
            json = document.MassUpdate.elements[wp].value;
            json = $.parseJSON( json );
        }
        var reg_for_existing_uid = new RegExp('^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$|^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$');
        if (typeof document.MassUpdate.elements[wp].name != 'undefined' &&
            document.MassUpdate.elements[wp].name == 'mass[]' &&
            document.MassUpdate.elements[wp].checked &&
            !reg_for_existing_uid.test(document.MassUpdate.uid.value)) {
            tabId.push(document.MassUpdate.elements[wp].value);
        }
    }
    if (document.MassUpdate.uid.value != ''){
        var massUpdate = document.MassUpdate.uid.value;
        massUpdate += ',';
        massUpdate += tabId.join(',');
        tabId = massUpdate.split(',');
        if(tabId[tabId.length - 1] == ''){
            tabId.pop();
        }
    }
    return ( document.MassUpdate.select_entire_list.value == 1 ) ? { dossiers: false, filtres: json } : { dossiers: tabId, filtres: false };
}

// Cette variable regroupe les differentes fonctions des actions à mener apres la réponse de l'Ajax
var retourFunctionDocument = {
    initChoixDocument: function(data) {
        if(data.result.dossiers_selected.nums){
            $('#document_liste_titre').text('Liste des dossiers qui seront généré dans le récapitulatif :');
            $('#document_liste_contenu').show();
            $('#document_liste_dossier').text(data.result.dossiers_selected.nums);
            $('#form_generer_document_btn_execute').show();
        }
    },
    GenererDocumentDossiers: function(data) {
        $('#document_liste_titre').text('Le récapitulatif a bien été généré');
        $('#document_liste_contenu').hide();
        $('#form_generer_document_btn_execute').hide();
        $('#form_generer_document_btn_telecharger').show();
        $('#form_generer_document_btn_telecharger').off();
        $('#form_generer_document_btn_telecharger').click(function(){
            window.location = "/index.php?module=OPS_dossier&action=telechargerDocument&file_name="+data.result.nom;
        });
    },
};

// Fonction qui retourne la liste des dossiers 
function getDossiers(){

    var dossiers = false;
    var tabId = new Array();
    for (var wp = 0; wp < document.MassUpdate.elements.length; wp++) {
        if (document.MassUpdate.elements[wp].name == 'current_query_by_page') {
            json = document.MassUpdate.elements[wp].value;
        }
        var reg_for_existing_uid = new RegExp('^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '[\s]*,|,[\s]*' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$|^' + RegExp.escape(document.MassUpdate.elements[wp].value) + '$');
        if (typeof document.MassUpdate.elements[wp].name != 'undefined' &&
            document.MassUpdate.elements[wp].name == 'mass[]' &&
            document.MassUpdate.elements[wp].checked &&
            !reg_for_existing_uid.test(document.MassUpdate.uid.value)) {
            tabId.push(document.MassUpdate.elements[wp].value);
        }
    }
    dossiers = tabId + '&selectAll=0';
    if (document.MassUpdate.select_entire_list.value == 1) {
        dossiers = json + '&selectAll=1';
    }
    return dossiers;

}