<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
use ODE\CustomBlock\modules\OPS_dossier\FiltreSimple;
use ODE\Surcharge\TraitementViewMetadata;

class OPS_dispositifViewEdit extends ViewEdit
{

    public function __construct()
    {
        parent::__construct();
    }

    function display()
    {

        global $app_strings, $app_list_strings;

        $tabTypeTier = get_bean_select_array(false, 'OPS_type_personne',"name", "",'name');
        $typeTierlListe = '';
        $typeTierIds = str_replace('^', '', $this->bean->type_tier);
        $typeTierIds = explode(',', $typeTierIds);

        foreach($tabTypeTier as $key => $value){
            if(array_search($key,$typeTierIds) === false){
                $typeTierlListe .= '<option label="'.$value.'" value="'.$key.'">'.$value.'</option>';
            }else{
                $typeTierlListe .= '<option label="'.$value.'" value="'.$key.'" selected="selected">'.$value.'</option>';
            }
        }

        $input_type_tier = '<input type="hidden" id="type_tier_multiselect" name="type_tier_multiselect" value="true">
        <select id="type_tier" name="type_tier[]" multiple="true" size="6" style="width:150" title="" tabindex="0">'.$typeTierlListe.'</select>';

        $this->ss->assign("input_type_tier", $input_type_tier);

        // recuperation des nom des champs du dossier pour la config de la gestion des dossiers.
        $champEnPlus = array(
            "date_transmission" => "",
            "dossier_prioritaire" => "",
            "dossier_signale" => "",
            "dossier_urgent" => "",
            "sous_territoires"=> "",
        );

        $bean = BeanFactory::newBean("OPS_dossier");
        $field_defs = $bean->getFieldDefinitions();

        foreach($champEnPlus as $nomTechnique => &$valeur) {
            foreach ($field_defs as $name => $value) {

                if ($name == $nomTechnique) {
                    $display_label = translate($value['vname'], "OPS_dossier");
                    $valeur = str_replace(' :', '', $display_label);
                }
            }
        }

        $liste_champs_tri = $this->sortArrayByArray($app_list_strings['list_champs_dossier'], $app_list_strings['list_champs_dossier_defaut']) ;
        $liste_champs_tri = array_merge($liste_champs_tri, $champEnPlus);

        $this->ss->assign("CHAMPS_DOSSIER_LISTE", $liste_champs_tri);

        $collator = new \Collator('fr_FR');

        uasort($liste_champs_tri, function ($a, $b) use ($collator) {
            return $collator->compare($a, $b);
        });

        $this->ss->assign("CHAMPS_DOSSIER_LISTE_SORTED", $liste_champs_tri);
        $liste_colonnes_affichees = array_filter(explode(",", $this->bean->colonnes_gestion_dossiers));


        $this->ss->assign("LISTE_COLONNES_AFFICHEES", $liste_colonnes_affichees);
        $this->ss->assign("CHAMPS_DOSSIER_LISTE_DEFAUT", $app_list_strings['list_champs_dossier_defaut']);
        $choixColonnes = $this->ss->fetch("modules/OPS_dispositif/tpls/choix_colonnes_dossier.tpl");
        $this->ss->assign("CUSTOM_COLONNES_GESTION_DOSSIERS", $choixColonnes);

        global $app_list_strings;

        $test = $this->inputDisplayFilter();
        $this->ss->assign("CUSTOM_FILTER_TO_SHOW", $test);

        $cheminSurcharge = "custom/modules/OPS_dispositif/Surcharge/views/";
        $fichiers = TraitementViewMetadata::checkDir('view.edit',$cheminSurcharge);

        if(!empty($fichiers) && is_array($fichiers)){
            foreach ($fichiers as $fichier) {
                include("$cheminSurcharge$fichier");
                if(!empty($surchargeClass)){
                    new $surchargeClass($this,$smarty,$contenue);
                }
            }
        }

        parent::display();
        $this->displayTMCE();

        if(!isset($app_list_strings['moduleList']['OPS_engagement'])){
            echo '<script>

                    $("#affiche_indicateur_title").parent().parent().remove();
                    $("div[field=\'affiche_indicateur\']").prev().remove();
        
                    if($("div[field=\'affiche_indicateur\']").parent().children().length == 1) 
                        $("div[field=\'affiche_indicateur\']").parent().remove();
                    else 
                        $("div[field=\'affiche_indicateur\']").remove();
                </script>';
        }


    }

    private function sortArrayByArray($array, $orderArray)
    {
        $ordered = array();
        foreach ($orderArray as $key => $value) {
            if (array_key_exists($key, $array)) {
                $ordered[$key] = $array[$key];
                unset($array[$key]);
            }
        }
        return $ordered + $array;
    }

    private function inputDisplayFilter(){
        $filtres = new FiltreSimple();
        $controllers = $filtres->getInfos()['php_controllers'];
        $filtresButton = [];
        foreach($controllers as $controller){
            if(!method_exists($controller, "getNomListe"))continue;
            $filtresButton[] = ["libelle"=>$controller->getNomListe(), "id"=>"filtre_".$controller->getNomFiltre()];
            
        }

        $columns = array_column($filtresButton, 'libelle');
        array_multisort($columns, SORT_ASC, $filtresButton);

        $html =<<<EOD
            <input type="hidden" id="filtres_gestion_dossier" name="filtres_gestion_dossier" value="{$this->bean->filtres_gestion_dossier}">
            <div class="row">
        EOD;


        $filtresAlreadySelected = explode(",", $this->bean->filtres_gestion_dossier);
        $valueExist = !empty($this->bean->filtres_gestion_dossier);

        

        foreach($filtresButton as $index => $filtresData){
            $libelle = $filtresData['libelle'];
            $id = $filtresData['id'];
            $checked = in_array($id, $filtresAlreadySelected) || !$valueExist ? "checked" : "";


            $html .= <<<EOD
                <div class="col-sm-6">
                    <div class="col-sm-4">$libelle :</div>
                    <div class="col-sm-8"><input class="filtres_gestion_dossier_input" type="checkbox" id="$id" name="$id" $checked title="" tabindex="0"></div>
                </div>
            EOD;
            
            // fermeture et ouverture d'une row 
            if($index % 2 != 0 && $index !== array_key_last($filtresButton)){
                $html .= <<<EOD
                    </div>
                    <div class="row">
                EOD;
            }
        }
        $html .= <<<EOD
            </div>
        EOD;

        return $html;







    }

    function displayTMCE()
    {
        require_once ("include/SugarTinyMCE.php");
        global $locale;

        $tiny = new SugarTinyMCE();
        $tinyMCE = $tiny->getConfig();

        $js = <<<JS
        <script language="javascript" type="text/javascript">
        $tinyMCE
        var df = '{$locale->getPrecedentPreference('default_date_format')}';

        tinyMCE.init({
            selector: '#accroche, #description_dispositif,#piece_a_fournir,#mode_operatoire,#contacts,#eligibilite,#faq',
            plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
            license_key: 'gpl',
            toolbar: 'undo redo | blocks fontfamily fontsizeinput | bold italic underline forecolor backcolor removeformat | align numlist bullist | link image | table quickimage | lineheight indent outdent | pagebreak | code fullscreen preview | wordcount',
            quickbars_selection_toolbar: 'bold italic underline | quicklink h2 h3 blockquote quickimage quicktable',
            inline_styles: true,
            directionality: 'ltr',
            remove_redundant_brs: true,
            entity_encoding: 'raw',
            verify_html: false,
            valid_children: '+a[*]',
            cleanup: false,
            cleanup_on_startup: false,
            convert_urls: false,
            plugin_insertdate_dateFormat: "{DATE {$defaultDateFormat}}",
            pagebreak_separator: '<pagebreak />',
            extended_valid_elements: '*[*]',  // Allow all elements and attributes
            valid_elements: '*[*]',           // Allow all elements and attributes
            custom_elements: 'textblock',
            language: 'fr_FR',
            language_url: '/vendor/tweeb/tinymce-i18n/langs/fr_FR.js',
            promotion: false,
            branding: false,
            relative_urls: false,
            remove_script_host: false,
        });

        </script>

JS;
        echo $js;

    }
}
