<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once('include/MVC/View/views/view.detail.php');
use ODE\CustomBlock\modules\OPS_dossier\FiltreSimple;
use ODE\Surcharge\TraitementViewMetadata;

class OPS_dispositifViewDetail extends ViewDetail {


    public function __construct(){
        parent::__construct();
    }

    function display(){

        global $app_strings;

        echo '<link href="custom/include/libs/fontawesome/css/all.min.css" rel="stylesheet">';

        if(empty($this->bean->id)){
            sugar_die($app_strings['ERROR_NO_RECORD']);
        }

        $this->dv->process();

        $tabTypeTier = get_bean_select_array(false, 'OPS_type_personne',"name", "",'name');
        $typeTierlListe = '';
        $typeTierIds = str_replace('^', '', $this->bean->type_tier);
        $typeTierIds = explode(',', $typeTierIds);

        foreach($tabTypeTier as $key => $value){
            if(array_search($key,$typeTierIds) !== false){
                $typeTierlListe .= '<li style="margin-left:10px;">'.$value.'</li>';
            }
        }

        $input_type_tier = '<input type="hidden" id="type_tier" name="type_tier" value="true">'.$typeTierlListe;

        $this->ss->assign("input_type_tier", $input_type_tier);

        // On récupère la liste des colonnes affichées dans le dashlet
        $liste_colonnes_affichees = array_filter(explode(",", $this->bean->colonnes_gestion_dossiers));

        // On récupère la définition des champs du module OPS_dossier
        $bean = BeanFactory::newBean("OPS_dossier");
        $field_defs = $bean->getFieldDefinitions();

        $array_liste_colonnes = array();
        for ($i = 0; $i < count($liste_colonnes_affichees); $i++) {
            foreach ($field_defs as $name => $value) {
                if ($name == $liste_colonnes_affichees[$i]) {
                    $display_label = translate($value['vname'], "OPS_dossier");
                    $array_liste_colonnes[$name] = str_replace(' :', '', $display_label);
                }
            }
        }
        $this->ss->assign('LISTE_COLONNES_AFFICHEES', "<ul style='list-style:inside'><li> " . implode("</li>\n<li>", $array_liste_colonnes) ."</li></ul>");
        $this->inputDisplayFilter();
        global $app_list_strings;

        $cheminSurcharge = "custom/modules/OPS_dispositif/Surcharge/views/";
        $fichiers = TraitementViewMetadata::checkDir('view.detail',$cheminSurcharge);

        if(!empty($fichiers) && is_array($fichiers)){
            foreach ($fichiers as $fichier) {
                include("$cheminSurcharge$fichier");
                if(!empty($surchargeClass)){
                    new $surchargeClass($this,$smarty,$contenue);
                }
            }
        }

        parent::display();

        if(!isset($app_list_strings['moduleList']['OPS_engagement'])){
            echo '<script>
                    $("#affichage_indicateur").parent().parent().remove();

                    $("div[field=\'affiche_indicateur\']").prev().remove();
        
                    if($("div[field=\'affiche_indicateur\']").parent().children().length == 1) 
                        $("div[field=\'affiche_indicateur\']").parent().remove();
                    else 
                        $("div[field=\'affiche_indicateur\']").remove();
                </script>';
        }

    }

    private function inputDisplayFilter(){
        $filtres = new FiltreSimple();
        $controllers = $filtres->getInfos()['php_controllers'];
        $filtresButton = [];
        foreach($controllers as $controller){
            if(!method_exists($controller, "getNomListe"))continue;
            $filtresButton["filtre_".$controller->getNomFiltre()] = $controller->getNomListe();
            
        }

        
        

        $filtresAffichees = explode(",",$this->bean->filtres_gestion_dossier);

        if(empty($this->bean->filtres_gestion_dossier)) 
            $listeFiltreAffichee = $filtresButton;
        else {

            $listeFiltreAffichee = array_map(fn($value) => $filtresButton[$value],$filtresAffichees );

        }
    
        $this->ss->assign('LISTE_FILTRES_AFFICHEES', "<ul style='list-style:inside'><li> " . implode("</li>\n<li>", $listeFiltreAffichee) ."</li></ul>");








    }
}