$(document).ready(function () {
    var counter = 0;
    /* On ajoute la div des filtres du module Dossier dans le panel "Filtres" */
    let div_filtres = document.getElementById('filtres-container');
    let div_filtres_dossier = document.getElementById('filtres_dossier');
    div_filtres.append(div_filtres_dossier);

    /* On ajoute avant le champ "Description" les sélecteurs de colonnes à afficher */
    add_colonne_field('display_tabs_dossier_div');

    /* On déclenche l'affichage du sélecteur de colonnes et des filtres correspondants à l'objet sélectionné  */
    on_objet_change_dossier();

    /* Si l'objet est modifié, on déclenche l'affichage du sélecteur de colonnes et des filtres correspondants à l'objet sélectionné */
    $('#dashlet_objet').change(function () {
        on_objet_change_dossier()
    });

    /* On déclenche le resize des select des colonnes affichées / masquées au déplacement d'une colonne */
    var div_tabs_dossier = document.getElementById('display_tabs_dossier_div');
    var chooser_display_tabs_left_arrow = $('#chooser_display_tabs_left_arrow', div_tabs_dossier)[0];
    var chooser_display_tabs_left_to_right = $('#chooser_display_tabs_left_to_right', div_tabs_dossier)[0];

    chooser_display_tabs_left_arrow.addEventListener("click", () => {
        modify_css_colonnes_select('hide_tabs', 'display_tabs')
    }, false);

    chooser_display_tabs_left_to_right.addEventListener("click", () => {
        modify_css_colonnes_select('hide_tabs', 'display_tabs')
    }, false);

    $("#addrow").on("click", function () {
        add_metadata_button()
    });

    $("table.order-list").on("click", ".ibtnDel", function (event) {
        $(this).closest("tr").remove();
        counter -= 1
    });

    jQuery('#filtres_dossier div[id^="checkboxes_"] input[type=checkbox]').each(function () {
        if (this.checked) {
            $('#' + this.id).prop("checked", true);
            checkbox_change_css(this)
            checkbox_verify_all_checked(this)
        } else {
            $('#' + this.id).prop("checked", false);
            checkbox_change_css(this)
            checkbox_verify_all_checked(this)
        }
    });

    check_justificatif_etude();
    jQuery('#flag_justificatif_etude').change(function () {
        check_justificatif_etude();
    });

    check_justificatif_reetude();
    jQuery('#flag_justificatif_reetude').change(function () {
        check_justificatif_reetude();
    });
});

function check_justificatif_reetude()
{
    if(jQuery('#flag_justificatif_reetude').is(':checked'))
    {
        jQuery('#flag_justificatif_etude').attr('disabled', true);
    }
    else
    {
        jQuery('#flag_justificatif_etude').attr('disabled', false);
    }
}

function check_justificatif_etude()
{
    if(jQuery('#flag_justificatif_etude').is(':checked'))
    {
        jQuery('#flag_justificatif_reetude').attr('disabled', true);
    }
    else
    {
        jQuery('#flag_justificatif_reetude').attr('disabled', false);
    }
}


/**
 * Fonction vérifiant le type d'objet sélectionné pour afficher les filtres et le sélecteur de colonnes correspondants
 * 
 * @return {void}
 */
var on_objet_change_dossier = function () {
    var valueObjet = document.getElementById('dashlet_objet').value;

    if (valueObjet == 'OPS_dossier') {
        $('#display_tabs_dossier').parent().show();
        $('#display_tabs').prop('disabled', false);
        $('#filtres_dossier').show();
        $('#filtres_dossier *').prop('disabled', false);
        $('#li-filtres').show()
    } else {
        $('#display_tabs_dossier').parent().hide();
        $('#display_tabs').prop('disabled', true);
        $('#filtres_dossier').hide();
        $('#filtres_dossier *').prop('disabled', true);
    }
}

var add_metadata_button = function () {
    var nb_metadata_input = document.getElementById('nb_metadata');
    if (nb_metadata_input) {
        var counter = document.getElementById('nb_metadata').value;
    } else {
        var counter = 0;
    }

    var newRow = "<tr></tr>";
    var cols = "";

    var select = document.getElementById('metadata0');
    var options = select.innerHTML;

    cols += '<td class="col-sm-5"><select id="metadata' + counter + '" name="metadata' + counter + '" style="width:100%;height:35px">' +
        options + '</select></td>';
    cols += '<td class="col-sm-5"><input type="text" class="form-control" name="value_metadata' + counter +
        '"></td>';

    cols += '<td class="col-sm-5"><input type="button" class="ibtnDel btn btn-md btn-danger" style="height: 35px;" value="Supprimer"></td>';
    $(newRow).append(cols);
    $("table.order-list").append(newRow);
    
    counter++;
}