<?php
if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

require_once('modules/OPS_dashlet/views/view.detail.php');

/** 
 * Classe appelée par le view.detail.php du module Dashlet permettant la récupération d'informations liés à l'objet "OPS_dispositif"
 */
class OPS_dispositifDetail
{
    public $ss; // Variable du smarty actuel
    public $bean; // Variable du bean actuel

    public function __construct($objet)
    {
        $this->ss = $objet->ss;
        $this->bean = $objet->bean;
    }

    /**
     * Fonction d'assignation Smarty des variables contenant les valeurs des filtres du Dashlet
     *
     * @param array $filtres
     * @return void
     */
    public function assignValeursFiltres($filtres)
    {
        $liste_dispositifs = array();

        if (isset($filtres['dispositifs'])) { // Filtre dispositifs
            foreach ($filtres['dispositifs'] as $dispositif) {
                if ($dispositif != "") {
                    $un_dispositif = BeanFactory::getBean('OPS_dispositif', $dispositif);
                    $liste_dispositifs[$dispositif] = $un_dispositif->name;
                }
            }
        }
        $this->ss->assign("LISTE_DISPOSITIFS_AFFICHES", $liste_dispositifs);
    }
    
}
