<?php

class hook_conversation
{


    /**
     * Prépare la zone de contenu de la vue détail dossier pour le nouvel onglet.
     * 
     * @internal logic_hooks
     * @access after_ui_frame
     * @uses Bean OPS_conversation
     */ 
    function prepare_after_ui_frame($event, $arguments = null)
    {
        global $app_list_strings;

        if ($event != 'after_ui_frame') return;

        if ($GLOBALS['app']->controller->action == 'DetailView') 
        {
            echo "<!-- F2C[after_ui_frame] -->";

            // Fetch the UI Framing template used to build pre rendering. JS/CSS/HTML basis.
            $smarty           = new Sugar_Smarty();
            $current_template = "modules/OPS_conversation/tpls/fil_conversationnel.tpl";

            $smarty->assign("module", $GLOBALS['app']->controller->module);
            $smarty->assign("record", $GLOBALS['app']->controller->record);

            /**
             * Javascript module run an Ajax callback during Loading sequence.
             * @uses DetailView_UIControler JS module factory
             * 
             * @uses fil_conversationel.css
             * @uses fil_conversationel.js
             * Ajax calls controler method to detect if OPS_Dossier by ID have a relationship loaded for OPS_conversation.
             * 
             */

            echo "\r";
            $smarty->display($current_template); 
            echo "\r";
            
        }
    }
    

    /**
     * Supprime les messages d'une conversation liée à un dossier lorsque ce dernier est supprimé.
     * 
     * @internal logic_hooks
     * @access before_delete
     * @uses Bean OPS_conversation
     */ 
    function delete_messages_conversation($bean, $event, $arguments = null)
    {
        global $app_list_strings;

        if ($event != 'before_delete') return;


        // On récupere le dossier 
        $obj_bean = (!empty($bean->id)) ? BeanFactory::getBean('OPS_dossier', $bean->id) : false;


        # On vérifie de disposer véritablement d'un dossier.
        if ($obj_bean === false) {

            $is_erreur = true;

            $GLOBALS['log']->fatal(" hook_conversation :: delete_messages_conversation => Récupération impossible du Bean Dossier !");
            return;
        }

        # On collecte l'ensemble des éléments liés...
        $bean_name = 'OPS_conversation';
        $Conversation = BeanFactory::getBean($bean_name, null); // Retrieve OPS_conversation bean class.

        $beanList = $Conversation->get_full_list(
                                    //Order by the stamp
                                    'stamp',
                                    //Only conversation messages related to the OPS_dossier ID.
                                    "ops_conversation.parent_id = '". $obj_bean->id ."'"
                                    );

        # Et pour finir on boucle pour les marquer supprimé...
        if ( is_array($beanList) && count($beanList) > 0 ) {
            foreach ( $beanList as $conversation_bean ) {

                $Conversation->mark_deleted($conversation_bean->id);

            }
        }

    }
    
}



