<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

include_once 'custom/include/models/Autoloader.php';
require_once 'include/MassUpdate.php';
use ODE\Helper\OdeArrayHelper;
use ODE\Model\DossierModel;

class OPS_commissionController extends SugarController {

    /**
     * @access public
     * @name action_initFormulaireModifierReunion()
     * Fonction pour initialiser le formulaire de modification de reunion
     * 
     *  @param array                            $_REQUEST : les données transférées en Ajax
     *  @return json                            $data : Json avec un statut ( ok/err ) + les données du dossier ou le libellé de l'erreur
    */
    public function action_initFormulaireModifierCommission() {

        $erreur = "";
        $data_verified =  $this->getDossiers( $_REQUEST );
        $resultat = $resultat_dossier = $commissions_all = $commissions = array();

        if ( $data_verified['statut'] == 'ok') {  

            do {
               
                // On récupere les dossiers
                $dossiers = $data_verified['data'];
                if ( !is_array( $dossiers ) || count( $dossiers ) === 0 ) {
                    $erreur = "Aucun dossier n'a été récupéré";
                    break;
                }

                // On récupere la liste des commissions
                $obj_commission = new OPS_commission();
                $liste_commission = $obj_commission->get_full_list();
                foreach ( $liste_commission as $comi ) {
                    $commissions_all[$comi->id] = $comi->name ;
                    if ( $comi->statut_commission === "1" ){
                        $commissions[$comi->id] = $comi->name ;
                    }
                }
                
                // On vérifie qu'on a des commissions
                if ( !is_array( $commissions ) || count( $commissions ) === 0 ) {
                    $erreur = "Aucune commission n'est disponible";
                    break;
                } else {
                    $resultat['commissions'] = $commissions;
                }

                // On parcours les dossiers 
                foreach ( $dossiers as $dossier_id ) {

                    // On récupere le dossier 
                    $dossierModel = new DossierModel( $dossier_id );
                    $dossier = $dossierModel->getBean();
                    if ( !is_array($dossier) || count($dossier) === 0 ) {
                        $GLOBALS['log']->fatal(" OPS_reunionController :: action_initFormulaireModifierReunion => Dossier id = " . $dossier_id . " introuvable");
                        continue;
                    }

                    // On récupere le numéro du dossier
                    $resultat_dossier[$dossier['id']]['dossier_num'] =  $dossier['num_dossier'];

                    // On récupere l'id de la commission du dossier
                    $dossier_commissions = $dossierModel->getCommissionIds();
                    $dossier_commission_id = ( is_array($dossier_commissions) && count($dossier_commissions) > 0 ) ? $dossier_commissions[0] : "" ;
                    $dossier_commission_name = ( array_key_exists( $dossier_commission_id, $commissions_all) ) ? $commissions_all[$dossier_commission_id] : "aucune commission" ;
                    $resultat_dossier[$dossier['id']]['old_commission'] =  $dossier_commission_name;

                    // On vérifie si l'id de la réunion existe dans le resultat

                    $resultat['dossiers']['dossier_id'] .= "|" . $dossier['id']; 
                    $resultat['dossiers']['dossier_num'] .= "," . $dossier['num_dossier']; 

                    if( empty($resultat['dossiers']['commissions']) || array_key_exists ( $dossier_commission_id ,  $resultat['dossiers']['commissions'] ) === false ) {
                        
                        $resultat['dossiers']['commissions'][$dossier_commission_id]['dossier_id'] = $dossier['id'];
                        $resultat['dossiers']['commissions'][$dossier_commission_id]['dossier_num'] = $dossier['num_dossier'];
                        $resultat['dossiers']['commissions'][$dossier_commission_id]['name'] = $dossier_commission_name;

                    } else {
                        $resultat['dossiers']['commissions'][$dossier_commission_id]['dossier_id'] .= "|" . $dossier['id']; 
                        $resultat['dossiers']['commissions'][$dossier_commission_id]['dossier_num'] .= "," . $dossier['num_dossier']; 
                    }
                        
                    $resultat['nb'] = count($dossiers);

                }

            } while (0);
  
        } else {
            $erreur = $data_verified['data'];
        }

        $data = ( empty($erreur) ) ? array( 'statut' => 'ok', 'data' =>  $resultat ) : array( 'statut' => 'err', 'data' => $erreur );
        
        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }
    
    /**
     * @access public
     * @name action_modifierCommission()
     * Fonction qui retourne le recap avant modification
     * 
     *  @param array                            $_REQUEST : les données transférées en Ajax
     *  @return json                            $data : Json avec un statut ( ok/err ) + les données du dossier ou le libellé de l'erreur
    */
    public function action_modifierCommission() {

        $resultat = array();
        $dossiers = array();
        $erreur = "";
        $champs = array( "json" => true );

        $data_verified =  OdeArrayHelper::isDataValid( $_REQUEST, $champs );
        if ( $data_verified['statut'] == 'ok') {   
            
            $donnees = $data_verified['data']['json_array'];
            $donnees = base64_decode($data_verified['data']['json_array']);
            $donnees = json_decode($donnees);

            do {

                // On récupere la liste des commissions
                $obj_commission = new OPS_commission();
                $liste_commission = $obj_commission->get_full_list();
                foreach ( $liste_commission as $comi ) {
                    $commissions[$comi->id] = $comi->name ;
                }
                
                // On vérifie qu'on a des commissions
                if ( !is_array( $commissions ) || count( $commissions ) === 0 ) {
                    $erreur = "Aucune commission n'est disponible sur la plateforme";
                    break;
                }

                foreach ( $donnees->data as $data ) {
                    if( !empty( $data->dossiers ) ) {

                        $dossiers_ids = array();
                        // On récupere les ids des dossiers
                        if ( strpos($data->dossiers, "|") !== false ) {
                            $dossiers_ids = explode("|", $data->dossiers ); 
                        } else {
                            $dossiers_ids[] = $data->dossiers;
                        }

                        foreach ( $dossiers_ids as $dossier_id) {
                            if ( !empty( $data->commission_id ) ) {
                                $dossiers[$dossier_id]['commission'] = $data->commission_id;
                            }
                        }
                    }
                }

                if ( is_array($dossiers) && count($dossiers) > 0 ) {
                    foreach ( $dossiers as $dossier_id => $donnees ) {
                        $resultat[$this->getDossierNum($dossier_id)] = $this->getRecapDossier( $commissions, $dossier_id, $donnees );
                        if ( $this->updateDossier($dossier_id, $donnees) === false) {
                            $resultat[$this->getDossierNum($dossier_id)] = "erreur";
                        }
                    }
                } 


            } while (0);


        } else {
            $erreur = $data_verified['data'];
        }

        $data = ( empty($erreur) ) ? array( 'statut' => 'ok', 'data' => $resultat ) : array( 'statut' => 'err', 'data' => $erreur);
        
        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    /**
     * @access public
     * @name action_getRecapModificationCommission()
     * Fonction qui retourne le recap avant modification
     * 
     *  @param array                            $_REQUEST : les données transférées en Ajax
     *  @return json                            $data : Json avec un statut ( ok/err ) + les données du dossier ou le libellé de l'erreur
    */
    public function action_getRecapModificationCommission() {

        $resultat = array();
        $dossiers = array();
        $erreur = "";
        $champs = array( "json" => true );

        $data_verified =  OdeArrayHelper::isDataValid( $_REQUEST, $champs );
        if ( $data_verified['statut'] == 'ok') {   

            $donnees = $data_verified['data']['json_array'];
            $donnees = base64_decode($data_verified['data']['json_array']);
            $donnees = json_decode($donnees);

            do {

                // On récupere la liste des commissions
                $obj_commission = new OPS_commission();
                $liste_commission = $obj_commission->get_full_list();
                foreach ( $liste_commission as $comi ) {
                    $commissions[$comi->id] = $comi->name ;
                }
                
                // On vérifie qu'on a des commissions
                if ( !is_array( $commissions ) || count( $commissions ) === 0 ) {
                    $erreur = "Aucune commission n'est disponible sur la plateforme";
                    break;
                }
                
                foreach ( $donnees->data as $data ) {
                    if( !empty( $data->dossiers ) ) {

                        $dossiers_ids = array();
                        // On récupere les ids des dossiers
                        if ( strpos($data->dossiers, "|") !== false ) {
                            $dossiers_ids = explode("|", $data->dossiers ); 
                        } else {
                            $dossiers_ids[] = $data->dossiers;
                        }

                        foreach ( $dossiers_ids as $dossier_id) {
                            if ( !empty( $data->commission_id ) ) {
                                $dossiers[$dossier_id]['commission'] = $data->commission_id;
                            }
                        }
                    }
                }

                if ( is_array($dossiers) && count($dossiers) > 0 ) {
                    foreach ( $dossiers as $dossier_id => $donnees ) {
                        $resultat[$this->getDossierNum($dossier_id)] = $this->getRecapDossier( $commissions, $dossier_id, $donnees );
                    }
                } 


            } while (0);


        } else {
            $erreur = $data_verified['data'];
        }

        $data = ( empty($erreur) ) ? array( 'statut' => 'ok', 'data' => $resultat ) : array( 'statut' => 'err', 'data' => $erreur);

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }

    private function getDossierNum( $dossier_id ) {

        $dossierModel = new DossierModel( $dossier_id );
        $dossier = $dossierModel->getBean();
        return ( is_array($dossier) && count($dossier) > 0 && !empty($dossier["num_dossier"]) ) ? $dossier["num_dossier"] : "" ;

    }

    private function getRecapDossier( $commissions, $dossier_id, $donnees ) {

        $recap_dossier = array(
            "old_commission" => "",
            "new_commission" => "",
        );

        $dossierModel = new DossierModel( $dossier_id );
        $dossier = $dossierModel->getBean();

        // On récupere l'id de la commission du dossier
        $dossier_commissions = $dossierModel->getCommissionIds();
        $dossier_commission_id = ( is_array($dossier_commissions) && count($dossier_commissions) > 0 ) ? $dossier_commissions[0] : "" ;
        $recap_dossier['old_commission'] = ( array_key_exists( $dossier_commission_id, $commissions) ) ? $commissions[$dossier_commission_id] : "aucune commission" ;

        // On récupere le nom de la nouvelle commission
        $recap_dossier['new_commission'] = ( !empty($donnees['commission']) && array_key_exists( $donnees['commission'], $commissions) ) ? $commissions[$donnees['commission']] : "aucune commission" ;

        return $recap_dossier ;
        
    }

    private function updateDossier( $dossier_id, $donnees ) {

        $updated = false;
        $obj_dossier = BeanFactory::getBean( 'OPS_dossier', $dossier_id );
        if( !empty($obj_dossier->id) && !empty($donnees['commission']) )
        { 
            $commissions = $obj_dossier->get_linked_beans( "ops_commission_ops_dossier" , "OPS_commission" ) ;
            if( is_array($commissions) && count($commissions) > 0 ){
                foreach ( $commissions as $commission ) {
                    $obj_dossier->load_relationship( "ops_commission_ops_dossier" );
                    $obj_dossier->ops_commission_ops_dossier->delete( $obj_dossier->id, $commission);
                }
            }
            $obj_dossier->load_relationship("ops_commission_ops_dossier");
            $obj_dossier->ops_commission_ops_dossier->add($donnees['commission']);
            $updated = true;
        }
        return $updated ;
        
    }
    

    /**
     * @access public
     * @name getDossiers()
     * Fonction pour retourne les ids des dossiers séléctionnés 
     * 
     *  @param array                            $_REQUEST : les données transférées en Ajax
     *  @return array                           $data : array avec un statut ( ok/err ) + les données ou le libellé de l'erreur
    */
    private function getDossiers($request)
    {
        global $db;
        $libelle_erreur = '';
        $dossiers = [];
        do {
            $data_verified = OdeArrayHelper::isDataValid($request, ["json" => true]);
            if ($data_verified['statut'] === "err") {
                $libelle_erreur = 'Aucun dossier n\'a été récupéré';
                break;
            }

            $data = $data_verified["data"]["json_array"];

            if (!empty($data['dossiers']) && is_array($data['dossiers']) && count($data['dossiers']) > 0) {
                $dossiers = $data['dossiers'];
                break;
            }
            if (!empty($data['filtres'])) {
                $json = htmlentities(json_encode($data['filtres']), ENT_QUOTES, 'UTF-8');
                // Ce traitement est utilisé dans le cas ou l'utilisateur sélectionne l'intégralité des dossiers + filtres
                $mass = new MassUpdate();
                $mass->generateSearchWhere('OPS_dossier', $json);
                $where_clause = $mass->where_clauses;
                $obj_dossier = new OPS_dossier();
                $query = $obj_dossier->create_export_query("", $where_clause);
                $queryExplode = explode('FROM',$query);
                $queryExplode[0] = 'SELECT ops_dossier.id';
                $query = implode(' FROM', $queryExplode);
                $query = OPS_dossier::cleanQueryActionLot($query,array('ops_sous_territoire','ops_dossier','ops_elu'));
                $result = $db->query($query);
                while ($dossier = $db->fetchByAssoc($result)) {
                    $dossiers[] = $dossier['id'];
                }
            }

            // Je ne vérifie pas si $request['selectAll'] est non vide, empty($request['selectAll']) retourne true quand $request['selectAll']=0
            if (!is_array($dossiers) || count($dossiers) === 0) {
                $libelle_erreur = 'Aucun dossier n\'a été récupéré';
                break;
            }
        } while (0);

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = (empty($libelle_erreur)) ? array('statut' => 'ok', 'data' => $dossiers) : array('statut' => 'err', 'data' => $libelle_erreur);

        return $data;
    }
}