<?php

class OPS_appairage extends Basic
{
    var $new_schema = true;
    var $module_dir = 'OPS_appairage';
    var $object_name = 'OPS_appairage';
    var $table_name = 'ops_appairage';
    var $importable = false;

    var $id;
    var $name;
    var $date_entered;
    var $date_modified;
    var $modified_user_id;
    var $modified_by_name;
    var $created_by;
    var $created_by_name;
    var $description;
    var $deleted;
    var $created_by_link;
    var $modified_user_link;
    var $assigned_user_id;
    var $assigned_user_name;
    var $assigned_user_link;
    var $SecurityGroups;
    var $logiciel;

    var $code_appli_ext;
    var $id_externe;
    var $jeton_appli;
    var $date_expiration;
    var $parent_name;
    var $parent_type;
    var $parent_id;
    var $statut;

    public function __construct()
    {
        parent::__construct();
    }

    public function bean_implements($interface)
    {
        switch ($interface) {
            case 'ACL':
                return true;
        }

        return false;
    }

    /**
     * @access public
     * @name createAppairage()
     * Fonction pour créer un appairage
     * 
     *  @param array				   $data : Tableau des champs du formulaire
     *  @return string				   $dossier_id : retourne l'id de l'appairage ou vide
     */
    public static function createAppairage($data)
    {
        $obj_appairage = BeanFactory::newBean('OPS_appairage');
        $obj_appairage->name = (!empty($data["appairage_name"])) ? $data["appairage_name"] : "";
        $obj_appairage->description = (!empty($data["appairage_description"])) ? $data["appairage_description"] : "";
        $obj_appairage->logiciel = (!empty($data["appairage_logiciel"])) ? $data["appairage_logiciel"] : "";
        $obj_appairage->parent_type = (!empty($data["object_type"])) ? $data["object_type"] : "";
        $obj_appairage->parent_id = (!empty($data["object_id"])) ? $data["object_id"] : "";
        $obj_appairage->statut = (!empty($data["appairage_statut"])) ? $data["appairage_statut"] : "err";
        $appairage_id = $obj_appairage->save();
        return (!empty($appairage_id)) ? $appairage_id : "";
    }
}
