<?php
/*
Author     : LANTEAS
*/
use BeanFactory;
if (!defined('sugarEntry') || !sugarEntry)
	die('Not A Valid Entry Point');

require_once('include/MVC/View/SugarView.php');

class OPS_agendasViewVisualisation extends SugarView
{

	public function __construct($bean = null, $view_object_map = array())
	{
		parent::__construct($bean, $view_object_map);
	}


	/**
	 * @see SugarView::display()
	 */
	public function display()
	{
		global $beanList, $beanFiles, $app_list_strings, $mod_strings, $sugar_config, $db, $current_user;

		$smarty = new Sugar_Smarty();

		$obj_agenda = new OPS_agendas();
		$ressource = "";
		$motif = "";
		$where = "";
		$user_gestion = false;

		// Gestion des droits de l'utilisateur pour la visualisation des rendez-vous
		$liste_agenda_droits = $obj_agenda->recuperation_droits("visualisation");

		if (!empty($liste_agenda_droits)) {

			$where = "  ops_agendas.id in ( " . $liste_agenda_droits . " )";

			//Connaitre le nombre d'agenda paramétré sur l'environnement
			$list_agenda = $obj_agenda->get_full_list('name', $where);

			if (isset($_GET['record']) && !empty($_GET['record']) && mb_substr_count($liste_agenda_droits, $_GET['record']) > 0) {
				$agenda_id = $_GET['record'];
			} elseif (is_array($list_agenda) && !empty($list_agenda) && count($list_agenda) > 0) { // LORSQU'IL N'Y A QU'UN AGENDA - A REVOIR POSE PB LORS DE LA CREATION
				$agenda_id = $list_agenda[0]->id;
			}

			// L'agent a sélectionné un agenda || il n'y a qu'un agenda paramétré
			if (isset($agenda_id)) {

				// Récupération des ressources de l'agenda selectionné
				if (isset($_GET['ressource']) && !empty($_GET['ressource'])) {
					$ressource = $_GET['ressource'];
				}

				// Récupération des motifs de l'agenda selectionné
				if (isset($_GET['motif']) && !empty($_GET['motif'])) {
					$motif = $_GET['motif'];
				}


				// Récupération des lieux de l'agenda selectionné
				if (isset($_GET['lieu']) && !empty($_GET['lieu'])) {
					$lieu = $_GET['lieu'];
				}

				$modale = $this->modale_filtre_agenda($agenda_id, $ressource, $motif, $lieu);
				echo $modale;

				$obj_agenda = BeanFactory::getBean("OPS_agendas", $agenda_id);

				// Affichage de la visualisation des rendez-vous
				if (isset($obj_agenda->id)) {

					// Récupération des droits utilisateurs
					$user_gestion = $obj_agenda->recuperation_droits("gestion");
					$user_gestion_hors_plage = $obj_agenda->recuperation_droits("hors_plage");


					// Mise en place des variables
					$smarty->assign('GESTION_HORS_PLAGE_USER', $user_gestion_hors_plage);
					$smarty->assign('ASSIGNATION_MODIFIABLE', $obj_agenda->assignation_modifiable);
					$smarty->assign('AFFICHAGE_DEFAUT', $obj_agenda->visualisation);
					$smarty->assign('AFFICHAGE_GESTION', $obj_agenda->visualisation_gestion);
					$smarty->assign('AFFICHAGE_MIN_TIME', $obj_agenda->min_time);
					$smarty->assign('AFFICHAGE_MAX_TIME', $obj_agenda->max_time);
					$smarty->assign('AFFICHAGE_WEEK_END', $obj_agenda->week_end);
					$smarty->assign('AFFICHAGE_DURATION', $obj_agenda->slot_duration);


					// Mise en place de la modale de CREATION / MODIF d'un RDV
					$modale_html = $this->html_modale_creation_rdv($obj_agenda, "gru", "");

					if ($user_gestion == 1 || $user_gestion_hors_plage ==1) {
						$smarty->assign('MODALE_CREATION', $modale_html);
					} else {
						$smarty->assign('MODALE_CREATION', "");
					}

					$smarty->assign('GESTION_USER', $user_gestion);
					$smarty->display("modules/OPS_agendas/tpls/agenda_visualisation.tpl");

				} else {

					SugarApplication::appendErrorMessage("L'agenda sélectionné n'existe pas");
					$params = array(
						'module' => 'OPS_agendas',
						'action' => 'visualisation',
						'return_action' => $_REQUEST['return_action'],
						'return_module' => $_REQUEST['return_module']
					);
					SugarApplication::redirect('index.php?' . http_build_query($params));
				}
			} else {

				$modale = $this->modale_filtre_agenda();

				if (0 !== $modale) {

					echo $modale;

					$smarty->assign('AFFICHAGE_DEFAUT', "month");
					$smarty->display("modules/OPS_agendas/tpls/agenda_visualisation.tpl");

				} else {

					SugarApplication::appendErrorMessage("Aucun agenda paramétré");
					$params = array(
						'module' => 'OPS_agendas',
						'action' => 'index',
						'return_action' => $_REQUEST['return_action'],
						'return_module' => $_REQUEST['return_module']
					);
					SugarApplication::redirect('index.php?' . http_build_query($params));
				}
			}
		} else {
			SugarApplication::appendErrorMessage("Vous n'avez pas accès à cette zone, veuillez contacter votre administrateur");
			SugarApplication::redirect('index.php');
		}
	}

	// Modale permettant l'affichage des filtres de l'agenda
	private function modale_filtre_agenda($agenda_id = "", $ressource_id = "", $motif_id = "", $lieu_id = "")
	{
		$obj_agenda = new OPS_agendas();
		$where = "";

		$liste_agenda_droits = $obj_agenda->recuperation_droits("visualisation");

		if (!empty($liste_agenda_droits)) {

			$where = "  ops_agendas.id in ( " . $liste_agenda_droits . " )";

			$list_agenda = $obj_agenda->get_full_list('name', $where);

			if ( is_array($list_agenda) && count($list_agenda) > 0 ) {

				$modale = "<section id='choix_agenda'>
							<div class='panel-body'>
							<div class='filtre_agenda' id='choix_agenda'>
							<form id='form_choix_agenda' action='' method='get' enctype='multipart/form-data' role='form'>";

				/// Filtre des agendas
				$modale .= "<div style='float:left;'>";
				$modale .= "<label class='visua_agenda'>Agenda :</label>
							<select name='visua_agenda' id='visua_agenda' class='visua_agenda'>";

				if (empty($agenda_id)) {
					$modale .= "<option value=''></option>";
				}

				foreach ($list_agenda as $un_agenda) {

					$modale .= "<option value='" . $un_agenda->id . "'";
					if ($agenda_id == $un_agenda->id) {

						// On récupère les différents lieux disponibles sur l'agenda
						$list_plage_ouverture = $un_agenda->get_linked_beans("ops_agendas_ops_plage_ouverture", "OPS_plage_ouverture");
						$list_lieux = array();

						foreach ($list_plage_ouverture as $plage_ouverture) {
							$list_lieux_agenda = $plage_ouverture->get_linked_beans('ops_lieux_ops_plage_ouverture', 'OPS_lieux', 'name');

							if (!empty($list_lieux_agenda)) {
								$list_lieux = array_merge($list_lieux, $list_lieux_agenda);
							}
						}
						$list_lieux = $obj_agenda->unique_multidim_array($list_lieux, 'id');


						$list_ressources = $un_agenda->get_linked_beans('ops_agendas_ressources_ops_agendas', 'OPS_agendas_ressources');
						$list_motifs = $un_agenda->get_linked_beans('ops_agendas_motifs_ops_agendas', 'OPS_agendas_motifs', 'name');
						$modale .= "selected";
					}
					$modale .= "/>" . $un_agenda->name . "</option>";
				}

				$modale .= "</select>";
				$modale .= "</div>";

				/// Filtre des lieux
				$modale .= "<div style='float:left;'>";
				$modale .= "<label class='visua_lieu'>Lieu :</label>
							<select name='visua_lieu' id='visua_lieu' class='visua_lieu'>";
				$modale .= "<option value=''></option>";

				if (isset($list_lieux) && !empty($list_lieux)) {

					usort($list_lieux, function ($a, $b) {
						return strtolower($a->name) > strtolower($b->name);
					});

					foreach ($list_lieux as $lieu) {

						$modale .= "<option value='" . $lieu->id . "'";
						if ($lieu_id == $lieu->id) {

							$modale .= "selected";
						}
						$modale .= "/>" . $lieu->name . "</option>";
					}
				}
				$modale .= "</select>";
				$modale .= "</div>";

				/// Filtre des motifs
				$modale .= "<div style='float:left;'>";
				$modale .= "<label class='visua_motif'>Motif :</label>
							<select name='visua_motif' id='visua_motif' class='visua_motif'>";
				$modale .= "<option value=''></option>";
				if (isset($list_motifs) && !empty($list_motifs)) {

					usort($list_motifs, function ($a, $b) {
						return strtolower($a->name) > strtolower($b->name);
					});

					foreach ($list_motifs as $motif) {

						$modale .= "<option value='" . $motif->id . "'";
						if ($motif_id == $motif->id) {

							$modale .= "selected";
						}
						$modale .= "/>" . $motif->name . "</option>";
					}
				}
				$modale .= "</select>";
				$modale .= "</div>";

				/// Filtre des ressources
				$modale .= "<div style='float:left;'>";
				$modale .= "<label class='visua_ressource'>Ressource :</label>
							<select name='visua_ressource' id='visua_ressource' class='visua_ressource'>";
				$modale .= "<option value=''></option>";
				if (isset($list_ressources) && !empty($list_ressources)) {

					usort($list_ressources, function ($a, $b) {
						return strtolower($a->name) > strtolower($b->name);
					});

					foreach ($list_ressources as $ressource) {

						$modale .= "<option value='" . $ressource->id . "'";
						if ($ressource_id == $ressource->id) {

							$modale .= "selected";
						}
						$modale .= "/>" . $ressource->name . "</option>";
					}

				}
				$modale .= "</select>";
				$modale .= "</div>";
				$modale .= "</form></div>";
				$modale .= '</div></section>';

				return $modale;
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}

	
	/**
	 * Creation de la modale de creation d'un rendez-vous
	 * @param mixed $obj_agenda
	 * @param mixed canal (front ou back)
	 * @param mixed $method (creation/modification)
	 * @param mixed $id_meeting (obligatoire pour la modification)
	 * @return null|string (html)
	 */
	private function html_modale_creation_rdv($obj_agenda, $canal = "", $id_meeting = "")
	{

		global $beanFiles, $current_user, $app_list_strings, $sugar_config;

		require_once($beanFiles["OPS_agendas_ressources"]);
		require_once($beanFiles["OPS_agendas_motifs"]);
		require_once($beanFiles["User"]);
		require_once($beanFiles["Meeting"]);

		if (empty($current_user->id)) {
			$obj_user = new User();
			$current_user = $obj_user->retrieve('1');
		}

		if ($canal == "gru") {
			$modale_html = '<script src="modules/OPS_agendas/js/agenda_creation_rdv.js" type="text/javascript" charset="utf-8"></script>
							<script src="modules/OPS_agendas/js/agenda_creation_individu.js" type="text/javascript" charset="utf-8"></script>
							<script src="/custom/include/javascript/jquery.inputmask.bundle.js" type="text/javascript"></script>
							<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
							<link href="/modules/OPS_agendas/css/agenda_modal_creation_rdv.css" rel="stylesheet" type="text/css" media="all" />';
        

			$modale_html .= '<div id="champ_agenda" class="champ_agenda">';
			$modale_html .= '<input type="hidden" id="date_fin" name="date_fin" />
							<input type="hidden" id="meeting_id" name="meeting_id" value="' . $id_meeting . '" />
							<input type="hidden" id="meeting_id_2" name="meeting_id_2" value="" />
							<input type="hidden" id="agenda_id" name="agenda_id" value="' . $obj_agenda->id . '" />
							<input type="hidden" id="current_user" name="current_user" value="' . $current_user->id . '" />
							<input type="hidden" id="assigned_user" name="assigned_user" value="' . $obj_agenda->assigned_user_id . '" />
							<input type="hidden" id="agenda_duree_tmp" name="agenda_duree_tmp" value="' . $obj_agenda->duree_rdv_temp . '" />';

        
			// Init Liste des Motifs
			$list_motifs = $obj_agenda->get_linked_beans('ops_agendas_motifs_ops_agendas', 'OPS_agendas_motifs', 'name');

			if (isset($list_motifs) && !empty($list_motifs)) {

				$motifs_html ="";
				$motif_id_defaut = $list_motifs[0]->id;
				foreach ($list_motifs as $motif) {

					$motifs_html .= "<option id='" . $motif->id . "' value='" . $motif->id . "'";
					if ($obj_agenda->motif_defaut == $motif->name) {
						$motifs_html .= "selected";
						$motif_id_defaut =$motif->id;

					}
					$motifs_html .= ">" . $motif->name . "</option>";
				}
				$motifs_html .= "<option id='' value='autre'>Autre</option>";

				$modale_html .= '<script>var motif_id_defaut = "' . $motif_id_defaut. '";</script>';
				

			} else {
				return null;
			}


			// Init Liste des lieux
			$lieux_html = "<option id='' value=''>Sélectionner un lieu</option>";
        
			$list_lieux = array();
			$list_plage_ouverture = $obj_agenda->get_linked_beans("ops_agendas_ops_plage_ouverture", "OPS_plage_ouverture");

			foreach ($list_plage_ouverture as $plage_ouverture) {

				$list_lieux_agenda = $plage_ouverture->get_linked_beans('ops_lieux_ops_plage_ouverture', 'OPS_lieux', 'name');
				if (!empty($list_lieux_agenda)) {
					$list_lieux = array_merge($list_lieux, $list_lieux_agenda);
				}
			}

			$list_lieux = array_values($obj_agenda->unique_multidim_array($list_lieux, 'id'));

			foreach ($list_lieux as $lieu) {
				$lieux_html .= "<option id='" . $lieu->id . "' value='" . $lieu->id . "'>" . $lieu->name . "</option>";
			}

			$lieux_html .= "<option id='' value='autre'>Autre</option>";
            

			// Variables de la modale
			$modale_html .= '<input type="hidden" id="date_start" name="date_start" />'; // Utiliser pour la gestion hors plage ouverture
			$modale_html .= '<input type="hidden" id="canal" name="canal" value="guichet" />
							<input type="hidden" id="usager" name="usager" value="" />
							<input type="hidden" id="id_individu_trouve_id" name="id_individu_trouve_id" value="" />
							<input type="hidden" id="civilite_stock" name="civilite_stock" value="" class="stock"/>
							<input type="hidden" id="last_name_stock" name="last_name_stock" value="" class="stock"/>
							<input type="hidden" id="first_name_stock" name="first_name_stock" value="" class="stock"/>
							<input type="hidden" id="date_naissance_stock" name="date_naissance_stock" value="" class="stock"/>
							<input type="hidden" id="email_stock" name="email_stock" value="" class="stock"/>
							<input type="hidden" id="tel_stock" name="tel_stock" value="" class="stock"/>
							<input type="hidden" id="action" name="action" value="" />
							<input type="hidden" id="lieu_agenda" name="lieu_agenda" value="' . $obj_agenda->lieu . '" />
							<input type="hidden" id="service" name="service" value="' . $obj_agenda->ops_service_id . '" />
							<input type="hidden" id="dossier_id" name="dossier_id" value="">';



			/// ONGLET DETAILS ///

			// BLOC Demandeur
			// Init liste des civilités
			$liste_dom = $app_list_strings['salutation_dom'];
			ksort($liste_dom);
			foreach ($liste_dom as $key => $value) {
				$civilite_html .= "<option id='" . $key . "' value='" . $key . "'>" . $value . "</option>";
			}

			// Init liste des types d'individu
			$liste_indiv_type = $app_list_strings['ops_type_individu_list'];
			ksort($liste_indiv_type);

			foreach ($liste_indiv_type as $key => $value) {
				$type_html .= "<option id='" . $key . "' value='" . $key . "'>" . $value . "</option>";
			}

			$obligatoire_ressource = "";
			$obligatoire_tel = "";
			$obligatoire_com = "";

			$champ_ressource = "";
			$champ_tel = "";

			if ($obj_agenda->ressource_obl == 1) {
				$champ_ressource = "class='obligatoire'";
				$obligatoire_ressource = " *";
			}

			if ($obj_agenda->tel_obl == 1) {
				$champ_tel = "class='obligatoire'";
				$obligatoire_tel = " *";
			}
			if ($obj_agenda->email_obl == 1) {
				$champ_emailobl = "class='obligatoire'";
				$obligatoire_email = " *";
			}
			if ($obj_agenda->date_naissance_obl == 1) {
				$champ_date = "class='obligatoire'";
				$obligatoire_date = " *";
			}

            
			// BLOC RENDEZ-VOUS
			// Init Liste des ressources
			$list_ressources = $obj_agenda->get_linked_beans('ops_agendas_ressources_ops_agendas', 'OPS_agendas_ressources');
			$ressource_html .= "<option value=''></option>";

			foreach ($list_ressources as $ressource) {
				$ressource_html .= "<option id='" . $ressource->id . "' value='" . $ressource->id . "'>" . $ressource->name . "</option>";
			}


			if (isset($list_ressources) && !empty($list_ressources)) {
				$ressource_bloc_html .= '<div class="col-xs-12 col-sm-12 row edit-view-row-item col-item-agenda">
											<div class="col-xs-12 col-sm-4 label crea_ressource" data-label="ressource">Ressource ' . $obligatoire_ressource . '</div>
											<div class="col-xs-12 col-sm-8 edit-view-field "><select name="crea_ressource" id="crea_ressource" ' . $champ_ressource . '>'. $ressource_html ."</select></div>
										</div>";
			}

			$dossier_front_bloc_html = '<div id="view_dossier_front" class="col-xs-12 col-sm-12 row edit-view-row-item col-item-agenda" style="display: none;">
											<div style="margin-top: 1em;">
												<p id="dossier_front_numero" class="col-xs-12 col-sm-4 label" style="margin-top: 1em;"></p>
												<div id="btns_view_dossier_front">
													<input id="btn_view_dossier_front" title="Voir" class="button" type="submit" name="methode" value="Voir" rel="" style="float: center;">
												</div>
											</div>
										</div>';


			// BLOC PARTICIPANTS
			$participant_bloc_html = "";
			if ($obj_agenda->afficher_participants == true){
				$participant_bloc_html = '<div class="row edit-view-row" style ="height: auto; border-radius: 8px 8px; border: solid 2px #dddddd; padding-bottom: 12px;">
            
					<h1 class="rdv_area" style="width: 35% !important;">Participants</h1>
            
					<div class="col-xs-12 col-sm-12 row edit-view-row-item col-item-agenda">
						<div class="col-xs-12 col-sm-4 label" data-label="usager_concerne">Participant</div>
						<div class="col-xs-12 col-sm-8 edit-view-field "><input type="text" id="usager_concerne" name="usager_concerne" readonly/></div>
					</div>

					<div class="col-xs-12 col-sm-12 row edit-view-row-item col-item-agenda">
						<div class="col-xs-12 col-sm-4 label" data-label="accompagnants">Accompagnants</div>
						<div class="col-xs-12 col-sm-8 edit-view-field ">
							<textarea id="accompagnants" name="accompagnants" style="margin:0px; width:90%;"></textarea>
						</div>
					</div>

				</div> ';
			}

			//BLOC SUITES DE RDV
			$dossier_back_bloc_html = '';

			if ($obj_agenda->ops_service_id != ""){

				$dossier_back_bloc_html = '<div id="dossier_back_btns" class="col-xs-12 col-sm-12 row edit-view-row-item col-item-agenda" style:"margin-bottom: 0;">
												<div id="view_dossier" style="display:none; margin-bottom: 0;">
													<p id="dossier_numero" class="col-xs-12 col-sm-4 label" style="margin-top: 1em;"></p>
													<input id="btn_view_dossier"  title="Voir"       class="button"  type="submit" name="methode" value="Voir" style="margin-bottom: 0 !important;" >
													<input id="btn_suppr_dossier" title="Supprimer"  class="button"  type="submit" name="methode" value="Supprimer" style="margin-bottom: 0 !important;">
												</div>
						
												<div id="create_dossier" style="display:none; margin-bottom: 0;">
													<input id="btn_create_dossier" class="button"  type="submit" name="methode" value="Suites" style="margin-bottom: 0 !important;">
												</div>
											</div>';
			}


			// BLOC CONTENU
			if ($obj_agenda->assign_obl == 1) {
				$champ_assign = "class='obligatoire'";
				$obligatoire_assign = " *";
			}

			if ($obj_agenda->commentaire_obl == 1) {
				$champ_commentaire = "class='obligatoire'";
				$obligatoire_com = " *";
			}

			// Init Liste statut de présence au rdv
			foreach ($app_list_strings['rdv_statut_presence_list'] as $key => $value) {
				$statut_presence_html .= "<option id='" . $key . "' value='" . $key . "'>" . $value . "</option>";
			}

			// Init Liste des Natures
			$nature_html = "<option id='' value=''></option>";

			if (!empty($obj_agenda->nature)) {

				$array_ligne = explode(",", str_replace("^", "", $obj_agenda->nature));
				foreach ($array_ligne as $key => $ligne) {

					$new_line = htmlspecialchars_decode(trim($ligne), ENT_QUOTES);

					if (strpos($new_line, ';') === false) {
						$list_nature[$new_line] = $new_line;
					} else {
						list($cle, $valeur) = explode(';', $new_line);
						$list_nature[$cle] = $valeur;
					}
				}

				foreach ($list_nature as $key => $value) {
					$nature_html .= "<option id='" . $value . "' value='" . $value . "'>" . $app_list_strings['rdv_nature_list'][$value] . "</option>";
				}
			}

			// Liste des Utilisateurs assignés
			$user_bloc_html = "";
			$list_users = $obj_agenda->get_linked_beans('ops_agendas_droits_ops_agendas', 'OPS_agendas_droits');


			if (isset($list_users) && !empty($list_users)) {
				$user_bloc_html .= '<div class="col-xs-12 col-sm-12 row edit-view-row-item col-item-agenda">
										<div class="col-xs-12 col-sm-4 label" data-label="utilisateur">Assigné à ' . $obligatoire_assign . '</div>
										<div class="col-xs-12 col-sm-8 edit-view-field ">
											<select name="user_id" id="user_id" ' . $champ_assign . '>
											<option value=""></option>';

				foreach ($list_users as $user) {
					$user_select = "";

					if (!empty($obj_agenda->assigned_user_id) && $obj_agenda->assigned_user_id == $user->users_id) {
						$user_select = "selected";
					}

					$user_bloc_html .= "<option id='" . $user->users_id . "' value='" . $user->users_id . "'";
					$user_bloc_html .= $user_select . " >" . $user->ops_agendas_droits_users_name . "</option>";
				}
				$user_bloc_html .= "        </select>
										</div>
									</div>";
			}

			// Init du tpl contenant la modale de creation de rdv
			$smarty = new Sugar_Smarty();
			$smarty->assign('lieux_html', $lieux_html);
			$smarty->assign('canal', $canal);
			$smarty->assign('type_html', $type_html);
			$smarty->assign('civilite_html', $civilite_html);
			$smarty->assign('obligatoire_date', $obligatoire_date);
			$smarty->assign('obligatoire_tel', $obligatoire_tel);
			$smarty->assign('obligatoire_email', $obligatoire_email);
			$smarty->assign('champ_date', $champ_date);
			$smarty->assign('champ_tel', $champ_tel);
			$smarty->assign('champ_emailobl', $champ_emailobl);
			$smarty->assign('lieu_agenda', $obj_agenda->lieu);
			$smarty->assign('motifs_html', $motifs_html);
			$smarty->assign('ressource_bloc_html', $ressource_bloc_html);
			$smarty->assign('dossier_front_bloc_html', $dossier_front_bloc_html);
			$smarty->assign('statut_presence_html', $statut_presence_html);
			$smarty->assign('nature_html', $nature_html);
			$smarty->assign('obligatoire_com', $obligatoire_com);
			$smarty->assign('champ_commentaire', $champ_commentaire);
			$smarty->assign('user_bloc_html', $user_bloc_html);
			$smarty->assign('participant_bloc_html', $participant_bloc_html);
			$smarty->assign('dossier_back_bloc_html', $dossier_back_bloc_html);
			$modale_html.=  $smarty->fetch('./modules/OPS_agendas/tpls/agenda_modale_rdv.tpl');

			// Init modales recherche & creation d'un individu
			$modale_html .= file_get_contents('./modules/OPS_agendas/tpls/agenda_modale_individu.tpl');

		}

		return $modale_html;
	}
}