/**
 * Gestion du Calendrier de visualisation des RDV
 */


// Permettre le non conflit avec la librairie standard SuiteCRM
var jquery = jQuery.noConflict();
var click_url_back = ""; // url du dossier lié au rdv
var click_url_front = ""; // url du dossier lié au rdv
var week = true;


if (affichage_week_end == "0") {
	week = false;
}

if (affichage_duration == "") {
	affichage_duration = '10';
}

if (affichage_min_time == "") {
	affichage_min_time = '00:00:00';
}

if (affichage_max_time == "") {
	affichage_max_time = '24:00:00';
}


if (affichage_gestion == "basicWeek") {
	affichage_gestion_visu = "agendaWeek";
} else {
	affichage_gestion_visu = affichage_gestion;
} 

jquery(document).ready(function () {

	jquery('#visua_agenda').select2({
		"language": {
			"noResults": function(){
				return "Aucun agenda trouvé";
			}
		}
	});

	var id_agenda = document.getElementById("visua_agenda");
	document.title = id_agenda.options[id_agenda.selectedIndex].text;


	// Choix d'agenda
	document.getElementById("visua_agenda").input = function () {
		document.getElementById("loading").innerText = "Veuillez patientez pendant le chargement";
		creation_url();
	}


	// Choix d'une ressource dans les filtres 
	document.getElementById("visua_ressource").onchange = function () {
		creation_url();
	}

	// Choix d'une ressource dans les filtres 
	document.getElementById("visua_motif").onchange = function () {
		creation_url();
	}

	// Choix d'un lieu dans les filtres 
	document.getElementById("visua_lieu").onchange = function () {
		creation_url();
	}

	if (document.getElementById('visua_motif').length == 1) {
		document.getElementsByClassName('visua_motif')[0].style = "display:none";
		document.getElementsByClassName('visua_motif')[1].style = "display:none";
		document.getElementById('calendar').style = "display:none";
		alert("Pas de motif déclaré pour cet agenda.");
		document.getElementById('loading').style = "display:none";
	}

	if (document.getElementById('visua_ressource').length == 1) {
		document.getElementsByClassName('visua_ressource')[0].style = "display:none";
		document.getElementsByClassName('visua_ressource')[1].style = "display:none";
	}

	if (document.getElementById('visua_lieu').length == 1) {
		document.getElementsByClassName('visua_lieu')[0].style = "display:none";
		document.getElementsByClassName('visua_lieu')[1].style = "display:none";
	}


	/// MAJ des variables CSS en fonction du theme courant
	if (document.getElementById('visua_motif') != null && document.getElementsByClassName('account-icon')[0]!= null){
		var primaryElement = document.getElementById('visua_motif');
		var secondaryElement = document.getElementsByClassName('account-icon')[0];

		var primaryColor = getComputedStyle(primaryElement).color;
		var secondaryColor = getComputedStyle(secondaryElement).color;
	

		document.documentElement.style.setProperty('--color_primary', primaryColor);
		document.documentElement.style.setProperty('--color_secondary', secondaryColor);
		document.documentElement.style.setProperty('--color_primary_active', secondaryColor);
	}

	document.getElementById('loading').innerText = "Veuillez sélectionner un agenda";
	

	if(document.getElementById("visua_agenda").value !== undefined ){
		
		/// Calendar visualisation
		jquery('#calendar').fullCalendar({
			locale: 'fr',
			defaultView: affichage_gestion_visu,
			slotDuration: '00:' + affichage_duration + ':00',
			slotLabelInterval: "01:00",
			slotLabelFormat: 'HH:mm',
			minTime: affichage_min_time,
			maxTime: affichage_max_time,
			height: 700,
			aspectRatio: 15,
			timezone: Intl.DateTimeFormat().resolvedOptions().timeZone,
			timeFormat: 'HH:mm',
			weekends: week, // Masquer des jours dans la semaine 

			// Gestion des plages hors ouverture => pas de création de rdv temporaire (inutile dans notre cas)
			selectable: gestion_hors_plage,

			// Création d'un bouton custom pour la création d'un rdv 
			customButtons: {
				createRDV: {
					text: 'Créer un RDV',
					click: function () {
						rdv_modif = false;

						if (document.getElementById('visua_agenda').value == "") {

							alert("Veuillez sélectionner un agenda afin de prendre un RDV");

						}  else if (document.getElementById('visua_motif') == null || document.getElementById('visua_motif').style.display == "none") {

							alert("Pas de motif déclaré sur cet agenda");

						} else if (gestion == false) {

							alert("Vous n'avez pas les droits pour accèder à cette fonctionnalité");

						} else {

								// Onglets
								document.getElementById('tr_table').innerHTML = "";
								document.getElementById("historic_link_id").innerHTML = "Historique(0)";
								document.getElementById("individu_creation_area").innerHTML = "Demandeur";
								document.getElementById('modale_creation').style.display = "block";
								$('input[name=action]').val('');


								// Cacher Hors Plage
								jquery("#crea_lieu option[value='autre']").hide();
								jquery('#crea_lieu_autre').hide();

								jquery("#crea_motif option[value='autre']").hide();
								jquery('#crea_motifautre').hide();


								// Suites du rdv
								if (document.getElementById('create_dossier') != null && document.getElementById('view_dossier') != null){
									document.getElementById("dossier_back_btns").style.display = "none";
									document.getElementById("create_dossier").style.display = "none";
									document.getElementById("view_dossier").style.display = "none";
								}

								if (document.getElementById("suites_rdv")!= null ){
									document.getElementById("suites_rdv").style.display = "none";
								}


								// Buttons
								document.getElementById('supprimer').style.display = "none";
								
								
								reset();

								// CSS Champs obligatoires
								var collection_champ_obl = document.getElementsByClassName('obligatoire');
								for (var i = collection_champ_obl.length - 1; i >= 0; i--) {
									collection_champ_obl[i].style = "border-color: #a5e8d6 !important; ";
								}


								if(window.innerWidth > 900){
									document.getElementById("btns_actions").style.marginTop = "-58px";
								} else{
									document.getElementById("btns_actions").style.marginTop = "20px";
								}
							
						}
					}
				},
				refresh: {
					text: 'Rafraîchir',
					click: function () {
						document.getElementById('calendrier').style.display = "block";
						jquery('#calendar').fullCalendar('refetchEvents');
					}
				}
			},

			// Personnaliser le nombre limite d'affichage de RDV 
			views: {
				basicWeek: {
					buttonText: "Jour/liste",
				},
				listMonth: {
					buttonText: "Liste Mois",
				},
				month: {
					buttonText: "Mois",
					eventLimit: 5,
				},
				agendaWeek: {
					buttonText: "Semaine",
					eventLimit: 6,
				},
				agendaDay: {
					buttonText: "Jour",
				},
				listDay: {
					buttonText: "Planning Jour",
				},
				listMonth: {
					buttonText: "Planning Mois",
				},
			},

			// Affichage des boutons au dessus du calendrier
			header: {
				left: 'prev,next,refresh,createRDV',
				center: 'title',
				right: 'month,agendaWeek,agendaDay,basicWeek',
			},

			buttonIcons: true, // Utilisation des icones prec/suiv
			weekNumbers: false,// Afficher les numéros de semaines
			navLinks: true,
			businessHours: false, // display business hours
			editable: false,
			eventLimit: true, // allow "more" link when too many events

			events: {
				url: '/index.php?entryPoint=agenda_visualisation&methode=visualisation',
				type: 'POST',
				data: {
					id_agenda: document.getElementById("visua_agenda").value,
					ressource: document.getElementById("visua_ressource").value,
					motif: document.getElementById("visua_motif").value,
					lieu: document.getElementById("visua_lieu").value
				}
			},


			loading: function (bool) {
				document.getElementById('loading').innerText = "Veuillez patienter pendant le chargement ...";
				jquery('#loading').toggle(bool);
			},


			// Event click Rdv hors plage
			select: function (startDate, endDate) {

				//Si modification d'un Hors Plage en cours
				if (!modification_hors_plage){
					reset();
				}

				
				// Dossier
				if (document.getElementById("suites_rdv")!= null && rdv_action!=="modification"){
					document.getElementById("suites_rdv").style.display = "none";
				} else{
					document.getElementById("suites_rdv").style.display = "block";
				}
				// Cacher champs Réservé
				document.getElementById('supprimer').style.display = "none";
				document.getElementById('loading').style.display = "none";
				document.getElementById('calendrier').style.display = "none";
				//document.getElementById("crea_motif").parentElement.parentElement.style.display = "none";
				jquery(".head_agenda_tab a[rel='calendar'].btn_agenda_tab").hide();

				// Afficher champs Hors Plage
				document.getElementById('crea_lieu').removeAttribute('readonly');
				var val_lieu = $('#crea_lieu').find(":selected").val();

				if (val_lieu === 'autre') {
					jquery('#crea_lieu_autre').show();
				} else {
					jquery('#crea_lieu_autre').hide();
				}
				
				jquery('#crea_lieu').change(function() {
					var val_lieu = $('#crea_lieu').find(":selected").val();
					if (val_lieu === 'autre') {
						jquery('#crea_lieu_autre').show();
					} else {
						jquery('#crea_lieu_autre').hide();
					}
				}); 
				
				jquery("#crea_lieu option[value='autre']").show();


				jquery('#crea_motif').change(function() {
					var val_motif = $('#crea_motif').find(":selected").val();
					if (val_motif === 'autre') {
						jquery('#crea_motif_autre').show();
					} else {
						jquery('#crea_motif_autre').hide();
					}
				}); 
				
				jquery("#crea_motif option[value='autre']").show();

				// CSS Champs obligatoires
				var collection_champ_obl = document.getElementsByClassName('obligatoire');
				for (var i = collection_champ_obl.length - 1; i >= 0; i--) {
					collection_champ_obl[i].style = "border-color: #a5e8d6 !important; ";
				}


				var formDateDeb = jquery.fullCalendar.formatDate(startDate, 'DD/MM/YYYY HH:mm');
				var formDateFin = jquery.fullCalendar.formatDate(endDate, 'HH:mm');

				type_rdv = "hors_plage";
				document.getElementById('modale_creation').style.display = "block";
				document.getElementById('date_debut').value = formDateDeb + ' à ' + formDateFin;
				document.getElementById('date_start').value = formDateDeb;
				document.getElementById('date_fin').value = jquery.fullCalendar.formatDate(endDate,'DD/MM/YYYY HH:mm');
				show_tab_agenda("details");


				if(window.innerWidth > 900){
					document.getElementById("btns_actions").style.marginTop = "-58px";
				} else{
					document.getElementById("btns_actions").style.marginTop = "20px";
				}

			},


			// Gestion vue
			eventRender: function (event, element, view) {

				let date = sessionStorage.getItem('goToDate');
				if (date != null && date !== "null"){
					
					var dateParts = date.split(" ");
					var datePart = dateParts[0].split("/");
					var timePart = dateParts[1].split(":");

					date = new Date(datePart[2], datePart[1] - 1, datePart[0], timePart[0], timePart[1]);

					jquery('#calendar').fullCalendar("gotoDate", date);
					jquery('#calendar').fullCalendar("changeView", "agendaWeek");
					sessionStorage.removeItem('goToDate')
				}

				element.find(".fc-title").html("<span class='event_" + event.presence + "'>" + event.title + "</span>");

				if (event.motif) {
					element.find('.fc-event-inner').append("<div class='desc'>" + event.motif + "</div>");
				}
			},


			// Modification du RDV 
			eventClick: function (calEvent, jsEvent, view) {

				if (gestion == 1 || gestion_hors_plage == 1) {

					rdv_modif = true;
					reset();

					/// INDIVIDU
					$('input[name=id_individu_trouve_id]').val(calEvent.id_individu);
					$('input[name=usager]').val(calEvent.usager);
					$('input[name=type_individu_recherche]').val(calEvent.type_individu);
					$('input[name=civilite_recherche]').val(calEvent.salutation);
					$('input[name=nom_usage_recherche]').val(calEvent.nom_usage);
					$('input[name=last_name_recherche]').val(calEvent.last_name);
					$('input[name=last_name_stock]').val(calEvent.last_name);
					$('input[name=first_name_recherche]').val(calEvent.first_name);
					$('input[name=first_name_stock]').val(calEvent.first_name);
					$('input[name=date_naissance_recherche]').val(calEvent.date_naissance);
					$('input[name=date_naissance_stock]').val(calEvent.date_naissance);

					$('input[name=tel]').val(calEvent.tel);
					$('input[name=email_recherche]').val(calEvent.email);

					$('input[name=adr-num]').val(calEvent.adr_num);
					$('input[name=adr-street]').val(calEvent.adr_street);
					$('input[name=adr-bat]').val(calEvent.adr_bat);
					$('input[name=adr-lieu]').val(calEvent.adr_lieu);
					$('input[name=commune]').val(calEvent.adr_comm);
					$('input[name=code-postal]').val(calEvent.adr_cp);

					document.getElementById("date_naissance_recherche").removeAttribute('readonly');
					document.getElementById("tel").setAttribute('readonly', true);
					document.getElementById("email_recherche").setAttribute('readonly', true);
					document.getElementById("adr-num").removeAttribute('readonly');
					document.getElementById("adr-bat").removeAttribute('readonly');
					document.getElementById("adr-street").removeAttribute('readonly');
					document.getElementById("adr-lieu").removeAttribute('readonly');
					document.getElementById("code-postal").removeAttribute('readonly');
					document.getElementById("commune").removeAttribute('readonly');


					if (!calEvent.notif_sms){
						document.getElementById("btn-notif-tel").classList.remove('fa-bell', 'fa-solid', 'btn-notif-activate');
						document.getElementById("btn-notif-tel").classList.add('fa-light', 'fa-bell-slash', 'btn-notif-disabled');
						document.getElementById("btn-notif-tel").setAttribute("data-notif", false);
					}

					if (!calEvent.notif_mail){
						document.getElementById("btn-notif-mail").classList.remove('fa-bell', 'fa-solid', 'btn-notif-activate');
						document.getElementById("btn-notif-mail").classList.add('fa-light', 'fa-bell-slash', 'btn-notif-disabled');
						document.getElementById("btn-notif-mail").setAttribute("data-notif", false);
					}
					
					


					// Récupération du select civilite
					var elmt = document.getElementById('civilite_recherche');
					for (let i = 0; i < elmt.options.length; i++) {
						if (elmt.options[i].value == calEvent.salutation) {
							elmt.selectedIndex = i;
						}
					}

			
					// Récupération du select type_individu
					var elmtType = document.getElementById('type_individu_recherche');
					for (let i = 0; i < elmtType.options.length; i++) {
						if (elmtType.options[i].value == calEvent.type_individu) {
							elmtType.selectedIndex = i;
						}
					}


					if (document.getElementById("btns_individu")!= null){

						document.getElementById("btns_individu").style.display = "none";
					}


					if (document.getElementById("vider") != null) {
						document.getElementById("vider").style.display = 'none';
					}
					document.getElementById("rechercher").style.display = "none";

					// TYPE RDV
					if (modification_hors_plage) {
						return;
					}
					type_rdv = calEvent.type_rdv;
					
					// Gestion perte type_rdv
					if	(type_rdv === ""){
						type_rdv="hors_plage";
					}


					// Rendez-Vous
					document.getElementById("nature").value = calEvent.nature;


					document.getElementById('tr_table').innerHTML = "";
					document.getElementById("historic_link_id").innerHTML = "Historique(0)";

		

					// Si Réservé, Cacher champs Hors Plage
					if (type_rdv == "Réservé" && gestion == 1) { 

						$('input[name=lieu]').val();
						$('#crea_lieu_autre_input').val();
						$("#crea_lieu_autre").hide();
						$("#crea_lieu option[value='autre']").hide();

						$('input[name=motif]').val();
						$('#crea_motif_autre_input').val();
						$("#crea_motif_autre").hide();
						$("#crea_motif option[value='autre']").hide(); 

					}

					affiche_modale_edit(calEvent);
					
					// Si Hors plage
					if (type_rdv == "hors_plage" && gestion_hors_plage == 1) { 
					

						// Afficher champs Hors Plage
						document.getElementById('crea_lieu').removeAttribute('readonly');
						document.getElementById('date_debut').value = calEvent.date_deb + ' à ' + calEvent.heure_fin;
						document.getElementById('date_start').value = calEvent.date_deb;
						document.getElementById('date_fin').value = calEvent.date_fin;
						document.getElementById("container_hors_plage").style.display = "block";
						document.getElementById("type_rdv").checked = true;

						// LIEU
						jquery("#crea_lieu_autre").show();
						jquery("#crea_lieu option[value='autre']").show();

						// Assignation
						var val_lieu = $('#crea_lieu').find(":selected").val();
						if(val_lieu === 'autre') {
							jquery('#crea_lieu_autre').show();
						} else {
							jquery('#crea_lieu_autre').hide();
						}

						// Event
						jquery('#crea_lieu').change(function() {
							var val_lieu = $('#crea_lieu').find(":selected").val();
							if(val_lieu === 'autre') {
								jquery('#crea_lieu_autre').show();
							} else {
								jquery('#crea_lieu_autre').hide();
							}
						});


						// MOTIF
						jquery("#crea_motif_autre").show();
						jquery("#crea_motif option[value='autre']").show();

						// Assignation
						var val_motif = $('#crea_motif').find(":selected").val();
						if(val_motif === 'autre') {
							jquery('#crea_motif_autre').show();
						} else {
							jquery('#crea_motif_autre').hide();
						}

						// Event
						jquery('#crea_motif').change(function() {
							var val_motif = $('#crea_motif').find(":selected").val();
							if(val_motif === 'autre') {
								jquery('#crea_motif_autre').show();
							} else {
								jquery('#crea_motif_autre').hide();
							}
						}); 

						$("#date_debut").closest('div').append($(
							'<input type="button" title="Modifier" class="button_update" id="modifier_rdv_hors_plage" value="✎" onclick="modifier_rdv_hors_plage()" style="padding:0 1rem;margin: 0 -10px 0 -25%; float: left; width:4rem!important;">'
						));

						// Cacher champs Réservé
						jquery(".head_agenda_tab a[rel='calendar'].btn_agenda_tab").hide();
						document.getElementById('loading').style.display = "none";
						document.getElementById('calendrier').style.display = "none";
					}

					document.getElementById("canal_rdv").value = calEvent.canal;
				
				}
			},


			// Entrée Survol
			eventMouseover: function (data, event, view) {
				var formDateDeb = jquery.fullCalendar.formatDate(data.start, 'DD/MM/YYYY à HH:mm');

				var motif = "";
				if (data.motif != "") {
					motif = "Motif" + ": " + data.motif + "<br>";
				}
				var user_name = $('#user_id').find('option[value="'+ data.user_id+'"]').text();

				// Préparation du contenu de la popup pour l'affichage du mois, de la semaine et du jour 
				var tooltip ='<div id="survolRDV" class="survolRDV" data-container="body" data-toggle="popover" data-placement="top">' +
							"Individu" + ": " + data.usager + "<br>" +
							"Lieu" + ": " + data.lieu + "<br>" +
							motif +
							"Date" + ": " + formDateDeb + "<br>" +
							"Commentaire" + ": " + data.description + "<br>" +
							"Créé par" + ": " + data.user_create_by +"<br>" +
							"Assigné à" + ": " + user_name + "<br>" +
						'</div>';

				jquery("body").append(tooltip);
				jquery(this).mouseover(function (e) {
					jquery(this).css('z-index', 10000);
					jquery('.survolRDV').fadeIn('500');
					jquery('.survolRDV').fadeTo('10', 1.9);
				}).mousemove(function (e) {
					jquery('.survolRDV').css('top', e.pageY - 80);
					jquery('.survolRDV').css('left', e.pageX + 20);
				});
			},


			// Retrait du Survol
			eventMouseout: function (data, event, view) {
				jquery(this).css('z-index', 8);
				jquery('.survolRDV').remove();
			}
		});


		if (gestion == 1) {
			document.getElementsByClassName("fc-createRDV-button")['0'].style = "display:block";
		} else {
			document.getElementsByClassName("fc-createRDV-button")['0'].style = "display:none";
		}

		// Assignation par défaut verrouillé
		if (assignation_modifiable == "0") {
			$("#user_id").attr("disabled", true);
		}

		
		affiche_suites_rdv();

		// Appel affichage dossier front
		if (view_dossier_front !== null){
			document.getElementById('btn_view_dossier_front').onclick = function () {
				window.open(click_url_front, '_blank');
			}
		}

	}

	function redirect(url) {
		window.open(url, '_blank');
		creation_url(); // Reload la page
	}

	
	function affiche_modale_edit(calEvent){

		rdv_action="modification";
		document.getElementById("individu_creation_area").innerHTML = "Demandeur";
		document.getElementById('supprimer').style.display = "block";

		if (document.getElementById('visua_agenda').value != null) {
						
			// RENDEZ-VOUS
			if (calEvent.lieu_id != "") {
				document.getElementById('crea_lieu').value = calEvent.lieu_id;
			} else if (calEvent.lieu.includes('Autre')) {
				var lieu_autre = calEvent.lieu.slice(calEvent.lieu.indexOf('-') + 1);
				document.getElementById('crea_lieu').value = 'autre';
				document.getElementById('crea_lieu_autre_input').value = lieu_autre.trim();
			}

			if (calEvent.nature != "" && document.getElementById(calEvent.nature)!= null) {
				document.getElementById(calEvent.nature).selected = "true";
			}

			document.getElementById('date_debut').value = calEvent.date_deb;
			document.getElementById('date_fin').value = calEvent.date_fin;


			if (calEvent.ressource_id != "") {
				document.getElementById(calEvent.ressource_id).selected = "true";
			}


			// CONTENU
			if (calEvent.motif_id != "autre") {
				document.getElementById('crea_motif').value = calEvent.motif_id;
			} else {
				var motif_autre = calEvent.motif.slice(calEvent.motif.indexOf('-') + 1);
				document.getElementById('crea_motif').value = 'autre';
				document.getElementById('crea_motif_autre_input').value = motif_autre.trim();
			}

			document.getElementById('commentaire').value = calEvent.description;

			if (document.getElementById("user_id") != null ){
				var selectUserElement = document.getElementById("user_id");
				for (var i = 0; i < selectUserElement.options.length; i++) {
					if (selectUserElement.options[i].value === calEvent.user_id) {
						selectUserElement.options[i].selected = true;
						break;
					}
				}
			}

			// PARTICIPANTS
			if (document.getElementById('accompagnants')!= null){
				document.getElementById('accompagnants').value = calEvent.accompagnant;
				document.getElementById('usager_concerne').value = calEvent.usager;
			}

			// Limitation des modifications des rdv passés
			var date_jour = moment().format('YYYY-MM-DD HH:mm');
			var eventDateDeb = jquery.fullCalendar.formatDate(calEvent.start,'YYYY-MM-DD HH:mm');

			if (date_jour > eventDateDeb) { 
				document.getElementById('calendrier').style = "display:none";
				jquery(".head_agenda_tab a[rel='calendar'].btn_agenda_tab").hide();
				show_tab_agenda('details');

				document.getElementById("usager").readOnly = true;
				document.getElementById("canal").disabled = true;

				if (document.getElementById("crea_ressource") != null) {
					document.getElementById("crea_ressource").disabled = true;
				}
				document.getElementById("crea_motif").disabled = true;

			} else {
				document.getElementById('calendrier').style = "display:block";
				jquery(".head_agenda_tab a[rel='calendar'].btn_agenda_tab").show();
				show_tab_agenda('details');
				document.getElementById("usager").readOnly = false;
				document.getElementById("canal").disabled = false;
				document.getElementById("canal").value= "guichet";
				document.getElementById("crea_motif").disabled = false;

				if (document.getElementById("crea_ressource") != null) {
					document.getElementById("crea_ressource").disabled = false;
				}
			}

			$("#civilite_recherche").css('pointer-events', 'none');


			// Input hidden
			document.getElementById('modale_creation').style.display = "block";
			document.getElementById('meeting_id').value = calEvent.id;



			get_historics_selected_indi();


			// SUITES DU RDV
			document.getElementById("suites_rdv").style.display = "block";
			if (calEvent.presence != "") {

				document.getElementById(calEvent.presence).selected = "true";
				document.getElementById("dossier_id").value = calEvent.parent_id;

				if (document.getElementById("dossier_numero")!= null){
					document.getElementById("dossier_numero").textContent  = "Dossier n° " + calEvent.num_dossier_back;
				}

				// Gestion du bouton création/voir dossier back
				if (calEvent.presence === "venu" && calEvent.parent_id != '' && document.getElementById("service").value != "") {

					click_url_back ="/index.php?module=OPS_dossier&action=DetailView&record=" + calEvent.parent_id;
					document.getElementById("dossier_back_btns").style.display = "block";
					document.getElementById("create_dossier").style.display = "none";
					document.getElementById("view_dossier").style.display = "block";

				} else if (calEvent.presence === "venu" && document.getElementById('service').value != "") {

					click_url_back="/index.php?module=OPS_dossier&action=EditView&record=";
					document.getElementById("dossier_back_btns").style.display = "block";
					document.getElementById("create_dossier").style.display = "block";
					document.getElementById("view_dossier").style.display = "none";

				}else{
					click_url_back="/index.php?module=OPS_dossier&action=EditView&record=";
				}
			} else{
				click_url_back="/index.php?module=OPS_dossier&action=EditView&record=";
			}
			
			
			// Gestion du bouton Voir dossier front
			if (calEvent.id_dossier_front != '' && calEvent.num_dossier_front != ''){

				click_url_front ="/index.php?module=OPS_dossier&action=DetailView&record=" + calEvent.id_dossier_front;
				document.getElementById("dossier_front_numero").innerHTML="Dossier n° " + calEvent.num_dossier_front;
				document.getElementById("view_dossier_front").style.display = "block";
				document.getElementById('btn_view_dossier_front').setAttribute('rel', calEvent.id_dossier_front);

			}

			// Gestion Rdv enregistre par
			document.getElementById("create_by_name").value = calEvent.user_create_by !=1 ? calEvent.user_create_by : "";
			document.getElementById("create_by_date").value = calEvent.user_create_date;
			document.getElementById("create_by_rdv").style.display = "block";

			jquery('#calendrier').fullCalendar('refetchEvents');
		}
	}


	/**
	 * 	Gestion affichage des boutons suites du rdv
	 */
	function affiche_suites_rdv(){

		if (document.getElementById("presence") != null){
			document.getElementById('presence').onchange = function () {


				if (document.getElementById("presence").value == "venu" && document.getElementById("service").value != ""){

					if (document.getElementById("view_dossier") != null  &&  document.getElementById("dossier_id").value !==''){
						document.getElementById("dossier_back_btns").style.display = "block";
						document.getElementById("view_dossier").style.display ="block";
						document.getElementById("create_dossier").style.display ="none";

					} else if(document.getElementById("create_dossier") != null ){
						document.getElementById("dossier_back_btns").style.display = "block";
						document.getElementById("view_dossier").style.display ="none";
						document.getElementById("create_dossier").style.display ="block";
					}
				} else if(document.getElementById("service").value != ""){
					document.getElementById("dossier_back_btns").style.display = "none";
					document.getElementById("view_dossier").style.display ="none";
					document.getElementById("create_dossier").style.display ="none";
				}
			}
		}

		// Appels gestion dossier back
		if (document.getElementById('view_dossier') != null){

			// Appel vue dossier
			document.getElementById('btn_view_dossier').onclick = function () {
				window.open(click_url_back, '_blank');
			}

			// Appel suppression d'un dossier
			document.getElementById('btn_suppr_dossier').onclick = function () {

				var confirm_suppr = confirm("Voulez-vous réellement supprimer ce dossier ?");
				if (confirm_suppr) {
					var params = "methode=dossier_suppr&meeting_id=" + document.getElementById('meeting_id').value + "&dossier_id=" + document.getElementById("dossier_id").value;
					mise_a_jour(params);
					window.location.reload();
				} 
			}
		}


		// Appel création dossier back
		if (document.getElementById('create_dossier') != null){
			document.getElementById('btn_create_dossier').onclick = function () {

				var params = "methode=dossier_crea&meeting_id=" + document.getElementById('meeting_id').value + "&service_id=" + document.getElementById('service').value;
				mise_a_jour(params);
				var result = resultat.replace(/ /gi, '');


				save_rdv();
				
				//console.log(`click_rul_back`,click_url_back)
				click_url_back += result;
				redirect(click_url_back);
			}
		}
	}


	function creation_url() {

		var url = window.location.origin + "/index.php?module=OPS_agendas&action=visualisation";
		var params = "";

		if (typeof document.getElementById("visua_agenda").value !== 'undefined' ) {
			params = "&record=" + document.getElementById("visua_agenda").value;
		}

		if (document.getElementById("visua_motif") != null) {
		params += "&motif=" + document.getElementById("visua_motif").value;
		}

		if (document.getElementById("visua_ressource") != null) {
		params += "&ressource=" + document.getElementById("visua_ressource").value;
		}

		if (document.getElementById("visua_lieu") != null) {
		params += "&lieu=" + document.getElementById("visua_lieu").value;
		}

		if ("" == params) {
		document.location.href = url;
		} else {
		document.location.href = url + params;
		}

	}

});