<?php
use BeanFactory;
if (!defined('sugarEntry') || !sugarEntry)
	die('Not A Valid Entry Point');

global $db, $beanFiles, $log, $current_user, $sugar_config;

require_once('include/entryPoint.php');
require_once($beanFiles["OPS_agendas"]);
require_once($beanFiles["User"]);
require_once($beanFiles["OPS_exception"]);
require_once($beanFiles["OPS_plage_ouverture"]);
require_once('include/TimeDate.php');
$current_user = new User();
$current_user->getSystemUser();


if (isset($current_user) && !empty($current_user->id) && isset($_POST['id_agenda']) && isset($_POST['annee']) && "import_JF" == $_GET['methode']) {// Importer Jours Féries

	function creer_exception_jf() {

		$id_agenda = $_POST['id_agenda'];
		$annee = $_POST['annee'];
		$resultat = false;

		if(!empty($annee)){

			// Récupération des jours fériés via l'api gouv
			$url = "https://calendrier.api.gouv.fr/jours-feries/metropole/{$annee}.json";
			$data = file_get_contents($url);
			$list_feries_api = json_decode($data, true);


			// Création de l'array contenant les jours fériés avec les dates vers le format d/m/Y
			$list_feries_formated = array();
			foreach ($list_feries_api as $key_date => $value_nom) {

				$date_formated = date('d/m/Y', strtotime($key_date));
				$list_feries_formated[$date_formated] = $value_nom;
			}


			// Récupération des plage d'ouvertures de l'agenda
			//$obj_agenda = new OPS_agendas();
			//$obj_agenda->retrieve($id_agenda);
			$obj_agenda= BeanFactory::getBean("OPS_agendas", $id_agenda);
			$list_plage_ouverture = $obj_agenda->get_linked_beans("ops_agendas_ops_plage_ouverture", "OPS_plage_ouverture");

			if (count($list_plage_ouverture) > 0) {


				foreach($list_feries_formated as $date_formated => $value){

					$timedate = new TimeDate();
					$date_obj = DateTime::createFromFormat('d/m/Y', $date_formated);
					$date_deb = $timedate->to_db($date_obj->format('d/m/Y') . " 00:00");
					$date_fin = $timedate->to_db($date_obj->format('d/m/Y') . " 23:59");

					// Préparation de la recherche d'exception sur le créneaux
					$where = " ops_exception.deleted = 0 AND date_exception_deb <= '" . $date_deb. "' AND date_exception_fin" . " >= '" . $date_fin . "'";
					$list_exceptions_agenda = $obj_agenda->get_linked_beans("ops_agendas_ops_exception", "OPS_exception", array(), 0, -1, 0, $where);

					// Si aucune exception n'existe pour cette date dans cet agenda, on la créée
					if (empty($list_exceptions_agenda)) {
						//$obj_exception = new OPS_exception();
						$obj_exception = BeanFactory::newBean("OPS_exception");
						$obj_exception->nb_disponible = 0;
						$obj_exception->nb_disponible_bo = 0;
						$obj_exception->date_exception_deb = $date_deb;
						$obj_exception->date_exception_fin = $date_fin;
						$obj_exception->name = $value . " " .$annee;

						$obj_exception->save();

						$obj_agenda->load_relationship('ops_agendas_ops_exception');
						$obj_agenda->ops_agendas_ops_exception->add($obj_exception);

					}
				}

				$resultat = true;
			}

			if($resultat == true){

				$reponse['0']['resultat'] = 'valide';
				$reponse['0']['reponse'] = 'creation_succes';

			} else {

				$reponse['0']['resultat'] = 'error';
				$reponse['0']['reponse'] = 'creation_fail';

			}

		} else {
			$reponse['0']['resultat'] = 'error';
			$reponse['0']['reponse'] = 'erreur_requete';
		}


		return $reponse;
	}

    

	$resultat_creation = creer_exception_jf();

	echo json_encode($resultat_creation);

}