<?PHP

/**
 * @author   : LANTEAS
 */
use ODE\Mailer\OdeEmail;
use ODE\Mailer\OdeMailer;
use BeanFactory;
use ODE\Sms\OdeSms;

class OPS_agendas extends Basic
{

	public $new_schema = true;
	public $module_dir = 'OPS_agendas';
	public $object_name = 'OPS_agendas';
	public $table_name = 'ops_agendas';
	public $importable = false;
	public $disable_row_level_security = true; // to ensure that modules created and deployed under CE will continue to function under team security if the instance is upgraded to PRO
	public $id;
	public $name;
	public $date_entered;
	public $date_modified;
	public $modified_user_id;
	public $modified_by_name;
	public $created_by;
	public $created_by_name;
	public $description;
	public $deleted;
	public $created_by_link;
	public $modified_user_link;
	public $assigned_user_id;
	public $assigned_user_name;
	public $assigned_user_link;
	public $nature;
	public $duree;
	public $recherche_date_debut;
	public $date_fin;
	public $espacement;

	/**
	 *   __construct
	 */
	public function __construct()
	{
		parent::__construct();
	}


	/**
	 * bean_implements
	 * @param mixed $interface
	 * @return bool
	 */
	public function bean_implements($interface)
	{
		switch ($interface) {
			case 'ACL':
				return true;
			default:
				return false;
		}
	}


	function verif_disponibilite_creneau($rdv_date_debut, $canal = "", $id_meeting, $id_meeting_2, $motif_id, $lieu_id)
	{

		global $beanFiles, $current_user;
		require_once($beanFiles["OPS_exception"]);
		require_once($beanFiles["OPS_plage_ouverture"]);
		require_once($beanFiles["OPS_agendas_motifs"]);
		require_once($beanFiles["User"]);
		require_once($beanFiles["Meeting"]);

		$tab_jours = array(
			'Mon' => 'lundi',
			'Tue' => 'mardi',
			'Wed' => 'mercredi',
			'Thu' => 'jeudi',
			'Fri' => 'vendredi',
			'Sat' => 'samedi',
			'Sun' => 'dimanche'
		);

		if (empty($current_user->id)) {
			$current_user = BeanFactory::getBean("Users", "1");
		}

		$timeZone = TimeDate::userTimezone($current_user);
		date_default_timezone_set($timzone_user);

		$obj_agenda = $this;
		$obj_motif = BeanFactory::getBean("OPS_agendas_motifs", $motif_id);
		$duree = $obj_motif->duree;


		if (!empty($rdv_date_debut)) {
			$format = $current_user->getPreference('datef') . " " . $current_user->getPreference('timef');

			if (substr($rdv_date_debut, 4, 1) == "-") {
				$dateTime = strtotime($rdv_date_debut . ':' . '00');
			} else {
				$jours = substr($rdv_date_debut, 0, 2);
				$mois = substr($rdv_date_debut, 3, 2);
				$annee = substr($rdv_date_debut, 6, 4);
				$heure = substr($rdv_date_debut, 11, 2);
				$minute = substr($rdv_date_debut, 14, 2);

				$dateTime = strtotime($annee . '-' . $mois . '-' . $jours . ' ' . $heure . ':' . $minute . ':' . '00');
			}

			$jour_date_rendez = date("D", $dateTime);
			$dateRendezVous = date("Y-m-d", $dateTime);

			// Récupération des plage ouvertures
			$list_plage_ouverture = $obj_agenda->get_linked_beans(
				"ops_agendas_ops_plage_ouverture",
				"OPS_plage_ouverture",
				'',
				0,
				-1,
				0,
				"ops_plage_ouverture.jours = '" . $tab_jours[$jour_date_rendez] . "'"
			);

			$nbDispos = 0;

			foreach ($list_plage_ouverture as $obj_plage_ouverture) {
				if ($obj_plage_ouverture->ops_lieux_id == $lieu_id) {
					if ($obj_plage_ouverture->a_partir_de <= date("H:i", $dateTime) && date("H:i", $dateTime) <= $obj_plage_ouverture->jusqu_a) {

						if ($canal == "gru") {

							$nbDispos = $nbDispos + $obj_plage_ouverture->nb_disponible_bo;
						} else {

							$nbDispos = $nbDispos + $obj_plage_ouverture->nb_disponible;
						}
					}
				}
			}

			// Récupération des jours exceptions
			$where_except = "ops_exception.date_exception_deb like '" . $dateRendezVous . "%'";
			$list_exceptions = $obj_agenda->get_linked_beans("ops_agendas_ops_exception", "OPS_exception", "", 0, -1, 0, $where_except);

			foreach ($list_exceptions as $obj_exception) {

				$date_deb = DateTime::createFromFormat($format, $obj_exception->date_exception_deb);
				$date_fin = DateTime::createFromFormat($format, $obj_exception->date_exception_fin);

				if ($date_deb->format('H:i:') <= date("H:i", $dateTime) && date("H:i", $dateTime) < $date_fin->format('H:i:')) {

					if ($canal == "gru") {

						$nbDispos = $nbDispos + $obj_plage_ouverture->nb_disponible_bo;
					} else {
						$nbDispos = $nbDispos + $obj_plage_ouverture->nb_disponible;
					}
				}
			}

			// Récupération des meetings liés à l'agenda
			$where .= " meetings.type_rdv = 'Réservé' AND (meetings.rdv_statut_presence !='excuse' OR meetings.rdv_statut_presence IS NULL)  AND meetings.date_start like '" . $dateRendezVous . "%' AND meetings.deleted=0 AND meetings.location_id = '" . $lieu_id . "'";
			$liste_meetings = $this->get_linked_beans('ops_agendas_meetings', 'Meetings', "", 0, -1, 0, $where);

			$date_RDV = date("Y-m-d\TH:i:s", $dateTime);
			$creneau_debut = substr($date_RDV, 11, 5);

			$date_fin = $dateTime + (60 * $duree);
			$date_fin = date("Y-m-d\TH:i:s", $date_fin);
			$creneau_fin = substr($date_fin, 11, 5);

			// Récupération du min motif afin de calculer le nombre de créneaux disponible sur le rendez-vous
			$list_motifs = $this->get_linked_beans('ops_agendas_motifs_ops_agendas', 'OPS_agendas_motifs', "", 0, -1, 0, "");

			foreach ($list_motifs as $key => $un_motif) {

				if (!isset($min_duree) || $un_motif->duree < $min_duree) {
					$min_duree = $un_motif->duree;
				}
			}

			// Calcul de la boucle pour connaitre tous les créneaux
			$boucle = $duree / $min_duree;
			$nb_creneau = $nbDispos;
			$nbDispoAfter = $nbDispos;

			// Boucle sur tous les créneaux possibles dans le rendez-vous
			for ($i = 0; $i < floor($boucle); $i++) {

				$nbDispos = $nb_creneau;

				// Gestion de la date pour ajouter le créneau suivant à vérifier
				$selectedTime = $creneau_debut . ":00";
				$creneau_fin_boucle = strtotime("+" . $min_duree . " minutes", strtotime($selectedTime));
				$creneau_fin = date('H:i', $creneau_fin_boucle);

				foreach ($liste_meetings as $key => $obj_meeting) {

					if (empty($lieu_id) || ($obj_meeting->location_id == $lieu_id)) {

						// Création de la date en fonction des préférences de l'utilisateur
						$date_start = $obj_meeting->date_start;
						$date_end = $obj_meeting->date_end;

						$format = $current_user->getPreference('datef') . " " . $current_user->getPreference('timef');
						$date_deb = DateTime::createFromFormat($format, $date_start);
						$date_fin = DateTime::createFromFormat($format, $date_end);

						if ($date_deb == null || $date_fin == null) {
							$date_deb = new DateTime($date_start, new DateTimeZone('UTC'));
							$date_deb->setTimezone(new DateTimeZone($timeZone));

							$date_fin = new DateTime($date_fin, new DateTimeZone($timeZone));
						}


						$tab_meetings['start'] = $date_deb->format('Y-m-d\TH:i:s');
						$tab_meetings['end'] = $date_fin->format('Y-m-d\TH:i:s');

						// Parsing des jours et heures pour faire les conditions
						$meeting_debut = substr($tab_meetings['start'], 11, 5);
						$meeting_fin = substr($tab_meetings['end'], 11, 5);

						//Gestion que l'heure du rdv égale l'heure du créneaux
						if ($creneau_debut == $meeting_debut) {
							$nbDispos = $nbDispos - 1;
						} elseif ($creneau_fin == $meeting_fin) {
							$nbDispos = $nbDispos - 1;
						} elseif ($creneau_debut < $meeting_debut && $meeting_fin < $creneau_fin) { // 8:00 < 8:10 - 8:20 < 8:30
							$nbDispos = $nbDispos - 1;
						} elseif ($creneau_debut > $meeting_debut && $meeting_fin < $creneau_fin && $creneau_debut < $meeting_fin) { // 8:10 > 8:00 - 8:20 < 8:30
							$nbDispos = $nbDispos - 1;
						} elseif ($creneau_debut > $meeting_debut && $meeting_fin > $creneau_fin) { // 8:10 > 8:00 - 8:30 > 8:20
							$nbDispos = $nbDispos - 1;
						} elseif ($creneau_debut < $meeting_debut && $meeting_fin > $creneau_fin && $meeting_debut < $creneau_fin) { // 8:00 < 8:10 - 8:30 > 8:20
							$nbDispos = $nbDispos - 1;
						}
					}
				}

				// Gestion de la date pour ajouter le créneau suivant à vérifier
				$selectedTime = $creneau_debut . ":00";
				$creneau_debut = strtotime("+" . $min_duree . " minutes", strtotime($selectedTime));
				$creneau_debut = date('H:i', $creneau_debut);

				if ($nbDispos < $nbDispoAfter) {

					$nbDispoAfter = $nbDispos;
				}
			}

			if ($nbDispoAfter >= 1) { // le créneau est toujours disponible
				return true;
			} else {

				if ($nbDispoAfter == 0) {

					// Vérification si le RDV courant est une modification dans ce cas pas de vérification du créneau disponible

					if (isset($id_meeting_2) && !empty($id_meeting_2)) {
						$ob_meeting = BeanFactory::getBean("Meetings", $id_meeting_2);
						$date_meeting = $ob_meeting->date_start;

						if ($date_meeting == $rdv_date_debut) {

							return true;
						}
					}

					if (isset($id_meeting) && !empty($id_meeting)) {
						$ob_meeting = BeanFactory::getBean("Meetings", $id_meeting);
						$date_meeting = $ob_meeting->date_start;

						if ($date_meeting == $rdv_date_debut) {

							return true;
						}
					}

					return "surbooking";

				}
				if ($nbDispoAfter == '-1') { // Cas ou les deux RDV (courant et tmp) sont sur le même créneau 


					//$GLOBALS['log']->fatal('$nbDispoAfter' . print_r($nbDispoAfter, true));
					// Vérification si le RDV courant est une modification dans ce cas pas de vérification du créneau disponible

					if (isset($id_meeting_2) && !empty($id_meeting_2)) {
						$ob_meeting = BeanFactory::getBean("Meetings", $id_meeting_2);
						$date_meeting = $ob_meeting->date_start;

						if ($date_meeting == $rdv_date_debut) {

							$date_2 = true;
						}
					}

					if (isset($id_meeting) && !empty($id_meeting)) {
						$ob_meeting = BeanFactory::getBean("Meetings", $id_meeting);
						$date_meeting = $ob_meeting->date_start;

						if ($date_meeting == $rdv_date_debut) {

							$date_1 = true;
						}
					}

					if ($date_1 == true && $date_2 == true) {
						return true;
					}

					return "surbooking";

				} else {
					// TRAITEMENT DU SURBOOKING
					return "surbooking";
				}

			}
		} else {

			return false;
		}
	}



	/**
	 * Récupération des créneaux disponibles pour la creation des rendez-vous
	 * @param mixed $recherche_date_deb (YYYY-mm-dd)
	 * @param mixed $date_fin (YYYY-mm-dd)
	 * @param string $motif_id
	 * @param string $canal (GRU/INTERNET)
	 * @param string $lieu_id
	 * @param string $meeting_id => Ecarter le rdv courant dans la recherche au cas ou d'un motif différent
	 * @return array|bool
	 */
	public function liste_creneaux_dispos($recherche_date_deb = "", $recherche_date_fin = "", $motif_id = "", $canal = "", $lieu_id = "", $meeting_id = "")
	{

		global $beanFiles, $current_user;
		require_once($beanFiles["OPS_agendas_ressources"]);
		require_once($beanFiles["OPS_agendas_motifs"]);
		require_once($beanFiles["User"]);
		require_once($beanFiles["OPS_exception"]);
		require_once($beanFiles["OPS_plage_ouverture"]);

		if (empty($current_user->id)) {
			$current_user = BeanFactory::getBean("Users", "1");
		}
		$timeZone = TimeDate::userTimezone($current_user);
		date_default_timezone_set($timeZone);

		// Gestion des dates de début et fin
		if (empty($this->date_debut) && $this->souhait_glissement_debut == 1) {
			$agenda_date_debut = new DateTime();
			$agenda_date_debut->setTimezone(new DateTimeZone($timeZone));
			$agenda_date_debut = date_add($agenda_date_debut, date_interval_create_from_date_string($this->jours_glissement_debut . ' days'));
			$agenda_date_debut = $agenda_date_debut->format('Y-m-d');
		} else {
			$agenda_date_debut = DateTime::createFromFormat($current_user->getPreference('datef'), $this->date_debut);
			$agenda_date_debut = $agenda_date_debut->format('Y-m-d');
		}

		if (empty($this->date_fin) && $this->souhait_glissement_fin == 1) {
			$agenda_date_fin = new DateTime();
			$agenda_date_fin->setTimezone(new DateTimeZone($timeZone));
			$agenda_date_fin = date_add($agenda_date_fin, date_interval_create_from_date_string($this->jours_glissement_fin . ' days'));
			$agenda_date_fin = $agenda_date_fin->format('Y-m-d');
		} else {
			$agenda_date_fin = DateTime::createFromFormat($current_user->getPreference('datef'), $this->date_fin);
			$agenda_date_fin = $agenda_date_fin->format('Y-m-d');
		}

		$recherche_date_deb_timestamp = $this->convert_date_timestamp($recherche_date_deb);
		$recherche_date_fin_timestamp = $this->convert_date_timestamp($recherche_date_fin);
		$agenda_date_debut_timestamp = $this->convert_date_timestamp($agenda_date_debut);
		$agenda_date_fin_timestamp = $this->convert_date_timestamp($agenda_date_fin);


		// Vérification des dates de début et de fin de recherche en fonction du paramétrage de l'agenda 
		if (empty($recherche_date_deb_timestamp) && empty($recherche_date_fin_timestamp)) {

			$recherche_date_deb = $agenda_date_debut;
			$recherche_date_fin = $agenda_date_fin;

		} else {

			if ($recherche_date_fin_timestamp > $agenda_date_fin_timestamp) {
				$recherche_date_fin = $agenda_date_fin;
				$recherche_date_fin_timestamp = $agenda_date_fin_timestamp;
			}

			if ($recherche_date_deb_timestamp < $agenda_date_debut_timestamp) {
				$recherche_date_deb = $agenda_date_debut;
				$recherche_date_deb_timestamp = $agenda_date_debut_timestamp;
			}

			// la date de fin de l'agenda est inférieur à la date de début rechercher => On arrête la 
			if ($recherche_date_fin_timestamp < $recherche_date_deb_timestamp) {
				return array();
			}

		}

		// Récupération du motif pour connaitre la durée des créneaux
		$obj_motifs = BeanFactory::getBean("OPS_agendas_motifs", $motif_id);
		$duree = $obj_motifs->duree;

		// Récupération du min motif afin de calculer correctement la disponibilité du créneau
		$list_motifs = $this->get_linked_beans('ops_agendas_motifs_ops_agendas', 'OPS_agendas_motifs');

		foreach ($list_motifs as $key => $un_motif) {
			if (!isset($min_duree) || $un_motif->duree < $min_duree) {
				$min_duree = $un_motif->duree;
			}
		}

		// Calcul de la boucle pour connaitre tous les créneaux possibles
		$boucle = $duree / $min_duree;

		// Récupération des plages ouvertures 
		$obj_plage_ouverture = new OPS_plage_ouverture();
		$obj_plage_ouverture = $obj_plage_ouverture->liste_plage_ouverture($this->id, $recherche_date_deb, $recherche_date_fin, $duree, $canal, $lieu_id);


		if ($obj_plage_ouverture != []) {

			$tab_creneaux = array();

			// Récupération des meetings plannifiés liés à l'agenda sans prendre en compte le rdv courant et les rdv excusés
			$where = " meetings.type_rdv = 'Réservé' AND (meetings.rdv_statut_presence !='excuse' OR meetings.rdv_statut_presence IS NULL) AND meetings.id != '" . $meeting_id . "'";

			if (!empty($recherche_date_deb) && !empty($recherche_date_fin)) {
				$where .= " and date_start BETWEEN '" . $recherche_date_deb . " 00:00:00' AND '" . $recherche_date_fin . " 23:59:59'";
			} elseif (!empty($recherche_date_deb)) {
				$where .= " and meetings.date_start > '" . $recherche_date_deb . "'";
			} elseif (!empty($recherche_date_fin)) {
				$where .= " and meetings.date_end > '" . $recherche_date_fin . " 23:59:59'";
			}

			$this->load_relationship('ops_agendas_meetings');


			// On récupère l'ensemble des RDV ///  y compris les hors plages? 
			$liste_meetings = $this->get_linked_beans('ops_agendas_meetings', 'Meetings', "", 0, -1, 0, $where);

			foreach ($obj_plage_ouverture as $key => $creneau) {

				$nb_creneau = $creneau['title'];
				$nbDispoAfter = $creneau['title'];
				$creneau_jour = substr($creneau['start'], 0, 10);
				$creneau_debut = substr($creneau['start'], 11, 5);

				$nbDispoAfter = $this->check_nb_Dispos($boucle, $nb_creneau, $min_duree, $liste_meetings, $creneau_debut, $creneau_jour, $nbDispoAfter, $creneau['lieu_id']);

				if ($nbDispoAfter > 0) {

					if ($canal == "internet") {
						$creneau['title'] = $nbDispoAfter; // Display none dans le css
					} else {
						$creneau['title'] = $nbDispoAfter;
					}
					$tab_creneaux[] = $creneau;
				}
			}

			// Vérification d'un rdv hors plage lors des creneaux
			$tab_creneaux = $this->check_rdv_hors_plage($tab_creneaux);
			//$GLOBALS['log']->fatal('tab_creneaux:::'.print_r($tab_creneaux, true));
			return $tab_creneaux;
		} else {
			return false;
		}
	}



	/**
	 * Calcul du nombre de creneaux disponibles
	 * @param float $boucle
	 * @param int $nb_creneau
	 * @param int $min_duree
	 * @param array $liste_meetings
	 * @param string $creneau_debut
	 * @param string $creneau_jour
	 * @param int $nbDispoAfter
	 */
	public function check_nb_Dispos($boucle, $nb_creneau, $min_duree, $liste_meetings, $creneau_debut, $creneau_jour, $nbDispoAfter, $lieu_id = '')
	{
		global $beanFiles, $current_user;

		if (empty($current_user->id)) {
			$current_user = BeanFactory::getBean("Users", '1');
		}

		for ($i = 0; $i < floor($boucle); $i++) {
			$dispo = $nb_creneau;

			// Gestion de la date pour ajouter le créneau suivant à vérifier
			$selectedTime = $creneau_debut . ":00";
			$creneau_fin_boucle = strtotime("+" . $min_duree . " minutes", strtotime($selectedTime));
			$creneau_fin = date('H:i', $creneau_fin_boucle);

			foreach ($liste_meetings as $key => $obj_meeting) {

				if (empty($lieu_id) || ($obj_meeting->location_id == $lieu_id)) {

					// Création de la date en fonction des préférences de l'utilisateur
					$date_start = $obj_meeting->date_start;
					$date_end = $obj_meeting->date_end;
					$format = $current_user->getPreference('datef') . " " . $current_user->getPreference('timef');
					$recherche_date_deb = DateTime::createFromFormat($format, $date_start);
					$date_fin = DateTime::createFromFormat($format, $date_end);

					$tab_meetings['start'] = $recherche_date_deb->format('Y-m-d\TH:i:s');
					$tab_meetings['end'] = $date_fin->format('Y-m-d\TH:i:s');

					// Parsing des jours et heures pour faire les conditions
					$meeting_jour = substr($tab_meetings['start'], 0, 10);
					$meeting_debut = substr($tab_meetings['start'], 11, 5);
					$meeting_fin = substr($tab_meetings['end'], 11, 5);

					// Vérification que la date du créneaux soit bien la date du rdv
					if ($creneau_jour == $meeting_jour || $creneau_jour == null) {

						// Gestion que l'heure du rdv égale l'heure du créneaux
						if ($creneau_debut == $meeting_debut) {
							$GLOBALS['log']->debug($creneau_debut . " == " . $meeting_debut);
							$dispo = $dispo - 1;
						} elseif ($creneau_fin == $meeting_fin) {
							$GLOBALS['log']->debug($meeting_fin . " == " . $creneau_fin);
							$dispo = $dispo - 1;
						} elseif ($creneau_debut < $meeting_debut && $meeting_fin < $creneau_fin) { // 8:00 < 8:10 - 8:20 < 8:30
							$GLOBALS['log']->debug($creneau_debut . " < " . $meeting_debut . " && " . $meeting_fin . " < " . $creneau_fin);
							$dispo = $dispo - 1;
						} elseif ($creneau_debut > $meeting_debut && $meeting_fin < $creneau_fin && $creneau_debut < $meeting_fin) { // 8:10 > 8:00 - 8:20 < 8:30
							$GLOBALS['log']->debug($creneau_debut . " > " . $meeting_debut . " && " . $meeting_fin . " < " . $creneau_fin);
							$dispo = $dispo - 1;
						} elseif ($creneau_debut > $meeting_debut && $meeting_fin > $creneau_fin) { // 8:10 > 8:00 - 8:30 > 8:20
							$GLOBALS['log']->debug($creneau_debut . " > " . $meeting_debut . " && " . $meeting_fin . " > " . $creneau_fin);
							$dispo = $dispo - 1;
						} elseif ($creneau_debut < $meeting_debut && $meeting_fin > $creneau_fin && $meeting_debut < $creneau_fin) { // 8:00 < 8:10 - 8:30 > 8:20
							$GLOBALS['log']->debug($creneau_debut . " < " . $meeting_debut . " && " . $meeting_fin . " > " . $creneau_fin);
							$dispo = $dispo - 1;
						}
					}
				}
			}
			// Gestion de la date pour ajouter le créneau suivant à vérifier
			$selectedTime = $creneau_debut . ":00";
			$creneau_debut = strtotime("+" . $min_duree . " minutes", strtotime($selectedTime));
			$creneau_debut = date('H:i', $creneau_debut);

			if ($dispo < $nbDispoAfter) {

				$nbDispoAfter = $dispo;
			}
		}

		return $nbDispoAfter;
	}

	/**
	 * Vérification de la présence de rdv hors plage lors des creneaux disponibles
	 * Ajoute un attribut hors_plage avec une valeur de type bool: true si un rdv hors plage est présent
	 * @param array $tab_creneau
	 * @return array
	 */
	public function check_rdv_hors_plage($tab_creneaux)
	{

		global $beanFiles, $current_user;

		// Initialisation du format de date et de sa timezone
		if (empty($current_user->id)) {
			$current_user = BeanFactory::getBean("Users", "1");
		}

		$timeZone = TimeDate::userTimezone($current_user);
		date_default_timezone_set($timeZone);

		foreach ($tab_creneaux as $keys => $creneau) {


			$creneau_start = new DateTime($creneau['start'], new DateTimeZone($timeZone));
			$creneau_start = $creneau_start->format('d/m/Y H:i');
		
			$creneau_end = new DateTime($creneau['end'], new DateTimeZone($timeZone));
			$creneau_end = $creneau_end->format('d/m/Y H:i');

	
			// Récupération des rdv hors plages existants entre la date de début et de fin du creneau pour le lieu donné
			$where = " meetings.location_id = '".$creneau['lieu_id']."' AND meetings.type_rdv = 'hors_plage' ";

			
			$this->load_relationship('ops_agendas_meetings');
			$lst_meetings = $this->get_linked_beans('ops_agendas_meetings', 'Meetings', "date_start", 0, -1, 0, $where);

			$tab_creneaux[$keys]['hors_plage'] = 0;
			foreach($lst_meetings as $key => $meet){

				// Gestion que l'heure du rdv égale l'heure du créneaux
				if ($creneau_start == $meet->date_start) {
					$GLOBALS['log']->debug($creneau_start . " == " .$meet->date_start);
					$tab_creneaux[$keys]['hors_plage'] = 1;
					break;

				} elseif ($creneau_end == $meet->date_end) {
					$GLOBALS['log']->debug($meet->date_end . " == " . $creneau_end);
					$tab_creneaux[$keys]['hors_plage'] = 1;
					break;

				} elseif ($creneau_start < $meet->date_start &&$meet->date_end < $creneau_end) { // 8:00 < 8:10 - 8:20 < 8:30
					$GLOBALS['log']->debug($creneau_start . " < " . $meet->date_start . " && " .$meet->date_end. " < " . $creneau_end);
					$tab_creneaux[$keys]['hors_plage'] = 1;
					break;

				} elseif ($creneau_start >$meet->date_start && $meet->date_end < $creneau_end && $creneau_start < $meet->date_end) { // 8:10 > 8:00 - 8:20 < 8:30
					$GLOBALS['log']->debug($creneau_start . " > " .$meet->date_start. "creneau_end && " . $meet->date_end . " < " . $creneau_end);
					$tab_creneaux[$keys]['hors_plage'] = 1;
					break;

				} elseif ($creneau_start > $meet->date_start && $meet->date_end > $creneau_end) { // 8:10 > 8:00 - 8:30 > 8:20
					$GLOBALS['log']->debug($creneau_start . " > " . $meet->date_start . " && " . $meet->date_end . " > " . $creneau_end);
					$tab_creneaux[$keys]['hors_plage'] = 1;
					break;
				} elseif ($creneau_start < $meet->date_start && $meet->date_end > $creneau_end && $meet->date_start < $creneau_end) { // 8:00 < 8:10 - 8:30 > 8:20
					$GLOBALS['log']->debug($creneau_start . " < " . $meet->date_start . " && " . $meet->date_end . " > " . $creneau_end);
					$tab_creneaux[$keys]['hors_plage'] = 1;
					break;
				}
			}


			//$GLOBALS['log']->fatal('tabcreneau endend::'.print_r($tab_creneaux[$keys], true));
			//$GLOBALS['log']->fatal('');
		}

		return $tab_creneaux;
	}


	/**
	 * Récupération des rendez-vous existants pour visualisation
	 * @param mixed $recherche_date_deb
	 * @param mixed $date_fin
	 * @param mixed $ressource_id
	 * @param mixed $motif_id
	 * @param mixed $lieu_id
	 * @return array|int
	 */
	public function liste_rendez_vous($recherche_date_deb = "", $date_fin = "", $ressource_id = "", $motif_id = "", $lieu_id = "")
	{
		global $beanFiles, $current_user;
		require_once($beanFiles["OPS_agendas_ressources"]);
		require_once($beanFiles["OPS_agendas_motifs"]);
		require_once($beanFiles["User"]);
		require_once($beanFiles["OPS_agendas"]);
		require_once($beanFiles["OPS_individu"]);

		$where = " meetings.name != 'RDV_TEMP' ";

		// Gestion des paramétres d'entrées date_deb & date_fin :
		if (!empty($recherche_date_deb) && !empty($date_fin)) {
			$where .= "and date_start BETWEEN '" . $recherche_date_deb . " 00:00:00' AND '" . $date_fin . " 23:59:59'";
		} elseif (!empty($recherche_date_deb)) {
			$where .= "and meetings.date_start > '" . $recherche_date_deb . "'";
		} elseif (!empty($date_fin)) {
			$where .= "and meetings.date_end > '" . $date_fin . " 23:59:59'";
		} else {
			$where = "";
		}

		// On vérifie si on a un filtrage sur les lieux
		if (!empty($lieu_id)) {
			$where .= " and meetings.location_id = '" . $lieu_id . "'";
		}

		// Récupération des meetings liés à l'agenda sans les RDV temporaires
		$liste_meetings = $this->get_linked_beans('ops_agendas_meetings', 'Meeting', array(), 0, -1, 0, $where);

		if (count($liste_meetings) > 0) {
			foreach ($liste_meetings as $key => $obj_meeting) {

				$meeting_ok = true; // permet de savoir si on inclut le meeting dans le tab de retour en fonction des filtres d'entrées
				$user_id = "";

				// Traitement du filtre ressource
				if (!empty($ressource_id)) {
					$obj_ressource = BeanFactory::getBean("OPS_agendas_ressources", $ressource_id);
					$liste_meetings_ressource = $obj_ressource->get_linked_beans('ops_agendas_ressources_meetings', 'Meetings', '', 0, -1, 0, 'meetings.id="' . $obj_meeting->id . '"');

					// J'ai un filtre ressource mais le meeting n'est pas lié à la ressource selectionné
					if (count($liste_meetings_ressource) == 0) {
						$meeting_ok = false;
					} else {
						$meeting_ok = true;
					}
				}

				// Traitement du filtre motif
				if (!empty($motif_id) && true === $meeting_ok) {
					$obj_motif = BeanFactory::getBean("OPS_agendas_motifs", $motif_id);
					$liste_meetings_motifs = $obj_motif->get_linked_beans('ops_agendas_motifs_meetings', 'Meetings', '', 0, -1, 0, 'meetings.id="' . $obj_meeting->id . '"');

					if (count($liste_meetings_motifs) == 0) {
						$meeting_ok = false;
					} else {
						$meeting_ok = true;
					}
				}

				// Traitement du filtre lieu
				if (!empty($lieu_id) && true === $meeting_ok) {

					// Récupération des meetings liés au lieu
					$bean_meeting = BeanFactory::newBean('Meetings');
					$list_meetings = $bean_meeting->get_full_list('name', 'meetings.location_id = "' . $lieu_id . '"');

					if (count($list_meetings) == 0) {
						$meeting_ok = false;
					} else {
						$meeting_ok = true;
					}
				}

				if (true === $meeting_ok) {

					// Motif
					$liste_motif = $obj_meeting->get_linked_beans('ops_agendas_motifs_meetings', 'OPS_agendas_motifs', '', 0, -1, 0, '');
					if (isset($liste_motif[0]) && !empty($liste_motif[0]->name)) {
						$tab_meetings['motif'] = $liste_motif[0]->name;
						$tab_meetings['motif_id'] = $liste_motif[0]->id;
					} else {
						$tab_meetings['motif_id'] = 'autre';
						$tab_meetings['motif'] = html_entity_decode($obj_meeting->motif_autre);
					}

					// Ressource
					$liste_ressource = $obj_meeting->get_linked_beans('ops_agendas_ressources_meetings', 'OPS_agendas_ressources', '', 0, -1, 0, '');
					if (isset($liste_ressource[0]) && !empty($liste_ressource[0]->name)) {
						$tab_meetings['ressource_id'] = $liste_ressource[0]->id;
						$tab_meetings['ressource'] = $liste_ressource[0]->name;
					} else {
						$tab_meetings['ressource_id'] = "";
						$tab_meetings['ressource'] = "";
					}

					// Couleur par defaut
					if($obj_meeting->type_rdv == "hors_plage"){
						$tab_meetings['color'] = "rgb(253, 130, 86)";
					} else if ("ops_agendas_motifs" == $this->couleur_defaut) {
						$tab_meetings['color'] = "#" . $liste_motif[0]->couleur;
					} elseif ("ops_agendas_ressources" == $this->couleur_defaut) {
						$tab_meetings['color'] = "#" . $liste_ressource[0]->couleur;
					} elseif ("ops_agendas_lieux" == $this->couleur_defaut) {
						$obj_lieu = BeanFactory::getBean('OPS_lieux', $obj_meeting->location_id);
						$tab_meetings['color'] = "#" . $obj_lieu->couleur;
					}

					// Statuts
					if ($obj_meeting->status == 'en_attente') {
						$tab_meetings['borderColor'] = "#FF4747";
					}

					if (empty($obj_meeting->rdv_statut_presence)) {
						$asterix_presence = "*";
					} else {
						$asterix_presence = '';
					}

					// RDV
					$tab_meetings['id'] = $obj_meeting->id;
					$tab_meetings['title'] = html_entity_decode($obj_meeting->name, ENT_QUOTES, "UTF-8") . ' ' . $asterix_presence;
					$tab_meetings['usager'] = html_entity_decode($obj_meeting->name, ENT_QUOTES, "UTF-8");
					$tab_meetings['canal'] = $obj_meeting->provenance_rdv;
					$tab_meetings['type_rdv'] = $obj_meeting->type_rdv;
					$tab_meetings['presence'] = $obj_meeting->rdv_statut_presence;

					$tab_meetings['nature'] = $obj_meeting->nature;
					$tab_meetings['description'] = html_entity_decode($obj_meeting->description, ENT_QUOTES, "UTF-8");


					// Dossier BACK
					$obj_dossier_back = BeanFactory::getBean("OPS_dossier", $obj_meeting->parent_id);

					if (isset($obj_dossier_back) && !empty($obj_dossier_back->id)) {
						$tab_meetings['parent_id'] = $obj_meeting->parent_id;
						$tab_meetings['num_dossier_back'] = $obj_dossier_back->num_dossier;
					} else {
						$tab_meetings['parent_id'] = "";
						$tab_meetings['num_dossier_back'] = "";
					}

					// Dossier FRONT
					$tab_meetings['id_dossier_front'] = "";
					$tab_meetings['num_dossier_front'] = "";

					if ($obj_meeting->provenance_rdv === 'internet') {

						$obj_dossier_front = $obj_meeting->get_linked_beans("meetings_ops_dossier", "OPS_dossier");
						$obj_dossier_front = isset($obj_dossier_front[0]) ? $obj_dossier_front[0] : "";

						if (isset($obj_dossier_front) && !empty($obj_dossier_front->id)) {
							$tab_meetings['id_dossier_front'] = $obj_dossier_front->id;
							$tab_meetings['num_dossier_front'] = $obj_dossier_front->num_dossier;
						}
					}


					//Individu
					// Bug :: id individu devenu null dans meetings
					if ($obj_meeting->ops_individu_id != null) {
						$id_individu = $obj_meeting->ops_individu_id;
					} elseif ($obj_meeting->fetched_row['ops_individu_id'] != null) {
						$id_individu = $obj_meeting->fetched_row['ops_individu_id'];
					}

					if (!empty($id_individu)) {
						$obj_individu = BeanFactory::getBean("OPS_individu", $id_individu);
					}

					$tab_meetings['id_individu'] = $obj_individu->id;
					$tab_meetings['type_individu'] = $obj_individu->type_individu;
					$tab_meetings['salutation'] = $obj_individu->salutation;
					$tab_meetings['first_name'] = html_entity_decode($obj_individu->first_name);
					$tab_meetings['nom_usage'] = html_entity_decode($obj_individu->nom_usage);
					$tab_meetings['last_name'] = html_entity_decode($obj_individu->last_name);
					$tab_meetings['date_naissance'] = $obj_individu->date_naissance;

					$tab_meetings['email'] = $obj_individu->email1;
					$tab_meetings['notif_mail'] = boolval($obj_meeting->notif_mail);
					$tab_meetings['tel'] = $obj_individu->phone_mobile;
					$tab_meetings['notif_sms'] = boolval($obj_meeting->notif_sms);

					$tab_meetings['adr_num'] = $obj_individu->primary_address_number;
					$tab_meetings['adr_street'] = html_entity_decode($obj_individu->primary_address_street);
					$tab_meetings['adr_bat'] = html_entity_decode($obj_individu->primary_address_complement_batiment);
					$tab_meetings['adr_lieu'] = html_entity_decode($obj_individu->primary_address_complement_lieu);
					$tab_meetings['adr_comm'] = $obj_individu->primary_address_city;
					$tab_meetings['adr_cp'] = $obj_individu->primary_address_postalcode;


					$tab_meetings['accompagnant'] = html_entity_decode($obj_meeting->accompagnant);


					// Lieu
					$tab_meetings['lieu'] = html_entity_decode($obj_meeting->location, ENT_QUOTES, "UTF-8");
					$tab_meetings['lieu_id'] = html_entity_decode($obj_meeting->location_id, ENT_QUOTES, "UTF-8");

					// Agent assigné
					if ($obj_meeting->assigned_user_id != 1 && $obj_meeting->assigned_user_id != "") {
						$user_id = $obj_meeting->assigned_user_id;
					}
					$tab_meetings['user_id'] = $user_id;

					// Createur
					$obj_user_creator = "";
					if ($obj_meeting->provenance_rdv == "guichet") {
						$obj_user_creator = BeanFactory::getBean("Users", $obj_meeting->created_by)->name;
						$obj_user_creator = $obj_user_creator !== "Administrator" ? $obj_user_creator : "Administrateur";
					} else {
						$obj_user_creator = $obj_individu->salutation . " " . html_entity_decode($obj_individu->last_name);
					}

					if (empty($current_user->id)) {
						$current_user = BeanFactory::getBean("Users", '1');
					}
					$format = $current_user->getPreference('datef') . " " . $current_user->getPreference('timef');


					$user_create_date = DateTime::createFromFormat($format, $obj_meeting->date_entered);
					$user_create_date = "Le " . $user_create_date->format("d/m/Y à H:i");

					$tab_meetings['user_create_by'] = $obj_user_creator;
					$tab_meetings['user_create_date'] = $user_create_date;


					// Dates
					$format = $current_user->getPreference('datef') . " " . $current_user->getPreference('timef');
					$recherche_date_deb = DateTime::createFromFormat($format, $obj_meeting->date_start);
					$date_fin = DateTime::createFromFormat($format, $obj_meeting->date_end);

					$tab_meetings['date_deb'] = $recherche_date_deb->format($format);
					$tab_meetings['date_fin'] = $date_fin->format($format);
					$tab_meetings['heure_fin'] = $date_fin->format("H:i");
					$tab_meetings['start'] = $recherche_date_deb->format('Y-m-d\TH:i:s');
					$tab_meetings['end'] = $date_fin->format('Y-m-d\TH:i:s');


					$json_rdv[] = $tab_meetings;
				}
			}

			return $json_rdv;

		} else {
			return 0;
		}
	}


	/**
	 * Récupération des agendas où l'utilisateur connecté possède des droits
	 * @param string type
	 * @return bool|null|string|array
	 */
	public function recuperation_droits($type = "")
	{

		global $beanFiles, $current_user, $app_list_strings, $db;

		if (isset($current_user) && !empty($current_user->id)) {

			if ($type == "visualisation" || $type == "parametrage") {

				if (!$current_user->isAdmin()) {

					$req = "SELECT DISTINCT(ops_agendas.id)
						FROM ops_agendas, ops_agendas_droits_ops_agendas, ops_agendas_droits, ops_agendas_droits_users, users
						WHERE ops_agendas.deleted = '0'
							AND ops_agendas.id = ops_agendas_droits_ops_agendas.ops_agendas_id
							AND ops_agendas_droits_ops_agendas.ops_agendas_droits_id = ops_agendas_droits.id
							AND ops_agendas_droits.id = ops_agendas_droits_users.ops_agendas_droits_id
							AND ops_agendas_droits_users.users_id = users.id
							AND ops_agendas_droits." . $type . " = '1'
							AND ops_agendas_droits.deleted = '0'
							AND users.id = '" . $current_user->id . "'";

				} else {
					$req = "SELECT DISTINCT(ops_agendas.id)
						FROM ops_agendas
						WHERE ops_agendas.deleted = '0'";
				}

				$liste_id_agenda = $db->query($req);
				while ($un_agenda = $db->fetchRow($liste_id_agenda)) {

					$tab[] = "'" . $un_agenda['id'] . "'";

				}

				$tab_id_agenda = null;
				if (is_array($tab) && !empty($tab)) {
					$tab_id_agenda = implode(",", $tab);
				}

				return $tab_id_agenda;
			} elseif ($type == "gestion") {

				if ($current_user->isAdmin()) {
					return true;
				} else {

					$req2 = "SELECT DISTINCT(ops_agendas.id)
						FROM ops_agendas, ops_agendas_droits_ops_agendas, ops_agendas_droits, ops_agendas_droits_users, users
						WHERE ops_agendas.deleted = '0'
						AND ops_agendas.id = ops_agendas_droits_ops_agendas.ops_agendas_id
						AND ops_agendas_droits_ops_agendas.ops_agendas_droits_id = ops_agendas_droits.id
						AND ops_agendas_droits.id = ops_agendas_droits_users.ops_agendas_droits_id
						AND ops_agendas_droits_users.users_id = users.id
						AND ops_agendas_droits.instruction = '1'
						AND ops_agendas_droits.deleted = '0'
						AND users.id = '" . $current_user->id . "'
						AND ops_agendas.id = '" . $this->id . "'";

					$agenda_id = $db->getOne($req2);

					if (!empty($agenda_id)) {
						return true;
					}

					return false;
				}

			} elseif ($type == "hors_plage") {

				if ($current_user->isAdmin()) {
					return true;
				} else {

					$req2 = "SELECT DISTINCT(ops_agendas.id)
						FROM ops_agendas, ops_agendas_droits_ops_agendas, ops_agendas_droits, ops_agendas_droits_users, users
						WHERE ops_agendas.deleted = '0'
						AND ops_agendas.id = ops_agendas_droits_ops_agendas.ops_agendas_id
						AND ops_agendas_droits_ops_agendas.ops_agendas_droits_id = ops_agendas_droits.id
						AND ops_agendas_droits.id = ops_agendas_droits_users.ops_agendas_droits_id
						AND ops_agendas_droits_users.users_id = users.id
						AND ops_agendas_droits.hors_plage = '1'
						AND ops_agendas_droits.deleted = '0'
						AND users.id = '" . $current_user->id . "'
						AND ops_agendas.id = '" . $this->id . "'";

					$agenda_id = $db->getOne($req2);

					if (!empty($agenda_id)) {
						return true;
					}

					return false;
				}
			} elseif ($type == "actions") {
				if ($current_user->isAdmin()) {
					return array(
						'parametrage' => true,
						'motif' => true,
						'plage_ouverture' => true,
						'exception' => true
					);
				} else {

					$req2 = "SELECT ops_agendas_droits.parametrage, ops_agendas_droits.motif, ops_agendas_droits.plage_ouverture, ops_agendas_droits.exception 
						FROM ops_agendas, ops_agendas_droits_ops_agendas, ops_agendas_droits, ops_agendas_droits_users, users
						WHERE ops_agendas.deleted = '0'
						AND ops_agendas.id = ops_agendas_droits_ops_agendas.ops_agendas_id
						AND ops_agendas_droits_ops_agendas.ops_agendas_droits_id = ops_agendas_droits.id
						AND ops_agendas_droits.id = ops_agendas_droits_users.ops_agendas_droits_id
						AND ops_agendas_droits_users.users_id = users.id						
						AND ops_agendas_droits.deleted = '0'
						AND users.id = '" . $current_user->id . "'
						AND ops_agendas.id = '" . $this->id . "'";

					$agenda_actions = $db->query($req2);
					while ($un_agenda = $db->fetchRow($agenda_actions)) {

						$tab[] = array(
							'parametrage' => $un_agenda['parametrage'],
							'motif' => $un_agenda['motif'],
							'plage_ouverture' => $un_agenda['plage_ouverture'],
							'exception' => $un_agenda['exception']
						);

					}

					if (!empty($tab[0])) {
						return $tab[0];
					}

					return array(
						'parametrage' => false,
						'motif' => false,
						'plage_ouverture' => false,
						'exception' => false
					);
				}
			} elseif ($type == "menu"){
				if (!$current_user->isAdmin()) {

					$req = "SELECT DISTINCT(ops_agendas.id)
						FROM ops_agendas, ops_agendas_droits_ops_agendas, ops_agendas_droits, ops_agendas_droits_users, users
						WHERE ops_agendas.deleted = '0'
							AND ops_agendas.id = ops_agendas_droits_ops_agendas.ops_agendas_id
							AND ops_agendas_droits_ops_agendas.ops_agendas_droits_id = ops_agendas_droits.id
							AND ops_agendas_droits.id = ops_agendas_droits_users.ops_agendas_droits_id
							AND ops_agendas_droits_users.users_id = users.id
							AND (ops_agendas_droits.parametrage = '1' OR ops_agendas_droits.motif = '1' OR ops_agendas_droits.plage_ouverture = '1' OR ops_agendas_droits.exception = '1' )
							AND ops_agendas_droits.deleted = '0'
							AND users.id = '" . $current_user->id . "'";

				} else {
					$req = "SELECT DISTINCT(ops_agendas.id)
						FROM ops_agendas
						WHERE ops_agendas.deleted = '0'";
				}

				$liste_id_agenda = $db->query($req);
				while ($un_agenda = $db->fetchRow($liste_id_agenda)) {

					$tab[] = "'" . $un_agenda['id'] . "'";

				}

				$tab_id_agenda = null;
				if (is_array($tab) && !empty($tab)) {
					$tab_id_agenda = implode(",", $tab);
				}
				//$GLOBALS['log']->fatal('tab_id_agenda menu::'.print_r($tab_id_agenda, true));

				return $tab_id_agenda;
			} 
			
			elseif (isset($type) && !empty($type)) {
				if ($current_user->isAdmin()) {
					return true;
				} else {

					$req2 = "SELECT DISTINCT(ops_agendas.id)
						FROM ops_agendas, ops_agendas_droits_ops_agendas, ops_agendas_droits, ops_agendas_droits_users , users
						WHERE ops_agendas.deleted = '0'
						AND ops_agendas.id = ops_agendas_droits_ops_agendas.ops_agendas_id
						AND ops_agendas_droits_ops_agendas.ops_agendas_droits_id = ops_agendas_droits.id
						AND ops_agendas_droits.id = ops_agendas_droits_users.ops_agendas_droits_id
						AND ops_agendas_droits_users.users_id = users.id
						AND ops_agendas_droits." . $type . " = '1'
						AND ops_agendas_droits.deleted = '0'
						AND users.id = '" . $current_user->id . "'
						AND ops_agendas.id = '" . $this->id . "'";


					$agenda_id = $db->getOne($req2);

					if (!empty($agenda_id)) {
						return true;
					}

					return false;
				}
			}
		} else {
			return false;
		}
	}


	/**
	 * Gestions des notifications par mail pour les agents
	 * @param object $obj_meeting
	 * @param string $action
	 * @return bool
	 */
	public function gestion_notifications_agent($obj_meeting, $action)
	{
		global $sugar_config, $beanFiles;

		require_once($beanFiles["Meeting"]);
		require_once($beanFiles["Note"]);


		// Gestion des notifs de création lorsque l'utilisateur change ; envoi de la création du RDV sachant que l'annulation est envoyé via le hook meeting
		if ($action == "creation_agent" || $action == "creation") {
			$action = "creation";
			$nb_event = 0;
		} elseif ($action == "modification") {
			$nb_event = 1;
		} else {
			$nb_event = 2;
		}

		if (empty($current_user->id)) {
			$current_user = BeanFactory::getBean("Users", "1");
		}
		$timeZone = TimeDate::userTimezone($current_user);

		// CREATION DE LA SYNCHRO
		// Récupération de l'agent assigné
		$obj_user = BeanFactory::getBean('Users', $obj_meeting->assigned_user_id);
		$from = $obj_user->full_name;
		$from_mail_user = $obj_user->email1;

		// Valorisation selon l'adresse mail (gmail ou autre)
		$email = $from_mail_user;
		$domain = explode("@", $email)[1];
		$mx = getmxrr($domain, $mxrecords);

		if (str_contains($mxrecords[0], "google")) {

			$zone = $timeZone;
			$method = "REQUEST";

			if ($action == "creation" || $action == "modification") {
				$statut = "CONFIRMED";
			} else {
				$statut = "CANCELLED";
			}

		} else {
			$zone = 'UTC';

			if ($action == "creation" || $action == "modification") {
				$statut = "CONFIRMED";
				$method = "REQUEST";
			} else {
				$method = "CANCEL";
				$statut = "CANCELLED";
			}
		}


		// Récupération de l'email par défaut de la plateforme
		$query = "SELECT value FROM config WHERE category = 'notify' AND name like 'fr%'";
		$result = $GLOBALS["db"]->query($query);

		while ($config_Elmt = $GLOBALS["db"]->fetchByAssoc($result)) {
			$configs[] = $config_Elmt;
		}

		$from_syst = $configs[1]['value'];
		$from_mail_syst = $configs[0]['value'];

		$description = str_replace(array("\r\n", "\r", "\n"), ' ', $obj_meeting->description);
		if ($obj_meeting->accompagnant != "") {
			$description .= "\\n Participant(s):\\n " . str_replace(array("\r\n", "\r", "\n"), ', ', $obj_meeting->accompagnant);
		}


		// Récupération de l'individu
		$title = str_replace("&#039;", "\'", $obj_meeting->name);
		$obj_individu = BeanFactory::getBean('OPS_individu', $obj_meeting->ops_individu_id);

		if (!empty($obj_individu->phone_mobile)) {
			$title .= ' - ' . $obj_individu->phone_mobile;
		}
		


		// Récupération du lieu
		$obj_lieu_multi = BeanFactory::getBean('OPS_lieux', $obj_meeting->location_id);
		if ($obj_lieu_multi != null && !empty($obj_lieu_multi) && $obj_meeting->location_id != '') {
			$location_rue = $obj_lieu_multi->address_numero . ' ' . $obj_lieu_multi->address_street . ' (Bat/Etage:' . $obj_lieu_multi->address_bat . ')';
			$location_ville = $obj_lieu_multi->address_city;
			$location_cp = $obj_lieu_multi->address_postalcode;

			$location_all = html_entity_decode(ucfirst($obj_meeting->location) . ' - ' . $location_rue . ', ' . $location_ville . ' ' . $location_cp);


			$title .= ' - ' . $obj_lieu_multi->name;
			
		} else if(!empty($obj_meeting->location)){
			$title .= ' - ' . $obj_meeting->location;
		}


		// Récupération des Dates
		$date_debut = DateTime::createFromFormat("Y-m-d H:i:s", $obj_meeting->date_start, new DateTimeZone($timeZone));
		$date_fin = DateTime::createFromFormat("Y-m-d H:i:s", $obj_meeting->date_end, new DateTimeZone($timeZone));

		if ($date_debut == false && $date_fin == false) {
			$format = $current_user->getPreference('datef') . " " . $current_user->getPreference('timef');
			$date_debut = DateTime::createFromFormat($format, $obj_meeting->date_start, new DateTimeZone($timeZone));
			$date_fin = DateTime::createFromFormat($format, $obj_meeting->date_end, new DateTimeZone($timeZone));
			$date_debut->setTimezone(new DateTimeZone("UTC"));
			$date_fin->setTimezone(new DateTimeZone("UTC"));
		}

		$date_debut = $date_debut->format("Y-m-d H:i:s");
		$date_fin = $date_fin->format("Y-m-d H:i:s");

		$date_start = $this->convert_date($date_debut, "Ymd\THis", $zone);
		$date_end = $this->convert_date($date_fin, "Ymd\THis", $zone);


		if ($obj_meeting->date_entered == null) {
			$date_created = date("Ymd\THis\Z");
			$date_modified = date("Ymd\THis\Z");
		} else {
			$date_created = $this->convert_date($obj_meeting->date_entered, "Ymd\THis", $zone);
			$date_modified = $this->convert_date($obj_meeting->date_modified, "Ymd\THis", $zone);
		}


		$uid = 'ops-' . substr($from, 0, 5) . '-' . $obj_meeting->id . '-' . $obj_meeting->outlook_id;

		$ical = 'BEGIN:VCALENDAR' . "\r\n" .
			'PRODID:OPENSocle' . "\r\n" .
			'VERSION:2.0' . "\r\n" .
			'CALSCALE:GREGORIAN' . "\r\n" .
			'METHOD:' . $method . "\r\n" .
			'BEGIN:VEVENT' . "\r\n" .
			'DTSTAMP:' . $date_created . "\r\n" .
			'CREATED:' . $date_created . "\r\n" .
			'LAST-MODIFIED:' . $date_modified . "\r\n" .
			'DTSTART:' . $date_start . "\r\n" .
			'DTEND:' . $date_end . "\r\n" .
			'DESCRIPTION;LANGUAGE=fr-FR:' . wordwrap(html_entity_decode($description), 60, "\n ", true) . "\r\n" .
			'ORGANIZER;CN=' . $from_syst . ':mailto:' . $from_mail_syst . "\r\n" .
			'UID:' . $uid . "\r\n" .
			'ATTENDEE;CUTYPE=INDIVIDUAL;RSVP=FALSE;CN=' . $from . ';X-NUM-GUESTS=0:mailto:' . $from_mail_user . "\r\n" .
			'LOCATION:' . $location_all . "\r\n" .
			'SEQUENCE:' . $nb_event . "\r\n" .
			'STATUS:' . $statut . "\r\n" .
			'SUMMARY:' . wordwrap(html_entity_decode($title), 60, "\n ", true) . "\r\n" .
			'TRANSP:OPAQUE' . "\r\n" .
			'CLASS:PUBLIC' . "\r\n" .
			'PRIORITY:5' . "\r\n" .
			'BEGIN:VALARM' . "\r\n" .
			'DESCRIPTION;LANGUAGE=fr-FR:' . wordwrap(html_entity_decode($description), 60, "\n ", true) . "\r\n" .
			'TRIGGER;RELATED=START:-PT15M' . "\r\n" .
			'ACTION:DISPLAY' . "\r\n" .
			'END:VALARM' . "\r\n" .
			'END:VEVENT' . "\r\n" .
			'TZID:' . $timeZone . "\r\n" .
			'END:VCALENDAR';



		///
		/// CREATION MAIL (UNIQUEMENT)
		$message_status = "";
		$bool_send_mail = true;

		// Check meeting
		if (empty($obj_meeting->id)) {
			$message_status .= " Echec récupération du rdv. ";
			$bool_send_mail = false;
		}


		// Récupération ID template mail agent
		$id_template = $sugar_config['agenda']['agenda_' . $action . 'tmpl'];
		if (empty($id_template)) {
			$message_status .= " Modèle de mail inexistant pour $action.";
			$bool_send_mail = false;
		}

		// Check envoi des notifications agents
		if ($sugar_config['agenda']['notif_agent'] == false) {
			$message_status .= " Notifications agents désactivées. ";
			$bool_send_mail = false;
		}


		if (empty($obj_user->email1)) {
			$message_status .= " Email vide. ";
			$bool_send_mail = false;
		}

		if ($bool_send_mail) {

			$result_agent = false;

			# Initialisation du mailer
			$mailer = new OdeMailer();

			# Initialisation du mail
			$ode_email = new OdeEmail([
				'bean_source_id' => $obj_meeting->id,
				'bean_source_name' => 'Meetings',
				'bean_historisation_id' => $obj_meeting->id,
				'bean_historisation_name' => 'Meetings',
				'email_template_id' => $id_template,
				'dest_to' => $obj_user->email1,
				'dest_cc' => '',
				'dest_cci ' => '',
				'genere_dossier_pdf' => false,
				'attachments' => $ical
			]);

			# On déclenche l'envoi
			$result_agent = $mailer->send($ode_email);

			# Flag de la réussite pour éviter des relances inutiles
			if ($result_agent == true) {
				$obj_meeting->nb_relances_agent = 3;
				$obj_meeting->save();
				$GLOBALS['log']->debug('gestion_notifications_agent - MAIL AGENT SUCCES - '.$obj_user->email1);
			} else {
				$GLOBALS['log']->fatal('gestion_notifications_agent - Impossible d\'effectuer l\'envoi vers l\' agent');
			}

			// NOTES
			$date = $this->convert_date($date_debut, "d/m/Y", $timeZone);
			$heure = $this->convert_date($date_debut, "H:i", $timeZone);

			$message = "Envoyé à l'adresse: " . $obj_user->email1 . "\r\n" .
				"Date et heure du rendez-vous: Le " . $date . " à " . $heure . "\r\n\n" .
				$ode_email->subject . ' ' . $ode_email->body; //. "\r\n\n" .$ical;

			$this->gestion_historique_notification('Meetings', $obj_meeting->id, 'MAIL', $action, $message, $result_agent, $obj_meeting->assigned_user_id, $message_status);

		} else {
			$GLOBALS['log']->fatal("gestion_notifications_agent - MAIL non envoyé: $message_status (agent)");
		}
	}


	/**
	 * Gestions des notifications par mail et SMS pour les usagers
	 * @param mixed $obj_meeting
	 * @param mixed $action
	 * @return bool
	 */
	public function gestion_notifications_usager($obj_meeting, $action = "creation")
	{

		global $sugar_config, $beanFiles;

		require_once($beanFiles["Meeting"]);
		require_once($beanFiles["Note"]);

		$bool_send_sms = true;
		$bool_send_mail = true;


		///
		/// Gestion des MAIL
		if ($obj_meeting->notif_mail) {
			///
			/// Gestion des MAIL
			$message_status = "";

			// Récupération de l'id template
			$id_template_mail = $this->{"ops_email_" . $action . "_id"};

			// Check meeting
			if (empty($obj_meeting->id)) {
				$message_status .= " Echec récupération du rdv. ";
				$bool_send_sms = false;
				$bool_send_mail = false;
			}

			// Check id_template
			if (empty($id_template_mail)) {
				$bool_send_mail = false;
				$message_status .= " Modèle de mail inexistant pour $action.";
			}

			// Récupération de l'individu et de son mail
			$obj_individu = BeanFactory::getBean('OPS_individu', $obj_meeting->ops_individu_id);
			if (empty($obj_individu->email1)) {
				$message_status .= " Email vide. ";
				$bool_send_mail = false;
			}


			if ($bool_send_mail) {

				$result_individu = false;

				# On initialise le mailer
				$mailer = new OdeMailer();

				# On initialise l'email
				$ode_email = new OdeEmail([
					'bean_source_id' => $obj_meeting->id,
					'bean_source_name' => 'Meetings',
					'bean_historisation_id' => $obj_meeting->id,
					'bean_historisation_name' => 'Meetings',
					'email_template_id' => $id_template_mail,
					'dest_to' => $obj_individu->email1,
					'dest_cc' => '',
					'dest_cci ' => '',
					'genere_dossier_pdf' => false
				]);

				$result_individu = $mailer->send($ode_email);
				if ($result_individu == true) {
					$obj_meeting->confirmation_mail = 1;
					$obj_meeting->nb_relances_usager_mail = 3;
					$obj_meeting->save();
					$GLOBALS['log']->debug('gestion_notifications_usager - MAIL USAGER SUCCES');
				} else {
					$GLOBALS['log']->debug('gestion_notifications_usager - MAIL : Impossible d\'effectuer l\'envoi vers l\' usager');
				}

				$message = $ode_email->subject . ' ' . $ode_email->body;

				$this->gestion_historique_notification('OPS_individu', $obj_meeting->ops_individu_id, 'MAIL', $action, $message, $result_individu, $obj_meeting->assigned_user_id, $message_status);

			} elseif (!empty($message_status) && $message_status != " Email vide. ") {
				$GLOBALS['log']->debug("gestion_notifications_usager - MAIL non envoyé: $message_status (usager)" . print_r($message_status, true));
			}

			// On réinitialise la variable message pour les SMS 
			$message = "";
		} else {
			$GLOBALS['log']->debug('gestion_notifications_usager MAIL :: Envoi non accepté dans le rdv :' . $obj_meeting->notif_mail);
		}

		// On réinitialise la variable message pour les SMS 
		$message = "";


		/// Gestion par SMS
		if ($obj_meeting->notif_sms) {

			$message_status = '';
			/// Gestion par SMS
			$message_status = '';
			// Récupération ID template SMS
			$id_template_sms = $this->{"ops_sms_" . $action . "_id"};
			$template_sms = BeanFactory::getBean("OPS_template_sms", $id_template_sms);

			if (empty($id_template_sms) || empty($template_sms)) {
				$bool_send_sms = false;
				$message_status .= " Modèle de SMS inexistant pour $action. ";
			}

			// Verification numéro tel
			// Récupération de l'individu et de son mail
			$obj_individu = BeanFactory::getBean('OPS_individu', $obj_meeting->ops_individu_id);
			if (empty($obj_individu->email1)) {
				$message_status .= " Email vide. ";
				$bool_send_mail = false;
			}

			$numero_tel = $obj_individu->phone_mobile;
			if (empty($numero_tel)) {
				$bool_send_sms = false;
				$message_status .= " Numéro de telephone portable vide. ";
			} elseif (substr($numero_tel, 0, 2) !== '06' && substr($numero_tel, 0, 2) !== '07') {
				$bool_send_sms = false;
				$message_status .= " Numéro de telephone portable incorrect. $numero_tel";
			}


			if ($bool_send_sms) {

				$sms_envoye = false;

				// On remplace les champs du modele
				$ops_sms = new OdeSms($obj_meeting);
				$message = $template_sms->description;

				// on récupere le numéro du destinataire
				$numero_telephone = $obj_meeting->tel_rdv;
				if (empty($numero_telephone) && !empty($numero_tel)) {
					$numero_telephone = $numero_tel;
				}
				$numero = $ops_sms->format_numero($numero_telephone);

				if ($numero != false) {
					// on envoie le message
					try {
						$sms_envoye = $ops_sms->send_sms($numero, $message);
					} catch (\Exception $e) {
						$GLOBALS['log']->fatal('gestion_notifications_usager - SMS : Impossible d\'effectuer l\'envoi vers l\' usager : : ' . $e);
						$sms_envoye = false;
					}

					if ($sms_envoye == true) {
						$message_status .= '';
					} else {
						$message_status .= " Echec de l'envoi par l'opérateur SMS.";
					}

				} else {
					$message_status .= " Numéro de téléphone non renseigné ou mal formaté. ";
				}

				// On flag la réussite pour éviter des relances inutiles
				if ($sms_envoye == true) {
					$obj_meeting->confirmation_sms = 1;
					$obj_meeting->tel_rdv = $numero_telephone; // On sauvegarde le téléphone utilisé pour les RDV
					$obj_meeting->nb_relances_usager_sms = 3;
					$obj_meeting->save();
					$message_status = "Envoyé";
				}

				$this->gestion_historique_notification('OPS_individu', $obj_meeting->ops_individu_id, 'SMS', $action, $message, $sms_envoye, $obj_meeting->assigned_user_id, $message_status);


			} elseif (!empty($message_status) && $message_status != " Numéro de telephone portable vide. ") {
				$GLOBALS['log']->debug("gestion_notifications_usager - SMS non envoyé:  $message_status(usager)");
			}


		} else {
			$GLOBALS['log']->debug('gestion_notifications_usager SMS :: Envoi non accepté dans le rdv :' . $obj_meeting->notif_sms);
		}
	}


	/**
	 * Stockage de l'action d'envoi et du résultat de cet envoi
	 * @param mixed $bean_meeting
	 * @param mixed $parent_type
	 * @param mixed $parent_id
	 * @param mixed $type_notification
	 * @param mixed $action
	 * @param mixed $contenu_message
	 * @param mixed $status
	 * @param mixed $message_status
	 * @return mixed
	 */
	public function gestion_historique_notification($parent_type, $parent_id, $type_notification, $action, $contenu_message, $status, $assigned_user_id, $message_status = '')
	{
		$obj_notes = BeanFactory::newBean('Notes');
		if ($status == 1) {
			$statut_envoi = 'Succès';
			$obj_notes->description = $contenu_message;
		} else {
			$statut_envoi = 'Echec';
			$obj_notes->description = 'Erreur : ' . $message_status . "\n" . 'Contenu du ' . $type_notification . ' : ' . "\n" . $contenu_message;
		}

		if (isset($statut_envoi)) {
			$obj_notes->name = $type_notification . " (" . $statut_envoi . ") - " . ucfirst($action) . " du rendez-vous";
		} else {
			$obj_notes->name = $type_notification . " - " . ucfirst($action) . " du rendez-vous";
		}
		$obj_notes->parent_type = $parent_type;
		$obj_notes->parent_id = $parent_id;

		// Récupération de l'email de l'agent assigné
		$obj_user = BeanFactory::getBean('Users', $assigned_user_id);
		$assigned_user_name = $obj_user->full_name;

		$obj_notes->assigned_user_id = $assigned_user_id;
		$obj_notes->assigned_user_name = $assigned_user_name;
		return $obj_notes->save();
	}


	/**
	 * Summary of unique_multidim_array
	 * @param mixed $array mutidim
	 * @param mixed $key
	 * @return array
	 */
	public function unique_multidim_array($array, $key)
	{
		$temp_array = array();
		$i = 0;
		$key_array = array();

		foreach ($array as $val) {
			if (!in_array($val->$key, $key_array)) {
				$key_array[$i] = $val->$key;
				$temp_array[$i] = $val;
			}
			$i++;
		}
		return $temp_array;
	}


	/**
	 * Conversion de date vers un format chainé
	 * @param mixed $date
	 * @param string $format
	 * @param string $zone
	 * @return string
	 */
	protected function convert_date($date, $format, $zone = "UTC")
	{

		if (substr($date, 4, 1) == "-") {

			$annee = substr($date, 0, 4);
			$mois = substr($date, 5, 2);
			$jours = substr($date, 8, 2);
			$heure = substr($date, 11, 2);
			$minute = substr($date, 14, 2);
			$dateTime = $annee . '-' . $mois . '-' . $jours . ' ' . $heure . ':' . $minute . ':' . '00';
			$date = new DateTime($dateTime, new DateTimeZone('UTC'));

			$date->setTimezone(new DateTimeZone($zone));
			$date_sortie = $date->format($format);
		} else {

			$jours = substr($date, 0, 2);
			$mois = substr($date, 3, 2);
			$annee = substr($date, 6, 4);
			$heure = substr($date, 11, 2);
			$minute = substr($date, 14, 2);

			$dateTime = $annee . '-' . $mois . '-' . $jours . ' ' . $heure . ':' . $minute . ':' . '00';

			$date = new DateTime($dateTime, new DateTimeZone($zone));

			$date->setTimezone(new DateTimeZone($zone));
			$date_sortie = $date->format($format);
		}

		return $date_sortie;
	}


	protected function convert_date_timestamp($date = "")
	{

		if (!empty($date)) {

			$date_timestamp = new TimeDate();
			$date_timestamp = $date_timestamp->fromString($date);
			$date_timestamp->format("Y-m-d H:s");
			$date_timestamp = $date_timestamp->getTimestamp();

			return $date_timestamp;
		}


	}


	/**
	 * Création du code html pour la liste des variables de mail
	 * Appellé dans le module emailTemplate par templateFields.php
	 */
	public static function get_field_list()
	{
		global $app_list_strings;

		$selectHtml = '';

		foreach ($app_list_strings['list_champs_meetings'] as $key => $field) {
			$selectHtml .= '<option value="' . $key . '">' . $field . '</option>';
		}
		$selectHtml .= '</optgroup>';

		return $selectHtml;
	}

}