<?php

if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

use ODE\ActionStatut\OdeActionStatut;


class OPS_action_statutViewEdit extends ViewEdit
{

    public function __construct()
    {
        parent::__construct();
    }

    function display()
    {
        global $mod_strings, $app_list_strings;

        $action_statut = new OdeActionStatut(null, null);
        $fonction_options = $action_statut->getOptions();

        $script_action = '';
        
        $fonctions_html = '<select name="fonction" id="fonction" style="width: 90%;" title="">';
        if (is_array($fonction_options) && count($fonction_options) > 0) 
        {
            foreach ($fonction_options as $optgroup_value => $options) 
            {
                $fonctions_html .= '<optgroup label="' . $app_list_strings['ops_action_statut_group_fonction_list'][$optgroup_value] . '">';
                foreach ($options as $option_value => $option) {
                    $selected = ($option['name'] === $this->bean->fonction) ? 'selected' : '';
                    $fonctions_html .= '<option ' . $selected . ' value="' . $option['name'] . '"  data-script="' . $option["script_name"] . '">' . $option["libelle"] . '</option>';

                    if(!empty($option["script_name"]))
                    {
                        $script_action .= '<script type="text/javascript" charset="UTF-8" src="custom/include/Ode/ActionStatut/Js/'.$option["script_name"].'.js"></script>';
                    } 
                }
                $fonctions_html .= '</optgroup>';
            }
        } 
        else 
        {
            $GLOBALS['log']->fatal(" OPS_action_statutViewEdit :: display => Aucune fonction");
        }
        $fonctions_html .= '</select>';

        $execution = '<label>'.$mod_strings['LBL_JOURS'].' : </label>';
        $execution .= '<input type="number" name="jours" id="jours" size="6" maxlength="255" min="0" value="'.$this->bean->jours.'" title="" style="margin: 0 5px">';
        $execution .= '<label>'.$mod_strings['LBL_HEURES'].' : </label>';
        $execution .= '<input type="number" name="heures" id="heures" size="6" maxlength="255" min="0" value="'.$this->bean->heures.'" title="" style="margin: 0 5px">';
        $execution .= '<label>'.$mod_strings['LBL_MINUTES'].' : </label>';
        $execution .= '<input type="number" name="minutes" id="minutes" size="6" maxlength="255" min="0" value="'.$this->bean->minutes.'" title="" style="margin: 0 5px">';

        $this->ss->assign("execution", $execution);
        $this->ss->assign("fonctions_html", $fonctions_html);
        $this->ss->assign("script_action", $script_action);
        parent::display();
    }
}
