<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

use ODE\Helper\OdeArrayHelper;
use ODE\ActionStatut\OdeActionStatut;

class OPS_action_statutController extends SugarController
{

    /**
     * @access public
     * action_getFonctionDetail()
     * Fonction qui retourne les données d'initialisation du sous-panel fonctions 
     *
     * @return json     $data
     */
    function action_getFonctionDetail()
    {

        $libelle_erreur = "";

        // Vérification des champs recu dans $_REQUEST
        $data_verified =  OdeArrayHelper::isDataValid($_REQUEST, ["json" => true]);
        if ($data_verified['statut'] == 'ok') {
            $donnees = $data_verified["data"]["json_array"];
            if (!empty($donnees["fonction"])) {
                $obj_action_statut = (!empty($donnees["action_statut_id"])) ? BeanFactory::getBean('OPS_action_statut', $donnees["action_statut_id"]) : null;
                $action_statut = new OdeActionStatut($obj_action_statut, null);
                $fonction_data = $action_statut->getDataEdition($donnees["fonction"]);
                $fonction_detail = [
                    "title" => (!empty($fonction_data["title"])) ? $fonction_data["title"] : "",
                    "form" => (!empty($fonction_data["form"])) ? $fonction_data["form"] : "Erreur de récupération du formulaire",
                    "aide" => (!empty($fonction_data["aide"])) ? $fonction_data["aide"] : ""
                ];
            } else {
                $libelle_erreur = "Erreur Serveur";
            }
        } else {
            // On retourne les erreurs de vérification
            $libelle_erreur = $data_verified['data'];
        }

        // Si on a aucune erreur le statut est à 'ok' et on retourne les données formatées sinon le statut passe à 'err' et on retourne le libelle de l'erreur 
        $data = (empty($libelle_erreur)) ? ["statut" => "ok", "data" => $fonction_detail] : ["statut" => "err", "data" => $libelle_erreur];

        ob_clean();
        echo json_encode($data);
        sugar_cleanup(true);
    }
}
