<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

require_once('include/MVC/View/SugarView.php');

class Viewsuitepro_settings extends SugarView {

    public function display() {

        require_once('modules/Administration/Administration.php');
        $OEPL_Admin = new Administration();

        ## START Module License For Access Rights
        require_once('modules/OE_SuitePro/license/OE_SuitePro_Outfitters_License.php');
        if ( isset($GLOBALS['sugar_config']['outfitters_licenses']['suitepro']) && $GLOBALS['sugar_config']['outfitters_licenses']['suitepro'] == 'No_License_Key' )
            $validate_license = '1';
        else
            $validate_license = OE_SuitePro_Outfitters_License::isValid('OE_SuitePro', '', false);

        if($validate_license != '1') {
            sugar_die('<font style="color:red">Please enter your valid license key to use this module. If you already have key <a href="index.php?module=OE_SuitePro&action=license">Click here</a> to set. License did NOT validate. Reason:'.$validate_license.'</font>');
        }
        
        $dir_path = 'custom/themes/OEPLTheme/images/';

        if (isset($_REQUEST['upload_images']) && $_REQUEST['upload_images'] == 'Upload') {

            $files_cnt = count($_FILES);
            
            if ($files_cnt > 0) {
                
                $flag = false;
                $image_name_arr = array('login_banner', 'company_logo', 'company_icon');
                
                foreach ($image_name_arr as $img_name) {
                    
                    $file_name = $this->OEPL_cleanStr( $_FILES[$img_name]["name"] );
                    $targetFile = $dir_path . $file_name;

                    if (move_uploaded_file($_FILES[$img_name]["tmp_name"], $targetFile)) {
                        
                        $flag = true;
                        
                        $json_IMG = base64_encode(serialize($targetFile));
                        $img_save_name = str_replace('_', '-', $img_name);
                        $OEPL_Admin->saveSetting('OEPLTheme', $img_save_name, $json_IMG);
                    }
                }
            }
            
            if ( $flag ) {
            	
                $_SESSION['OEPL']['success_msg'] = '<div class="alert alert-success">Images uploaded successfully.</div>';
				
				$queryParams = array(
					'module' => $_REQUEST['module'],
			   		'action' => $_REQUEST['action']
			   	 );
			   	 
                SugarApplication::redirect( 'index.php?' . http_build_query( $queryParams ) );
                exit;
            }
        }

        ## get saved settings
        $OEPLTheme_Admin = new Administration();
        $OEPLTheme_Admin->retrieveSettings('OEPLTheme');
        $login_banner = '';
        $company_logo = '';
        $company_icon = '';
        if(isset($OEPLTheme_Admin->settings['OEPLTheme_login-banner']) && !empty($OEPLTheme_Admin->settings['OEPLTheme_login-banner'])) {
            $login_banner = unserialize(base64_decode($OEPLTheme_Admin->settings['OEPLTheme_login-banner']));
        }
        if(isset($OEPLTheme_Admin->settings['OEPLTheme_company-logo']) && !empty($OEPLTheme_Admin->settings['OEPLTheme_company-logo'])) {
            $company_logo = unserialize(base64_decode($OEPLTheme_Admin->settings['OEPLTheme_company-logo']));
        }
        if(isset($OEPLTheme_Admin->settings['OEPLTheme_company-icon']) && !empty($OEPLTheme_Admin->settings['OEPLTheme_company-icon'])) {
            $company_icon = unserialize(base64_decode($OEPLTheme_Admin->settings['OEPLTheme_company-icon']));
        }
        ?>

        <style>
            .oeplTable {width: 70%;margin: 30px 0;}
            .oeplTable tr td {padding: 15px 0;vertical-align: middle;}
            .oeplTable tr td input {margin-bottom: 10px;width: 55%;}
            .oepl_info_icon {cursor: pointer;}
            input[type="file"] {display: inline-block;}
            .oepl_icon {font-size: 20px;cursor: pointer;margin: 0 5px;color: #000000;}
            .oepl_label {width: 12%;}
            .oepl_browse_fld {width: 30%;}
            .oepl_info_msg {width: 40%;}
            .oepl_info_msg div {background: #FAFAFA;padding: 10px ​30px;}
            .oepl_info_msg div {font-size: 15px;padding: 10px;letter-spacing: 1px;line-height: 20px;position: relative;}
            .oepl_info_msg div:after {content: " ";position: absolute;left: -15px;top: 10px;border-top: 15px solid transparent;border-right: 15px solid #FAFAFA;border-left: none;border-bottom: 15px solid transparent;}
            .oeplTable tr td input[type=submit] {width: 100px;}
        </style>
        
        <link rel="stylesheet" href="themes/OEPLTheme/css/fontawesome.min.css" />
        <script type="text/javascript" src="<?php echo getJSPath('modules/OE_SuitePro/js/custom.js'); ?>"></script>
        
        <!-- Re-Submit stop on page refresh -->
        <script type="text/javascript">
        	if ( window.history.replaceState ) {
        		window.history.replaceState( null, null, window.location.href );
			}

            function ShowInfoMessage(ID, thisID) {
                $('#' + ID).show();
                $('#' + thisID).attr('onclick', 'HideInfoMessage("'+ ID +'", "' + thisID + '");')
            }

            function HideInfoMessage(ID, thisID) {
                $('#' + thisID).attr('onclick', 'ShowInfoMessage("'+ ID +'", "' + thisID + '");')
                $('#' + ID).hide();
            }
        </script>

        <h2 style="font-size: 25px; font-weight: 300; text-transform: uppercase; letter-spacing: 2px;">SuitePro Theme Settings</h2>

        <?php
        $success_msg = '';
        if ( isset( $_SESSION['OEPL']['success_msg'] ) && !empty( $_SESSION['OEPL']['success_msg'] ) ) {
            $success_msg = $_SESSION['OEPL']['success_msg'];
			$_SESSION['OEPL']['success_msg'] = '';
        }
        echo $success_msg;
        ?>

        <form method="post" name="oepl_upload_files" id="oepl_upload_files" enctype="multipart/form-data">
            <table class="oeplTable" cellpadding="1" width="100%" cellspacing="1" border="0">
                
                <tr>
                <td class="oepl_label"><label>Login Banner: </label></td>
                    <td class="oepl_browse_fld">
                        <input accept=".png,.jpg,.jpeg,.ico" type="file" onchange="return oepl_fileValidation(this.id);" name="login_banner" id="login_banner" />
                    
                            <?php
                            if (!empty($login_banner) && file_exists($login_banner)) {
                            ?>
                                
                                <a class="oepl_icon" href="<?php echo $login_banner; ?>" download>
                                    <i class="fa fa-download" aria-hidden="true"></i>
                                </a>
                                
                                <a class="oepl_icon" onclick="OpenFileWithoutDownoad('index.php?entryPoint=documentdownload&module=OE_SuitePro&filename=<?php echo basename($login_banner); ?>', 'Login Banner')"><i class="fa fa-eye" aria-hidden="true"></i></a>

                            <?php
                            }
                            ?>
                            <a href="javascript:void(0);" class="oepl_icon">
                                <i class="fa fa-info-circle oepl_info_icon" id="lb_icon" aria-hidden="true" onclick="ShowInfoMessage('login_banner_info', this.id);"></i>
                            </a>
                    </td>

                    <td class="oepl_info_msg">
                        <div id="login_banner_info" style="display: none;">
                            - It'll display on login page (left side section).<br>
                            - Recommended Size: 1382*922.<br>
                            - Valid File Type: .png, .jpg, .jpeg, .ico
                        </div>
                    </td>
                </tr>
                
                <tr>
                    <td><label>Company Logo: </label></td>
                    <td>
                        <input accept=".png,.jpg,.jpeg,.ico" type="file" onchange="return oepl_fileValidation(this.id);" name="company_logo" id="company_logo" />
                            <?php
                            if (!empty($company_logo) && file_exists($company_logo)) {
                            ?>
                                
                                <a class="oepl_icon" href="<?php echo $company_logo; ?>" download>
                                    <i class="fa fa-download" aria-hidden="true"></i>
                                </a>
                                
                                <a class="oepl_icon" onclick="OpenFileWithoutDownoad('index.php?entryPoint=documentdownload&module=OE_SuitePro&filename=<?php echo basename($company_logo); ?>', 'Company Logo')"><i class="fa fa-eye" aria-hidden="true"></i></a>

                            <?php
                            }
                            ?>
                            <a href="javascript:void(0);" class="oepl_icon">
                                <i class="fa fa-info-circle oepl_info_icon" id="cg_icon" aria-hidden="true" onclick="ShowInfoMessage('company_logo_info', this.id);"></i>
                            </a>
                    </td>

                    <td class="oepl_info_msg">
                        <div id="company_logo_info" style="display: none;">
                            - It'll display on login page (above login section).<br>
                            - Recommended Size: 115*25.<br>
                            - Valid File Type: .png, .jpg, .jpeg, .ico
                        </div>
                    </td>
                </tr>
                
                <tr>
                    <td><label>Company Icon:</label></td>
                    <td>
                        <input accept=".png,.jpg,.jpeg,.ico" type="file" onchange="return oepl_fileValidation(this.id);" name="company_icon" id="company_icon" />
                            <?php
                            if (!empty($company_icon) && file_exists($company_icon)) {
                            ?>
                                
                                <a class="oepl_icon" href="<?php echo $company_icon; ?>" download>
                                    <i class="fa fa-download" aria-hidden="true"></i>
                                </a>
                                
                                <a class="oepl_icon" onclick="OpenFileWithoutDownoad('index.php?entryPoint=documentdownload&module=OE_SuitePro&filename=<?php echo basename($company_icon); ?>', 'Company Icon')"><i class="fa fa-eye" aria-hidden="true"></i></a>

                            <?php
                            }
                            ?>
                            <a href="javascript:void(0);" class="oepl_icon">
                                <i class="fa fa-info-circle oepl_info_icon" id="ci_icon" aria-hidden="true" onclick="ShowInfoMessage('company_icon_info', this.id);"></i>
                            </a>
                    </td>

                    <td class="oepl_info_msg">
                        <div id="company_icon_info" style="display: none;">
                            - It'll display on header section of CRM.<br>
                            - Recommended Size: 36*36.<br>
                            - Valid File Type: .png, .jpg, .jpeg, .ico
                        </div>
                    </td>
                </tr>
                
                <tr>
                    <td colspan="2">
                        <input type="submit" name="upload_images" id="upload_images" value="Upload" />
                    </td>
                </tr>
            </table>
        </form>
        <?php
    }
    
    function OEPL_cleanStr( $string ) {
	    # Replaces all spaces with hyphens.
	    $string = str_replace(' ', '-', $string);
		
	    # Removes special chars.
	    $string = preg_replace('/[^A-Za-z0-9\-\.]/', '', $string);
		
	    # Replaces multiple hyphens with single one.
	    $string = preg_replace('/-+/', '-', $string);
	    return $string;
	}
}