/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2018 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo and "Supercharged by SuiteCRM" logo. If the display of the logos is not
 * reasonably feasible for technical reasons, the Appropriate Legal Notices must
 * display the words "Powered by SugarCRM" and "Supercharged by SuiteCRM".
 */
var selected = 0;

var custom_individu = ['LBL_BENEFICIAIRE', 'LBL_OPS_INDIVIDU_OPS_DOSSIER_FROM_OPS_INDIVIDU_TITLE', 'LBL_PERSONNE_INDIVIDU', 'OPS_individu', 'LBL_MEDECIN_TRAITANT', 'LBL_PERSONNE_INDIVIDU_FONCTION', 'LBL_DOSSIER_PERSONNE_INDIVIDU_FONCTION', 'demandeur'];
var custom_personne_moral = ['LBL_OPS_PERSONNE_MORALE', 'LBL_PERSONNE_MORALE', 'LBL_INTERVENANT_MANDATAIRE_MOR', 'OPS_personne_morale'];

function showVariable(fld) {

    var regex = /^\$dossier_personne_individu_fonction|^\$personne_individu_fonction/;

    if (regex.test(fld) && $("#fonction_name").val()) {
        fld += '[fonction:' + $("#fonction_name").val() + ']';
    }
    $('#variable_text').val(fld);
}

function setType(type) {
    document.getElementById("type").value = type;
    populateModuleVariables(type);
}

function populateVariables(type) {
    document.getElementById('variable_name').innerHTML = '';
    document.getElementById('variable_text').value = '';

    if (type === 'LBL_OPS_INDIVIDU_OPS_DOSSIER_FROM_OPS_INDIVIDU_TITLE') {
        type = 'demandeur';
    }

    var selector = document.getElementById('variable_name');

    if (custom_individu.includes(type) || custom_personne_moral.includes(type)) {
        var variable_name = type.replace('LBL_', '');
        variable_name = variable_name.toLowerCase();

        if (custom_individu.includes(type)) {
            $('#variable_name').append(individu_field_list);
        }
        else {
            $('#variable_name').append(personne_morale_field_list);
        }

        $('select[name="variable_name"] option').each(function () {
            if ($(this).text().indexOf("LBL") >= 0) {
                $(this).hide();
            }
            else {
                $(this).val('$' + variable_name + '_' + $(this).val());
            }
        });
    }
    else {
        var reg_values = regularOptions[type];

        for (var i in reg_values) {
            var text_option = reg_values[i].replaceAll('&#039;', "'");
            if (!text_option.indexOf("LBL") >= 0) {
                selector.options[selector.options.length] = new Option(text_option, i);
            }
        }


        function NASort(a, b) {
            const collator = new Intl.Collator(undefined, { sensitivity: 'base' });

            if (a.innerHTML == 'NA') {
                return 1;
            }
            else if (b.innerHTML == 'NA') {
                return -1;
            }
            return collator.compare(a.innerHTML, b.innerHTML);
        };

        $(selector.options).sort(NASort).appendTo('select[name="variable_name"]');

    }
    $('#variable_name').val('#variable_name option:first');

    $('#variable_text').val($('#variable_name').val());
}

function populateModuleVariables(type) {
    var mod_values = moduleOptions[type];
    $('#fonction_name').hide();

    document.getElementById('module_name').innerHTML = '';

    var selector = document.getElementById('module_name');
    for (var i in mod_values) {
        selector.options[selector.options.length] = new Option(mod_values[i], i);
    }
    populateVariables(type);
}

function insert_variable(text) {
    if (text != '') {
        var inst = tinyMCE.getInstanceById("description");
        if (inst) inst.getWin().focus();
        inst.execCommand('mceInsertContent', false, text);
        inst.execCommand('mceToggleEditor');
        inst.execCommand('mceToggleEditor');
    }
}

function insertSample(smpl) {
    if (smpl != 0) {
        var body = tinyMCE.getInstanceById("description");
        var header = tinyMCE.getInstanceById("pdfheader");
        var footer = tinyMCE.getInstanceById("pdffooter");
        var cnf = true;
        if (body.getContent() != '' || header.getContent() != '' || footer.getContent() != '') {
            cnf = confirm(SUGAR.language.get('AOS_PDF_Templates', 'LBL_WARNING_OVERWRITE'));
        }
        if (cnf) {
            smpl = JSON.parse(smpl);
            setType(smpl[0]);
            body.setContent(smpl[1]);
            header.setContent(smpl[2]);
            footer.setContent(smpl[3]);
            selected = document.getElementById('sample').options.selectedIndex;
        }
        else {
            document.getElementById('sample').options.selectedIndex = selected;
        }
    }
}
$(document).ready(function () {

    function NASort(a, b) {
        const collator = new Intl.Collator(undefined, { sensitivity: 'base' });

        if (a.innerHTML == 'NA') {
            return 1;
        }
        else if (b.innerHTML == 'NA') {
            return -1;
        }
        return collator.compare(a.innerHTML, b.innerHTML);
    };

    // Valeur inutile, on supprime
    delete regularOptions.OPS_dossier.$ops_dossier_ops_commission_ops_dossier_name

    populateModuleVariables($("#type").val());

    $('#module_name').on('change', function () {

        function NASort(a, b) {
            const collator = new Intl.Collator(undefined, { sensitivity: 'base' });

            if (a.innerHTML == 'NA') {
                return 1;
            }
            else if (b.innerHTML == 'NA') {
                return -1;
            }
            return collator.compare(a.innerHTML, b.innerHTML);
        };

        if (!custom_individu.includes($(this).val()) && !custom_personne_moral.includes($(this).val())) {
            $('select[name="variable_name"] option').sort(NASort).appendTo('select[name="variable_name"]');
        }

        $('select[name="variable_name"]').prop("selectedIndex", 0);
        $("input[name='variable_text']").val($('select[name="variable_name"] option:selected').val());

        if ($(this).val() == 'LBL_DOSSIER_PERSONNE_INDIVIDU_FONCTION' || $(this).val() == 'LBL_PERSONNE_INDIVIDU_FONCTION') {
            $('#fonction_name').val('');
            $('#fonction_name').show();
        } else {
            $('#fonction_name').hide();
        }
    });

    $('#fonction_name').change(function () {
        if ($(this).val() != '') {
            $('#variable_text').val($('#variable_name').val() + '[fonction:' + $("#fonction_name").val() + ']');
        }
    });
});