<?php
/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2018 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo and "Supercharged by SuiteCRM" logo. If the display of the logos is not
 * reasonably feasible for technical reasons, the Appropriate Legal Notices must
 * display the words "Powered by SugarCRM" and "Supercharged by SuiteCRM".
 */

namespace SuiteCRM\SubPanel;

class SubPanelRowCounter
{
    /**
     * @var \SugarBean
     */
    private $focus;

    /**
     * @var array
     */
    private $subPanelDef;

    /**
     * SubPanelRowCounter constructor.
     * @param $focus
     */
    public function __construct($focus)
    {
        $this->focus = $focus;
    }

    /**
     * @param array $subPanelDef
     * @return int
     */
    public function getSubPanelRowCount($subPanelDef)
    {
        $this->setSubPanelDefs($subPanelDef);

        try {
            $count = $this->doGetSubPanelRowCount($this->subPanelDef);

            if ($count < 0) {
                throw new \Exception('sub panel row count can not be negative');
            }
            return $count;
        } catch (\Exception $e) {
            \LoggerManager::getLogger()->error($e->getMessage());
            return -1;
        }
    }

    /**
     * @param string[] $subPanelDef
     */
    public function setSubPanelDefs($subPanelDef)
    {
        $this->subPanelDef = $subPanelDef;
    }

    /**
     * @param array $subPanelDef
     * @return int
     */
    private function doGetSubPanelRowCount($subPanelDef)
    {
        
        if (!isset($subPanelDef['get_subpanel_data'])) {
            foreach ($subPanelDef['collection_list'] as $subSubPanelDef) {
                $subPanelRowCount = $this->doGetSubPanelRowCount($subSubPanelDef);

                if ($subPanelRowCount) {
                    return $subPanelRowCount;
                }
            }
            return 0;
        }

        return $this->getSingleSubPanelRowCount();
    }

    /**
     * @return int
     */
    public function getSingleSubPanelRowCount()
    {
        global $db, $current_user;

        $query = $this->makeSubPanelRowCountQuery();

        if( $this->subPanelDef["get_subpanel_data"] == "ops_dossier_ops_dossier" ){
            $query = "
            SELECT COUNT(ops_dossier_id) 
            FROM ops_dossier_ops_dossier 
            LEFT JOIN ops_dossier ON ops_dossier.id = ops_dossier_ops_dossier.ops_dossier_id
            WHERE ops_dossier_ops_dossier.ops_dossier_id2 = '" . $_REQUEST['record'] . "' 
            AND ops_dossier_ops_dossier.deleted=0 
            AND ops_dossier.name != 'TEMP' 
            LIMIT 1";
        }

        if( $this->subPanelDef["get_subpanel_data"] == "ops_dossier_ops_dossier_paiement" ){
            $query = "SELECT COUNT(ops_dossier_pere_id) 
            FROM ops_dossier_ops_dossier_paiement 
            WHERE ops_dossier_ops_dossier_paiement.ops_dossier_pere_id = '".$_REQUEST['record']."' 
            AND ops_dossier_ops_dossier_paiement.deleted=0 
            LIMIT 1";
        }

        if (!$query) {
            $add_query = ' AND ops_dossier.name != "TEMP" ';
            if(!$current_user->isAdmin())
            {
                if( isset($_SESSION['ops_requete_dossier']) && !empty($_SESSION['ops_requete_dossier']) ){
                    $add_query .= ' AND (' . $_SESSION['ops_requete_dossier'] . ')'; 
                }
            }
            
            #OPENSOCLE : sous panel custom 
            if( $this->subPanelDef["get_subpanel_data"] == "function:get_list_dossier_profil" ){
                $query = "SELECT COUNT(id) from ops_dossier where ops_personne_morale = '".$_REQUEST['record']."' AND ops_dossier.deleted = 0" . $add_query;
            }
            elseif( $this->subPanelDef["get_subpanel_data"] == "function:get_list_dossier_individu" ){
                $query = "SELECT COUNT(distinct(id)) from ops_dossier where ( ops_dossier.beneficiaire_id = '".$_GET['record']."' or  ops_dossier.id IN ( select ops_dossier_id from ops_individu_ops_dossier where ops_individu_id = '".$_GET['record']."'  AND ops_individu_ops_dossier.deleted = 0  ) )  AND ops_dossier.deleted = 0  " . $add_query;

            }
            elseif( $this->subPanelDef["get_subpanel_data"] == "function:ops_lien_parente_ops_individu" || $this->subPanelDef["get_subpanel_data"] == "function:ops_lien_parente_ops_individu_2"){
                $query = '
                SELECT COUNT(distinct(ops_lien_parente.id))
                FROM ops_lien_parente
                LEFT JOIN ops_lien_parente_ops_individu ON ops_lien_parente.id = ops_lien_parente_ops_individu.ops_lien_parente_id 
                LEFT JOIN ops_lien_parente_ops_individu_2 ON ops_lien_parente.id = ops_lien_parente_ops_individu_2.ops_lien_parente_id
                WHERE (ops_lien_parente_ops_individu.ops_individu_id = "' . $_REQUEST["record"] . '" AND ops_lien_parente_ops_individu.deleted = 0) OR (ops_lien_parente_ops_individu_2.ops_individu_id2 = "' . $_REQUEST['record'] . '" AND ops_lien_parente_ops_individu_2.deleted = 0)';
            }
            elseif ($this->subPanelDef["get_subpanel_data"] == "function:get_meetings_dossier_individu") {# SubPanel Rendez-vous
                $query = "
                SELECT COUNT(distinct(meetings.id))
                FROM meetings
                WHERE meetings.ops_individu_id = '" . $_REQUEST['record'] . "' AND meetings.deleted = 0  AND meetings.name != 'RDV_TEMP';";
            }
            else if( $this->subPanelDef["get_subpanel_data"] == "ops_engagement_ap_id" ){ // SubPanel Astre Engagement CP sur AP
                $query = "
                SELECT COUNT(ops_engagement_cp_id) 
                FROM ops_engagement_ops_engagement 
                LEFT JOIN ops_engagement ON ops_engagement.id = ops_engagement_ops_engagement.ops_engagement_ap_id
                WHERE ops_engagement_ops_engagement.ops_engagement_cp_id = '" . $_REQUEST['record'] . "' 
                AND ops_engagement_ops_engagement.deleted=0  
                LIMIT 1";
            }
            elseif( $this->subPanelDef["get_subpanel_data"] == "function:get_list_dossier_partenaire_individu" ){
                $query = "
                SELECT COUNT(distinct(ops_dossier.id))
                FROM ops_dossier_ops_avis, ops_avis, ops_dossier
                WHERE (
                    ops_avis.individu_id = '".$_GET['record']."'
                    AND ops_avis.id = ops_dossier_ops_avis.ops_avis_id
                    AND ops_dossier.id = ops_dossier_ops_avis.ops_dossier_id
                    AND ops_dossier.deleted = 0 AND ops_avis.deleted = 0 
                ) " . $add_query;
            }
            else
            {
                return -1;
            }
        }

        # SubPanel Documents : SubPanelRowCount...
        if( $this->subPanelDef["module"] == "Documents" ){

            # SubPanel Documents pour OPS_dossier
            # SubPanel Documents pour OPS_personne_morale
            # SubPanel Documents pour OPS_individu
            $table_ref_view_def = trim( $this->subPanelDef["get_subpanel_data"] );
            $field_ref_document = str_replace('_documents', '_id', $table_ref_view_def);

            if( in_array( $table_ref_view_def , [
                'ops_dossier_documents',
                'ops_personne_morale_documents',
                'ops_individu_documents',
            ]) ){

                $query = "
                SELECT COUNT(id) 
                FROM `documents` 
                WHERE documents.deleted=0 
                  AND documents.status_id != 'brouillon' 
                  AND id IN ( SELECT `document_id` AS `id` 
                                       FROM `".$table_ref_view_def."` 
                                       WHERE ".$table_ref_view_def.".deleted = 0 
                                        AND  ".$table_ref_view_def.".".$field_ref_document." = '".$_REQUEST['record']."' )";
                $query = trim( $query );
            }

        }# /. SubPanel Documents : SubPanelRowCount.

        $result = $db->query($query);
        if ($result === false) {
            return -1;
        }

        if ($row = $db->fetchByAssoc($result)) {

            return (int)array_shift($row);
        }

        return 0;
    }

    /**
     * @return string
     */
    public function makeSubPanelRowCountQuery()
    {
        $relationshipName = isset($this->subPanelDef['get_subpanel_data']) && $this->subPanelDef['get_subpanel_data'] ? $this->subPanelDef['get_subpanel_data'] : null;
        if (!$relationshipName) {
            throw new \Exception('relationship name can not be empty');
        }

        if (0 === strpos($relationshipName, 'function:')) {
            return $this->makeFunctionCountQuery($relationshipName);
        }

        if ($this->focus->load_relationship($relationshipName) !== false) {
            /** @var \Link2 $relationship */
            $relationship = $this->focus->$relationshipName;
            return $this->selectQueryToCountQuery($relationship->getQuery());
        }

        return '';
    }

    /**
     * @param $relationshipName
     * @return string
     */
    public function makeFunctionCountQuery($relationshipName)
    {
        include_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'utils.php';
        $functionName = substr($relationshipName, 9);
        $qry = [];
        $functionParameters = isset($this->subPanelDef['function_parameters']) && $this->subPanelDef['function_parameters'] ? $this->subPanelDef['function_parameters'] : null;
        if (null === $functionParameters) {
            \LoggerManager::getLogger()->warn('Function parameters is empty');
        }
        if (method_exists($this->focus, $functionName)) {
            $qry = $this->focus->$functionName($functionParameters);
        } elseif (\function_exists($functionName)) {
            $qry = $functionName($functionParameters);
        }
        if (\is_array($qry) && \count($qry)) {
            $qry = $qry['select'] . $qry['from'] . $qry['join'] . $qry['where'];
        }
        return $this->selectQueryToCountQuery($qry);
    }

    /**
     * @param string $selectQuery
     * @return string
     */
    public function selectQueryToCountQuery($selectQuery)
    {
        if (!\is_string($selectQuery)) {
            return '';
        }

        $selectQuery = trim(str_replace(["\n", "\t", "\r", '  '], ' ', $selectQuery));

        if (0 !== stripos($selectQuery, 'SELECT')) {
            return '';
        }

        $fromPos = strpos($selectQuery, ' FROM');
        if ($fromPos === false) {
            return '';
        }

        $selectPart = trim(substr($selectQuery, 7, $fromPos - 7));
        if (false !== strpos($selectPart, ',')) {
            return '';
        }

        $selectArr = explode(' ', $selectPart);
        $selectPartFirst = $selectArr[0];

        if (strpos($selectPartFirst, '*') !== false) {
            $selectPartFirst = \str_replace('*', 'id', $selectPartFirst);
        }

        return 'SELECT COUNT(' . $selectPartFirst . ')' . substr($selectQuery, $fromPos) . ' LIMIT 1';
    }
}
