<?php
if (!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');

class SecurityGroupsViewEdit extends ViewEdit
{
    public function __construct()
    {
        parent::__construct();
    }

    function display()
    {
        $habilitation_field = [
            'visualisation',
            'assignation',
            'correction',
            'duplication',
            'execution',
            'instruction',
            'edition',
            'suppression'
        ];

        $smarty = new Sugar_Smarty();

        $obj_dispositif = new OPS_dispositif();
        $dispositifs = $obj_dispositif->get_full_list('name');

        // Récupération des dispositifs liés au profil métier 
        $this->bean->load_relationship('ops_habilitation_dispositif_securitygroups');
        $habilitation_ids = $this->bean->ops_habilitation_dispositif_securitygroups->get();
        
        $habilitation_dispositifs = array();
        if (!empty($habilitation_ids)) 
        {
            // Boucle sur les habilitations dispositifs 
            foreach ($habilitation_ids as $habiliatation_id) 
            {
                $obj_habilitation_dispositif = BeanFactory::getBean('OPS_habilitation_dispositif', $habiliatation_id);

                if( !empty($obj_habilitation_dispositif))
                {
                    // Récupération des habilitations du dispositif
                    $habilitation_dispositifs[$obj_habilitation_dispositif->ops_dispositif_id] = $obj_habilitation_dispositif->get_habilitations() ;                         
                }
            }
        }
        
        $habilitation_partielle = (!empty($this->bean->habilitation_partielle)) ? json_decode( base64_decode($this->bean->habilitation_partielle), true) : '';

        $dispositifs_data = [];
        $modal_list = [];
        foreach($dispositifs as $dispositif)
        {
            $dispositif_data = [
                'id'   => $dispositif->id,
                'name' => $dispositif->name,
            ];

            $habilitation_dispositif = '';
            if(is_array($habilitation_dispositifs) && array_key_exists($dispositif->id, $habilitation_dispositifs))
            {
                $habilitation_dispositif = $habilitation_dispositifs[$dispositif->id];

                foreach($habilitation_field as $field)
                {
                    $value = 'none';
                    if (!empty($habilitation_partielle) && array_key_exists($dispositif->id, $habilitation_partielle) && array_key_exists($field, $habilitation_partielle[$dispositif->id]))
                    {
                        $value = 'partielle';
                    }
                    else if (isset($habilitation_dispositif[$field]))
                    {
                        $value = $this->getValue($habilitation_dispositif[$field]);
                    }
                    $dispositif_data[$field] = $value;
                }
            }

            $dispositif->load_relationship('ops_guide_instruction_ops_dispositif');

            $guide_instruction = BeanFactory::getBean('OPS_guide_instruction', $dispositif->ops_guide_instruction_ops_dispositif->get()[0]);
            $etapes = $guide_instruction->get_linked_beans('ops_guide_instruction_ops_etape' , 'OPS_etape');

            $etapes_data = [];
            foreach($etapes as $etape)
            {
                $etapes_data[$etape->id] = [
                    'id'   => $etape->id,
                    'name' => $etape->name,

                ];
            }

            if(!empty($habilitation_dispositif) && array_key_exists('etapes', $habilitation_dispositif))
            {
                foreach($habilitation_dispositif['etapes'] as $etape_id => $habilitation_dispositif_etape)
                {
                    foreach($habilitation_dispositif_etape as $habilitation_etape => $value)
                    {
                        $etapes_data[$etape_id][$habilitation_etape] = $this->getValue($value);
                    }
                }
            }
            $dispositif_data['etapes'] = $etapes_data;


            $modal_visualisation = $this->build_modal([
                'dispositif_data'    => $dispositif_data,
                'habilitation_label' => 'Accès',
                'habilitation'       => 'visualisation',
            ]);

            $modal_instruction = $this->build_modal([
                'dispositif_data'    => $dispositif_data,
                'habilitation_label' => 'Instruction',
                'habilitation'       => 'instruction',
            ]);

            $modal_edition = $this->build_modal([
                'dispositif_data'    => $dispositif_data,
                'habilitation_label' => 'Edition',
                'habilitation'       => 'edition',
            ]);

            $modal_list[$dispositif->id] = [
                'edition'       => $modal_edition,
                'instruction'   => $modal_instruction,
                'visualisation' => $modal_visualisation,
            ];

            $dispositifs_data[$dispositif->id] = $dispositif_data;
        }

        $smarty->assign('assigned_user_id',         $this->bean->assigned_user_id);
        $smarty->assign('assigned_user_name',       $this->bean->assigned_user_name);
        $smarty->assign('bridage_page_accueil_c',   $this->bean->bridage_page_accueil_c);
        $smarty->assign('dispositif_data',          $dispositifs_data);
        $smarty->assign('habilitation_dispositifs', base64_encode (json_encode($dispositifs_data)));
        $smarty->assign('habilitation_partielle',   $this->bean->habilitation_partielle);
        $smarty->assign('name',                     $this->bean->name);
        $smarty->assign('modal_list',               $modal_list);
        $smarty->assign('noninheritable',           $this->bean->noninheritable);
        $smarty->assign('record',                   $this->bean->id);
        $smarty->assign('titre',                    'edition');

        // Partie Individu

        $onglets_individu_list = [
            'autorisations_attestations' => [
                'id' => 'autorisations_attestations',
                'name' => 'autorisations et attestations',
                'value' => ($this->bean->autorisations_attestations == 1) ? 'checked' : '',
            ],
            'fiche_sante' =>[
                'id' => 'fiche_sante',
                'name' => 'fiche santé',
                'value' => ($this->bean->fiche_sante == 1) ? 'checked' : '',
            ],
            'regime_alimentaire' =>[
                'id' => 'regime_alimentaire',
                'name' => 'régime alimentaire',
                'value' => ($this->bean->regime_alimentaire == 1) ? 'checked' : '',
            ],
            'situation_professionnelle' =>[
                'id' => 'situation_professionnelle',
                'name' => 'situation professionnelle',
                'value' => ($this->bean->situation_professionnelle == 1) ? 'checked' : '',
            ],
        ];
        
        $smarty->assign('onglets_individu_list',  $onglets_individu_list);

        $smarty->assign('journal_modification', ($this->bean->journal_modification == 1) ? 'checked' : '');
        $smarty->assign('individu_calendrier', ($this->bean->individu_calendrier == 1) ? 'checked' : '');
        $smarty->assign('profil_calendrier', ($this->bean->profil_calendrier == 1) ? 'checked' : '');

        $current_template = "custom/modules/SecurityGroups/tpls/edit.tpl";

        $smarty->display($current_template);
    }

    private function build_modal($params = array())
    {
        if (!is_array($params)) {
            return '';
        }

        $dispositif_data         = (isset($params['dispositif_data']))         ? $params['dispositif_data']         : '';
        $habilitation            = (isset($params['habilitation']))            ? $params['habilitation']            : '';
        $habilitation_label      = (isset($params['habilitation_label']))      ? $params['habilitation_label']      : '';

        $modal =  '<div id="modal-' . $habilitation . '-' . $dispositif_data['id'] . '" class="modal" tabindex="-1" role="dialog">';
        $modal .= '  <div class="modal-dialog" style="max-width: 800px;">';
        $modal .= '     <div class="modal-content">';
        $modal .= '         <div class="modal-header">';
        $modal .= '             <button type="button" class="close" data-dismiss="modal" aria-hidden="true">x</button>';

        $titre = '';
        if(!empty($this->bean->name)) {
            $titre = '“' . $this->bean->name . '”';
        }

        $modal .= '                 <h4 class="modal-title" id="titre_modal_' . $habilitation . '">Habilitations du profil</h4><h4> Personnalisation du dispositif “' . $dispositif_data['name'] . '”</h4>';
        $modal .= '             </button>';
        $modal .= '         </div>';
        $modal .= '         <div id="modal-' . $habilitation . '-body" class="modal-body" style="min-height: 78px;">';
        $modal .= '             <table class="table table-bordered">';
        $modal .= '                 <thead>';
        $modal .= '                     <tr>';
        $modal .= '                         <th scope="col">Étapes du guide d’instruction</th>';
        $modal .= '                         <th scope="col">' . $habilitation_label . '</th>';
        $modal .= '                     </tr>';
        $modal .= '                 </thead>';
        $modal .= '                 <tbody>';

        if(is_array($dispositif_data['etapes']))
        {
            foreach($dispositif_data['etapes'] as $etape)
            {   
                if(!empty($etape['id']))
                {
                    $value = 'none';
                    if( array_key_exists($habilitation, $etape) )
                    {
                        $value = $dispositif_data['etapes'][$etape['id']][$habilitation];
                    }

                    $modal .= '                 <tr id="' . $etape['id'] . '" data-role="etape">';
                    $modal .= '                     <th scope="row">';
                    $modal .=                           $etape['name'];
                    $modal .= '                     </th>';
                    $modal .= '                     <td>';
                    $modal .= '                         <i class="far" id="' . $habilitation . '_' . $etape['id'] . '" name="' . $habilitation . '_' . $etape['id'] . '" data-role="habilitation-etape" data-name="' . $habilitation . '" data-value="' . $value . '"></i>';
                    $modal .= '                     </td>';
                    $modal .= '                 </tr>';
                }
            }
        }

        $modal .= '                 </tbody>';
        $modal .= '             </table>';
        $modal .= '         </div>';
        $modal .= '     </div>';
        $modal .= '  </div>';
        $modal .= '</div>';

        return $modal;
    }

    private function getValue($habilitation_value)
    {
        $value = 'none';

        if( $habilitation_value == 1 )
        {
            $value = 'all';
        }

        return $value;
    }
}