<?php

/*
 * Vérifie la validité de la clef profil et la supprimer si obsolète
 *
 */

$job_strings[] = 'verifier_validite_clef_profil';

function verifier_validite_clef_profil()
{
    global $db, $sugar_config;

    if(!empty($sugar_config['opensocle']['profil_delai_validite_clef'])){
        $query =    "SELECT id 
                    FROM ops_personne_morale_individu 
                    WHERE ops_personne_morale_individu.deleted = 0
                    AND ops_personne_morale_individu.statut_clef = 'nouveau'
                    AND CURDATE() > ops_personne_morale_individu.date_expiration;"; 
        $result = $db->query($query);

        while($row = $db->fetchByAssoc($result)){
            if(!empty($row['id'])){
                $objProfilIndividu = BeanFactory::getBean('OPS_personne_morale_individu',$row['id']);
                if(!empty($objProfilIndividu->id)){
                    $objProfilIndividu->statut_clef = 'perime';
                    $objProfilIndividu->save();
                }
            }
        }
    }

    if(!empty($sugar_config['opensocle']['profil_delai_suppression_clef'])){
        $query =    "SELECT id 
                    FROM ops_personne_morale_individu 
                    WHERE ops_personne_morale_individu.deleted = 0
                    AND (ops_personne_morale_individu.statut_clef = 'perime'
                    AND CURDATE() >= DATE_ADD(ops_personne_morale_individu.date_expiration, INTERVAL ".$sugar_config['opensocle']['profil_delai_suppression_clef']." day))
                    || (ops_personne_morale_individu.statut_clef = 'revoque'
                    AND CURDATE() >= DATE_ADD(ops_personne_morale_individu.date_revocation, INTERVAL ".$sugar_config['opensocle']['profil_delai_suppression_clef']." day))"; 
        $result = $db->query($query);

        while($row = $db->fetchByAssoc($result)){
            if(!empty($row['id'])){
                $objProfilIndividu = BeanFactory::getBean('OPS_personne_morale_individu',$row['id']);
                if(!empty($objProfilIndividu->id)){
                    $objProfilIndividu->mark_deleted($id);
                    $objProfilIndividu->save();
                }
            }
        }
    }
    return true;
}