<?php 
 //WARNING: The contents of this file are auto-generated


/*
 * Gestion des actions retardées
 *
 */

$job_strings[] = 'generer_donnees';

use ODE\Model\DossierModel;

function generer_donnees()
{
    require_once('modules/Configurator/Configurator.php');
    
    $configuratorObj = new Configurator();

    $configuratorObj->loadConfig();
    
    $nombre     = $configuratorObj->config['generateur_donnees']['nombre_dossier'];
    $typeProfil = $configuratorObj->config['generateur_donnees']['type_profil'];
    $dispositif = $configuratorObj->config['generateur_donnees']['dispositif'];
    $email      = $configuratorObj->config['generateur_donnees']['email'];

    $nombreDossierIndividu = 10;
    $nombreDossierMax = 100;

    if( !empty($nombre) && !empty($dispositif) && $nombre > 0)
    {
        $user_nombre = (!empty($configuratorObj->config['generateur_donnees']['user_nombre'])) ? $configuratorObj->config['generateur_donnees']['user_nombre'] : 0;

        if($nombre > $nombreDossierMax)
        {
            $nombre = $nombreDossierMax;
        }

        $nombre = $nombre / $nombreDossierIndividu;

        $nombre = $user_nombre + $nombre;

        for($i = $user_nombre + 1; $i <= $nombre; ++$i)
        {
            $userName = 'UserTest ' . $i;

            //Créer individu
            $objIndividu = BeanFactory::newBean('OPS_individu');
            $objIndividu->last_name  = $userName;
            $objIndividu->first_name = $userName;

            if(!empty($email))
            {
                $objIndividu->email1     = $email;
            }

            $individu = $objIndividu->save();

            if(!empty($typeProfil))
            {
                //Créer personne morale
                $objPersonneMorale = BeanFactory::newBean('OPS_personne_morale');
                $objPersonneMorale->name = $userName;
                $personneMorale = $objPersonneMorale->save();
                $objPersonneMorale->load_relationship('ops_type_personne_ops_personne_morale');
                $objPersonneMorale->ops_type_personne_ops_personne_morale->add($typeProfil);

                //Créer personne morale individu
                $objPersonneMoraleIndividu = BeanFactory::newBean('OPS_personne_morale_individu');
                $objPersonneMoraleIndividu->save();
                $objPersonneMoraleIndividu->load_relationship('ops_individu_ops_personne_morale_individu');
                $objPersonneMoraleIndividu->ops_individu_ops_personne_morale_individu->add($individu);
                $objPersonneMoraleIndividu->load_relationship('ops_personne_morale_ops_personne_morale_individu');
                $objPersonneMoraleIndividu->ops_personne_morale_ops_personne_morale_individu->add($personneMorale);
            }

            for($j = 0; $j <= $nombreDossierIndividu; ++$j)
            {
                //Créer les dossiers
                $objDossier = BeanFactory::newBean('OPS_dossier');

                if(!empty($personneMorale))
                {
                    $objDossier->ops_personne_morale = $personneMorale;
                }

                $objDossier->beneficiaire_id = $individu;
                $objDossier->brouillon = 'non';
                $objDossier->type_tiers = 'OPS_individu';
                $objDossier->date_avancement = date("Y-m-d");
                $objDossier->save();
                $objDossier = OPS_dossier::initStatutEtapeDossier($objDossier, $dispositif);
                $objDossier->num_dossier = DossierModel::getNumDossier($objDossier->id);
                $objDossier->name = (!empty($objDossier->libelle_dossier)) ? $objDossier->num_dossier . " - " . $objDossier->libelle_dossier : (string)$objDossier->num_dossier;
                $objDossier->save();
                $objDossier->load_relationship('ops_dispositif_ops_dossier');
                $objDossier->ops_dispositif_ops_dossier->add($dispositif);
                $objDossier->load_relationship('ops_individu_ops_dossier');
                $objDossier->ops_individu_ops_dossier->add($individu);

                if(!empty($configuratorObj->config['generateur_donnees']['sous_territoire']))
                {
                    $objSousTerritoire = BeanFactory::getBean('OPS_sous_territoire', $configuratorObj->config['generateur_donnees']['sous_territoire']);
                    $objSousTerritoire->load_relationship('ops_sous_territoire_ops_dossier');
                    $objSousTerritoire->ops_sous_territoire_ops_dossier->add($objDossier->id);

                }
            }
        }

        $configuratorObj->config['generateur_donnees']['nombre_dossier'] = $configuratorObj->config['generateur_donnees']['nombre_dossier'] - ($nombreDossierIndividu * ($nombre - $user_nombre));
        $configuratorObj->config['generateur_donnees']['user_nombre'] = $user_nombre + $nombre;

        $configuratorObj->saveConfig();
    }

    return true;
} 
 
/*
 * Gestion des rappels des rendez-vous 
 *
 */

$job_strings[] = 'notification_justificatifs';

use ODE\Mailer\OdeEmail;
use ODE\Mailer\OdeMailer;

function notification_justificatifs()
{
    global $db, $sugar_config, $beanFiles;
    
    require_once($beanFiles["OPS_justificatif"]);
    
    $requete = $db->query(
        "SELECT ops_justificatif.id as id_justificatif,
            ops_type_document.id as id_type_document,
            ops_type_document.name as nom_document,
            ops_type_document.ops_notifications_email_id as id_modele_email,
            ops_type_document.objet as objet
        FROM ops_justificatif, ops_type_document_ops_justificatif , ops_type_document 
        WHERE ops_justificatif.id = ops_type_document_ops_justificatif.ops_justificatif_id 
        AND ops_type_document_ops_justificatif.ops_type_document_id = ops_type_document.id 
        AND ops_type_document.notification =  true
        AND ( ops_justificatif.statut  = 'rejete' OR ops_justificatif.statut  = 'non_fourni')
        AND ops_justificatif.notification = false
        AND ops_justificatif.date_modified < DATE_ADD(UTC_TIMESTAMP(), INTERVAL -ops_type_document.nb_jours day)
        LIMIT 10 "
    );

    while ($row = $db->fetchRow($requete)) {
        $liste_justificatifs[$row['id_justificatif']] = $row; 
    }

    if( count($liste_justificatifs) > 0 ){

        foreach ($liste_justificatifs as $id_justif => $un_justif) {
            // Récupération du type de document 
            $id_modele_mail = $un_justif['id_modele_email']; 

            if ( !empty($id_modele_mail) ) {

                $obj_justificatif = BeanFactory::getBean('OPS_justificatif',$un_justif['id_justificatif']);

                // Récupération de l'objet du mail : 
                switch ($un_justif['objet']) {
                    case 'dossier':
                        $bean_source_name = 'OPS_dossier';
                        $obj_justificatif->load_relationship("ops_dossier_ops_justificatif");
                        $liste_beans = $obj_justificatif->ops_dossier_ops_justificatif->getBeans() ; 
                        foreach ($liste_beans as $key => $bean) {
                            $objet = $bean ; 
                        }
                        // Récupération du demandeur : 
                        $obj_individu = new OPS_individu();
                        $obj_individu->retrieve( $objet->ops_individu_id ); 
                        $email = $obj_individu->email1;
                        $type_historique = 'OPS_individu';
                        $id_historique = $objet->ops_individu_id;
                        break;
                    case 'tiers':
                        $bean_source_name = 'OPS_personne_morale';
                        $obj_justificatif->load_relationship("ops_personne_morale_ops_justificatif");
                        $liste_beans = $obj_justificatif->ops_personne_morale_ops_justificatif->getBeans() ; 
                        foreach ($liste_beans as $key => $bean) {
                            $objet = $bean ; 
                        }
                        $email = $objet->email1;
                        $type_historique = 'OPS_personne_morale';
                        $id_historique = $objet->id;
                        break;
                    default:   
                        $GLOBALS['log']->fatal('Justififs - Objet non pris en compte ' . $un_justif['objet'] );
                        continue;
                }

                if( !empty( $email ) ){

                    # On initialise le mailer 
                    $mailer = new OdeMailer();

                    # On initialise l'email 
                    $ode_email = new OdeEmail([
                        'bean_source_id' => $objet->id,
                        'bean_source_name' => $bean_source_name,
                        'bean_historisation_id' => $id_historique,
                        'bean_historisation_name' => $type_historique,
                        'email_template_id' => $id_modele_mail,
                        'dest_to' => $email,
                    ]);

                    # On déclenche l'envoie
                    $mailer->send($ode_email);

                    $obj_justificatif->notification = true; 
                    $obj_justificatif->save();
                }

            }
            else{
                $GLOBALS['log']->fatal('Justififs - Notification pas de modèle mail pour le type ' . $un_justif['id_modele_email']);

            }
        }
    }
    
    return true;
} 
 

/*
 * Supprime les justificatifs périmés
 *
 */

$job_strings[] = 'supprimer_justificatif';

function supprimer_justificatif()
{
    global $beanFiles, $db;
    
    require_once($beanFiles["OPS_justificatif"]);

    require_once('modules/Configurator/Configurator.php');

    $configuratorObj = new Configurator();
    $jours_perime = $configuratorObj->config['opensocle']['justificatif_jours_perime'];
    $jours_perime = (isset($jours_perime) && !empty($jours_perime)) ? $jours_perime : 0;

    $query = "
        SELECT id 
        FROM ops_justificatif 
        WHERE deleted = 0 
        AND statut = 'perime' 
        AND date_modified <= DATE_ADD(UTC_TIMESTAMP(), INTERVAL -" . $jours_perime . " day)";

    $requete = $db->query($query);

    while ($row = $db->fetchRow($requete)) 
    {
        $obj_justificatif = BeanFactory::getBean('OPS_justificatif', $row['id']);
        $obj_justificatif->mark_deleted($row['id']);
        $obj_justificatif->save();
    }

    return true;
}

/*
 * Gestion des actions retardées
 *
 */

$job_strings[] = 'execution_retarde';

use ODE\ActionStatut\OdeActionStatut;

function execution_retarde()
{
    global $db, $sugar_config, $beanFiles;
    
    $requete = $db->query(
        "SELECT id, ops_action_id, ops_dossier_id, ops_statut_id
        FROM ops_action_retarde
        WHERE deleted = 0
        AND date_declenchement < UTC_TIMESTAMP()
        LIMIT 50"
    );

    $rowResults = array();
    while ($row = $db->fetchRow($requete)) {
        $listeActionRetarde[$row['id']] = $row; 
    }

    foreach ($listeActionRetarde as $actionRetarde) {

        $objDossier = BeanFactory::getBean('OPS_dossier',$actionRetarde['ops_dossier_id']);
        if($actionRetarde['ops_statut_id'] == $objDossier->ops_statut_id){
            $objAction = BeanFactory::getBean('OPS_action_statut',$actionRetarde['ops_action_id']);
            $action_statut = new OdeActionStatut($objAction, $objDossier);
            $action_statut->execute();
            $objActionRetarde = BeanFactory::getBean('OPS_action_retarde',$actionRetarde['id']);
            $objActionRetarde->mark_deleted($actionRetarde['id']);
            $objActionRetarde->save();
        }
        else
        {
            $objStatut = BeanFactory::getBean('OPS_statut', $objDossier->ops_statut_id);
            $objAction = BeanFactory::getBean('OPS_action_statut',$actionRetarde['ops_action_id']);

            $GLOBALS['log']->fatal('Instruction - exécution retardée => statut différent' . PHP_EOL . print_r(array(
                'Num_dossier' => $objDossier->num_dossier,
                'statut' => $objStatut->name,
                'action' => $objAction->name,
            ), true));

            $objActionRetarde = BeanFactory::getBean('OPS_action_retarde',$actionRetarde['id']);
            $objActionRetarde->mark_deleted($actionRetarde['id']);
            $objActionRetarde->save();
        }
    }

    return true;
} 

/*
 * Gestion des rappels des rendez-vous 
 *
 */

$job_strings[] = 'supprimer_brouillon';

function supprimer_brouillon()
{
    global $db, $sugar_config, $beanFiles;

    $requete = $db->query(
        "SELECT ops_dossier.id
        FROM ops_dossier, ops_dispositif_ops_dossier, ops_dispositif
        WHERE ops_dossier.id = ops_dispositif_ops_dossier.ops_dossier_id 
        AND ops_dispositif_ops_dossier.ops_dispositif_id = ops_dispositif.id
        AND ops_dossier.brouillon = 'oui'
        AND ops_dossier.name != 'TEMP'
        AND ops_dossier.deleted = 0
        AND ops_dossier.flag_suppression = 0
        AND ops_dispositif.supression_brouillon = 1
        AND ops_dossier.date_modified < DATE_ADD(UTC_TIMESTAMP(), INTERVAL -ops_dispositif.delai_notification_suppression day)
        LIMIT 30"
    );

    while ($row = $db->fetchRow($requete)) {
        $objDossier = BeanFactory::getBean('OPS_dossier',$row['id']);
        $bean_source_name = 'OPS_dossier';
        # Récupération du demandeur : 
        $obj_individu = BeanFactory::getBean('OPS_individu',$objDossier->ops_individu_id);
        $email = $obj_individu->email1;
        $type_historique = 'OPS_individu';
        $id_historique = $objDossier->ops_individu_id;
        if( !empty( $email ) && !empty($sugar_config['opensocle']['notif_usager_dossier_avant_suppression']) ){

            # On initialise le mailer 
            $mailer = new OdeMailer();

            # On initialise l'email 
            $ode_email = new OdeEmail([
                'bean_source_id' => $objDossier->id,
                'bean_source_name' => $bean_source_name,
                'bean_historisation_id' => $id_historique,
                'bean_historisation_name' => $type_historique,
                'email_template_id' => $sugar_config['opensocle']['notif_usager_dossier_avant_suppression'],
                'dest_to' => $email,
            ]);

            # On déclenche l'envoie
            $mailer->send($ode_email);
        }

        $query = 'UPDATE ops_dossier SET flag_suppression = 1 WHERE ops_dossier.id = "' . $objDossier->id . '"';

        $db->query($query);
    }
    
    $requete2 = $db->query(
        "SELECT ops_dossier.id
        FROM ops_dossier, ops_dispositif_ops_dossier, ops_dispositif
        WHERE ops_dossier.id = ops_dispositif_ops_dossier.ops_dossier_id 
        AND ops_dispositif_ops_dossier.ops_dispositif_id = ops_dispositif.id
        AND ops_dossier.brouillon = 'oui'
        AND ops_dossier.name != 'TEMP'
        AND ops_dossier.deleted  = 0
        AND ops_dossier.flag_suppression = 1
        AND ops_dispositif.supression_brouillon = 1
        AND ops_dossier.date_modified < DATE_ADD(UTC_TIMESTAMP(), INTERVAL -ops_dispositif.delai_suppression day)"
    );

    while ($row = $db->fetchRow($requete2)) {
        $objDossier = BeanFactory::getBean('OPS_dossier',$row['id']);
        $objDossier->mark_deleted($row['id']);
        $objDossier->save();
    }

    return true;
} 


/*
 * Gestion des dossiers temporaires
 *
 */

$job_strings[] = 'supprimer_dossier_temp';

function supprimer_dossier_temp()
{
    global $db;

    $requete = $db->query(
        "SELECT ops_dossier.id
        FROM ops_dossier
        WHERE ops_dossier.name = 'TEMP' AND deleted = 0
        AND date_entered <= DATE_ADD(UTC_TIMESTAMP(), INTERVAL -1 day)
        LIMIT 30"
    );

    while ($row = $db->fetchRow($requete)) {
        $obj_dossier = BeanFactory::getBean('OPS_dossier', $row['id']);
        $obj_dossier->mark_deleted($row['id']);
        $obj_dossier->save();
    }

    return true;
}
 

$job_strings[] = 'purge_bd_avec_delai';

/**
 * Fonction de purge des elements flaggé deleted en bdd
 * basé sur la tache planifié de suitecrm "pruneDatabase"
 */
function purge_bd_avec_delai()
{

    $GLOBALS['log']->fatal(print_r("## Lancement de la tache planifié de purge de BDD ##",true));
    $backupDir = sugar_cached('backups');
    $backupFile = 'backup-deleted-OpenCRM-' . date("Y-m-d_H-i-s") . '.php';

    /* Recuperation du delais de la purge */
    $configuratorObj = new Configurator();
    $configuratorObj->loadConfig();
    $delai = $configuratorObj->config['opensocle']['delai_purge_bdd'] ?? 30;

    $GLOBALS['log']->fatal(print_r("# Delai de suppression définitive : $delai jours",true));

    $db = DBManagerFactory::getInstance();
    $tables = $db->getTablesArray();
    $queryString = array();

    if (!empty($tables)) {
        foreach ($tables as $kTable => $table) {

            // find tables with deleted=1
            $columns = $db->get_columns($table);
            
            /* On va controler le delai avec la date modifié, donc si cette colonne n'existe pas on ne purge pas cette table */
            if(!array_key_exists("date_modified", $columns)){
                $GLOBALS['log']->fatal(print_r("# Table :  " . $table,true));
                $GLOBALS['log']->fatal(print_r("# La colonne 'date_modified' n'existe pas, cette table ne peut être purgée.",true));
                continue;
            }
            if (empty($columns['deleted'])) {
                continue;
            }

            /* Gestion des colonnes custom pour la creation du BACKUP, normalement on en a pas, mais on sait jamais */
            $custom_columns = array();
            if (array_search($table . '_cstm', $tables, true)) {
                $custom_columns = $db->get_columns($table . '_cstm');
                if (empty($custom_columns['id_c'])) {
                    $custom_columns = array();
                }
            }

            /*
                Recuperation des lignes à supprimer
                DATE_ADD(date_modified, INTERVAL X DAY) : (exemple) date modifié le 1er janvier + X jrs
                Si cette date est inferieur a la date du jour, c'est qu'on a depassé le delai 
            */
            $qDel = "SELECT * 
                     FROM $table 
                     WHERE deleted = 1 and  DATE_ADD(date_modified, INTERVAL " . $delai . " DAY) < CURDATE()";
            $rDel = $db->query($qDel);


            // make a backup INSERT query if we are deleting.
            while ($aDel = $db->fetchByAssoc($rDel, false)) {

                // build column names
                $queryString[] = $db->insertParams($table, $columns, $aDel, null, false);

                if (!empty($custom_columns) && !empty($aDel['id'])) {
                    $qDelCstm = 'SELECT * FROM ' . $table . '_cstm WHERE id_c = ' . $db->quoted($aDel['id']);
                    $rDelCstm = $db->query($qDelCstm);

                    // make a backup INSERT query if we are deleting.
                    while ($aDelCstm = $db->fetchByAssoc($rDelCstm)) {
                        $queryString[] = $db->insertParams($table, $custom_columns, $aDelCstm, null, false);
                    } // end aDel while()

                    $db->query('DELETE FROM ' . $table . '_cstm WHERE id_c = ' . $db->quoted($aDel['id']));
                }
            } // end aDel while()

            // now do the actual delete
            $db->query("DELETE FROM " . $table . " WHERE deleted = 1 and  DATE_ADD(date_modified, INTERVAL " . $delai . " DAY) < CURDATE()");

        } 
        if (!file_exists($backupDir) || !file_exists($backupDir . '/' . $backupFile)) {
            // create directory if not existent
            mkdir_recursive($backupDir, false);
        }

        // write cache file
        write_array_to_file('pruneDatabase', $queryString, $backupDir . '/' . $backupFile);

        $GLOBALS['log']->fatal(print_r("## Sauvegarde du backup : " . $backupDir . '/' . $backupFile,true));
        $GLOBALS['log']->fatal(print_r('## FIN DE LA TACHE PLANIFIEE DE PURGE DE BDD ##',true));
        return true;
    }

    $GLOBALS['log']->info('## FIN DE LA TACHE PLANIFIEE DE PURGE DE BDD ##');
    return false;
}


$job_strings[] = 'anonymisation_dossier_cloture';

function anonymisation_dossier_cloture(){

    global $db;


    $GLOBALS['log']->fatal(print_r("## LANCEMENT DE LA TÂCHE PLANIFIÉ D'ANONYMISATION DES DOSSIERS",true));

    // fonction anonyme pour factoriser la recherche + creation du profil/individu anonyme
    $recuperationOuCreationAnonyme = function($table, $champ) use ($db) {
        $sql = "SELECT id FROM ops_$table WHERE $champ LIKE '%Anonyme%' AND deleted = 0";
        $res = $db->query($sql);
        $id = $db->fetchRow($res)['id'] ?? false;
    
        if (!$id) {
            $bean = BeanFactory::newBean("OPS_$table");
            $bean->$champ = "ANONYME";
            $bean->save();
            $id = $bean->id;
        }
        return $id;
    };

    // recherche et creation des anonymes
    $idIndividuAnonyme = $recuperationOuCreationAnonyme("individu", "last_name");
    $idProfilAnonyme = $recuperationOuCreationAnonyme("personne_morale", "name");

    /* Recuperation des dossier qui cloturé qui ont dépassé le delai et qui n'ont pas deja été anonymisé */
    /* DATE_ADD(ops_dossier.date_modified, INTERVAL ops_dispositif.delai_suppression DAY) < CURDATE() renvoi null si le delai de suppression est a null */
    $sqlDossier = "SELECT 
                ops_dossier_id AS dossierId
            FROM   ops_dispositif_ops_dossier
            INNER JOIN ops_dispositif
                ON ops_dispositif_id = ops_dispositif.id
            INNER JOIN ops_dossier
                ON ops_dossier.id = ops_dossier_id
            WHERE  ops_dispositif_ops_dossier.deleted = 0
            AND ops_dispositif.deleted = 0
            AND ops_dossier.cloture = 1
            AND ops_dossier.flag_anonymise = 0
            AND DATE_ADD(ops_dossier.date_modified, INTERVAL ops_dispositif.delai_anonymisation_cloture DAY) < CURDATE()";

    $res = $db->query($sqlDossier);
    
    while ($dossier = $db->fetchByAssoc($res, false)) {
        $GLOBALS['log']->fatal(print_r("# Anonymisation du dossier d'id : " . $dossier['dossierId'],true));

        // recupereation du bean Dossier
        $beanDossier = BeanFactory::getBean("OPS_dossier", $dossier['dossierId']);

        // anonymisation profil et beneficiaire
        if(!empty($beanDossier->ops_personne_morale)) $beanDossier->ops_personne_morale = $idProfilAnonyme;
        if(!empty($beanDossier->beneficiaire_id)) $beanDossier->beneficiaire_id = $idIndividuAnonyme;

        // recuperation de la derniere date de modification avec formatage datetime => cloture du dossier
        $derniereDateModifie = date('Y-m-d H:i:s', strtotime($beanDossier->date_modified));

        $beanDossier->save();

        // anonymisation demandeur
        $beanDossier->load_relationship("ops_individu_ops_dossier");
        $demandeurBean = reset($beanDossier->ops_individu_ops_dossier->getBeans()); // premier bean 
        $beanDossier->ops_individu_ops_dossier->delete($dossier['dossierId'], $demandeurBean); // suppression ancienne relation
        $beanDossier->ops_individu_ops_dossier->add($idIndividuAnonyme); // ajout relation avec anonyme

        // requête pour remettre la derniere date de modification (sans passer par le bean) du dossier sinon on perd la date de cloture du dossier
        $sqlChangementDeDate = "update ops_dossier set flag_anonymise = 1, date_modified = '$derniereDateModifie' where id='" . $dossier['dossierId'] . "'";
        $db->query($sqlChangementDeDate);

    }

    $GLOBALS['log']->fatal(print_r("## FIN DE LA TÂCHE PLANIFIÉ D'ANONYMISATION DES DOSSIERS",true));

    return true;
}
 

$job_strings[] = 'suppression_dossier_cloture';

function suppression_dossier_cloture(){

    global $db;


    $GLOBALS['log']->fatal(print_r("## LANCEMENT DE LA TÂCHE PLANIFIÉ DE SUPPRESSION DES DOSSIERS",true));

    /* Recuperation des dossier qui cloturé qui ont dépassé le delai */
    /* DATE_ADD(ops_dossier.date_modified, INTERVAL ops_dispositif.delai_suppression DAY) < CURDATE() renvoi null si le delai de suppression est a null */
    $sql = "SELECT ops_dossier_id AS dossierId
            FROM   ops_dispositif_ops_dossier
            INNER JOIN ops_dispositif
                ON ops_dispositif_id = ops_dispositif.id
            INNER JOIN ops_dossier
                ON ops_dossier.id = ops_dossier_id
            WHERE  ops_dispositif_ops_dossier.deleted = 0
            AND ops_dispositif.deleted = 0
            AND ops_dossier.cloture = 1
            AND DATE_ADD(ops_dossier.date_modified, INTERVAL ops_dispositif.delai_suppression_cloture DAY) < CURDATE()";

    $res = $db->query($sql);


    while ($dossier = $db->fetchByAssoc($res, false)) {
        $GLOBALS['log']->fatal(print_r("# Suppression du dossier d'id : " . $dossier['dossierId'],true));
        $bean = BeanFactory::getBean("OPS_dossier", $dossier['dossierId']);
        $bean->mark_deleted($dossier['dossierId']); 
        $bean->save(); // lancement des hooks
    }

    $GLOBALS['log']->fatal(print_r("## FIN DE LA TÂCHE PLANIFIÉ DE SUPPRESSION DES DOSSIERS",true));
    return true;
}

 

$job_strings[] = 'notification_suppression_compte_usager';

/*
 * Tâche planifié qui permet de : 
 * - notifier un usager lorsque que son compte n'est plus utilisé depuis X jours 
 * - supprimer le compte de l'usager lorsque son compte n'est plus utilisé depuis Y jours
 */
function notification_suppression_compte_usager()
{
    /**
     * RECUPERATION DES ELEMENTS DE CONFIG
     */
    global $db;
    $configuratorObj = new Configurator();
    $delaiNotif = $configuratorObj->config['opensocle']['delai_notification_compte_non_utilise'];
    $delaiSuppr = $configuratorObj->config['opensocle']['delai_suppression_compte_non_utilise'];
    $pointDeDepart = $configuratorObj->config['opensocle']['definition_compte_non_utilise'];
    $modeleDeMailNotif = $configuratorObj->config['opensocle']['notif_non_utilisation_compte'];
    $modeleDeMailSuppression = $configuratorObj->config['opensocle']['notif_usager_suppression'];


    $GLOBALS['log']->error(print_r("## LANCEMENT DE LA TÂCHE PLANIFIÉ DE NOTIFICATION ET SUPPRESSION DES COMPTES USAGERS",true));
    

    /**
     * CREATION DE FONCTION UTILITAIRE
     */

    # recuperation des individus considéré non utilisé depuis un certain delai
    $getIndividuParDelais = function($delai, $checkNotification) use($pointDeDepart, $db) {
        if($pointDeDepart == 'connexion'){
            $sql = "SELECT DISTINCT ind.id
                    FROM ops_individu ind
                    -- le join ici permet de selectionner la derniere date de connexion de chaque usager
                    JOIN (
                        SELECT r1.ops_individu_id, MAX(his.derniere_connexion) AS last_connexion
                        FROM ops_historique_connexion_ops_individu r1
                        JOIN ops_historique_connexion his ON his.id = r1.ops_historique_connexion_id
                        WHERE r1.deleted = 0 AND his.deleted = 0
                        GROUP BY r1.ops_individu_id
                    ) his_max ON his_max.ops_individu_id = ind.id
                    WHERE ind.deleted = 0 
                    --  derniere date de connexion + delai (j) < aujourdui
                    --  vrai => le delai est depasse
                    --  faux => le delai n'est pas depasse
                    AND DATE_ADD(his_max.last_connexion, INTERVAL $delai DAY) < CURDATE()"
                    . ($checkNotification ? " AND ind.inactif_notification = 0" : "") ; 
        }
        else if($pointDeDepart == 'dossier'){
            /**
             * On prend les individus non supprimés, qui ne sont pas anonyme pour lequels il n'existe pas de dossier 
             * vivant (non cloturé/non supprimé OU en brouillon) sur les X derniers jours
             */
            $sql = "SELECT DISTINCT ind.id
                    FROM ops_individu ind
                    JOIN ops_individu_ops_dossier r1 ON r1.ops_individu_id = ind.id
                    JOIN ops_dossier dos ON dos.id = r1.ops_dossier_id
                    WHERE 
                        ind.deleted = 0
                        AND ind.last_name NOT LIKE 'anonyme'"
                        . ($checkNotification ? " AND ind.inactif_notification = 0" : "") 
                        ." AND NOT EXISTS (
                            -- exclusion des dossier encore en vie dans les x derniers jours
                            SELECT 1 
                            FROM ops_individu_ops_dossier r2
                            JOIN ops_dossier d2 ON d2.id = r2.ops_dossier_id
                            WHERE r2.ops_individu_id = ind.id
                            AND ((d2.cloture = 0 AND d2.deleted = 0) OR d2.name = 'TEMP')  -- Dossier encore vivant
                            AND DATE_ADD(d2.date_modified, INTERVAL $delai DAY) >= CURDATE()   -- dans les x derniers jours
                        );";
        }
        else return false;
        

        return $db->query($sql);
    };

    # notifier un individu
    $actionNotifier = function($idIndividu, $modeleDeMailNotif) {
        $beanIndividu = BeanFactory::getBean("OPS_individu", $idIndividu);

        $GLOBALS['log']->error(print_r("# Notification à l'usager : " . $beanIndividu->first_name . " " . $beanIndividu->last_name . " (id = $idIndividu)" ,true));
        
        $mailIndividu = $beanIndividu->email1;

        if(empty($mailIndividu)) {
            $GLOBALS['log']->error(print_r("-> l'usager n'a pas d'adresse mail",true));
            return false;
        }


        
        $mailer = new OdeMailer();

        $ode_email = new OdeEmail([
            'bean_source_id' => $idIndividu,
            'bean_source_name' => "OPS_individu",
            'bean_historisation_id' => $idIndividu,
            'bean_historisation_name' => "OPS_individu",
            'email_template_id' => $modeleDeMailNotif,
            'dest_to' => $mailIndividu,
        ]);

        # On déclenche l'envoie
        $mailSended = $mailer->send($ode_email);

        // l'usager a ete notifie
        if($mailSended){
            $beanIndividu->inactif_notification = 1;
            $beanIndividu->save();
        }


        return true;

    };

    # supprimer un individu
    $actionSupprimer = function($idIndividu) use ($actionNotifier, $modeleDeMailSuppression){
        $beanIndividu = BeanFactory::getBean("OPS_individu", $idIndividu);
        $actionNotifier($idIndividu, $modeleDeMailSuppression);
        $GLOBALS['log']->error(print_r("# Suppression du compte usager : " . $beanIndividu->first_name . " " . $beanIndividu->last_name . " (id = $idIndividu)" ,true));
        $beanIndividu->mark_deleted($idIndividu);
    };

    /**
     * FIN DES FONCTIONS UTILITAIRES
     */



    /** 
     * NOTIFICATIONS
     */

    $GLOBALS['log']->error(print_r("## Traitement des notifications",true));


    $individuANotifier = $getIndividuParDelais($delaiNotif, true);


    if(!empty($modeleDeMailNotif)){
        while($row = $db->fetchByAssoc($individuANotifier)){
            $actionNotifier($row['id'], $modeleDeMailNotif);
        }
    }


    else $GLOBALS['log']->error(print_r("# Les notifications aux usagers n'a pas pu être réalisé : aucun modèle de mail de notification n'a été paramétré",true));


    
    $GLOBALS['log']->error(print_r("## Fin traitement des notifications",true));

    /**
     * FIN NOTIFICATIONS
     */


    /**
     * SUPPRESSIONS
     */


    $individuASupprimer = $getIndividuParDelais($delaiSuppr, false);

    $GLOBALS['log']->error(print_r("## Traitement des suppressions",true));
    
    if(!empty($modeleDeMailSuppression)){
        while($row = $db->fetchByAssoc($individuASupprimer)){
            $actionSupprimer($row['id']);
        }
    }
    else $GLOBALS['log']->error(print_r("# La suppression des usager n'a pas pu être réalisé : aucun modèle de mail de notification n'a été paramétré",true));

    /**
     * FIN SUPPRESSIONS
     */


    $GLOBALS['log']->error(print_r("## Fin traitement des suppressions",true));
    $GLOBALS['log']->error(print_r("## FIN DE LA TÂCHE PLANIFIÉ DE NOTIFICATION ET SUPPRESSION DES COMPTES USAGERS",true));
    return true;
}


/*
 * Suppression des Documents Éditique récents antérieurs à la veille encore en brouillon.
 * (Mise à jour à chaud possible via le fichier du planificateur assemblé : /custom/modules/Schedulers/Ext/ScheduledTasks/scheduledtasks.ext.php)
 */


$job_strings[] = 'supprimer_editiques_brouillons';

function supprimer_editiques_brouillons()
{
    global $db, $sugar_config;

    require_once('modules/Configurator/Configurator.php');

    $configuratorObj = new Configurator();
    $configuratorObj->loadConfig();

    # Default params...
    if( intval( $configuratorObj->config['module_editique']['scheduler_delay'] ) == 0 ){
        $configuratorObj->config['module_editique']['scheduler_delay'] = 1; 
        $configuratorObj->saveConfig();
    }
    if( intval( $configuratorObj->config['module_editique']['scheduler_purge_limit'] ) == 0 ){
        $configuratorObj->config['module_editique']['scheduler_purge_limit'] = 50; 
        $configuratorObj->saveConfig();
    }
    $scheduler_delay       = -1 * intval($configuratorObj->config['module_editique']['scheduler_delay']);
    $scheduler_purge_limit = $configuratorObj->config['module_editique']['scheduler_purge_limit'];

    $query_delete = "
        SELECT * FROM `documents` 
        WHERE documents.deleted = 0 
          AND documents.origine = 'editique' 
          AND documents.status_id = 'brouillon' 
          AND documents.date_entered <= DATE_ADD(UTC_TIMESTAMP(), INTERVAL ".$scheduler_delay." day)
        LIMIT ".$scheduler_purge_limit;

    $requete = $db->query( trim($query_delete) );

    while ($row = $db->fetchRow($requete)) {

        $document_id = $row['id'];

        $obj_document = BeanFactory::getBean( 'Documents' , $document_id );
        # $obj_document->ops_dossier_id
        # $obj_document->ops_type_document_documents_name
        # $obj_document->ops_type_document_id

        # Permet de récupérer les potentiels Bean via les relations.
        # Cela offre aussi la possibilité de savoir dans quel module le Document Éditique est généré / exporté !
        $loaded_relationships = [];
        $related_beans_name = [];
        try {
            // $loaded_relationships = $obj_document->loaded_relationships; // Cron process can not access to protected.

            // Bypass to access to related link properties from bean source over cronned task (protecte mode is disalloed).
            $fetched_rel_row = $obj_document->fetched_rel_row;
            foreach ($fetched_rel_row as $key_name => $v) {
                preg_match('/^(ops)([_]([a-z]*))*(documents_name)$/', $key_name, $output_array);
                # Integrité du match et de cohérence.
                if( is_array($output_array) && sizeof($output_array) >= 3 && strlen($output_array[0]) == strlen($key_name) ){
                    $relationship = str_replace('_documents_name', '_id', $key_name);
                    //  $obj_document->{strtolower($relationship)}
                    if( isset( $obj_document->rel_fields_before_value[$relationship] ) ){
                        $loaded_relationships[] = $relationship;
                    }
                }
            }


        } catch (Exception $e) {}

        # Store in related_beans_name the linked BeanName.
        foreach ($loaded_relationships as $key => $relationship) {
            if( strtolower($relationship) != "ops_type_document_id" ){
                $related_beans_name[] = preg_replace('/^(ops_)/', 'OPS_', str_replace('_id', '', $relationship ));
            }
        }
        
        # Module Bean courant... recherche par itération sur un petit nombre d'éléments.
        foreach ($related_beans_name as $key => $bean_name) {

            $query_fetch = "SELECT * FROM `".strtolower($bean_name)."_documents` WHERE `document_id` LIKE '".$document_id."'";
            $fetch_requete = $db->query( trim($query_fetch) );

            $document_solo = true;

            while ($line = $db->fetchRow($fetch_requete)) {

                $module_origin = $bean_name;
                $record_origin = $line[strtolower($bean_name).'_id'];

                if( !empty($record_origin) ){
                    
                    preg_match('/[a-f0-9]{8,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{4,}-[a-f0-9]{12,}/', $record_origin, $output_array);

                    if( is_array($output_array) && sizeof($output_array) == 1 && strlen($output_array[0]) == 36 ){

                        // Bean module référence (relationship)
                        $obj_bean_ref = BeanFactory::getBean( $module_origin , $record_origin );

                        $obj_document->load_relationship( strtolower( $module_origin ).'_documents' );
                        $obj_document->{strtolower( $module_origin ).'_documents'}->delete( $obj_bean_ref );

                        // Suppression du document.
                        $obj_document->mark_deleted($document_id);

                        // Compatibilité versions SuiteCRM.
                        try { $obj_document->save(); } catch (Exception $e) {}

                        $document_solo = false;
                    }
                }
            }
        }

        # Si document solo / related non trouvés... possible casse, donc finalment on marque ce Bean Document supprimé.
        if( $document_solo ){
            $obj_document->mark_deleted($document_id);
        }

    }
    return true;
} 


$job_strings[] = 'delai_dossier';

function delai_dossier(){

    global $db;
    $dossiers = "SELECT 
                DISTINCT ops_dossier.id, 
                ops_dossier.name, 
                ops_dossier.ops_etape_id, 
                ops_dossier.flag_correction_delai, 
                ops_etape.nb_jour_retard, 
                ops_etape.nb_jour_avant_retard,
                ops_historisation.ops_etape_id, 
                ops_historisation.date_entered 
                FROM 
                ops_dossier 
                INNER JOIN ops_historisation_ops_dossier ON ops_dossier.id = ops_historisation_ops_dossier.ops_dossier_id 
                AND ops_historisation_ops_dossier.deleted = 0 
                INNER JOIN ops_historisation ON ops_historisation_ops_dossier.ops_historisation_id = ops_historisation.id 
                INNER JOIN ops_etape ON ops_etape.id = ops_dossier.ops_etape_id 
                WHERE 
                ops_dossier.deleted = 0 
                AND ops_dossier.cloture = 0 
                AND ops_dossier.name != 'TEMP' 
                AND ops_dossier.brouillon = 'non'
                AND ops_historisation.deleted = 0 
                AND ops_historisation.date_entered = (
                    SELECT 
                    ops_historisation.date_entered 
                    FROM 
                    ops_historisation 
                    INNER JOIN ops_historisation_ops_dossier ON ops_historisation.id = ops_historisation_ops_dossier.ops_historisation_id 
                    AND ops_historisation_ops_dossier.deleted = 0 
                    WHERE 
                    ops_historisation_ops_dossier.ops_dossier_id = ops_dossier.id 
                    AND ops_historisation.ops_etape_id = ops_dossier.ops_etape_id 
                    ORDER BY 
                    ops_historisation.date_entered ASC 
                    LIMIT 1
                ) 
                ORDER BY 
                ops_historisation.date_entered
            ";
    $result = $db->query($dossiers);
    $currentDate = new DateTime(date('Y-m-d H:i:s'));

    while($row = $db->fetchByAssoc($result)){
        $dateEtape = new DateTime($row['date_entered']);
        
        if(!is_null($row["flag_correction_delai"])) $dateEtape = new DateTime($row["flag_correction_delai"]);


        $delai = $currentDate->diff($dateEtape)->days;
        $nbJourRetard = $row["nb_jour_retard"];
        $nbJourAvantRetard = $row["nb_jour_avant_retard"];

        // 0 => gris, 1 => dans les temps, 2 => entre deux, 3 => en retard
        $couleur = "0";
        if(!$nbJourAvantRetard || !$nbJourRetard) $couleur = "0";
        else if($delai < $nbJourAvantRetard) $couleur = "1";
        else if($delai >= $nbJourAvantRetard && $delai < $nbJourRetard) $couleur = "2";
        else if($delai >= $nbJourRetard) $couleur = "3";


        $beanDossier = BeanFactory::getBean("OPS_dossier", $row['id']);

        $beanDossier->delai = $couleur;
        $beanDossier->save();
    }
    return true;
}


/*
 * Vérifie la validité de la clef profil et la supprimer si obsolète
 *
 */

$job_strings[] = 'verifier_validite_clef_profil';

function verifier_validite_clef_profil()
{
    global $db, $sugar_config;

    if(!empty($sugar_config['opensocle']['profil_delai_validite_clef'])){
        $query =    "SELECT id 
                    FROM ops_personne_morale_individu 
                    WHERE ops_personne_morale_individu.deleted = 0
                    AND ops_personne_morale_individu.statut_clef = 'nouveau'
                    AND CURDATE() > ops_personne_morale_individu.date_expiration;"; 
        $result = $db->query($query);

        while($row = $db->fetchByAssoc($result)){
            if(!empty($row['id'])){
                $objProfilIndividu = BeanFactory::getBean('OPS_personne_morale_individu',$row['id']);
                if(!empty($objProfilIndividu->id)){
                    $objProfilIndividu->statut_clef = 'perime';
                    $objProfilIndividu->save();
                }
            }
        }
    }

    if(!empty($sugar_config['opensocle']['profil_delai_suppression_clef'])){
        $query =    "SELECT id 
                    FROM ops_personne_morale_individu 
                    WHERE ops_personne_morale_individu.deleted = 0
                    AND (ops_personne_morale_individu.statut_clef = 'perime'
                    AND CURDATE() >= DATE_ADD(ops_personne_morale_individu.date_expiration, INTERVAL ".$sugar_config['opensocle']['profil_delai_suppression_clef']." day))
                    || (ops_personne_morale_individu.statut_clef = 'revoque'
                    AND CURDATE() >= DATE_ADD(ops_personne_morale_individu.date_revocation, INTERVAL ".$sugar_config['opensocle']['profil_delai_suppression_clef']." day))"; 
        $result = $db->query($query);

        while($row = $db->fetchByAssoc($result)){
            if(!empty($row['id'])){
                $objProfilIndividu = BeanFactory::getBean('OPS_personne_morale_individu',$row['id']);
                if(!empty($objProfilIndividu->id)){
                    $objProfilIndividu->mark_deleted($id);
                    $objProfilIndividu->save();
                }
            }
        }
    }
    return true;
}
?>