<?php
/*
 * Author     : LANTEAS
 */

use Datetime;
use BeanFactory;
use ODE\Modal\OdeModal;

class hook_agenda
{


	/**
	 * Envoie d'un mail d'annulation de RDV à un agent lorsque l'agent est modifié
	 * @param mixed $bean
	 * @param mixed $event
	 * @param mixed $arguments
	 */
	public function send_mail_agent(&$bean, $event, $arguments = null)
	{

		if ($event != 'before_save') {
			return;
		}

		global $beanFiles, $sugar_config;


		// Si les notifs agents sont activées et que l'agent est modifié
		if (isset($sugar_config['agenda']['notif_agent']) && $sugar_config['agenda']['notif_agent'] == true) {

			$obj_meeting = BeanFactory::getBean("Meetings", $bean->id);

			// Check date
			$bool_date = false;
			if (isset($bean->date_start) && !empty($bean->date_start)) {
				$date_debut = DateTime::createFromFormat('Y-m-d H:i:s', $bean->date_start);
				$date_debut = $date_debut->format('Y-m-d H:i:s');

				$date_now = new DateTime();
				$date_now = $date_now->format('Y-m-d H:i:s');
				if ($date_now <= $date_debut) {

					$bool_date = true;
				}
			}

			// Envoie de l'annulation d'un rendez-vous à un agent lorsque l'utilisateur assigné est modifié
			if ($bool_date && $obj_meeting->assigned_user_id != $bean->assigned_user_id && $bean->assigned_user_id != "" && $obj_meeting->assigned_user_id != "" && $obj_meeting->id != "") {

				require_once('modules/OPS_agendas/OPS_agendas.php');

				$obj_agenda = BeanFactory::newBean("OPS_agendas");
				$obj_agenda->gestion_notifications_agent($obj_meeting, "annulation");

			}
		}
	}


	/**
	 * Modification des valeurs des champs de Meeting pour le subpanel Rendez-vous dans la vue d'un individu
	 * Mise en place d'une modale au clic sur la date
	 * @param mixed $bean
	 * @param mixed $event
	 * @param mixed $arguments
	 */
	public function subpanelFieldsChange(&$bean, $event, $arguments = null)
	{


		if ($event != 'process_record' || $_REQUEST['module'] != 'OPS_individu' || ($_REQUEST['action'] != 'DetailView' && $_REQUEST['action'] != 'SubPanelViewer')) {
			return;
		}

		$obj_meeting = BeanFactory::getBean('Meetings', $bean->id);

		if ($obj_meeting->ops_individu_id == $_REQUEST['record']) {


			$date_start = DateTime::createFromFormat("d/m/Y H:i", $obj_meeting->date_start);
			$date_end = DateTime::createFromFormat("d/m/Y H:i", $obj_meeting->date_end);


			$date = $date_start->format("d/m/Y");
			$heure_start = $date_start->format("H:i");
			$heure_end = $date_end->format("H:i");

			$bean->date_rdv = '<a id= "date_rdv_id' . $bean->id . '" class="date_rdv">' . $date . '</a>';
			$bean->heure_rdv = "De " . $heure_start . " à " . $heure_end;



			if (!empty($obj_meeting->motif_autre)) {
				$bean->motif_rdv = html_entity_decode($obj_meeting->motif_autre);
			} else {
				$liste_motif = $obj_meeting->get_linked_beans('ops_agendas_motifs_meetings', 'OPS_agendas_motifs', '', 0, -1, 0, '');
				$bean->motif_rdv = $liste_motif[0]->name;
			}


			$bean->user_rdv = $obj_meeting->assigned_user_name;
			if ($obj_meeting->assigned_user_id == "1") {
				$bean->user_rdv = " ";
			}

			$obj_dossier = BeanFactory::getBean("OPS_dossier", $obj_meeting->parent_id);
			$bean->parent_id = $obj_meeting->parent_id;
			$bean->num_dossier_rdv = $obj_dossier->num_dossier;

			echo $this->html_set_input($obj_meeting);

		}
	}


	/**
	 * Création de l'objet json contenant les valeurs des champs Meeting pour le subpanel Rendez-vous dans le detail d'un individu
	 * Mise en place d'une modale au clic sur la date
	 * @param bean $obj_meeting
	 */
	private function html_set_input($obj_meeting)
	{
		global $app_list_strings, $current_user;

		$obj_individu = BeanFactory::getBean("OPS_individu", $obj_meeting->ops_individu_id);


		// Si dossier back associé
		if (!empty($obj_meeting->parent_id)) {
			$obj_dossier = BeanFactory::getBean("OPS_dossier", $obj_meeting->parent_id);
			$num_dossier = $obj_dossier->num_dossier;
		}

		// Si dossier front associé
		$id_dossier_front = "";
		$num_dossier_front = "";
		if ($obj_meeting->provenance_rdv === 'internet') {

			$obj_dossier_front = $obj_meeting->get_linked_beans("meetings_ops_dossier", "OPS_dossier");
			$obj_dossier_front = isset($obj_dossier_front[0]) ? $obj_dossier_front[0] : "";

			if (isset($obj_dossier_front) && !empty($obj_dossier_front->id)) {
				$id_dossier_front = $obj_dossier_front->id;
				$num_dossier_front = $obj_dossier_front->num_dossier;
			}
		}

		// Createur
		$obj_user_creator = "";
		if ($obj_meeting->provenance_rdv == "guichet") {
			$obj_user_creator = BeanFactory::getBean("Users", $obj_meeting->created_by)->name;
			$obj_user_creator = $obj_user_creator !== "Administrator" ? $obj_user_creator : "Administrateur";
		} else {
			$obj_user_creator = $obj_individu->salutation . " " . html_entity_decode($obj_individu->last_name);
		}

		if (empty($current_user->id)) {
			$current_user = BeanFactory::getBean("Users", '1');
		}
		$format = $current_user->getPreference('datef') . " " . $current_user->getPreference('timef');

		$user_create_date = DateTime::createFromFormat($format, $obj_meeting->date_entered);
		$user_create_date = "Le " . $user_create_date->format("d/m/Y à H:i");

		$obj_json = array(
	//		'id_meeting' => $obj_meeting->id,
			'type_individu' => $obj_individu->type_individu,
			'salutation' => $obj_individu->salutation,
			'last_name' => $obj_individu->last_name,
			'nom_usage' => $obj_individu->nom_usage,
			'first_name' => $obj_individu->first_name,
			'date_naissance' => $obj_individu->date_naissance,
			'adr_street' => $obj_individu->primary_address_number . " " . $obj_individu->primary_address_street,
			'adr_bat' => $obj_individu->primary_address_complement_batiment,
			'adr_lieu' => $obj_individu->primary_address_complement_lieu,
			'adr_city' => $obj_individu->primary_address_postalcode . " " . $obj_individu->primary_address_city,
			'email' => $obj_individu->email1,
			'phone_mobile' => $obj_individu->phone_mobile,
			'location' => $obj_meeting->location,
			'name_motif' => empty($obj_meeting->ops_agendas_motifs_meetings_name)? $obj_meeting->motif_autre:$obj_meeting->ops_agendas_motifs_meetings_name,
			'date_start' => $obj_meeting->date_start,
			'presence' => $app_list_strings['rdv_statut_presence_list'][$obj_meeting->rdv_statut_presence],
			'nature' => $app_list_strings['rdv_nature_list'][$obj_meeting->nature],
			'description' => $obj_meeting->description,
			'user_assigned_name' => $obj_meeting->assigned_user_id == "1" ? " " : $obj_meeting->assigned_user_name,
			'participant' => $obj_meeting->name,
			'accompagnants' => $obj_meeting->accompagnant,
			'ressource' => $obj_meeting->ops_agendas_ressources_meetings_name,
			'num_dossier_back' => $num_dossier,
			'url_dossier_back' => (!empty($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . '/index.php?module=OPS_dossier&action=DetailView&record='.$obj_meeting->parent_id,
			'num_dossier_front' =>  $num_dossier_front,
			'url_dossier_front' => (!empty($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . '/index.php?module=OPS_dossier&action=DetailView&record='.$id_dossier_front,
			'create_by' => $obj_user_creator,
			'create_date' => $user_create_date,
			'type_rdv' => $obj_meeting->type_rdv,
			'canal' => $obj_meeting->provenance_rdv
		);


		$obj_json = base64_encode(json_encode($obj_json));

		return '<input id="showModale-' . $obj_meeting->id . '" type="hidden" value="' . $obj_json . '"/>';
	}



	/**
	 * Hook de suppression des relations du meeting supprimé
	 */
	public function annulation_rdv(&$bean, $event, $arguments = null)
	{

		if ($event != 'before_delete') {
			return;
		}

		global $beanFiles;
		require_once($beanFiles["OPS_dossier"]);


		// Suppression des dossiers front liés au meeting
		$lst_dossiers_front = $bean->get_linked_beans('meetings_ops_dossier', 'OPS_dossier');
		foreach ($lst_dossiers_front as $key => $un_dossier) {
			$obj_dossier = BeanFactory::getBean("OPS_dossier", $un_dossier->id);
			$obj_dossier->mark_deleted($un_dossier->id);
		}

		// Suppresion du dossier back lié au meeting
		if (!empty($bean->parent_id)) {

			$id_dossier = $bean->parent_id;
			$bean->parent_id = "";
			$bean->parent_type = "";
			$bean->save();

			$obj_dossier = BeanFactory::getBean("OPS_dossier", $id_dossier);
			$obj_dossier->mark_deleted($id_dossier);
		}
	}
}