var ContentManager = (function($) {


  return {

    tinyInstanceId : "corps",

    mce_PageBreakFragment : '<p style="page-break-before:auto;margin:0;height:1pt;border-top:dotted #FF0000 1px;" data-mce-style="page-break-before: auto; margin: 0; height: 1pt; border-top: dotted #FF0000 1px;">&nbsp;</p>',


    /**
     * Fonction qui insère le contenu relatif au modèle dans le corps du tinyMCE.
     *
     * @return @return {void}
     */
    insertDescription: function( rel_bean_id ) {
      const self = this;

      var inst = tinyMCE.getInstanceById( ContentManager.tinyInstanceId );
      if (inst) {

          let Navigation = JSON.parse( $('#navigation_items' ).val() || '[]' );
          let content_fragment = '';

          if( typeof Navigation.getObjectBy('id',rel_bean_id) != 'undefined' ){
            b64_content = String( Navigation.getObjectBy('id',rel_bean_id).content );
            content_fragment = b64_content.b64_to_utf8();
          }

          inst.getWin().focus();
          // Supprimer tout le contenu HTML
          inst.setContent('');
          inst.execCommand( 'mceInsertRawHTML', false, content_fragment );

          self.fixCursorPosition();

      }

    },


    /**
     * Fonction qui insère le contenu relatif au modèle dans le corps du tinyMCE.
     *
     * @return @return {void}
     */
    fixCursorPosition: function( rel_bean_id ) {
      const self = this;

      var inst = tinyMCE.getInstanceById( ContentManager.tinyInstanceId );
      if (inst) {

        var ed = tinyMCE.get( ContentManager.tinyInstanceId ); 

        ed.selection.select(ed.getBody(), true); // ed is the editor instance
        ed.selection.collapse(false);

        ed.focus(); // brings focus back to the editor

      }

    },


    /**
     * Fonction qui hook un callback sur le changement de contenu dans le corps du tinyMCE.
     *
     * @return @return {void}
     */
    bindContentChanges: function() {
      const self = this;

      var inst = tinyMCE.getInstanceById( ContentManager.tinyInstanceId );
      if (inst) {
          
          var editor = tinyMCE.get( ContentManager.tinyInstanceId );

          // Réponse dynamique aux changements du contenu (écriture / sélection avec déplacement).
          $( editor.contentDocument.activeElement ).on('change keyup keydown paste drop', function(e){
            ContentManager.detectContentChanges( e.type );
          });

          // Réponse interactive aux changements indus par une interaction tierce au sin du contenu ( mceToolbar / insertion de contenu).
          $( editor.contentDocument.activeElement ).observe( { attributes: true, childlist: true, subtree: true, added: true, removed: true } , function(record) {
            ContentManager.detectContentChanges( record.type );
          });

      }

    },


    /**
     * Fonction qui réécrit hook un callback sur le changement de contenu dans le corps du tinyMCE.
     *
     * @return @return {void}
     */
    overrideTinyMcePageBreak: function() {
      const self = this;

      var inst = tinyMCE.getInstanceById( ContentManager.tinyInstanceId );
      if (inst) {
          
          var editor = tinyMCE.get( ContentManager.tinyInstanceId );

          editor.execCommands.mcePageBreak.func = function(b){ 
            
              inst.getWin().focus();
              inst.execCommand( 'mceInsertContent', 0, ContentManager.mce_PageBreakFragment );
              
          }

      }

    },


    /**
     * Fonction hookée sur le changement de contenu dans le corps du tinyMCE.
     *
     * @return @return {void}
     */
    detectContentChanges: function(T_e) {
      const self = this;

      if( ['change', 'keyup', 'keydown', 'paste', 'drop', 'attributes', 'childList'].includes( T_e ) ){
        ContentManager.notifyContentChanges( T_e );
      }

    },


    /**
     * Fonction Notification.
     *
     * @param {event} fired event on mutation record or 
     * @return {void} 
     */
    notifyContentChanges: function(e) {

      $( '#edition[role="presentation"]' ).addClass('modified');

    },

   
  }

})(jQuery);
