<?php
if (!defined('sugarEntry') || !sugarEntry)
    die('Not A Valid Entry Point');

global $current_user, $sugar_config, $app_list_strings;
if (!is_admin($current_user))
    sugar_die("Unauthorized access to administration.");

require_once('modules/Configurator/Configurator.php');
require_once('custom/include/Ode/Helper/ImageHelper.php');

$configuratorObj = new Configurator();
$sugar_smarty = new Sugar_Smarty();
$errors = array();

$configuratorObj->loadConfig();

$phone_masks_ini = parse_ini_file('assets/ini/phone_masking.ini', true);

if (isset($_REQUEST['process']) && $_REQUEST['process'] == 'true') {
    $array_reparation = array();

    foreach ($_REQUEST as $key => $value) {
        if (strpos($key, "libelle_") !== false) {
            # Si changement de valeur, une réparation des modules OPS_personne_morale & OPS_individu est nécessaire
            if ($value != $configuratorObj->config['opensocle']['adresse_libelles'][$key])
                !in_array("OPS_personne_morale", $array_reparation) ? array_push($array_reparation, 'OPS_personne_morale', 'OPS_individu') : '';

            $configuratorObj->config['opensocle']['adresse_libelles'][$key] = $value;
        } elseif (strpos($key, "dossier_bouton_") !== false) {
            $key_clean = explode('_', $key)[2];
            $configuratorObj->config['opensocle']['dossier_boutons_libelles'][$key_clean] = $value;
        } elseif ($key == "format_telephone") {
            # Si changement de valeur, une réparation des modules OPS_personne_morale & OPS_individu est nécessaire
            if (!array_equal(explode(",", $configuratorObj->config['opensocle']['pays_telephone']), $_REQUEST['format_telephone']))
                !in_array("OPS_personne_morale", $array_reparation) ? array_push($array_reparation, 'OPS_personne_morale', 'OPS_individu') : '';

            $configuratorObj->config['opensocle']['type_pays'] = $_REQUEST['type_pays'];
            $configuratorObj->config['opensocle']['pays_telephone'] = isset($_REQUEST['format_telephone']) ? implode(",", $_REQUEST['format_telephone']) : '';
            foreach ($_REQUEST['format_telephone'] as $mask_telephone) {
                $array_masks_tel[] = implode(",", $phone_masks_ini['phone_masking'][$mask_telephone]);
            }
            $configuratorObj->config['opensocle']['format_telephone'] = implode(",", $array_masks_tel);
        }
    }

    $configuratorObj->config['opensocle']['disable_api_ban'] = isset($_REQUEST['disable_api_ban']) ? 1 : 0;
    $configuratorObj->config['opensocle']['disable_fiche_agent'] = isset($_REQUEST['disable_fiche_agent']) ? 1 : 0;

    $configuratorObj->config['opensocle']['custom_couleur_delai_0'] = $_REQUEST['delai_0'] ?? "rgb(240,240,6)";
    $configuratorObj->config['opensocle']['custom_couleur_delai_1'] = $_REQUEST['delai_1'] ?? "rgb(240,240,6)";
    $configuratorObj->config['opensocle']['custom_couleur_delai_2'] = $_REQUEST['delai_2'] ?? "rgb(240,240,6)";
    $configuratorObj->config['opensocle']['custom_couleur_delai_3'] = $_REQUEST['delai_3'] ?? "rgb(240,240,6)";

    $configuratorObj->config['opensocle']['cal_min_heure'] = $_REQUEST['cal_min_heure'] ?? "00:00";
    $configuratorObj->config['opensocle']['cal_max_heure'] = $_REQUEST['cal_max_heure'] ?? "24:00";

    $dir = 1;
    if((isset($configuratorObj->config['ops_justificatif']['chemin']) && $configuratorObj->config['ops_justificatif']['chemin'] != $_REQUEST['chemin']) || empty($configuratorObj->config['ops_justificatif']['chemin'])){
        $dir = mkdir($_REQUEST['chemin'], 0755);
    }

    if($dir || file_exists($_REQUEST['chemin'])){
        # Initialisation des paramètres des justificatifs
        $configuratorObj->config['ops_justificatif']['chemin'] = $_REQUEST['chemin'];
        $configuratorObj->config['ops_justificatif']['type_a'] = isset($_REQUEST['type_a']) ? 1 : 0;
    }else{
        $errors['main'] = "Le chemin de stockage n'a pas pu être créé";
    }   

    if (isset($_FILES['image_dispositif_defaut']) && isset($sugar_config['ops_justificatif']['chemin'])) {
        // Informations sur le fichier
        $fileError = $_FILES['image_dispositif_defaut']['error'];
        // Vérifier si l'upload a réussi sans erreurs
        if ($fileError === UPLOAD_ERR_OK) {
            // Construire le chemin complet de destination
            $justificatifPath = (substr($sugar_config['ops_justificatif']['chemin'], -1) == '/') ? $sugar_config['ops_justificatif']['chemin'] : $sugar_config['ops_justificatif']['chemin'] . '/';
            $fileTmpPath = $_FILES['image_dispositif_defaut']['tmp_name'];
            $fileName = $_FILES['image_dispositif_defaut']['name'];
            $destPath = $justificatifPath . 'catalogue_dispositif/defaut.' . explode('.', $fileName)[1];


            if(!is_dir($destPath)) mkdir($justificatifPath . 'catalogue_dispositif');
            
            if (move_uploaded_file($fileTmpPath, $destPath)) {
                    ImageHelper::getResizedImageJpeg($destPath, 60,600 );
                    $configuratorObj->config['dispositif']['image_defaut'] = $destPath;
            } else {
                $GLOBALS['log']->fatal('OpenCRM :: Admin => Il y a eu une erreur en déplaçant le fichier vers le répertoire de destination');
            }
        } else {
            $GLOBALS['log']->fatal('OpenCRM :: Admin => Il y a eu une erreur (Code : ' . $fileError . ')');
        }
    } else {
        $GLOBALS['log']->fatal('OpenCRM :: Admin => Chemin des justificatifs non remplit');
    }

    $configuratorObj->config['opensocle']['profil_delai_validite_clef'] = str_replace('-', '', $_REQUEST['profil_delai_validite_clef']);
    $configuratorObj->config['opensocle']['profil_delai_suppression_clef'] = str_replace('-', '', $_REQUEST['profil_delai_suppression_clef']);

    $configuratorObj->saveConfig();

    # Si on a un changement, on déclenche une réparation rapide des modules concernés uniquement (pas de réparation globale)
    if (!empty($array_reparation)) {
        require_once('modules/Administration/QuickRepairAndRebuild.php');
        $actions = array('clearAll');
        $randc = new RepairAndClear();
        $randc->repairAndClearAll($actions, $array_reparation, true, false);
    }

    header('Location:index.php?module=Administration&action=opencrm');
}

foreach ($configuratorObj->config['opensocle']['adresse_libelles'] as $key => $value) {
    $sugar_smarty->assign("ADRESSE_" . strtoupper($key), $value);
}

foreach ($configuratorObj->config['opensocle']['dossier_boutons_libelles'] as $key => $value) {
    $sugar_smarty->assign("BOUTON_DOSSIER_" . strtoupper($key), $value);
}

$sugar_smarty->assign("DISABLE_API_BAN", $configuratorObj->config['opensocle']['disable_api_ban']);
$sugar_smarty->assign("DISABLE_FICHE_AGENT", $configuratorObj->config['opensocle']['disable_fiche_agent']);

$array_type_country = array(
    'france' => 'France (Métropolitaine, DOM, TOM, ...)',
    'international' => 'International',
);
$type_country = explode(",", $configuratorObj->config['opensocle']['type_pays']);
$select_type_countries = get_select_options_with_id($array_type_country, $type_country);
$sugar_smarty->assign("TYPE_PAYS", $select_type_countries);


/*CALENDRIER*/

$select_cal_min_heure = get_select_options_with_id($app_list_strings['ops_calendrier_hours'], $configuratorObj->config['opensocle']['cal_min_heure']);
$sugar_smarty->assign("CAL_MIN_HEURE", $select_cal_min_heure);

$select_cal_max_heure = get_select_options_with_id($app_list_strings['ops_calendrier_hours'], $configuratorObj->config['opensocle']['cal_max_heure']);
$sugar_smarty->assign("CAL_MAX_HEURE", $select_cal_max_heure);



$country = explode(",", $configuratorObj->config['opensocle']['pays_telephone']);
foreach ($phone_masks_ini['liste_pays_france'] as $key => $value) {
    $array_countries_france_clean[$key] = $value;
}
asort($array_countries_france_clean);
$select_countries = get_select_options_with_id($array_countries_france_clean, $country);
$sugar_smarty->assign("FORMAT_TELEPHONE_FRANCE", $select_countries);

foreach ($phone_masks_ini['liste_pays_international'] as $key => $value) {
    $array_countries_inter_clean[$key] = $value;
}
asort($array_countries_inter_clean);
$select_countries = get_select_options_with_id($array_countries_inter_clean, $country);
$sugar_smarty->assign("FORMAT_TELEPHONE_INTERNATIONAL", $select_countries);
$sugar_smarty->assign('MOD', $mod_strings);
$sugar_smarty->assign('APP', $app_strings);

$sugar_smarty->assign("DELAI_TITRE", $app_list_strings['ops_delai_list']);

$delai_color = translate('LIST_DEFAULT_COLOR_DELAI', 'OPS_dossier');
foreach($delai_color as $index => $color){
    $delai_color[$index] = $configuratorObj->config['opensocle']['custom_couleur_delai_'.$index] ?? $delai_color[$index];
}

$sugar_smarty->assign("DELAI_COLOR_DEFAULT", $delai_color);


$image_defaut = '';
if (isset($configuratorObj->config['dispositif']['image_defaut'])) {
    $imageResized = ImageHelper::getResizedImageJpeg($configuratorObj->config['dispositif']['image_defaut'], 60, 600);
    if (!empty($imageResized)) {
        $image_defaut = 'data:image/jpeg;base64,' . $imageResized;
    }
}

$sugar_smarty->assign("SRC_IMG", $image_defaut);

//Délais clef profil
$sugar_smarty->assign("PROFIL_DELAI_VALIDITE_CLEF", $configuratorObj->config['opensocle']['profil_delai_validite_clef']);
$sugar_smarty->assign("PROFIL_DELAI_SUPPRESSION_CLEF", $configuratorObj->config['opensocle']['profil_delai_suppression_clef']);

$sugar_smarty->assign('CHEMIN', $configuratorObj->config['ops_justificatif']['chemin']);
$sugar_smarty->assign("TYPE_A", $configuratorObj->config['ops_justificatif']['type_a']);

$sugar_smarty->clearCache('custom/modules/Administration/ops_param_generaux.tpl');
$sugar_smarty->display('custom/modules/Administration/ops_param_generaux.tpl');

/**
 * Fonction de vérification de similitude entre 2 tableaux
 *
 * @param array $a
 * @param array $b
 * @return boolean
 */
function array_equal($a, $b) {
    return (
         is_array($a) 
         && is_array($b) 
         && count($a) == count($b) 
         && array_diff($a, $b) === array_diff($b, $a)
    );
}