/**
 * Appels vers api-adresse.data.gouv
 * Récupération des adresses et lieux
 * Appeler par OPS_Lieux
 */

/**
 * Mise en place des events onchange sur les != champs liés à l'adresse
 * @param {*} champ_id
 */
function SetAdresseField(champ_id = "") {
    // numéro et nom de la voie
    $("#" + champ_id + "_street").change(function () {
        open_modal(champ_id);
    });

    // code postal
    $("#" + champ_id + "_postalcode").change(function () {
        open_modal(champ_id);
    });

    // ville
    $("#" + champ_id + "_city").change(function () {
        open_modal(champ_id);
    });
}

/**
 * Affichage des résultats de la modale des lieux trouvés
 * Verification et Proposition des résultats
 * @param {Identifiant du champ} champ_id
 * @returns void
 */
function open_modal(champ_id = "") {
    let id_champ_rue = "#" + champ_id + "_street";
    let id_champ_cp = "#" + champ_id + "_postalcode";
    let id_champ_ville = "#" + champ_id + "_city";

    $("#titre_modal").html("Recherche d'adresse");
    $("#submit_modal").attr("disabled", "disabled");
    $("#corp_modal").html("");
    $("#error_form").html("");
    $("#process_form").html(
        'Recherche en cours&nbsp;&nbsp;&nbsp;<i class="fa fa-spinner fa-spin fa-lg"></i>'
    );

    let request_data = "";
    let request_url = location.protocol + "//api-adresse.data.gouv.fr/search/";

    // Récupèration de la premiere ligne du champ rue
    let valeur_rue = "";
    valeur_rue = $(id_champ_rue).val();
    let tableau_rue = valeur_rue.split("\n");

    if (tableau_rue[0] !== "") {
        valeur_rue = tableau_rue[0];
    } else {
        valeur_rue = "";
    }

    // En priorité: Recherche par rapport à la rue
    if (valeur_rue != "") {
        request_data += "q=" + valeur_rue;
    } else {
        if ($(id_champ_ville).val() !== "") {
            request_data += "q=" + $(id_champ_ville).val();
            request_data += "&type=city";
        } else {
            // Si la rue ET la ville sont vides ...
            return;
        }
    }

    if (request_data == "") {
        return;
    }

    // En Second: Si il y a un CP de saisie
    if ($(id_champ_cp).val() != "") {
        request_data += "&postcode=" + $(id_champ_cp).val();
    }

    // Initialisation de l'ID de l'adresse dans la modale
    $("#adresse_id").val(champ_id);

    $.ajax({
        type: "GET",
        url: request_url,
        data: request_data,
        success: function (msg) {
            let donnees = msg;
            let str_donnees = "";
            if (donnees.hasOwnProperty("features")) {
                let tableau_features = donnees["features"];
                if (tableau_features.length !== 0) {
                    for (let idx in tableau_features) {
                        str_donnees =
                            str_donnees +
                            '<div class="radio"><label>' +
                            '<input id="adresse" type="radio" value="' +
                            tableau_features[idx]["properties"]["name"] +
                            ":" +
                            tableau_features[idx]["properties"]["postcode"] +
                            ":" +
                            tableau_features[idx]["properties"]["city"] +
                            ":" +
                            tableau_features[idx]["geometry"]["coordinates"][0] +
                            ":" +
                            tableau_features[idx]["geometry"]["coordinates"][1] +
                            ":" +
                            tableau_features[idx]["properties"]["id"] +
                            '" name="adresse">' +
                            tableau_features[idx]["properties"]["label"] +
                            "</label></div>";
                    }
                    $("#corp_modal").html(str_donnees);
                    $("#process_form").html("");
                    $("#submit_modal").removeAttr("disabled");
                } else {
                    // Pas de suggestion :-(
                    $("#corp_modal").html("Aucune suggestion ...");
                    $("#process_form").html("");
                }
            }
        },
    });
    $("#verifAdresseModal").modal("show");
}

/**
 * Récupération des valeurs sélectionnées dans la modale
 */
function save_modal() {
    let select_value = $("input[id=adresse]:checked").val();

    // Initialisation des champs en fonction de la valeur sélectionnée
    let array_values = select_value.split(":");

    let champ_id = $("#adresse_id").val();
    let valeur_rue = $("#" + champ_id + "_street").val();

    if (valeur_rue !== "") {
        valeur_rue = array_values[0];
        $("#" + champ_id + "_street").val(valeur_rue);
    }

    $("#" + champ_id + "_postalcode").val(array_values[1]);
    $("#" + champ_id + "_city").val(array_values[2]);
    $("#" + champ_id + "_country").val("FRANCE");
    $("#" + champ_id + "_longitude").val(array_values[3]);
    $("#" + champ_id + "_latitude").val(array_values[4]);
    $("#verifAdresseModal").modal("hide");
}