<?php

namespace ODE\Surcharge;

if (!defined('sugarEntry')) define('sugarEntry', true);

class TraitementViewMetadata
{
    private $moduleTab = array();
    private $views = array('detailviewdefs','editviewdefs','listviewdefs','quickcreatedefs','searchdefs');
    private $cheminModule = 'modules/';
    private $cheminPrefixe = 'custom/modules/';
    private $cheminMetadata = '/Surcharge/metadata/';

    public function __construct($moduleTab,$supp = false)
    {
        $this->moduleTab = $moduleTab;
        if($supp){
            $this->suppressionCustom();
        }
        $this->execute();
    }

    private function suppressionCustom(){
        if(!empty($this->moduleTab) && is_array($this->moduleTab)){
            foreach ($this->moduleTab as $module) {
                foreach ($this->views as $view) {
                    $customView = $this->cheminPrefixe.$module.'/metadata/'.$view.'.php';
                    $customViewSurcharge = $this->cheminPrefixe.$module.'/metadata/'.$view.'.php_surcharge';
                    if(is_file($customView)){
                        unlink($customView);
                    }
                    if(is_file($customViewSurcharge) && !is_file($customView)){
                        rename($customViewSurcharge, $customView);
                    }
                }
            }
        }
    }

    private function execute(){
        if(!empty($this->moduleTab) && is_array($this->moduleTab)){

            foreach ($this->moduleTab as $module) {
                $cheminModule = $this->cheminModule.$module.'/metadata/';
                $cheminSurcharge = $this->cheminPrefixe.$module.$this->cheminMetadata;
                foreach ($this->views as $view) {
                    switch ($view) {
                        case 'detailviewdefs':
                        case 'editviewdefs':
                        case 'quickcreatedefs':
                            $this->basicView($view,$cheminModule,$cheminSurcharge,$module);
                            break;
                        case 'listviewdefs':
                            $this->listviewdefs($view,$cheminModule,$cheminSurcharge,$module);
                            break;
                        case 'searchdefs':
                            $this->searchdefs($view,$cheminModule,$cheminSurcharge,$module);
                            break;                    
                        default:
                            break;
                    }
                }
            }
        }else{
            $GLOBALS['log']->fatal(print_r('Aucun module à surcharger',true));
        }
    }

    private function basicView($view,$cheminModule,$cheminSurcharge,$module){

        $fichiers = TraitementViewMetadata::checkDir($view,$cheminSurcharge);

        $viewTab = array(
            'detailviewdefs' => 'DetailView',
            'editviewdefs' => 'EditView',
            'quickcreatedefs' => 'QuickCreate',
        );

        if(!empty($fichiers) && is_array($fichiers)){

            $custom = $this->checkIsCustom($view,$this->cheminPrefixe.$module);
            $metadata = ($custom)?$custom:"$cheminModule$view.php";
            include($metadata);
            $module_name = $module_name ?? $module;
            if(!empty($viewdefs[$module_name]) && !empty($viewTab[$view])){
                //On boucle pour ordonancer les onglets si ce n'est pas déjà fait
                $onglet = 10;
                if(!empty($viewdefs[$module_name][$viewTab[$view]]['templateMeta']['tabDefs'])){
                    foreach (array_keys($viewdefs[$module_name][$viewTab[$view]]['templateMeta']['tabDefs']) as $cle) {
                        if (strpos($cle, 'LBL_ONGLET_') !== 0) {
                            $cleSansPrefixe = preg_replace('/^LBL_/', '', $cle);
                            $lbl = 'LBL_ONGLET_'. $onglet . '_' . $cleSansPrefixe;
                            $viewdefs[$module_name][$viewTab[$view]]['templateMeta']['tabDefs'][$lbl] = $viewdefs[$module_name][$viewTab[$view]]['templateMeta']['tabDefs'][$cle];
                            unset($viewdefs[$module_name][$viewTab[$view]]['templateMeta']['tabDefs'][$cle]); // Supprime l'ancienne clé
                            if(is_array($viewdefs[$module_name][$viewTab[$view]]['panels'][$cle])){
                                $viewdefs[$module_name][$viewTab[$view]]['panels'][$lbl] = $viewdefs[$module_name][$viewTab[$view]]['panels'][$cle];
                                unset($viewdefs[$module_name][$viewTab[$view]]['panels'][$cle]); // Supprime l'ancienne clé
                            }

                            //On modifie le fichier de langue pour prendre en compte le chamgement de lbl
                            $this->addLangue($module_name,$cle,$lbl,'fr_FR');
                            $this->addLangue($module_name,$cle,$lbl,'en_us');
                            $onglet += 10;
                        }
                    }
                }
                //On boucle et on ajoute dans chaque tableau includes (js), tabDefs (Définition des onglets), panels (contenu des onglets)
                foreach ($fichiers as $fichier) {
                    include("$cheminSurcharge$fichier");
                    if(!empty($surchargeviewdefs)){
                        if(!empty($surchargeviewdefs['includes'])){
                            $viewdefs[$module_name][$viewTab[$view]]['templateMeta']['includes'] = array_merge_recursive($viewdefs[$module_name][$viewTab[$view]]['templateMeta']['includes'] ?? [], $surchargeviewdefs['includes']);
                        }
                        if(!empty($surchargeviewdefs['buttons'])){
                            $viewdefs[$module_name][$viewTab[$view]]['templateMeta']['form']['buttons'] = array_merge_recursive($viewdefs[$module_name][$viewTab[$view]]['templateMeta']['form']['buttons'] ?? [], $surchargeviewdefs['buttons']);
                        }
                        if(!empty($surchargeviewdefs['tabDefs'])){
                            $viewdefs[$module_name][$viewTab[$view]]['templateMeta']['tabDefs'] = array_merge_recursive($viewdefs[$module_name][$viewTab[$view]]['templateMeta']['tabDefs'] ?? [], $surchargeviewdefs['tabDefs']);
                        }
                        if(!empty($surchargeviewdefs['panels'])){
                            $viewdefs[$module_name][$viewTab[$view]]['panels'] = $this->array_merge_recursive_custom($viewdefs[$module_name][$viewTab[$view]]['panels'] ?? [], $surchargeviewdefs['panels']);
                        }
                    }
                }
                //Réordonner les onglets par ordre alpha par rapport aux clefs
                if(is_array($viewdefs[$module_name][$viewTab[$view]]['templateMeta']['tabDefs']))
                    ksort($viewdefs[$module_name][$viewTab[$view]]['templateMeta']['tabDefs']);
                if(is_array($viewdefs[$module_name][$viewTab[$view]]['panels'])){
                    ksort($viewdefs[$module_name][$viewTab[$view]]['panels']);
                }
            }

            $chemin = $this->cheminPrefixe.$module.'/metadata';

            if(!is_dir($chemin)){
                mkdir($chemin, 0755, true);
            }

            $monFichier = $chemin.'/'.$view.'.php';

            ob_start(); // Capture la sortie
            $contenuFichier = '<?php $module_name = "' .$module_name.'"; '.PHP_EOL;
            file_put_contents($monFichier, $contenuFichier);
            print_r('$viewdefs[$module_name] = ');
            //Permet de convertir directement le tableau
            var_export($viewdefs[$module_name]);
            print_r(';');
            $contenuFichier = ob_get_clean(); // Récupère la sortie capturée
            //On ajoute dans le fichier sans enlever ce qu'il y a dedans
            file_put_contents($monFichier, $contenuFichier, FILE_APPEND);

        }
    } 

    private function listviewdefs($view,$cheminModule,$cheminSurcharge,$module){
        $fichiers = TraitementViewMetadata::checkDir($view,$cheminSurcharge);

        if(!empty($fichiers) && is_array($fichiers)){
            $custom = $this->checkIsCustom($view,$this->cheminPrefixe.$module);
            $metadata = ($custom)?$custom:"$cheminModule$view.php";
            include($metadata);

            $module_name = $module_name ?? $module;
            if(!empty($listViewDefs[$module_name])){
                foreach ($fichiers as $fichier) {
                    include("$cheminSurcharge$fichier");
                    if(!empty($surchargeviewdefs)){
                        $listViewDefs[$module_name] = array_merge_recursive($listViewDefs[$module_name] ?? [], $surchargeviewdefs);
                    }
                }
            }
            
            uasort($listViewDefs[$module_name], function ($a,$b){
                return $a['ordre'] <=> $b['ordre']; // Opérateur spaceship pour une comparaison plus concise
            });

            $chemin = $this->cheminPrefixe.$module.'/metadata';

            if(!is_dir($chemin)){
                mkdir($chemin, 0755, true);
            }

            $monFichier = $chemin.'/'.$view.'.php';

            ob_start(); // Capture la sortie
            $contenuFichier = '<?php $module_name = "' .$module_name.'"; '.PHP_EOL;
            file_put_contents($monFichier, $contenuFichier);
            print_r('$listViewDefs[$module_name] = ');
            //Permet de convertir directement le tableau
            var_export($listViewDefs[$module_name]);
            print_r(';');
            $contenuFichier = ob_get_clean(); // Récupère la sortie capturée
            //On ajoute dans le fichier sans enlever ce qu'il y a dedans
            file_put_contents($monFichier, $contenuFichier, FILE_APPEND);
        }
    }

    private function searchdefs($view,$cheminModule,$cheminSurcharge,$module){
        $fichiers = TraitementViewMetadata::checkDir($view,$cheminSurcharge);

        if(!empty($fichiers) && is_array($fichiers)){
            $custom = $this->checkIsCustom($view,$this->cheminPrefixe.$module);
            $metadata = ($custom)?$custom:"$cheminModule$view.php";
            include($metadata);

            $module_name = $module_name ?? $module;

            if(!empty($searchdefs[$module_name])){
                foreach ($fichiers as $fichier) {
                    include("$cheminSurcharge$fichier");
                    if(!empty($surchargeviewdefs['basic_search'])){
                        $searchdefs[$module_name]['layout']['basic_search'] = array_merge_recursive($searchdefs[$module_name]['layout']['basic_search'] ?? [], $surchargeviewdefs['basic_search']);
                    }
                    if(!empty($surchargeviewdefs['advanced_search'])){
                        $searchdefs[$module_name]['layout']['advanced_search'] = array_merge_recursive($searchdefs[$module_name]['layout']['advanced_search'] ?? [], $surchargeviewdefs['advanced_search']);
                    }
                }
            }

            $chemin = $this->cheminPrefixe.$module.'/metadata';

            if(!is_dir($chemin)){
                mkdir($chemin, 0755, true);
            }

            $monFichier = $chemin.'/'.$view.'.php';

            ob_start(); // Capture la sortie
            $contenuFichier = '<?php $module_name = "' .$module_name.'"; '.PHP_EOL;
            file_put_contents($monFichier, $contenuFichier);
            print_r('$searchdefs[$module_name] = ');
            //Permet de convertir directement le tableau
            var_export($searchdefs[$module_name]);
            print_r(';');
            $contenuFichier = ob_get_clean(); // Récupère la sortie capturée
            //On ajoute dans le fichier sans enlever ce qu'il y a dedans
            file_put_contents($monFichier, $contenuFichier, FILE_APPEND);
        }
    }

    static function checkDir($view, $cheminSurcharge)
    {
        $fichiers = array();
        $regex = "/^" . preg_quote($view, '/') . "_\w+\.php$/";

        // Récupère tous les fichiers dans le répertoire
        $files = is_dir($cheminSurcharge)? scandir($cheminSurcharge) : [];

        if (!empty($files) && is_array($files)) {
            // Filtre les fichiers qui correspondent à la regex
            $fichiers = array_filter($files, function ($file) use ($regex) {
                return preg_match($regex, $file);
            });

            // Trie les fichiers par date de modification (du plus vieux au plus récent)
            usort($fichiers, function ($a, $b) use ($cheminSurcharge) {
                return filemtime($cheminSurcharge . '/' . $a) - filemtime($cheminSurcharge . '/' . $b);
            });
        }
        return $fichiers;
    }

    private function checkIsCustom($view,$cheminModuleCustom){
        $customView = $cheminModuleCustom.'/metadata/'.$view.'.php';
        $customViewSurcharge = $cheminModuleCustom.'/metadata/'.$view.'.php_surcharge';

        if(is_file($customView) && !is_file($customViewSurcharge)){
            copy($customView,$customViewSurcharge);
            return $customViewSurcharge;
        }else if(is_file($customViewSurcharge)){
            return $customViewSurcharge;
        }

        return '';
    }

    private function array_merge_recursive_custom($originalPanels, $newPanels)
    {
        // Crée une copie du tableau original pour ne pas le modifier
        $mergedPanels = $originalPanels;
    
        // Stocker le dernier ordre par onglet
        $lastOrders = [];
    
        // Assigner des ordres aux panels initiaux
        foreach ($mergedPanels as $tabKey => $tabValue) {

            foreach ($tabValue as $lineIndex => $row) {
                $lineOrder = ($lineIndex + 1) * 10; // Déterminer l'ordre par défaut, de 10 en 10 pour permettre d'ajouter 9 lignes entre chaque ligne
                foreach ($row as $fieldIndex => $field) {
                    // Vérification que le champ est un tableau avant d'attribuer l'ordre
                    // car possibilité de mettre juste "name" par exemple
                    if (is_array($field) && !isset($field['order'])) {
                        $mergedPanels[$tabKey][$lineIndex][$fieldIndex]['order'] = $lineOrder; // Attribuer l'ordre
                    }
                    else if(!is_array($field) && !empty($field)){
                        $mergedPanels[$tabKey][$lineIndex][$fieldIndex] = array("name" => $field, "order" => $lineOrder);
                    }
                }
    
                // Mettre à jour le dernier ordre pour cet onglet
                $lastOrders[$tabKey] = max($lastOrders[$tabKey] ?? 0, $lineOrder);
            }
        }
    
        // Fusion des nouveaux panels
        foreach ($newPanels as $tabKey => $tabValue) {
            // Si l'onglet existe déjà, on l'update
            if (isset($mergedPanels[$tabKey])) {
                foreach ($tabValue as $newRow) {
                    // Vérifie si la ligne existe déjà dans l'onglet en comparant les champs 'name'
                    $exists = false;
    
                    foreach ($mergedPanels[$tabKey] as $existingRow) {
                        // Comparaison sur le champ 'name' du premier élément de la ligne
                        if (isset($existingRow[0]['name']) && $existingRow[0]['name'] === $newRow[0]['name']) {
                            $exists = true; // La ligne avec ce champ existe déjà
                            break; // Sort de la boucle si la ligne existe déjà
                        }
                    }
    
                    // Si la ligne n'existe pas, on l'ajoute
                    if (!$exists) {
                        // Attribuer l'ordre aux nouveaux champs
                        $lineOrder = ($lastOrders[$tabKey] ?? 0) + 10; // On commence après le dernier ordre pour cet onglet
                        foreach ($newRow as $index => $field) {
                            // Vérification que le champ est un tableau avant d'attribuer l'ordre
                            if (is_array($field)) {
                                if (!isset($field['order'])) {
                                    $newRow[$index]['order'] = $lineOrder; // Attribuer l'ordre par défaut
                                }
                            }
                        }
                        $mergedPanels[$tabKey][] = $newRow; // Ajoute la nouvelle ligne
                        $lastOrders[$tabKey] = $lineOrder; // Met à jour le dernier ordre utilisé pour cet onglet
                    }
                }
            } else {
                // Si l'onglet n'existe pas, on l'ajoute directement
                foreach ($tabValue as $index => $row) {
                    // Attribuer un ordre par défaut à la ligne entière
                    $lineOrder = ($lastOrders[$tabKey] ?? 0) + 10; // On commence après le dernier ordre pour cet onglet
                    foreach ($row as $fieldIndex => $field) {
                        // Vérification que le champ est un tableau avant d'attribuer l'ordre
                        if (is_array($field) && !isset($field['order'])) {
                            $row[$fieldIndex]['order'] = $lineOrder; // Attribuer l'ordre
                        }
                    }
                    $mergedPanels[$tabKey][] = $row; // Ajoute la ligne correctement
                    $lastOrders[$tabKey] = $lineOrder; // Met à jour le dernier ordre utilisé pour cet onglet
                }
            }
        }
    
        // Trier les lignes par ordre dans chaque onglet
        foreach ($mergedPanels as $tabKey => $tabValue) {
            usort($mergedPanels[$tabKey], function ($a, $b) {
                // Supposer que l'ordre se trouve dans le premier champ de la ligne
                return (isset($a[0]['order']) ? $a[0]['order'] : PHP_INT_MAX) <=> (isset($b[0]['order']) ? $b[0]['order'] : PHP_INT_MAX);
            });
        }
        $mergedPanels = $this->fusionnerTableauxSiCondition($mergedPanels);
    
        return $mergedPanels; // Renvoie le tableau fusionné avec l'ordre
    }

    function fusionnerTableauxSiCondition($tableau) {
        foreach ($tableau as $key => &$sousTableaux) {
            foreach ($sousTableaux as $index => &$elements) {
                // Vérifier si l'élément suivant existe et si l'order est le même
                $existanteSuivant = isset($sousTableaux[$index + 1]);
                
                // on a bien une ligne suivante (existanteSuivant)(index+1) mais la premiere colonne ([index+1][0]) est vide
                if($existanteSuivant && empty($sousTableaux[$index + 1][0])) continue;

                if ($existanteSuivant && $elements[0]['order'] === $sousTableaux[$index + 1][0]['order'] && !empty($sousTableaux[$index ][0]['name'])) {
                    $suivant = $sousTableaux[$index + 1];

                    // Condition : soit le tableau suivant est vide, soit il n'y a qu'un élément dans le tableau actuel
                    if (empty($suivant[1]) || empty($elements[1])) {
                        unset($elements[1]);
                        // Fusionner les deux tableaux
                        $elements = array_merge_recursive($elements, $suivant);

                        // Supprimer le tableau fusionné
                        unset($sousTableaux[$index + 1]);
                    }
                }
            }
        }
        return $tableau;
    }

    function addLangue($module_name,$cle,$lbl,$langue){
        $GLOBALS['log']->fatal(print_r($module_name,true));
        $GLOBALS['log']->fatal(print_r($cle,true));
        $GLOBALS['log']->fatal(print_r($langue,true));
        include('modules/'.$module_name.'/language/'.$langue.'.lang.php');
        $temp = $mod_strings[$cle];
        $cheminLangue = 'custom/modules/'.$module_name.'/language';
        $chemin = $cheminLangue.'/'.$langue.'.lang.php';
        unset($mod_strings);
        if(is_file($chemin)){
            include($chemin);
            $temp = $mod_strings[$cle] ?? $temp;
        }

        $GLOBALS['log']->fatal(print_r($module_name,true));

        if(!empty($temp)){
            $mod_strings[$lbl] = $temp;

            if(!is_dir($cheminLangue)){
                mkdir($cheminLangue, 0755, true);
            }
            ob_start(); // Capture la sortie
            $contenuFichier = '<?php'.PHP_EOL;
            file_put_contents($chemin, $contenuFichier);
            print_r('$mod_strings = ');
            //Permet de convertir directement le tableau
            var_export($mod_strings);
            print_r(';');
            $contenuFichier = ob_get_clean(); // Récupère la sortie capturée
            //On ajoute dans le fichier sans enlever ce qu'il y a dedans
            file_put_contents($chemin, $contenuFichier, FILE_APPEND);
            ob_end_clean();
        }
    }
}