<?php

namespace ODE\Model;

if (!defined('sugarEntry')) define('sugarEntry', true);

use BeanFactory;

class GenerateurVueModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe GenerateurVueModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données de la personne morale en tableau
     *
     *  @return array               - $appairage: retourne l'appairage de la personne morale
     */
    public function getBean()
    {

        global $db;
        $generateur_vues = array();

        $sql = "SELECT * FROM `ops_generateur_vue` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $generateur_vues[] = $row;
        }

        return (is_array($generateur_vues) && count($generateur_vues) === 1) ? $generateur_vues[0] : array();
    }

    /**
     * @access public
     * @name getChamps()
     * Fonction qui retourne les champs associé au formulaire
     *
     *  @return array               - $champs: lLes champs liée au formulaire
     */
    public function getChamps($only_champ = false)
    {

        global $db;
        $champs = array();
        $sql = "SELECT * FROM `ops_generateur_champ` WHERE `id` IN ( SELECT `ops_generateur_champ_id` FROM `ops_generateur_onglet_ops_generateur_champ` WHERE `ops_generateur_onglet_id` IN ( SELECT `ops_generateur_onglet_id` FROM `ops_generateur_vue_ops_generateur_onglet` WHERE `ops_generateur_vue_id` = '" . $this->id . "' AND `deleted` = '0' ) AND `deleted` = '0' )";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            if (!empty($row['name']) || $only_champ === false) {
                $champs[$row['name']] = $row;
            }
        }
        return (!empty($champs) && count($champs) > 0) ? $champs : array();
    }

    /**
     * @access public
     * @name getChamps()
     * Fonction qui retourne les champs associé au formulaire
     *
     *  @return array               - $champs: lLes champs liée au formulaire
     */
    public function getChampsByOnglet($ordre)
    {

        global $db;
        $champs = array();

        $onglet_id = $this->getOngletIdByOrdre($ordre);
        if (!empty($onglet_id)) {
            $sql = "SELECT * FROM `ops_generateur_champ` WHERE `id` IN ( SELECT `ops_generateur_champ_id` FROM `ops_generateur_onglet_ops_generateur_champ` WHERE `ops_generateur_onglet_id` = '" . $onglet_id . "' AND `deleted` = '0' )";
            $result = $db->query($sql);
            while ($row = $db->fetchByAssoc($result)) {
                if (!empty($row['name'])) {
                    $champs[$row['name']] = $row;
                }
            }
        }

        return (!empty($champs) && count($champs) > 0) ? $champs : array();
    }

    /**
     * @access public
     * @name getOngletIdByOrdre()
     * Fonction qui retourne les onglets associé au formulaire
     *
     *  @return array               - $onglets: lLes champs liée au formulaire
     */
    public function getOngletIdByOrdre($ordre)
    {

        global $db;
        $onglet_id = "";
        $sql_onglets = "SELECT * FROM `ops_generateur_onglet` WHERE `id` IN ( SELECT `ops_generateur_onglet_id` FROM `ops_generateur_vue_ops_generateur_onglet` WHERE `ops_generateur_vue_id` = '" . $this->id . "' AND `deleted` = '0' )";
        $result_onglets = $db->query($sql_onglets);
        while ($row = $db->fetchByAssoc($result_onglets)) {
            if ($row["ordre"] == $ordre) {
                $onglet_id = $row['id'];
            }
        }

        return $onglet_id;
    }

    /**
     * @access public
     * @name getOnglets()
     * Fonction qui retourne les onglets associé au formulaire
     *
     *  @return array               - $onglets: lLes champs liée au formulaire
     */
    public function getOnglets()
    {

        global $db;
        $onglets = [];
        $sql_onglets = "SELECT * FROM `ops_generateur_onglet` WHERE `id` IN ( SELECT `ops_generateur_onglet_id` FROM `ops_generateur_vue_ops_generateur_onglet` WHERE `ops_generateur_vue_id` = '" . $this->id . "' AND `deleted` = '0' )";

        $result_onglets = $db->query($sql_onglets);
        while ($row = $db->fetchByAssoc($result_onglets)) {
            $onglets[$row["ordre"]] = [
                "id" => $row["id"],
                "nom" => $row["name"],
                "libelle" => $row["libelle"],
                "description" => $row["description"],
                "ordre" => $row["ordre"],
                "cle" => $row["cle"],
                "visible" => $row["visible"],
                "modifiable" => $row["modifiable"],
                "conditions" => $row["conditions"],
                "lignes" => $this->getLignes($row['id'])
            ];
        }

        ksort($onglets);

        return $onglets;
    }

    /**
     * @access public
     * @name getLignes( onglet_id )
     * Fonction qui retourne les onglets associé au formulaire
     *
     *  @return array               - $lignes: Les champs liée au formulaire
     */
    public function getLignes($onglet_id)
    {

        global $db;
        $lignes = [];
        $sql_champs = "SELECT * FROM `ops_generateur_champ` WHERE `id` IN ( SELECT `ops_generateur_champ_id` FROM `ops_generateur_onglet_ops_generateur_champ` WHERE `ops_generateur_onglet_id` = '" . $onglet_id . "' AND `deleted` = '0' )";
        $result_champs = $db->query($sql_champs);
        while ($row = $db->fetchByAssoc($result_champs)) {

            if ($row["type"] === "section") {
                $lignes[$row["ligne"]] = [
                    "id" => $row["id"],
                    "type" => "section",
                    "title" => $row["libelle"],
                    "conditions" => $row["conditions"]
                ];
            } else {
                $lignes[$row["ligne"]]["champs"][$row["ordre"]] = ($row["type"] !== "vide") ? $row : [];
            }
        }
        ksort($lignes);

        foreach($lignes as $key => $ligne)
        {
            if (is_array($lignes[$key]["champs"]) && count($lignes[$key]["champs"]) == 1 && $lignes[$key]["type"] != "section") 
            {
                $lignes[$key]["type"] = "ligne_simple_champ";
            } 
            else if($lignes[$key]["type"] != "section") 
            {
                $lignes[$key]["type"] = "ligne_double_champ";
            }
        }

        return $lignes;
    }

    /**
     * @access public
     * @name deleteLignes()
     * Fonction qui retourne 
     *
     *  @return array|boolean               
     */
    public static function deleteLignes($onglet_id)
    {

        global $db;
        $sql_champs = "SELECT `id`,`ops_generateur_champ_id` FROM `ops_generateur_onglet_ops_generateur_champ` WHERE `ops_generateur_onglet_id` = '" . $onglet_id . "' AND `deleted` = '0'";
        $result_champs = $db->query($sql_champs);
        while ($row = $db->fetchByAssoc($result_champs)) {
            $sql_delete_relation_champ = "UPDATE `ops_generateur_onglet_ops_generateur_champ` SET `deleted`='1' WHERE `id` = '" . $row["id"] . "'";
            $sql_delete_champ = "UPDATE `ops_generateur_champ` SET `deleted`='1' WHERE `id` = '" . $row["ops_generateur_champ_id"] . "'";

            $sql_champ_name = "SELECT `name` FROM `ops_generateur_champ` WHERE `id`='".$row["ops_generateur_champ_id"]."'";
            $nameSql = $db->fetchOne($sql_champ_name);
            $champName = '';
            if(!empty($nameSql['name'])){
                $champName = $nameSql['name'];
            }

            $db->query($sql_delete_relation_champ);
            $db->query($sql_delete_champ);
            $resultTab = array();
            $sql = "SELECT `id` FROM `ops_generateur_champ` WHERE `name` = '" . $champName . "' AND `deleted` = '0' LIMIT 1";
            $result = $db->fetchOne($sql);
            $sql_generateur_referentiel = "SELECT `id` FROM `ops_generateur_referentiel` WHERE `deleted`=0 AND `name`='".$champName."'";
            $generateurResult = $db->fetchOne($sql_generateur_referentiel);
            if(!empty($result['id']) && !empty($generateurResult['id'])){
                $sql_utilise_referentiel = "UPDATE `ops_generateur_referentiel` SET `utilise`='1' WHERE `id` = '" . $generateurResult['id'] . "'";
                $db->query($sql_utilise_referentiel);
            }elseif(empty($result['id']) && !empty($generateurResult['id'])){
                $sql_utilise_referentiel = "UPDATE `ops_generateur_referentiel` SET `utilise`='0' WHERE `id` = '" . $generateurResult['id'] . "'";
                $db->query($sql_utilise_referentiel);
            }
        }
    }

    /**
     * @access public
     * @name deleteOnglets()
     * Fonction qui retourne 
     *
     *  @return array|boolean               
     */
    public static function deleteOnglets($vue_id)
    {
        global $db;
        $sql_onglets = "SELECT `id`,`ops_generateur_onglet_id` FROM `ops_generateur_vue_ops_generateur_onglet` WHERE `ops_generateur_vue_id` = '" . $vue_id . "' AND `deleted` = '0'";
        $result_onglets = $db->query($sql_onglets);
        while ($row = $db->fetchByAssoc($result_onglets)) {
            $sql_delete_relation_onglet = "UPDATE `ops_generateur_vue_ops_generateur_onglet` SET `deleted`='1' WHERE `id` = '" . $row["id"] . "'";
            $sql_delete_onglet = "UPDATE `ops_generateur_onglet` SET `deleted`='1' WHERE `id` = '" . $row["ops_generateur_onglet_id"] . "'";
            $db->query($sql_delete_relation_onglet);
            $db->query($sql_delete_onglet);
            GenerateurVueModel::deleteLignes($row["ops_generateur_onglet_id"]);
        }
    }

        /**
     * @access public
     * @name getChampsConditions()
     * Fonction qui retourne un talbeau de condtion des champs en fonction des onglets
     *
     *  @return array               - $conditions: Tableau des conditions
     */
    public function getChampsConditions()
    {
        global $db;
        $conditions = array();

        $sql = "SELECT ops_generateur_champ.id, ops_generateur_champ.name, ops_generateur_champ.type, ops_generateur_champ.conditions, ops_generateur_onglet_ops_generateur_champ.ops_generateur_onglet_id     FROM `ops_generateur_champ` 
                INNER JOIN ops_generateur_onglet_ops_generateur_champ ON ops_generateur_champ.id = ops_generateur_onglet_ops_generateur_champ.ops_generateur_champ_id
                WHERE ops_generateur_champ.id IN ( SELECT `ops_generateur_champ_id` FROM `ops_generateur_onglet_ops_generateur_champ` WHERE `ops_generateur_onglet_id` IN ( SELECT `ops_generateur_onglet_id` FROM `ops_generateur_vue_ops_generateur_onglet` WHERE `ops_generateur_vue_id` = '" . $this->id . "' AND `deleted` = '0' ) AND `deleted` = '0' )";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $champCondition = json_decode( base64_decode($row['conditions']), true );
            if(!empty($champCondition)){
                $name = ($row['type'] == 'section')?$row['id']:$row['name'];
                if(!empty($champCondition['conditions'])){
                     foreach ($champCondition['conditions'] as $condition) {
                        $conditions[$row['ops_generateur_onglet_id']][$condition['champ']][$name] = array('champ' => $name,'data' => $champCondition);
                    }
                }elseif(!empty($champCondition['type_profil'])){
                    $conditions[$row['ops_generateur_onglet_id']]['type_profil_'.$name] = array('type_profil'=>true, $name => array('champ' => $name,'data' => $champCondition));
                }
            }
        }
        return (!empty($conditions) && count($conditions) > 0) ?  base64_encode(json_encode($conditions)) : '';
    }
}
