<?php

namespace ODE\Model;

if (!defined('sugarEntry')) define('sugarEntry', true);

class DomiciliationModel
{

    private $time_start;
    private $time_end;
    private $id;

    /**
     * Constructeur de la classe DomiciliationModel
     * 
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($id)
    {

        $this->time_start = microtime(true);
        $this->time_end = microtime(true);
        $this->id = $id;
    }

    /**
     * @access public
     * @name getBean()
     * Fonction qui retourne les données de la personne morale en tableau
     *
     *  @return array               - $appairage: retourne l'appairage de la personne morale
     */
    public function getBean()
    {

        global $db;
        $domiciliations = array();

        $sql = "SELECT * FROM `ops_domiciliation` WHERE `id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $domiciliations[] = $row;
        }
        return (!empty($domiciliations) && count($domiciliations) === 1) ? $domiciliations[0] : array();
    }

    /**
     * @access public
     * @name getAppairage()
     * Fonction qui retourne l'appairage de la personne morale
     *
     *  @return array               - $appairage: retourne l'appairage de la personne morale
     */
    public function getAppairage()
    {

        global $db;
        $appairages = array();

        $sql = "SELECT * FROM `ops_appairage` WHERE `parent_type` = 'OPS_domiciliation' AND `parent_id` = '" . $this->id . "' AND `logiciel` = 'gestionfin' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $appairages[] = $row;
        }

        return (!empty($appairages) && count($appairages) === 1) ? $appairages[0] : array();
    }

    /**
     * @access public
     * @name getAppairageName()
     * Fonction qui retourne le nom de l'appairage de la personne morale
     *
     *  @return array               - $appairage_name : retourne le nom de l'appairage de la personne morale
     */
    public function getAppairageName()
    {

        $appairage_name = "";
        $appairage = $this->getAppairage();
        if (!empty($appairage) && count($appairage) > 0) {
            if (!empty($appairage['name']) && !empty($appairage['statut']) && $appairage['statut'] === "ok") {
                $appairage_name = $appairage['name'];
            }
        }
        return (!empty($appairage_name) && strpos($appairage_name, "-") !== false) ? explode("-", $appairage_name)[1] : "";
    }


    /**
     * @access public
     * @name getName()
     * Fonction qui retourne le nom de la domiciliation 
     *
     *  @return array               - $domiciliation_name : retourne le nom bic-iban de la domiciliation
     */
    public function getName()
    {

        $domiciliation = $this->getBean();
        if (!empty($domiciliation) && count($domiciliation) > 0) {
            $domiciliation_name = str_replace("_", "", str_replace(" ", "", strtoupper($domiciliation['bic']))) . " - " . str_replace("_", "", str_replace(" ", "", strtoupper($domiciliation['iban'])));
        }
        return (!empty($domiciliation_name)) ? $domiciliation_name : "";
    }

    /**
     * @access public
     * @name getTitulaireId()
     * Fonction qui retourne la personne morale associé à la domiciliation 
     *
     *  @return array               - $domiciliations: les domiciliations de la personne morale 
     */
    public function getTitulaireId()
    {

        global $db;
        $personne_morales = array();
        $sql = " SELECT `ops_personne_morale_id` FROM `ops_personne_morale_ops_domiciliation` WHERE `ops_domiciliation_id` = '" . $this->id . "' AND `deleted` = '0' ";
        $result = $db->query($sql);
        while ($row = $db->fetchByAssoc($result)) {
            $personne_morales[] = $row['ops_personne_morale_id'];
        }
        return (!empty($personne_morales) && count($personne_morales) > 0) ? $personne_morales[0] : array();
    }
}
