<?php

namespace ODE\Helper\ReplaceVariable;

use ODE\Helper\ReplaceVariable;

use BeanFactory;

if (!defined('sugarEntry')) define('sugarEntry', true);

class OPS_individuReplaceVariable
{
    private $bean;

    /**
     * Constructeur de la classe OPS_individuReplaceVariable
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($bean)
    {
        $this->bean = $bean;
    }

    /**
     * Fonction qui remplace les variables du text avec le module OPS_individu comme source
     * 
     * @param object $bean : Bean SuiteCRM
     * @param string $text : Le texte ou il faut remplacer les variables
     * 
     * @return string
     */
    public function remplaceChamps($text = '',$fonction = '', $personne_morale = '',$document_id = '',$typeIndividu = '')
    {
        if (empty($this->bean->object_name) || $this->bean->object_name !== 'OPS_individu') return $text;

        # boucle de remplacement des champs de l'individu dans le mail
        $fields = ReplaceVariable::getBeanFields($this->bean);

        foreach ($fields as $field_name) {
            $fieldDef  = $this->bean->getFieldDefinition($field_name);

            switch (true) {
                case preg_match("#^date_\w*#", $field_name):
                    $field_value = ReplaceVariable::formatDate($this->bean->$field_name);
                    break;
                case $fieldDef['type'] == 'enum':
                    $field_value = ReplaceVariable::getValueFromListe($fieldDef['options'],$this->bean->$field_name);
                    break;
                case $fieldDef['type'] == 'bool':
                    if(!empty($this->bean->$field_name)){
                        $field_value = 'Oui';
                    }else{
                        $field_value = 'Non';
                    }
                    break;
                default:
                    $field_value = $this->bean->$field_name;
                    break;
            }

            if(!empty($fonction)){
                $text = str_replace('$personne_individu_fonction_' . $field_name.'[fonction:'.$fonction.']', $field_value, $text);
                $text = str_replace('$dossier_personne_individu_fonction_' . $field_name.'[fonction:'.$fonction.']', $field_value, $text);
            }

            if($typeIndividu == 'demandeur'){
                $text = str_replace('$demandeur_' . $field_name, $field_value, $text);
            }else if($typeIndividu == 'beneficiaire'){
                $text = str_replace('$beneficiaire_' . $field_name, $field_value, $text);
            }else{
                $text = str_replace('$ops_individu_' . $field_name, $field_value, $text);
            }

        }

        $role = '';
        if($personne_morale != '')
        {
            $this->bean->load_relationship('ops_individu_ops_personne_morale_individu');
            $personne_morale_individu_list = $this->bean->ops_individu_ops_personne_morale_individu->get();
            if(count($personne_morale_individu_list) > 0)
            {
                foreach($personne_morale_individu_list as $personne_morale_individu)
                {
                    $objPersInd = BeanFactory::getBean('OPS_personne_morale_individu', $personne_morale_individu);

                    if($objPersInd->ops_personne_morale_id == $personne_morale)
                    {
                        $role = ReplaceVariable::getValueFromListe('ops_role_list', $objPersInd->role);
                        break;
                    }
                }
            }
        }
        else
        {
            $this->bean->load_relationship('ops_individu_ops_personne_morale_individu');
            $roles = $this->bean->ops_individu_ops_personne_morale_individu->get();

            if(count($roles) > 0)
            {
                $id = $roles[0];

                $objPersInd = BeanFactory::getBean('OPS_personne_morale_individu', $id);

                $role = ReplaceVariable::getValueFromListe('ops_role_list', $objPersInd->role);
            }
        }

        if($typeIndividu == 'demandeur'){
            $text = str_replace('$demandeur_role', $role, $text);
        }else if($typeIndividu == 'beneficiaire'){
            $text = str_replace('$beneficiaire_role', $role, $text);
        }else{
            $text = str_replace('$ops_individu_role', $role, $text);
        }

        # Remplacement des champs document
        if(!empty($document_id)){
            $document = BeanFactory::getBean('Documents',$document_id);
            if(!empty($document->id)){
                $document_replace_variable = new DocumentsReplaceVariable($document);
                $text = $document_replace_variable->remplaceChamps($text);
            }
        }

        return $text;
    }
}