<?php

namespace ODE\Helper\ReplaceVariable;

use BeanFactory;
use ODE\Helper\ReplaceVariable;
use ODE\Generateur\Factory\OdeFieldFactory;
use ODE\Model\DispositifModel;
use ODE\Model\GenerateurReferentielModel;

if (!defined('sugarEntry')) define('sugarEntry', true);

class OPS_dossierReplaceVariable
{
    private $bean;

    /**
     * Constructeur de la classe OdeActionStatut
     *
     * @access public
     * @name __construct
     * @return void
     */
    public function __construct($bean)
    {
        $this->bean = $bean;
    }

    /**
     * Fonction qui remplace les variables du text avec le module OPS_dossier comme source
     * @param object $bean : Bean SuiteCRM
     * @param string $text : Le texte ou il faut remplacer les variables
     * 
     * @return string
     */
    public function remplaceChamps($text = '',$document_id = '')
    {
        global $app_list_strings;
        # Gestion du dispositif
        $text = str_replace('$ops_dossier_ops_dispositif_ops_dossier_name', $this->bean->ops_dispositif_ops_dossier_name, $text);

        # Remplacement champs Extra
        if(strpos($text, '$ops_dossier_commissions') !== false)
        {
            $commission = $this->bean->get_linked_beans("ops_commission_ops_dossier", "OPS_commission",'libelle_court');
            $text = str_replace('$ops_dossier_commissions', $commission[0]->libelle_court, $text);
        }

        if(strpos($text, '$ops_dossier_reunions') !== false)
        {
            $reunion = $this->bean->get_linked_beans("ops_reunion_ops_dossier", "OPS_reunion",'name');
            $text = str_replace('$ops_dossier_reunions', $reunion[0]->name, $text);
        }

        if(strpos($text, '$documents_date_generer') !== false)
        {
            $text = str_replace('$documents_date_generer', ReplaceVariable::formatDate(date('Y-m-d')), $text);
        }

        # Surcharge module Partenaire
        // Si on vient d'un document, on enlève la partie "ops_dossier" de la variable pour les partenaires
        if (strpos($text, '$ops_dossier_ops_avis') !== false) {
            $this->bean->load_relationship('ops_dossier_ops_avis');
            $avis_ids = $this->bean->ops_dossier_ops_avis->get();

            if (count($avis_ids) == 1) { // Si il n'y a qu'une seule sollicitation sur le dossier, on récupère ses informations
                $bean_avis = BeanFactory::getBean('OPS_avis', $avis_ids[0]);
            } elseif (count($avis_ids) > 1) { // Si il y a plus d'une sollicitation sur le dossier, on prend la sollicitation principale pour les variables
                foreach ($avis_ids as $id_avis) {
                    $obj_avis = BeanFactory::getBean('OPS_avis', $id_avis);

                    if ($obj_avis->flag_principal == 1) {
                        $bean_avis = $obj_avis;
                        break;
                    }
                }
            }

            if (!isset($bean_avis)) { // Si il n'y a pas de sollicitation ou pas de sollicitation principale sur le dossier, on ne remplace pas les variables
                $pattern = '/\$ops_dossier_ops_avis_(\w+)/';
                $text = preg_replace($pattern, '', $text);
            } else { // Sinon on remplace les variables par la sollicitation récupérée
                $ReplaceVariable = new OPS_avisReplaceVariable($bean_avis);
                $text = str_replace('$ops_dossier_ops_avis_', '$ops_avis_', $text);
                $text = $ReplaceVariable->remplaceChamps($text);
            }
        }
        # Fin surcharge module Partenaire

        # (#3386) - Remplacement des champs custom du dossier de manière super rapide non iterative, pour chaque occurence unifiée. (Complement RegEx : Numeral)
        $custom_fields = $this->getDossierCustomFields();

        // traitement champs GF
        if (strpos($text, '$ops_dossier_domiciliation_tiers_financier') !== false) {
            $beanDomi = BeanFactory::getBean("OPS_domiciliation", json_decode($custom_fields['domiciliation_tiers_financier'])->id);
            $remplacement = $beanDomi->bic . " - " . $beanDomi->iban;

            $text = str_replace('$ops_dossier_domiciliation_tiers_financier', $remplacement, $text);
        }
        if (strpos($text, '$ops_dossier_tiers_financier') !== false) {
            $remplacement = json_decode($custom_fields['tiers_financier'])->libelle;
            $remplacement = str_replace([" (Profil)", " (Demandeur)", " (Mandataire du demandeur)", " (Partenaire)"], ['', '', '', ''], $remplacement);

            $text = str_replace('$ops_dossier_tiers_financier', $remplacement, $text);
        }

                
        //Pour les champs d'un tableau
        $reTab = '/(\$ops)([_]([a-z0-9]*))*(\[[0-9]+,[0-9]+\])+/mi';
        $matchesTab = [];
        if( preg_match_all($reTab, $text, $matchesTab, PREG_SET_ORDER, 0) ){
            uasort($matchesTab, function ($field_1, $field_2) {
                return ( ( strlen($field_2[0]) == strlen($field_1[0]) )? 0 : ( ( strlen($field_2[0]) < strlen($field_1[0]) )? -1 : 1 ) );
            });
        }
        $matchedFieldsTab = array_values( $matchesTab );

        if(!empty($matchedFieldsTab)){
            foreach ($matchedFieldsTab as $re) {
                if(preg_match('/\$(\w+)\[(\d+),(\d+)\]/', $re[0], $matches)){
                    $nomChamp = $matches[1];
                    $ligne = $matches[2];
                    $colonne = $matches[3];

                    $replaceFinal = '';

                    if( isset( $custom_fields[ str_replace( 'ops_dossier_', '', trim($nomChamp) ) ] ) )
                    {
                        $replaced = $custom_fields[ str_replace( 'ops_dossier_', '', trim($nomChamp) ) ];

                        $replaceFinal = $replaced['valeurs'][$ligne-1][$colonne-1];
                        if($replaced['params']['colonnes'][$colonne-1]['format'] == 'liste_deroulante'){
                            $replaceFinal = $replaced['params']['colonnes'][$colonne-1]['format_liste_valeurs'][$replaceFinal];
                        }
                    }

                    $text = str_replace($re[0], $replaceFinal, $text);
                }
            }
        }

        $re = '/(\$ops)([_]([a-z0-9]*))*/mi';
        $matches = [];
        if( preg_match_all($re, $text, $matches, PREG_SET_ORDER, 0) ){
            uasort($matches, function ($field_1, $field_2) {
                return ( ( strlen($field_2[0]) == strlen($field_1[0]) )? 0 : ( ( strlen($field_2[0]) < strlen($field_1[0]) )? -1 : 1 ) );
            });
        }
        $matched_fields = array_values( $matches );

        // La micro boucle permet aussi de faire un comptage et autorise le débuggage sur la RegEx dynamique...
        for ($i = 0; $i < count($matched_fields); $i++) { 
            $re = '/('."\\". $matched_fields[$i][0] .')/'; 
            // On préserve la clé si ce le champ n'existe pas dans les custom_fields...
            $replaced = isset( $custom_fields[ str_replace( '$ops_dossier_', '', trim($matched_fields[$i][0]) ) ] )? $custom_fields[ str_replace( '$ops_dossier_', '', trim($matched_fields[$i][0]) ) ] : str_replace( '$ops_dossier_', '$__ops_dossier_', trim($matched_fields[$i][0]) ) ; // Trick ( $__ops_ vs $ops_ ).

            if(is_array($replaced))
            {
                if($replaced['type'] == 'tableau')
                {
                    $text = preg_replace( $re, $replaced['pdf'], $text);
                }
            }
            else
            {
                $text = preg_replace( $re, $replaced, $text);
            }
        }
        // Restoration de la clé - reverse trick -
        $text = preg_replace( '/('."\\". '$__ops_dossier_' .')/', '$ops_dossier_', $text );

        # On récupére les champs de type liste 
        $fields_type_liste = ReplaceVariable::getBeanFieldsTypeListe($this->bean);
 
        # boucle de remplacement des champs de la dossier dans le mail
        $fields = ReplaceVariable::getBeanFields($this->bean);

        $dispositifModel = new DispositifModel($this->bean->ops_dispositif_id);
        $champsVueAgent = $dispositifModel->getChampsVueAgent();

        # (#3386) - Stockage des champs basic chaîne (non liste) du dossier en les identifiant/séparant.
        $simple_basic_fields = []; 

        foreach ($fields as $field_name) {

            $field_value = $this->bean->$field_name;

            # Traitement des champs de type liste (non custom), on envoie la valeur de la liste et non pas la clé
            if ( array_key_exists($field_name, $champsVueAgent) &&  $champsVueAgent[$field_name]['description'] == 'basic' && !empty($champsVueAgent[$field_name]['params']) )
            {
                $field = $champsVueAgent[$field_name];
                $params = ( !empty($field['params']) ) ? json_decode(base64_decode($field['params']),true) : '';

                if(isset($params['liste']))
                {
                    if($params['multiple'] == 0)
                    {
                        $field_value = $params['liste'][$field_value];
                    }
                    else
                    {
                        $champs = str_replace('^', '', $field_value);
                        $champs = explode(',', $champs);
                        $dernier = end(array_keys($champs));
                        $text_serie = '';
                        foreach ($champs as $key => $value) {
                            if($key == $dernier){
                                $text_serie .= $params['liste'][$value];
                            }else{
                                $text_serie .= $params['liste'][$value].', ';
                            }
                        }
                        $field_value = $text_serie;
                    }  
                }
                else if ( array_key_exists($field_name, $fields_type_liste) ) 
                {
                    $field_value = ReplaceVariable::getValueFromListe($fields_type_liste[$field_name],$field_value);
                }
            }
            else if ( array_key_exists($field_name, $fields_type_liste) ) 
            {
                $field_value = ReplaceVariable::getValueFromListe($fields_type_liste[$field_name],$field_value);
            }
            # (#3386) - Identification et séparation des champs basic simple (non liste).
            else{
                $simple_basic_fields[$field_name] = $field_value;
            }

            switch (true) {
                case preg_match("#^date_\w*#", $field_name):
                    if($field_name == 'date_transmission' && empty($this->bean->$field_name)){
                        $field_value = ReplaceVariable::formatDate(date('Y-m-d'));
                    }else{
                        $field_value = ReplaceVariable::formatDate($this->bean->$field_name);
                    }
                    $text = str_replace('$ops_dossier_' . $field_name, $field_value, $text);
                    break;
                case $field_name === 'ops_statut_id':
                    $objStatut = BeanFactory::getBean('OPS_statut', $this->bean->$field_name);
                    $field_value = !empty($objStatut->name) ? $objStatut->name : '';
                    $text = str_replace('$ops_dossier_' . $field_name, $field_value, $text);
                    break;
                case $field_name === 'ops_etape_id':
                    $objEtape = BeanFactory::getBean('OPS_etape', $this->bean->$field_name);
                    $field_value = !empty($objEtape->name) ? $objEtape->name : '';
                    $text = str_replace('$ops_dossier_' . $field_name, $field_value, $text);
                    break;
                case $field_name === 'ops_exercice_id':
                    $objExercice = BeanFactory::getBean('OPS_exercice', $this->bean->$field_name);
                    $field_value = !empty($objExercice->name) ? $objExercice->name : '';
                    $text = str_replace('$ops_dossier_' . $field_name, $field_value, $text);
                    break;
                case preg_match("#^ops_individu\d*_id$#", $field_name):
                    $objIndividu = BeanFactory::getBean('OPS_individu', $this->bean->$field_name);
                    $field_value = !empty($objIndividu->id) ?  $objIndividu->salutation . ' ' . $objIndividu->firdt_name . ' ' . $objIndividu->last_name : '';
                    $text = str_replace('$ops_dossier_' . $field_name, $field_value, $text);
                    break;
                default:
                    $odeFieldFactory = new OdeFieldFactory($this->bean, false, []);
                    $field_value = $odeFieldFactory->getChampPdfValue($champsVueAgent[$field_name]);
                    break;
            }

            // Autorise le remplacement de ce champ seulement si il ne vient d'être stocké dans $simple_basic_fields...
            if( !isset( $simple_basic_fields[$field_name] ) ){
                $text = str_replace('$ops_dossier_' . $field_name, $field_value, $text);
            }

        }

        # (#3386) - Remplacement des champs basic chaîne (non liste) du dossier de manière super rapide non iterative, pour chaque occurence unifiée. (Complement RegEx : Numeral)
        $re = '/(\$ops)([_]([a-z0-9]*))*/mi';
        $matches = [];
        if( preg_match_all($re, $text, $matches, PREG_SET_ORDER, 0) ){
            uasort($matches, function ($field_1, $field_2) {
                return ( ( strlen($field_2[0]) == strlen($field_1[0]) )? 0 : ( ( strlen($field_2[0]) < strlen($field_1[0]) )? -1 : 1 ) );
            });
        }
        $matched_fields = array_values( $matches );

        // La micro boucle permet aussi de faire un comptage et autorise le débuggage sur la RegEx dynamique...
        for ($i = 0; $i < count($matched_fields); $i++) { 

            $re = '/('."\\". $matched_fields[$i][0] .')/'; 
            // On préserve la clé si ce le champ n'existe pas dans les simple_basic_fields...
            $replaced = isset( $simple_basic_fields[ str_replace( '$ops_dossier_', '', trim($matched_fields[$i][0]) ) ] )? $simple_basic_fields[ str_replace( '$ops_dossier_', '', trim($matched_fields[$i][0]) ) ] : str_replace( '$ops_dossier_', '$__ops_dossier_', trim($matched_fields[$i][0]) ) ; // Trick ( $__ops_ vs $ops_ ).

            $text = preg_replace( $re, $replaced, $text);
        }
        // Restoration de la clé - reverse trick -
        $text = preg_replace( '/('."\\". '$__ops_dossier_' .')/', '$ops_dossier_', $text );

        # Initialisation des champs du beneficiaire
        $beneficiaire = BeanFactory::getBean('OPS_individu', $this->bean->beneficiaire_id);
        if (!empty($beneficiaire->id)) {
            $individu_replace_variable = new OPS_individuReplaceVariable($beneficiaire);
            $text = $individu_replace_variable->remplaceChamps(text:$text,typeIndividu:'beneficiaire');
        }

        # Initialisation des champs du demandeur
        $demandeur = BeanFactory::getBean('OPS_individu', $this->bean->ops_individu_id);
        if (!empty($demandeur->id)) {
            $individu_replace_variable = new OPS_individuReplaceVariable($demandeur);
            $text = $individu_replace_variable->remplaceChamps(text:$text,personne_morale:$this->bean->ops_personne_morale,typeIndividu:'demandeur');
        }

        # Initialisation des champs du profil
        $profil = BeanFactory::getBean('OPS_personne_morale', $this->bean->ops_personne_morale);
        if (!empty($profil->id)) {
            $personne_morale_replace_variable = new OPS_personne_moraleReplaceVariable($profil);
            $text = $personne_morale_replace_variable->remplaceChamps($text);
        }

        # Remplacement des champs utilisateur assigné
        $user = BeanFactory::getBean('Users', $this->bean->assigned_user_id);
        if (!empty($user->id)) {
            $user_replace_variable = new UsersReplaceVariable($user);
            $text = $user_replace_variable->remplaceChamps(text:$text,typeUser:'$assigned_user_name_');
            $text = $user_replace_variable->remplaceChamps(text:$text,typeUser:'$contact_user_');
        }else{
            $user_replace_variable = new UsersReplaceVariable($user);
            $text = $user_replace_variable->removeVar(text:$text,typeUser:'$assigned_user_name_');
            $text = $user_replace_variable->removeVar(text:$text,typeUser:'$contact_user_');
        }

        # Remplacement des champs utilisateur création
        $user = BeanFactory::getBean('Users', $this->bean->created_by);
        if (!empty($user->id)) {
            $user_replace_variable = new UsersReplaceVariable($user);
            $text = $user_replace_variable->remplaceChamps(text:$text,typeUser:'$created_by_name_');
        }else{
            $user_replace_variable = new UsersReplaceVariable($user);
            $text = $user_replace_variable->removeVar(text:$text,typeUser:'$created_by_name_');
        }

        # Remplacement des champs utilisateur modification
        $user = BeanFactory::getBean('Users', $this->bean->modified_user_id);
        if (!empty($user->id)) {
            $user_replace_variable = new UsersReplaceVariable($user);
            $text = $user_replace_variable->remplaceChamps(text:$text,typeUser:'$modified_by_name_');
        }else{
            $user_replace_variable = new UsersReplaceVariable($user);
            $text = $user_replace_variable->removeVar(text:$text,typeUser:'$modified_by_name_');
        }

        # Remplacement des champs document
        if(!empty($document_id)){
            $document = BeanFactory::getBean('Documents',$document_id);
            if(!empty($document->id)){
                $document_replace_variable = new DocumentsReplaceVariable($document);
                $text = $document_replace_variable->remplaceChamps($text);
            }
        }

        # Surchage BON
        if(isset($app_list_strings['moduleList']['OPS_bon'])){
            $this->bean->load_relationship('ops_bon_ops_dossier');
            $bon = $this->bean->ops_bon_ops_dossier->get();
    
            //Initialisation des champs du bon
            if(count($bon) > 0)
            {
                $bon = BeanFactory::getBean('OPS_bon', $bon[0]);
                if (!empty($bon->id)) 
                {
                    $bon_replace_variable = new OPS_bonReplaceVariable($bon);
                    $text = $bon_replace_variable->remplaceChamps($text);
                }
            }
        }
        # Fin Surcharge

        # Récupère tout les noms de relations
        $linkedFields = $this->bean->get_linked_fields();

        # Gère la partie relationship
        foreach ($linkedFields as $relationship) {
            if(strpos($text, '$' . $relationship['name'] . '_name') !== false) {
                if (preg_match_all('/\$' . $relationship['name'] . '_name_([a-zA-Z0-9_-]+)/', $text, $matches)) {
                    $relatedBean = $this->bean->get_linked_beans($relationship['name'], $relationship['module']);
                    foreach ($matches[1] as $field) {
                        if(!empty($relatedBean) && is_array($relatedBean) && sizeof($relatedBean) > 0 && isset($relatedBean[0]->field_defs[$field])) {
                            $field_value = '';
                            switch($relatedBean[0]->field_defs[$field]['type']) {
                                case 'enum':
                                    $field_value = ReplaceVariable::getValueFromListe($relatedBean[0]->field_defs[$field]['option'], $relatedBean[0]->$field);
                                    break;
                                case 'date':
                                    $field_value = ReplaceVariable::formatDate($relatedBean[0]->$field);
                                    break;
                                case 'bool':
                                    if(!empty($relatedBean[0]->$field)) {
                                        $field_value = 'Oui';
                                    }else{
                                        $field_value = 'Non';
                                    }
                                    break;
                                default:
                                    $field_value = $relatedBean[0]->$field;
                                    break;
                            }
                            $text = str_replace('$' . $relationship['name'] . '_name_' . $field, $field_value, $text);
                        }
                    }
                }
            }
        }

        $text = str_replace("&#13;", "<br>", $text);

        return $text;
    }

    /**
     * #3385
     * Fonction qui retourne les champs custom du dossier 
     * On ne test pas si le bean est de type OPS_dossier, cette fonction est appelé uniquement par remplaceChampsDossier()
     * @param object $bean : Bean SuiteCRM
     * 
     * @return array
     */
    protected function getDossierCustomFields()
    {
        # Si la classe est mal initialisé, on retourne un tableau vide
        if (empty($this->bean->id)) return [];

        # On récupére la liste des champs custom de la vue agent
        $dispositifModel = new DispositifModel($this->bean->ops_dispositif_id);
        $champsVueAgent = $dispositifModel->getChampsVueAgent();

        # On fait un tri décroissant ici aussi sur la longueur des clés. (donc une comparaison sur >)
        uasort($champsVueAgent, function ($field_1, $field_2) {
            return strlen($field_2['name']) > strlen($field_1['name']);
        });

        # On initialise la classe OdeFieldFactory
        $odeFieldFactory = new OdeFieldFactory($this->bean, false, []);

        # On boucle sur les champs du referentiel, on récupere la valeur si elle existe sur le dossier sinon string vide
        $fields = [];
        foreach ($champsVueAgent as $field_name => $field) 
        {
            if($field['description'] == 'custom')
            {
                if($field['type'] == 'tableau'){
                    $fields[$field_name] = $odeFieldFactory->getChampTableauValue($field);
                    $fields[$field_name]['type'] = 'tableau';
                    $fields[$field_name]['pdf'] = $odeFieldFactory->getChampPdfValue($field);
                }else{
                    $fields[$field_name] = $odeFieldFactory->getChampPdfValue($field);
                }
            }
        }

        return $fields;
    }
}