<?php

namespace ODE\Helper\ReplaceVariable;

use ODE\Helper\ReplaceVariable;
use Datetime;
use DateTimeZone;
use BeanFactory;
use TimeDate;

if (!defined('sugarEntry'))
	define('sugarEntry', true);

class MeetingReplaceVariable
{
	private $bean;

	/**
	 * Constructeur de la classe OdeActionStatut
	 *
	 * @access public
	 * @name __construct
	 * @return void
	 */
	public function __construct($bean)
	{
		$this->bean = $bean;
	}

	/**
	 * Remplace les variables du texte avec le module Meeting comme source
	 * @param string $text : Le texte ou il faut remplacer les variables
	 *
	 * @return string
	 */
	public function remplaceChamps($text = '', $document_id = '')
	{
		global $current_user;

		if (empty($current_user->id)) {
			$current_user = BeanFactory::getBean("Users", "1");
		}

		$timeZone = TimeDate::userTimezone($current_user);

		# boucle de remplacement des champs de rdv dans le mail
		$fields = ReplaceVariable::getBeanFields($this->bean);
		foreach ($fields as $field_name) {
			switch (true) {
				case preg_match("#^date_start$#", $field_name):
					$date = $this->convert_date($this->bean->$field_name, "d/m/Y", $timeZone);
					$heure = $this->convert_date($this->bean->$field_name, "H:i", $timeZone);
					$field_value = $date ;

					$text = str_replace('$meetings_heure', $heure, $text);

					break;
				case preg_match("#^motif_autre$#", $field_name) ||preg_match("#^ops_agendas_motifs_meetings_name$#", $field_name):
					if(!empty($this->bean->motif_autre)){
						$valMotif=$this->bean->motif_autre;
						$text = str_replace('$meetings_ops_agendas_motifs_meetings_name', $valMotif, $text);				
					} else{
						$valMotif=$this->bean->$field_name;
						$text = str_replace('$meetings_ops_agendas_motifs_meetings_name', $valMotif, $text);
					}

					
					break;
				case preg_match("#name#", $field_name):

					$obj_individu = BeanFactory::getBean('OPS_individu', $this->bean->ops_individu_id);

					$text = str_replace('$meetings_individu_last_name',  $obj_individu->last_name, $text);
					$text = str_replace('$meetings_individu_first_name', $obj_individu->first_name, $text);
					$text = str_replace('$meetings_individu_salutation', $obj_individu->salutation, $text);
					$text = str_replace('$meetings_participant', $this->bean->$field_name, $text);

					$field_value =  $this->bean->$field_name;
					break;
				case preg_match("#location_id#", $field_name):

					// Récupération du tel du lieu
					$obj_lieu = BeanFactory::getBean('OPS_lieux', $this->bean->location_id);
					$text = str_replace('$meetings_tel_location', $obj_lieu->tel , $text);
					
					$field_value =  $this->bean->$field_name;
					break;

				default:
					$field_value = $this->bean->$field_name;
					break;
			}
			$text = str_replace('$meetings_' . $field_name, $field_value, $text);
		}

		$text = preg_replace("#[$]meetings_\w*#", '', $text);

		return $text;
	}

	/**
	 * Convertir une date en chaine formatée
	 * @param mixed $date
	 * @param string $format
	 * @param string $zone
	 */
	private function convert_date($date, $format, $zone = "UTC")
	{

		if (substr($date, 4, 1) == "-") {
			$annee = substr($date, 0, 4);
			$mois = substr($date, 5, 2);
			$jours = substr($date, 8, 2);
			$heure = substr($date, 11, 2);
			$minute = substr($date, 14, 2);
			$datetime = $annee . '-' . $mois . '-' . $jours . ' ' . $heure . ':' . $minute . ':' . '00';

			$date = new DateTime($datetime, new DateTimeZone('UTC'));
			$date->setTimezone(new DateTimeZone($zone));
			$date_sortie = $date->format($format);

		} else {

			$jours = substr($date, 0, 2);
			$mois = substr($date, 3, 2);
			$annee = substr($date, 6, 4);
			$heure = substr($date, 11, 2);
			$minute = substr($date, 14, 2);

			$dateTime = $annee . '-' . $mois . '-' . $jours . ' ' . $heure . ':' . $minute . ':' . '00';

			$date = new DateTime($dateTime, new DateTimeZone($zone));

			$date->setTimezone(new DateTimeZone($zone));
			$date_sortie = $date->format($format);
		}
		return $date_sortie;
	}
}