var OdeBic = {};

OdeBic.initialisation = function(){
    $("[data-domi=bic]").each(function() {
        $(this).inputmask();
    });
}

OdeBic.isValid = function( field ){ 
    
    var isCorrect = true;
    if(field.attr('data-domi') !== undefined && field.attr('data-domi') == 'bic' && field.val() != ''){
        var bic = field.val().replaceAll('_','');
        bic = bic.replaceAll(' ', '');
        var validateBIC = OdeBic.validateBIC(bic);
        if(!validateBIC){
        isCorrect = false;
        }
    }
    if(isCorrect){
        OdeValidator.hideErreur(field);
        return true;
    }else{
        OdeValidator.showErreur(field , 'Le format BIC est incorrect');
    }
    return false;
}

OdeBic.getValue = function( field ){
    if($(field).attr('data-domi') == 'bic'){
        var val = $(field).val().replaceAll('_', '');
        return val.toUpperCase();
    }
    return '';
}

OdeBic.validateBIC =  function(bic){
    var newBIC = bic.toUpperCase();

    if ( ( newBIC.length != 11 ) && ( newBIC.length != 8 ) ) {
        return false;
    }

    var reg = new RegExp('[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}');

    if( reg.test(newBIC) ){
        return true;
    }
    else{
        return false;
    }
}

$(document).ready(function() {
    if ( typeof OdeFields !== 'undefined' ) {
        OdeFields['bic'] = OdeBic;
    }
});
