<?php

namespace ODE\Generateur\Field;
use Sugar_Smarty;

class OdeWysiwyg extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean			    $bean: Bean du module OPS_dossier
     * @param boolean			$editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        global $app_list_strings;
        
        // On récupere la valeur à afficher
        $value = $this->getFieldValue($value_bdd);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';
        $autre = ' rel="as-input-text"';

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $style = ' class="input-text"';
        }else{
            $style = ' style="width: 95%; border: 1px solid #b8daef; background: #c3e7fd; border-radius: 4px; padding: 5px;min-height: 47px;margin-left: 10px;"';
        }
    
        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("required", "");
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("autre", $autre);
        $smarty->assign("style", $style);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("aria", $champ["libelle"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/wysiwyg.tpl");

        return $field_label . $field_html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array			$champ: La définition du champ
     *  @param string			$value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $value = $this->getFieldDefautValue($champ["defaut"]);
        } else {
            $value = $this->getFieldValue($value_bdd);
        }

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';
        $autre = (isset($champ['ineditable']) && $champ['ineditable'] == 1)?1:0;

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("autre", ' rel="wysiwyg" id="'.$this->getUniqueId().'" is_readonly="'.$autre.'"');
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("aria", $champ["libelle"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/textarea_wysiwyg.tpl");

        return $field_label . $field_html;
    }

    public function getFieldValue($value_bdd)
    {
        return (!empty($value_bdd)) ? base64_decode($value_bdd) : "";
    }

    public function getFieldDefautValue($value_defaut)
    {
         $defautTab = json_decode( base64_decode($value_defaut), true);

        if(!empty($defautTab)){
            if($defautTab['defaut'] == 'autre'){
                $value_defaut = $defautTab['defaut_value']; 
            }
            elseif($defautTab['defaut'] == 'url'){
                $value_defaut = '';
                $isDefaut = 'data-defaut="url" data-url-attr="'.$defautTab['defaut_value'].'"';
            }
            else{
                $value_defaut = $this->getDefautValue($defautTab, 'text');
                if(!empty($defautTab['defaut']) && isset($isDefaut)){
                    $isDefaut = 'data-defaut="defaut"';
                }
            }
        }
        return (!empty($value_defaut)) ? str_replace('"', '&quot;',  html_entity_decode($value_defaut) ) : "";
    }
    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array			$champ: La définition du champ
     *  @param string			$value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        return (!empty($value)) ? base64_decode($value) : "";
    }

    public function getLabelField($name = "", $libelle = "", $aide = "", $obligatoire = 0, $multi = '')
    {
        $required = ( $obligatoire == "1" ) ? ' data-required="true" ' : '';
        $smarty = new Sugar_Smarty();
        $smarty->assign("required", $required);
        $smarty->assign("aide", $aide);
        $smarty->assign("label", $libelle);
        $smarty->assign("multi", $multi);
        return $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/label_wysiwyg.tpl");
    }

    public function getUniqueId()
    {
        return "id_".strtoupper(hash("sha256", time() . rand()));
    }

    public static function getLibelle()
    {
        return "Wysiwyg";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeWysiwyg::getLibelle(),
            'icon' => 'fas fa-keyboard',
            'route' => '/champs/?type=wysiwyg',
            'attributes' => '',
        ];
    }
}
