<?php

namespace ODE\Generateur\Field;
use Sugar_Smarty;
use BeanFactory;
use Configurator;

class OdeTableau extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        global $app_list_strings;

        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();

        // On récupere la valeur à afficher
        $defautTab = $this->getFieldDefautValue($champ["params"]);
        $value = $this->getFieldValue($value_bdd);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';
        $autre = '';
        $isCalcul = false;
    
        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("defautTab", $defautTab);
        $smarty->assign("params", base64_encode(json_encode($defautTab['colonnes'])));
        $smarty->assign("aria", $champ["libelle"]);
        $smarty->assign("separateur", $configuratorObj->config['default_number_grouping_seperator']);
        $smarty->assign("decimal", $configuratorObj->config['default_decimal_seperator']);

        // Front use a real base64 JSON encoded format.
        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){

            foreach ($value as &$tab) {
                foreach ($tab as $key => &$ligne) {
                    if($defautTab['colonnes'][$key]['calcul']) $isCalcul = true; 
                    if(!empty($defautTab['colonnes'][$key]) && $defautTab['colonnes'][$key]['format'] == 'liste_deroulante' && !empty($ligne)){
                        if(!empty($defautTab['colonnes'][$key]['format_liste_valeurs'][$ligne])){
                            $ligne = $defautTab['colonnes'][$key]['format_liste_valeurs'][$ligne];
                        }
                    }
                    elseif(!empty($defautTab['colonnes'][$key]) && ($defautTab['colonnes'][$key]['format'] == 'calcul' || $defautTab['colonnes'][$key]['format'] == 'montant' || $defautTab['colonnes'][$key]['format'] == 'nombre') && !empty($ligne) && !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
                        $ligne = str_replace($configuratorObj->config['default_decimal_seperator'], ".",  $ligne);
                    }
                    elseif(!empty($defautTab['colonnes'][$key]) && ($defautTab['colonnes'][$key]['format'] == 'calcul' || $defautTab['colonnes'][$key]['format'] == 'montant' || $defautTab['colonnes'][$key]['format'] == 'nombre') && !empty($ligne) ){
                        $ligne = str_replace($configuratorObj->config['default_decimal_seperator'], ".",  $ligne);
                    }
                }
            }

            // Potentially data value contains the final Total row values!
            // Detect it an remove to reflow only the real data values without the Total row...
            $total_row = null;
            if( $isCalcul ){
                $total_row = array_pop($value); // Value reduced of its last row
            }

            // Assign informations about lines labels.
            $smarty->assign("lignes", base64_encode(json_encode($defautTab['lignes']))); // data-lines

            $value = base64_encode(json_encode($value));
            $smarty->assign( "value", $value ); // Base64 JSON coded
        }else{
            foreach ($value as &$tab) {
                foreach ($tab as $key => &$ligne) {
                    if($defautTab['colonnes'][$key]['calcul']) $isCalcul = true; 
                    if(!empty($defautTab['colonnes'][$key]) && $defautTab['colonnes'][$key]['format'] == 'liste_deroulante' && !empty($ligne)){
                        if(!empty($defautTab['colonnes'][$key]['format_liste_valeurs'][$ligne])){
                            $ligne = $defautTab['colonnes'][$key]['format_liste_valeurs'][$ligne];
                        }
                    }
                    elseif(!empty($defautTab['colonnes'][$key]) && ($defautTab['colonnes'][$key]['format'] == 'calcul' || $defautTab['colonnes'][$key]['format'] == 'montant' || $defautTab['colonnes'][$key]['format'] == 'nombre') && !empty($ligne) && !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
                        $ligne = str_replace( ".",$configuratorObj->config['default_decimal_seperator'],  $ligne);
                    }
                    elseif(!empty($defautTab['colonnes'][$key]) && ($defautTab['colonnes'][$key]['format'] == 'calcul' || $defautTab['colonnes'][$key]['format'] == 'montant' || $defautTab['colonnes'][$key]['format'] == 'nombre') && !empty($ligne) ){
                        $ligne = str_replace( ".",$configuratorObj->config['default_decimal_seperator'],  $ligne);
                    }
                }
            }

            if(!empty($value) &&  ( (count($value) < count($defautTab['lignes'])) || (count($value) < count($defautTab['lignes'])+1 && $isCalcul ) ) ){
                $check = ($isCalcul)?count($defautTab['lignes'])+1 - count($value):count($defautTab['lignes']) - count($value);
                for($i = 0; $i < $check; $i++){
                    $tableau = array();
                    for ($j = 0; $j < count($defautTab['colonnes']); $j++) {
                        $tableau[]  = '';
                    }
                    if($isCalcul){
                        // Index de l'avant-dernière ligne
                        $index = count($value) - 1;
                        // Insérer l'élément à l'index de l'avant-dernière ligne
                        array_splice($value, $index, 0, array($tableau));
                    }else{
                        array_push($value, $tableau);
                    }
                }
            }
            $smarty->assign("value", $value);
        }

        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("autre", $autre);
        $smarty->assign("style", $style);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("view", 'detail');

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            // This a custom field served on the full line, so pick a dedicated label field.
            $smarty->assign("label", $champ["libelle"]);

            $regex = '/^([A-Za-z0-9+\/]{4})*([A-Za-z0-9+\/]{3}=|[A-Za-z0-9+\/]{2}==)?$/';
            if( !empty($champ["aide"]) && preg_match($regex,$champ["aide"])){
                $aide = base64_decode($champ["aide"]);
            }
            $smarty->assign("aide", $aide);

            // No required usage in detail view...
            $smarty->assign("ctx_err_msg", "");
            $smarty->assign("data_required", "");

            $field_html = $field_label ."\n". $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/tableau_front.tpl");
        }else{
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/tableau.tpl");
        }

        return $field_html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        global $app_list_strings;
        
        $configuratorObj = new Configurator();
        $configuratorObj->loadConfig();
        
        // On récupere la valeur à afficher
        $defautTab = $this->getFieldDefautValue($champ["params"]);
        $value = $this->getFieldValue($value_bdd);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';
        $ligne = (!empty($defautTab['lignes'][0]))?"data-ligne=ligne":"";

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("defautTab", $defautTab);
        $smarty->assign("params", base64_encode(json_encode($defautTab['colonnes'])));
        $autre = ' data-decimal="1" data-separateur="'.$configuratorObj->config['default_number_grouping_seperator'].'" data-separateur-decimal="'.$configuratorObj->config['default_decimal_seperator'].'" '.$ligne;

        // Front use a real base64 JSON encoded format.
        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){

            $isCalcul = false;
            foreach ($value as &$tab) {
                foreach ($tab as $key => &$ligne) {
                    if($defautTab['colonnes'][$key]['calcul']) $isCalcul = true; 
                }
                break;
            }
            // Potentially data value contains the final Total row values!
            // Detect it an remove to reflow only the real data values without the Total row...
            $total_row = null;
            if( $isCalcul ){
                $total_row = array_pop($value); // Value reduced of its last row
            }

            // Assign informations about lines labels.
            $smarty->assign("lignes", base64_encode(json_encode($defautTab['lignes']))); // data-lines

            $value = base64_encode(json_encode($value));
            $smarty->assign( "value", $value ); // Base64 JSON coded
        }else{
            if(!empty($value)){
                $isCalcul = false;
                foreach ($value as &$tab) {
                    foreach ($tab as $key => &$ligne) {
                        if($defautTab['colonnes'][$key]['calcul']) $isCalcul = true; 
                    }
                    break;
                }
                if(( (count($value) < count($defautTab['lignes'])) || (count($value) < count($defautTab['lignes'])+1 && $isCalcul ) )){
                    $check = ($isCalcul)?count($defautTab['lignes'])+1 - count($value):count($defautTab['lignes']) - count($value);
                    for($i = 0; $i < $check; $i++){
                        $tableau = [];
                        for ($j = 0; $j < count($defautTab['colonnes']); $j++) {
                            $tableau[]  = '';
                        }
                        if($isCalcul){
                            // Index de l'avant-dernière ligne
                            $index = count($value) - 1;
                            // Insérer l'élément à l'index de l'avant-dernière ligne
                            array_splice($value, $index, 0, array($tableau));
                        }else{
                            array_push($value, $tableau);
                        }
                    }
                }
            }
            $smarty->assign("value", $value);
        }

        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("required", $required);
        $smarty->assign("autre", $autre);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("style", $style);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("view", 'edit');
        $smarty->assign("aria", $champ["libelle"]);

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            // This a custom field served on the full line, so pick a dedicated label field.
            $smarty->assign("label", $champ["libelle"]);

            $regex = '/^([A-Za-z0-9+\/]{4})*([A-Za-z0-9+\/]{3}=|[A-Za-z0-9+\/]{2}==)?$/';
            if( !empty($champ["aide"]) && preg_match($regex,$champ["aide"])){
                $aide = base64_decode($champ["aide"]);
            }
            $smarty->assign("aide", $aide);

            // Required based on each collumn. Scan $defautTab['colonnes']...
            $ctx_err_msg = "Les champs de certaines colonnes sont obligatoires";
            $ctx_cols = array();
            $has_required = false;

            foreach ($defautTab['colonnes'] as $key => $infos) {
                if( $infos['obligatoire'] === true || $infos['obligatoire'] == 1 ){
                    $has_required = true;
                    array_push( $ctx_cols, $infos['libelle'] );
                }
            }
            $required = ( $has_required ) ? ' required="required" ' : '';
            $smarty->assign("required", $required);

            $data_required = ( $has_required ) ? ' data-required="true" ' : '';
            $smarty->assign("data_required", $data_required);

            // Custom error message...
            if( $has_required ){
                $ctx_err_msg = "Les champs de".( (sizeof($ctx_cols)>1)? "s":" la" )." colonne".( (sizeof($ctx_cols)>1)? "s":"" )." ". join(", ",$ctx_cols) ." sont obligatoires";
                $smarty->assign("ctx_err_msg", $ctx_err_msg);
            }

            $field_html = $field_label ."\n". $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/tableau_front.tpl");

        }else{
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/tableau.tpl");
        }

        return $field_html;
    }

    public function getFieldValue($value_bdd)
    {
        $tableau = json_decode(base64_decode($value_bdd),true);
        return (!empty($tableau)) ? $tableau : "";
    }

    public function getFieldDefautValue($value_defaut)
    {
        $tableau = json_decode(base64_decode($value_defaut),true);
        $tableauParam = json_decode(base64_decode($tableau['tableau_param']),true);

        foreach($tableauParam['colonnes'] as &$colonne){
            if($colonne['format'] == 'liste_deroulante' && !empty($colonne['format_liste'])){
                $liste = [];
                $liste[''] = '';
                $objListeReferentiel = BeanFactory::getBean('OPS_liste_referentiel',$colonne['format_liste']);
                if(!empty($objListeReferentiel->id)){
                    $listeValeur = $objListeReferentiel->get_linked_beans('ops_liste_valeur_ops_liste_referentiel', 'OPS_liste_valeur', 'ordre, libelle');
                    foreach ($listeValeur as $valeur) {
                        $liste[$valeur->name] = $valeur->libelle;
                    }
                }
                if(!empty($liste)){
                    $colonne['format_liste_valeurs'] = $liste;
                }else{
                    $colonne['format_liste_valeurs'][''] = "";
                }
            }else if($colonne['format'] == 'liste_deroulante' && empty($colonne['format_liste'])){
                $colonne['format_liste_valeurs'][''] = "";
            }
        }

        $vides = true;
        foreach($tableauParam['lignes'] as $ligne){
            if (!empty($ligne)) {
                $vides = false;
                break;
            }
        }

        if($vides){
            $tableauParam['ligne_vide'] = 'vide';
        }

        return (!empty($tableauParam)) ? $tableauParam : "";
    }
    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        $params = $this->getFieldDefautValue($champ["params"]);
        $tableauVal = json_decode(base64_decode($value),true);
        $isCalcul = false;
        $tailleColonne = 0;

        foreach ($params['colonnes'] as $key => $colonne) {
            if($colonne['calcul']){
                $isCalcul = true;
            }

            if($colonne['largeur'] == '0' || empty($colonne['largeur']) || $colonne['largeur'] == '' ){
                $params['colonnes'][$key]['largeur'] = 15;
                $colonne['largeur'] = 15;
            }

            $tailleColonne += intval($colonne['largeur']);
        }

        $htmlCss = '{literal}<style type="text/css">.label_tableau{margin-bottom: 5px;}.champ_tableau th, .champ_tableau td{border-collapse: collapse;padding: 15px;border: 1px solid #ddd;}.champ_tableau{border-collapse: collapse;padding: 8px;}.champ_tableau_thead{height: 64px;color: white;}.champ_tableau_th{color: black;font-weight: bold;background-color: #D3D3D3;}</style>{/literal}';
        $tableau .='<div class="div_tableau">';
        $tableau .= '<table class="champ_tableau" style="width:100%;" align="center">';
        $tableau .=     '<thead class="champ_tableau_thead">';
        $tableau .=         '<tr>';

        if(!empty($params['largeur_colonne_zero'])){
            $tableau .= '<th style="border:none;background:none;width: '.$params['largeur_colonne_zero'].'%;"></th>';  
        }else if($isCalcul || (!empty($params['lignes']) && !empty($params['lignes'][0]) && empty($params['largeur_colonne_zero']) )){
            $tableau .= '<th style="border:none;background:none;width: 8%;"></th>';
            $params['largeur_colonne_zero'] = 8;
        }
        $tailleColonne += intval($params['largeur_colonne_zero']);

        if($tailleColonne != 100 && $tailleColonne != 0){
            foreach ($params['colonnes'] as &$colonne) {
                $colonne['largeur'] = ((int)$colonne['largeur'] / $tailleColonne) * 100;
            }
        }else if($tailleColonne == 0 && $params['largeur_colonne_zero'] != 8){
            foreach ($params['colonnes'] as &$colonne) {
                $colonne['largeur'] = 100 / count($params['colonnes']);
            }
        }else if($tailleColonne == 8 && $params['largeur_colonne_zero'] == 8) {
            foreach ($params['colonnes'] as &$colonne) {
                $colonne['largeur'] = 92 / count($params['colonnes']);
            }
        }
        
        foreach ($params['colonnes'] as $key => $ligne) {
            $tableau .=         '<th class="champ_tableau_th" scope="col" style="width: '.$ligne['largeur'].'%;">'.$ligne['libelle'].'</th>';
        }
        $tableau .=         '</tr>';
        $tableau .=     '</thead>';
        $tableau .=     '<tbody>';
        foreach ($tableauVal as $key => $ligne) {
            $tableau .=     '<tr>';

            if($isCalcul && $key == count($tableauVal)-1 ) {
                $tableau .= '<td style="width: '.$params['largeur_colonne_zero'].'%;">Total</td>';
            }else if(empty($params['lignes'][$key]) && $isCalcul){
                $tableau .= '<td style="border:none;background:none;width: '.$params['largeur_colonne_zero'].'%;"></td>';
            }else if(!empty($params['lignes'][$key])){
                $tableau .= '<td style="width: '.$params['largeur_colonne_zero'].'%;">'.$params['lignes'][$key].'</td>'; 
            }else if(!empty($params['largeur_colonne_zero'])){
                $tableau .= '<td style="width: '.$params['largeur_colonne_zero'].'%;"></td>'; 
            }

            foreach ($ligne as $key2 => $champ) 
            {
                // Pour la ligne calcul
                if($isCalcul && $key == count($tableauVal)-1) 
                {
                    // Vérification si on peut affiche dans la ligne total la valeur (Si l'option total de la colonne a été coché)
                    if($params['colonnes'][$key2]['calcul'])
                    {
                        $tableau .=     '<td style="width: '.$params['colonnes'][$key2]['largeur'].'%;">';
                        $tableau .=         ($params['colonnes'][$key2]['format'] == 'montant')? str_replace('.', ',', $champ) :$champ;
                        $tableau .=     '</td>';
                    }
                    else
                    {
                        $tableau .=     '<td style="width: '.$params['colonnes'][$key2]['largeur'].'%;">';
                        $tableau .=     '</td>';
                    }
                }
                else
                {
                    if($params['colonnes'][$key2]['format'] == 'liste_deroulante'){
                        $champ = $params['colonnes'][$key2]['format_liste_valeurs'][$champ];
                    }
                    $tableau .=     '<td style="width: '.$params['colonnes'][$key2]['largeur'].'%;">';
                    $tableau .=         ($params['colonnes'][$key2]['format'] == 'montant')? str_replace('.', ',', $champ) :$champ;
                    $tableau .=     '</td>';
                }
            }
            $tableau .=     '</tr>';
        }
        $tableau .=     '</tbody>';
        $tableau .= '</table>';
        $tableau .='</div>';
        return (!empty($tableau)) ? $htmlCss.$tableau : "";
    }

    public function getUniqueId()
    {
        return strtoupper(hash("sha256", time() . rand()));
    }

    public static function getLibelle()
    {
        return "Tableau";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeTableau::getLibelle(),
            'icon' => 'fas fa-table',
            'route' => '/champs/?type=tableau',
            'attributes' => '',
        ];
    }
}
