<?php

namespace ODE\Generateur\Field;
use Sugar_Smarty;
use ODE\Model\DossierModel;
use BeanFactory;

class OdeFonction extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        // On récupere la valeur à afficher
        $value = $this->getFieldValue($value_bdd);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
    
        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("aria", $champ["libelle"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/fonction.tpl");

        return $field_label . $field_html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        $isDefaut = '';
        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $value = $this->getFieldDefautValue($champ["defaut"],$isDefaut);
        } else {
            $value = $this->getFieldValue($value_bdd);
        }

        $field_label = $this->getLabelField($champ["name"], $champ["libelle"], $champ["aide"], $champ["obligatoire"]);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $disabled = ' disabled="disabled" ';

        $params = json_decode(base64_decode($champ['params']),true);

        if(!empty($params['fonction'])){
            $valeurFonction = $this->executeFonction($params['fonction'], $params['parametre_fonction'] ?? "");

            if(!empty($valeurFonction) &&  ( empty($value) || (!empty($valeurFonction) && $valeurFonction != $value) )) $value = $valeurFonction;
        }

        $smarty = new Sugar_Smarty();
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("value", $value);
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);
        $smarty->assign("isDefaut", $isDefaut);
        $smarty->assign("aria", $champ["libelle"]);
        $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/fonction.tpl");

        return $field_label . $field_html;

    }

    public function getFieldValue($value_bdd)
    {
        return (!empty($value_bdd)) ? str_replace('"', '&quot;',  html_entity_decode($value_bdd) ) : "";
    }

    public function getFieldDefautValue($value_defaut,&$isDefaut = null)
    {
        $defautTab = json_decode( base64_decode($value_defaut), true);

        if(!empty($defautTab)){
            if($defautTab['defaut'] == 'autre'){
                $value_defaut = $defautTab['defaut_value']; 
            }
            elseif($defautTab['defaut'] == 'url'){
                $value_defaut = '';
                $isDefaut = 'data-defaut="url" data-url-attr="'.$defautTab['defaut_value'].'"';
            }
            else{
                $value_defaut = $this->getDefautValue($defautTab, 'text');
                if(!empty($defautTab['defaut']) && isset($isDefaut)){
                    $isDefaut = 'data-defaut="defaut"';
                }
            }
        }
        return (!empty($value_defaut)) ? str_replace('"', '&quot;',  html_entity_decode($value_defaut) ) : "";
    }

    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        return (!empty($value)) ? html_entity_decode($value) : "";
    }

    public static function getLibelle()
    {
        return "Fonction";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeFonction::getLibelle(),
            'icon' => 'fas fa-terminal',
            'route' => '/champs/?type=fonction',
            'attributes' => '',
        ];
    }

    private function executeFonction($fonction, $parametres){

        $fonctionNamespace = 'ODE\\Fonctions\\Liste\\';

        $classeName = $fonctionNamespace . ucfirst(str_replace(".php", "", $fonction));
        if(class_exists($classeName)){
            $classeObj = new $classeName();
            $champsDossier = array();

            if(!empty($this->bean)){
                $champsDossier = $this->getChampsDossier($this->bean->id);
            }

            $paramsFonction['dossier'] = $this->bean;
            $paramsFonction['champs'] = $champsDossier;
            $paramsFonction['donnees'] = $this->donnees;
            $paramsFonction['parametre_fonction'] = $parametres;
            
            return $classeObj->execute($paramsFonction);
        }
    }

    private function getChampsDossier($dossierId){
        $objDossier = BeanFactory::getBean("OPS_dossier", $this->bean->id);
        $dossier = new DossierModel($this->bean->id);
        $champsBasic = $dossier->getChamps();
        $champsDossier = array();
        foreach ($champsBasic as $champ) {
            $champsDossier['basic'][$champ] = $objDossier->{$champ};
        }

        $champsDossier['custom'] = $dossier->getCustomChamps();
        return $champsDossier;
    }
}
