<?php

namespace ODE\Generateur\Field;
use Sugar_Smarty;

class OdeApi_R2p extends OdeField
{

    /**
     * @access public
     * @name __construct de la classe OdePourcentage
     * @param bean              $bean: Bean du module OPS_dossier
     * @param boolean           $editable: Est ce que le champ est éditable ?
     * 
     * @return void
     */
    public function __construct($editable = false, $bean = null, $donnees = [])
    {
        parent::__construct($editable, $bean, $donnees);
    }

    /**
     * @access private
     * @name getIneditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue détail
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getIneditableField($champ, $value_bdd)
    {
        global $app_list_strings;

        // On récupere la valeur à afficher
        $value = $this->getFieldValue($value_bdd);
        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $disabled = ' disabled="disabled" ';
        $params = json_decode( base64_decode($champ['params']),true);

        $apiR2p = explode(',', $params['api_r2p']);
        $label_api_r2p = array();

        foreach ($apiR2p as $champApi) {
            $label_api_r2p[$champApi] = $app_list_strings[$params['liste_api_r2p']][$champApi];
        }

        $smarty = new Sugar_Smarty();
        $smarty->assign("id", $this->getUniqueId());
        $smarty->assign("type", "api_r2p");
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("data_required", $data_required);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("aria", $champ["libelle"]);

        if(isset($value["value"]))
        {
            $smarty->assign("value", $value["value"]);
        }
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("name_api_r2p_nom", "name_api_r2p_nom");
        $smarty->assign("name_api_r2p_prenom", "name_api_r2p_prenom");
        $smarty->assign("name_api_r2p_date_naissance", "name_api_r2p_date_naissance");
        $smarty->assign("label_api_r2p", $label_api_r2p);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);

        if(isset($value["value_api_r2p_nom"]))
        {
            $smarty->assign("value_api_r2p_nom", $value["value_api_r2p_nom"]);
        }

        if(isset($value["value_api_r2p_prenom"]))
        {
            $smarty->assign("value_api_r2p_prenom", $value["value_api_r2p_prenom"]);
        }

        if(isset($value["value_api_r2p_date_naissance"]))
        {
            $smarty->assign("value_api_r2p_date_naissance", $value["value_api_r2p_date_naissance"]);
        }

        if(isset($value["resultat"]))
        {
            $smarty->assign("value_api_r2p", $value["resultat"]);
        }

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/api_r2p_front.tpl");
        }else{
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/api_r2p.tpl");
        }



        return $field_html;
    }

    /**
     * @access private
     * @name getEditableField()
     * Fonction qui renvoie le code HTML à afficher dans la vue édit
     * 
     *  @param array            $champ: La définition du champ
     *  @param string           $value_bdd: La valeur en BDD
     *  @return string          $html: Le champ ( Format html )
     */
    public function getEditableField($champ, $value_bdd)
    {
        global $app_list_strings;
        // On récupere la valeur à afficher
        if (empty($value_bdd)) {
            $value = $this->getFieldDefautValue($champ["defaut"]);
        } else {
            $value = $this->getFieldValue($value_bdd);
        }

        $params = json_decode( base64_decode($champ['params']),true);

        $name = ( !empty($champ["name"]) ) ? $champ["name"] : "";
        $required = ( isset($champ['obligatoire']) && $champ['obligatoire'] == 1 ) ? ' required="required" ' : '';
        $data_required = ( $required != '' ) ? ' data-required="true" ' : '';
        $disabled = ( isset($champ['ineditable']) && $champ['ineditable'] == 1 ) ? ' disabled="disabled" ' : '';

        $apiR2p = explode(',', $params['api_r2p']);
        $label_api_r2p = array();

        foreach ($apiR2p as $champApi) {
            $label_api_r2p[$champApi] = $app_list_strings[$params['liste_api_r2p']][$champApi];
        }

        $smarty = new Sugar_Smarty();
        $smarty->assign("id", $this->getUniqueId());
        $smarty->assign("type", "api_r2p");
        $smarty->assign("name", $name);
        $smarty->assign("required", $required);
        $smarty->assign("data_required", $data_required);
        $smarty->assign("disabled", $disabled);
        $smarty->assign("aria", $champ["libelle"]);

        if(isset($value["value"]))
        {
            $smarty->assign("value", $value["value"]);
        }
        $smarty->assign("conditions", $champ['conditions']);
        $smarty->assign("name_api_r2p_nom", "name_api_r2p_nom");
        $smarty->assign("name_api_r2p_prenom", "name_api_r2p_prenom");
        $smarty->assign("name_api_r2p_date_naissance", "name_api_r2p_date_naissance");
        $smarty->assign("label_api_r2p", $label_api_r2p);
        $smarty->assign("vue_type",$this->donnees["vue"]["type"]);

        if(isset($value["value_api_r2p_nom"]))
        {
            $smarty->assign("value_api_r2p_nom", $value["value_api_r2p_nom"]);
        }

        if(isset($value["value_api_r2p_prenom"]))
        {
            $smarty->assign("value_api_r2p_prenom", $value["value_api_r2p_prenom"]);
        }

        if(isset($value["value_api_r2p_date_naissance"]))
        {
            $smarty->assign("value_api_r2p_date_naissance", $value["value_api_r2p_date_naissance"]);
        }

        if(isset($value["resultat"]))
        {
            $smarty->assign("value_api_r2p", $value["resultat"]);
        }

        if( !empty($this->donnees["vue"]["type"]) && array_key_exists($this->donnees["vue"]["type"], $app_list_strings['ops_espaces_front']) ){
            $smarty->assign( "x_correlation_uuid", create_guid() );
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/api_r2p_front.tpl");
        }else{
            $field_html = $smarty->fetch("custom/include/Ode/Generateur/Field/tpls/api_r2p.tpl");
        }

        return $field_html;
    }

    public function getFieldValue($value_bdd)
    {   
        if(!empty($value_bdd)){
            $value_bdd = str_replace('&amp;#x3D;','=',$value_bdd);
            $value = json_decode( base64_decode($value_bdd),true );
            $value["resultat"] = json_decode( base64_decode($value["resultat"]),true );;
            $value['value'] = $value_bdd;
        }
        return (!empty($value)) ? $value : "";
    }

    public function getFieldDefautValue($value_defaut)
    {
        return (!empty($value_defaut)) ? str_replace('"', '&quot;',  html_entity_decode($value_defaut) ) : "";
    }
    /**
     * @access public
     * @name getPdfValue()
     * Fonction qui retourne la valeur à afficher en pdf 
     *
     *  @param array            $champ: La définition du champ
     *  @param string           $value: La valeur en BDD
     *  @return string          $value_display: Le valeur à afficher
     */
    public function getPdfValue($champ, $value)
    {
        global $app_list_strings;
        if(!empty($value)){
            $value = $this->getFieldValue($value);
        } else {
            $value = array();
        }
        
        $params = json_decode( base64_decode($champ['params']),true);
        $apiR2p = explode(',', $params['api_r2p']);
        $label_api_r2p = array();

        foreach ($apiR2p as $champApi) {
            $label_api_r2p[$champApi] = $app_list_strings[$params['liste_api_r2p']][$champApi];
        }
        $value['label_api_r2p'] = $label_api_r2p;
        $value['label_nom'] = 'Nom';
        $value['label_prenom'] = 'Prénom';
        $value['label_date_naissance'] = 'Date de naissance';

        return (!empty($value)) ? $value : "";
    }

    public function getUniqueId()
    {
        return strtoupper(hash("sha256", time() . rand()));
    }

    public static function getLibelle()
    {
        return "Api R2P";
    }

    public static function getCreateButton()
    {
        return (object) [
            'libelle' => OdeApi_R2p::getLibelle(),
            'icon' => 'fas fa-book',
            'route' => '/champs/?type=api_r2p',
            'attributes' => '',
        ];
    }
}